/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.widgets.AvdSelector;
import java.io.File;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class AvdCreationDialog
extends Dialog {
    private final AvdManager mAvdManager;
    private final TreeMap<String, IAndroidTarget> mCurrentTargets = new TreeMap();
    private Text mAvdName;
    private Combo mTargetCombo;
    private Text mSdCard;
    private Button mBrowseSdCard;
    private Combo mSkinCombo;
    private Button mForceCreation;
    private Button mOkButton;
    private Label mStatusIcon;
    private Label mStatusLabel;
    private Composite mStatusComposite;
    private final ImageFactory mImageFactory;

    protected AvdCreationDialog(Shell parentShell, AvdManager avdManager, ImageFactory imageFactory) {
        super(parentShell);
        this.mAvdManager = avdManager;
        this.mImageFactory = imageFactory;
    }

    public void create() {
        super.create();
        Point p = this.getShell().getSize();
        if (p.x < 400) {
            p.x = 400;
        }
        this.getShell().setSize(p);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText("Create new AVD");
        this.mOkButton = this.getButton(0);
        this.validatePage();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayoutData((Object)new GridData(1808));
        top.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(top, 0);
        label.setText("Name:");
        this.mAvdName = new Text(top, 2048);
        this.mAvdName.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.mAvdName.addModifyListener((ModifyListener)new CreateNameModifyListener());
        label = new Label(top, 0);
        label.setText("Target:");
        this.mTargetCombo = new Combo(top, 12);
        this.mTargetCombo.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.mTargetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                AvdCreationDialog.this.reloadSkinCombo();
                AvdCreationDialog.this.validatePage();
            }
        });
        label = new Label(top, 0);
        label.setText("SD Card:");
        label.setToolTipText("Either a path to an existing SD card image\nor an image size in K or M (e.g. 512K, 10M).");
        ValidateListener validateListener = new ValidateListener();
        this.mSdCard = new Text(top, 2048);
        this.mSdCard.setLayoutData((Object)new GridData(768));
        this.mSdCard.addModifyListener((ModifyListener)validateListener);
        this.mBrowseSdCard = new Button(top, 8);
        this.mBrowseSdCard.setText("Browse...");
        this.mBrowseSdCard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdCreationDialog.this.onBrowseSdCard();
                AvdCreationDialog.this.validatePage();
            }
        });
        label = new Label(top, 0);
        label.setText("Skin");
        this.mSkinCombo = new Combo(top, 12);
        this.mSkinCombo.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        label = new Label(top, 0);
        this.mForceCreation = new Button(top, 32);
        this.mForceCreation.setText("Force");
        this.mForceCreation.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.mForceCreation.setEnabled(false);
        this.mForceCreation.addSelectionListener((SelectionListener)validateListener);
        label = new Label(top, 258);
        label.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.mStatusComposite = new Composite(top, 0);
        this.mStatusComposite.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        GridLayout gl = new GridLayout(2, false);
        this.mStatusComposite.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mStatusIcon = new Label(this.mStatusComposite, 0);
        this.mStatusIcon.setLayoutData((Object)new GridData(1, 1, false, false));
        this.mStatusLabel = new Label(this.mStatusComposite, 0);
        this.mStatusLabel.setLayoutData((Object)new GridData(768));
        this.mStatusLabel.setText(" \n ");
        this.reloadTargetCombo();
        return top;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = "Create AVD";
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void okPressed() {
        if (this.onCreate()) {
            super.okPressed();
        }
    }

    private void onBrowseSdCard() {
        FileDialog dlg = new FileDialog(this.getContents().getShell(), 4096);
        dlg.setText("Choose SD Card image file.");
        String fileName = dlg.open();
        if (fileName != null) {
            this.mSdCard.setText(fileName);
        }
    }

    private void reloadTargetCombo() {
        String selected = null;
        int index = this.mTargetCombo.getSelectionIndex();
        if (index >= 0) {
            selected = this.mTargetCombo.getItem(index);
        }
        this.mCurrentTargets.clear();
        this.mTargetCombo.removeAll();
        boolean found = false;
        index = -1;
        SdkManager sdkManager = this.mAvdManager.getSdkManager();
        if (sdkManager != null) {
            for (IAndroidTarget target : sdkManager.getTargets()) {
                String name = target.isPlatform() ? String.format("%s - API Level %s", target.getName(), target.getVersion().getApiString()) : String.format("%s (%s) - API Level %s", target.getName(), target.getVendor(), target.getVersion().getApiString());
                this.mCurrentTargets.put(name, target);
                this.mTargetCombo.add(name);
                if (found) continue;
                ++index;
                found = name.equals(selected);
            }
        }
        this.mTargetCombo.setEnabled(this.mCurrentTargets.size() > 0);
        if (found) {
            this.mTargetCombo.select(index);
        }
        this.reloadSkinCombo();
    }

    private void reloadSkinCombo() {
        String selected = null;
        int index = this.mSkinCombo.getSelectionIndex();
        if (index >= 0) {
            selected = this.mSkinCombo.getItem(index);
        }
        this.mSkinCombo.removeAll();
        this.mSkinCombo.setEnabled(false);
        index = this.mTargetCombo.getSelectionIndex();
        if (index >= 0) {
            String targetName = this.mTargetCombo.getItem(index);
            boolean found = false;
            IAndroidTarget target = this.mCurrentTargets.get(targetName);
            if (target != null) {
                this.mSkinCombo.add(String.format("Default (%s)", target.getDefaultSkin()));
                index = -1;
                for (String skin : target.getSkins()) {
                    this.mSkinCombo.add(skin);
                    if (found) continue;
                    ++index;
                    found = skin.equals(selected);
                }
                this.mSkinCombo.setEnabled(true);
                if (found) {
                    this.mSkinCombo.select(index);
                } else {
                    this.mSkinCombo.select(0);
                }
            }
        }
    }

    private void validatePage() {
        boolean can_create;
        AvdManager.AvdInfo avdMatch;
        String sdName;
        boolean hasAvdName;
        String error = null;
        String avdName = this.mAvdName.getText().trim();
        boolean bl = hasAvdName = avdName.length() > 0;
        if (hasAvdName && !AvdManager.RE_AVD_NAME.matcher(avdName).matches()) {
            error = String.format("AVD name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", avdName, "a-z A-Z 0-9 . _ -");
        }
        if (hasAvdName && error == null && this.mTargetCombo.getSelectionIndex() < 0) {
            error = "A target must be selected in order to create an AVD.";
        }
        if (error == null && (sdName = this.mSdCard.getText().trim()).length() > 0 && !new File(sdName).isFile() && !AvdManager.SDCARD_SIZE_PATTERN.matcher(sdName).matches()) {
            error = "SD Card must be either a file path or a size\nsuch as 128K or 64M.";
        }
        if (hasAvdName && error == null && (avdMatch = this.mAvdManager.getAvd(avdName, false)) != null && !this.mForceCreation.getSelection()) {
            error = String.format("The AVD name '%s' is already used.\nCheck \"Force\" to override existing AVD.", avdName);
        }
        boolean bl2 = can_create = hasAvdName && error == null;
        if (can_create) {
            can_create &= this.mTargetCombo.getSelectionIndex() >= 0;
        }
        this.mOkButton.setEnabled(can_create);
        if (error != null) {
            this.mStatusIcon.setImage(this.mImageFactory.getImageByName("reject_icon16.png"));
            this.mStatusLabel.setText(error);
        } else {
            this.mStatusIcon.setImage(null);
            this.mStatusLabel.setText(" \n ");
        }
        this.mStatusComposite.pack(true);
    }

    private boolean onCreate() {
        File avdFolder;
        String avdName = this.mAvdName.getText().trim();
        String sdName = this.mSdCard.getText().trim();
        int targetIndex = this.mTargetCombo.getSelectionIndex();
        int skinIndex = this.mSkinCombo.getSelectionIndex();
        boolean force = this.mForceCreation.getSelection();
        if (avdName.length() == 0 || targetIndex < 0) {
            return false;
        }
        String targetName = this.mTargetCombo.getItem(targetIndex);
        IAndroidTarget target = this.mCurrentTargets.get(targetName);
        if (target == null) {
            return false;
        }
        String skinName = null;
        if (skinIndex > 0) {
            skinName = this.mSkinCombo.getItem(skinIndex);
        }
        AvdSelector.SdkLog log = new AvdSelector.SdkLog(String.format("Result of creating AVD '%s':", avdName), this.getContents().getDisplay());
        try {
            avdFolder = new File(AndroidLocation.getFolder() + "avd", avdName + ".avd");
        }
        catch (AndroidLocation.AndroidLocationException e) {
            return false;
        }
        boolean success = false;
        AvdManager.AvdInfo avdInfo = this.mAvdManager.createAvd(avdFolder, avdName, target, skinName, sdName, null, force, (ISdkLog)log);
        success = avdInfo != null;
        log.displayResult(success);
        return success;
    }

    private class ValidateListener
    extends SelectionAdapter
    implements ModifyListener {
        private ValidateListener() {
        }

        public void modifyText(ModifyEvent e) {
            AvdCreationDialog.this.validatePage();
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            AvdCreationDialog.this.validatePage();
        }
    }

    private class CreateNameModifyListener
    implements ModifyListener {
        private CreateNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String name = AvdCreationDialog.this.mAvdName.getText().trim();
            AvdManager.AvdInfo avdMatch = AvdCreationDialog.this.mAvdManager.getAvd(name, false);
            if (avdMatch != null) {
                AvdCreationDialog.this.mForceCreation.setEnabled(true);
            } else {
                AvdCreationDialog.this.mForceCreation.setEnabled(false);
                AvdCreationDialog.this.mForceCreation.setSelection(false);
            }
            AvdCreationDialog.this.validatePage();
        }
    }
}

