/*!
* DevExtreme (dx.messages.en.js)
* Version: 18.2.5
* Build date: Wed Jan 23 2019
*
* Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define(function(require) {
            factory(require("devextreme/localization"))
        })
    } else {
        if ("object" === typeof module && module.exports) {
            factory(require("devextreme/localization"))
        } else {
            factory(DevExpress.localization)
        }
    }
}(this, function(localization) {
    localization.loadMessages({
        en: {
            Yes: "Evet",
            No: "Hayır",
            Cancel: "İptal",
            Clear: "Temizle",
            Done: "Tamamlandı",
            Loading: "Yükleniyor...",
            Select: "Seç...",
            Search: "Ara",
            Back: "Geri",
            OK: "OK",
            "dxCollectionWidget-noDataText": "Görüntülenecek bilgi yok",
            "validation-required": "Gerekli",
            "validation-required-formatted": "{0} gerekli",
            "validation-numeric": "Bir rakam olmalı",
            "validation-numeric-formatted": "{0} rakam olmalı",
            "validation-range": "Değer, olması gereken aralıkta değil",
            "validation-range-formatted": "{0} olması gereken aralıkta değil",
            "validation-stringLength": "Uzunluk değeri doğru değil",
            "validation-stringLength-formatted": "Uzunluk değeri olarak {0} doğru değil",
            "validation-custom": "Geçersiz değer",
            "validation-custom-formatted": "{0} geçersiz",
            "validation-compare": "Değerler uyuşmuyor",
            "validation-compare-formatted": "{0} uyuşmuyor",
            "validation-pattern": "Değer şablonla uyuşmuyor",
            "validation-pattern-formatted": "{0} şablonla uyuşmuyor",
            "validation-email": "Geçersiz e-posta",
            "validation-email-formatted": "{0} geçersiz",
            "validation-mask": "Geçersiz değer",
            "dxLookup-searchPlaceholder": "Minimum karakter sayısı: {0}",
            "dxList-pullingDownText": "Yenilemek için aşağı çekin...",
            "dxList-pulledDownText": "Yenilemek için bırakın...",
            "dxList-refreshingText": "Yenileniyor...",
            "dxList-pageLoadingText": "Yükleniyor...",
            "dxList-nextButtonText": "Daha fazla",
            "dxList-selectAll": "Tümünü seç",
            "dxListEditDecorator-delete": "Sil",
            "dxListEditDecorator-more": "Daha fazla",
            "dxScrollView-pullingDownText": "Yenilemek için aşağı çekin...",
            "dxScrollView-pulledDownText": "Yenilemek için bırakın...",
            "dxScrollView-refreshingText": "Yenileniyor...",
            "dxScrollView-reachBottomText": "Yükleniyor...",
            "dxDateBox-simulatedDataPickerTitleTime": "Zamanı seçin",
            "dxDateBox-simulatedDataPickerTitleDate": "Tarihi seçin",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Tarih ve zamanı seçin",
            "dxDateBox-validation-datetime": "Değer bir tarih veya zaman olmalı",
            "dxFileUploader-selectFile": "Dosya seç",
            "dxFileUploader-dropFile": "ya da dosyayı buraya bırakın",
            "dxFileUploader-bytes": "bytes",
            "dxFileUploader-kb": "kb",
            "dxFileUploader-Mb": "Mb",
            "dxFileUploader-Gb": "Gb",
            "dxFileUploader-upload": "Upload",
            "dxFileUploader-uploaded": "Upload tamamlandı",
            "dxFileUploader-readyToUpload": "Upload hazır",
            "dxFileUploader-uploadFailedMessage": "Upload başarısız",
            "dxFileUploader-invalidFileExtension": "Dosya tipine izin verilmedi",
            "dxFileUploader-invalidMaxFileSize": "Dosya çok büyük",
            "dxFileUploader-invalidMinFileSize": "Dosya çok küçük",
            "dxRangeSlider-ariaFrom": "İtibaren",
            "dxRangeSlider-ariaTill": "Kadar",
            "dxSwitch-switchedOnText": "AÇIK",
            "dxSwitch-switchedOffText": "KAPALI",
            "dxForm-optionalMark": "seçmeli",
            "dxForm-requiredMessage": "{0} gerekli",
            "dxNumberBox-invalidValueMessage": "Değer bir rakam olmalı",
            "dxDataGrid-columnChooserTitle": "Sütun Seçici",
            "dxDataGrid-columnChooserEmptyText": "Sütunu gizlemek için buraya sürükleyin",
            "dxDataGrid-groupContinuesMessage": "Sonraki sayfada devam eder",
            "dxDataGrid-groupContinuedMessage": "Önceki sayfadan devam eder",
            "dxDataGrid-groupHeaderText": "Bu sütuna göre gruplandır",
            "dxDataGrid-ungroupHeaderText": "Grubu dağıt",
            "dxDataGrid-ungroupAllText": "Her grubu dağıt",
            "dxDataGrid-editingEditRow": "Düzenle",
            "dxDataGrid-editingSaveRowChanges": "Kaydet",
            "dxDataGrid-editingCancelRowChanges": "İptal",
            "dxDataGrid-editingDeleteRow": "Sil",
            "dxDataGrid-editingUndeleteRow": "Silmeyi geri al",
            "dxDataGrid-editingConfirmDeleteMessage": "Bu kaydı silmek istediğinizden emin misiniz?",
            "dxDataGrid-validationCancelChanges": "Değişiklikleri iptal et",
            "dxDataGrid-groupPanelEmptyText": "Bu sütunu gruplandırmak için sütun başlığını sürükleyin",
            "dxDataGrid-noDataText": "Veri yok",
            "dxDataGrid-searchPanelPlaceholder": "Ara...",
            "dxDataGrid-filterRowShowAllText": "(Hepsi)",
            "dxDataGrid-filterRowResetOperationText": "Sıfırla",
            "dxDataGrid-filterRowOperationEquals": "Eşitle",
            "dxDataGrid-filterRowOperationNotEquals": "Eşitleme",
            "dxDataGrid-filterRowOperationLess": "Daha küçük",
            "dxDataGrid-filterRowOperationLessOrEquals": "Daha küçük veya eşit",
            "dxDataGrid-filterRowOperationGreater": "Daha büyük",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Daha büyük veya eşit",
            "dxDataGrid-filterRowOperationStartsWith": "İle başlayan",
            "dxDataGrid-filterRowOperationContains": "İçeren",
            "dxDataGrid-filterRowOperationNotContains": "İçermeyen",
            "dxDataGrid-filterRowOperationEndsWith": "İle biten",
            "dxDataGrid-filterRowOperationBetween": "Arasında",
            "dxDataGrid-filterRowOperationBetweenStartText": "Başla",
            "dxDataGrid-filterRowOperationBetweenEndText": "Bitir",
            "dxDataGrid-applyFilterText": "Filtreyi uygula",
            "dxDataGrid-trueText": "doğru",
            "dxDataGrid-falseText": "yanlış",
            "dxDataGrid-sortingAscendingText": "Çoğalana Göre Sırala",
            "dxDataGrid-sortingDescendingText": "Azalana Göre Sırala",
            "dxDataGrid-sortingClearText": "Sıralamayı Temizle",
            "dxDataGrid-editingSaveAllChanges": "Değişiklikleri kaydet",
            "dxDataGrid-editingCancelAllChanges": "Değişiklikleri temizle",
            "dxDataGrid-editingAddRow": "Satır ekle",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Min of {1} is {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Max of {1} is {0}",
            "dxDataGrid-summaryAvg": "Avg: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Avg of {1} is {0}",
            "dxDataGrid-summarySum": "Sum: {0}",
            "dxDataGrid-summarySumOtherColumn": "Sum of {1} is {0}",
            "dxDataGrid-summaryCount": "Sayım: {0}",
            "dxDataGrid-columnFixingFix": "Yasla",
            "dxDataGrid-columnFixingUnfix": "Yaslama",
            "dxDataGrid-columnFixingLeftPosition": "Sola",
            "dxDataGrid-columnFixingRightPosition": "Sağa",
            "dxDataGrid-exportTo": "Dışa aktar",
            "dxDataGrid-exportToExcel": "Excel dosyasına aktar",
            "dxDataGrid-excelFormat": "Excel dosyası",
            "dxDataGrid-selectedRows": "Seçili satırlar",
            "dxDataGrid-exportSelectedRows": "Seçili sıraları dışa aktar",
            "dxDataGrid-exportAll": "Bütün verileri dışa aktar",
            "dxDataGrid-headerFilterEmptyValue": "(Boşluklar)",
            "dxDataGrid-headerFilterOK": "TAMAM",
            "dxDataGrid-headerFilterCancel": "İptal",
            "dxDataGrid-ariaColumn": "Sütun",
            "dxDataGrid-ariaValue": "Değer",
            "dxDataGrid-ariaFilterCell": "Hücreyi filtrele",
            "dxDataGrid-ariaCollapse": "Daralt",
            "dxDataGrid-ariaExpand": "Genişlet",
            "dxDataGrid-ariaDataGrid": "Veri kılavuzu",
            "dxDataGrid-ariaSearchInGrid": "Veri kılavuzunda ara",
            "dxDataGrid-ariaSelectAll": "Tümünü seç",
            "dxDataGrid-ariaSelectRow": "Satırı seç",
            "dxDataGrid-filterBuilderPopupTitle": "Filtre Kurucusu",
            "dxDataGrid-filterPanelCreateFilter": "Filtre Oluştur",
            "dxDataGrid-filterPanelClearFilter": "Temizle",
            "dxDataGrid-filterPanelFilterEnabledHint": "Filtreyi etkinleştir",
            "dxTreeList-ariaTreeList": "Detaylı liste",
            "dxTreeList-editingAddRowToNode": "Ekle",
            "dxPager-infoText": "{0}/{1}. sayfa ({2} öğe)",
            "dxPager-pagesCountText": "/",
            "dxPivotGrid-grandTotal": "Genel Toplam",
            "dxPivotGrid-total": "{0} Toplam",
            "dxPivotGrid-fieldChooserTitle": "Alan Seçici",
            "dxPivotGrid-showFieldChooser": "Alan Seçicisini Göster",
            "dxPivotGrid-expandAll": "Hepsini Genişlet",
            "dxPivotGrid-collapseAll": "Hepsini Daralt",
            "dxPivotGrid-sortColumnBySummary": 'Sütunu "{0}"a Göre Sırala',
            "dxPivotGrid-sortRowBySummary": 'Satırı "{0}"a Göre Sırala',
            "dxPivotGrid-removeAllSorting": "Bütün Sıralamaları Temizle",
            "dxPivotGrid-dataNotAvailable": "Uygulanamaz",
            "dxPivotGrid-rowFields": "Satır Alanları",
            "dxPivotGrid-columnFields": "Sütun Alanları",
            "dxPivotGrid-dataFields": "Veri Alanları",
            "dxPivotGrid-filterFields": "Filtre Alanları",
            "dxPivotGrid-allFields": "Bütün Alanlar",
            "dxPivotGrid-columnFieldArea": "Sütun Alanlarını Buraya Bırakın",
            "dxPivotGrid-dataFieldArea": "Veri Alanlarını Buraya Bırakın",
            "dxPivotGrid-rowFieldArea": "Satır Alanlarını Buraya Bırakın",
            "dxPivotGrid-filterFieldArea": "Filtre Alanlarını Buraya Bırakın",
            "dxScheduler-editorLabelTitle": "Konu",
            "dxScheduler-editorLabelStartDate": "Başlangıç Tarihi",
            "dxScheduler-editorLabelEndDate": "Bitiş Tarihi",
            "dxScheduler-editorLabelDescription": "Tanım",
            "dxScheduler-editorLabelRecurrence": "Tekrar",
            "dxScheduler-openAppointment": "Görev Tanımla",
            "dxScheduler-recurrenceNever": "Hiçbir zaman",
            "dxScheduler-recurrenceDaily": "Günlük",
            "dxScheduler-recurrenceWeekly": "Haftalık",
            "dxScheduler-recurrenceMonthly": "Aylık",
            "dxScheduler-recurrenceYearly": "Yıllık",
            "dxScheduler-recurrenceEvery": "Her",
            "dxScheduler-recurrenceEnd": "Tekrarı sonlandır",
            "dxScheduler-recurrenceAfter": "Sonra",
            "dxScheduler-recurrenceOn": "Tekrarlama açık",
            "dxScheduler-recurrenceRepeatDaily": "gün(ler)",
            "dxScheduler-recurrenceRepeatWeekly": "hafta(lar)",
            "dxScheduler-recurrenceRepeatMonthly": "ay(lar)",
            "dxScheduler-recurrenceRepeatYearly": "yıl(lar)",
            "dxScheduler-switcherDay": "Gün",
            "dxScheduler-switcherWeek": "Hafta",
            "dxScheduler-switcherWorkWeek": "Çalışma Haftası",
            "dxScheduler-switcherMonth": "Ay",
            "dxScheduler-switcherAgenda": "Ajanda",
            "dxScheduler-switcherTimelineDay": "Gün Zaman Çizelgesi",
            "dxScheduler-switcherTimelineWeek": "Hafta Zaman Çizelgesi",
            "dxScheduler-switcherTimelineWorkWeek": "Çalışma Haftası Zaman Çizelgesi",
            "dxScheduler-switcherTimelineMonth": "Ay Zaman Çizelgesi",
            "dxScheduler-recurrenceRepeatOnDate": "zamanında",
            "dxScheduler-recurrenceRepeatCount": "olay(lar)",
            "dxScheduler-allDay": "Bütün gün",
            "dxScheduler-confirmRecurrenceEditMessage": "Sadece bu görevi mi değiştirmek istiyorsunuz yoksa bütün görev serisini mi?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Sadece bu görevi mi silmek istiyorsunuz yoksa bütün görev serisini mi?",
            "dxScheduler-confirmRecurrenceEditSeries": "Görev serisini değiştir",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Görev serisini sil",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Görevi değiştir",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Görevi sil",
            "dxScheduler-noTimezoneTitle": "Saat dilimi yok",
            "dxScheduler-moreAppointments": "{0} fazla",
            "dxCalendar-todayButtonText": "Bugün",
            "dxCalendar-ariaWidgetName": "Takvim",
            "dxColorView-ariaRed": "Kırmızı",
            "dxColorView-ariaGreen": "Yeşil",
            "dxColorView-ariaBlue": "Mavi",
            "dxColorView-ariaAlpha": "Şeffaf",
            "dxColorView-ariaHex": "Renk kodu",
            "dxTagBox-selected": "{0} seçili",
            "dxTagBox-allSelected": "Hepsi seçili ({0})",
            "dxTagBox-moreSelected": "{0} fazla",
            "vizExport-printingButtonText": "Yazdır",
            "vizExport-titleMenuText": "Aktarılıyor/Yazdırılıyor",
            "vizExport-exportButtonText": "{0} dosya",
            "dxFilterBuilder-and": "Ve",
            "dxFilterBuilder-or": "Ya da",
            "dxFilterBuilder-notAnd": "Ve değil",
            "dxFilterBuilder-notOr": "Ya da değil",
            "dxFilterBuilder-addCondition": "Kondisyon Ekle",
            "dxFilterBuilder-addGroup": "Grup Ekle",
            "dxFilterBuilder-enterValueText": "<bir değer girin>",
            "dxFilterBuilder-filterOperationEquals": "Eşitle",
            "dxFilterBuilder-filterOperationNotEquals": "Eşitleme",
            "dxFilterBuilder-filterOperationLess": "daha az ",
            "dxFilterBuilder-filterOperationLessOrEquals": "Daha az veya eşit",
            "dxFilterBuilder-filterOperationGreater": "Daha fazla",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Daha fazla veya eşit",
            "dxFilterBuilder-filterOperationStartsWith": "İle başlayan",
            "dxFilterBuilder-filterOperationContains": "İçeren",
            "dxFilterBuilder-filterOperationNotContains": "İçermeyen",
            "dxFilterBuilder-filterOperationEndsWith": "İle biten",
            "dxFilterBuilder-filterOperationIsBlank": "Boş",
            "dxFilterBuilder-filterOperationIsNotBlank": "Boş değil",
            "dxFilterBuilder-filterOperationBetween": "Arasında",
            "dxFilterBuilder-filterOperationAnyOf": "Herhangi biri",
            "dxFilterBuilder-filterOperationNoneOf": "Hiçbiri",
            "dxHtmlEditor-dialogColorCaption": "Yazı Tipi Rengini Değiştir",
            "dxHtmlEditor-dialogBackgroundCaption": "Arka Plan Rengini Değiştir",
            "dxHtmlEditor-dialogLinkCaption": "Link Ekle",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Metin",
            "dxHtmlEditor-dialogLinkTargetField": "Linki yeni pencerede aç",
            "dxHtmlEditor-dialogImageCaption": "Görsel Ekle",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Metni değiştir",
            "dxHtmlEditor-dialogImageWidthField": "Genişlik (px)",
            "dxHtmlEditor-dialogImageHeightField": "Yükseklik (px)",
            "dxHtmlEditor-heading": "Başlık",
            "dxHtmlEditor-normalText": "Normal metin"
        }
    })
});
