///////////////
// LOGS PAGE //
///////////////

$(function()
{
	Init_translate();
	make_header("logs");
	$("#labellogtype").text(DevExpress.localization.formatMessage("Show log type:"));
	$("#labelautorefresh").text(DevExpress.localization.formatMessage("Autorefresh") + ":");
	set_rcpopup();
	var logrefresh = 1000;
	var ident;
	$.ajax(
	{
		dataType: "json",
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getident" + localStorage.getItem("TOKEN"),
		async: false,
		success: function(data)
		{
			if (CHECK_USER)
			{
				if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
				{
					var urlCam = window.location.href;
					console.log(urlCam);
					urlCam = urlCam.split(":8090")[0] + ":80";
					if (confirm(data))
					{
						window.location.href = urlCam;
					}
					else
					{
						window.location.href = urlCam;
					}
				}
			}
			ident = data;
		}
	});
	var loadPanel = $(".loadpanel").dxLoadPanel(
	{
		shadingColor: "rgba(0,0,0,0.4)",
		position:
		{
			of: ".content_wrapper"
		},
		visible: false,
		showIndicator: true,
		showPane: true,
		shading: true,
		message: DevExpress.localization.formatMessage("Restarting..."),
		closeOnOutsideClick: false
	}).dxLoadPanel("instance");

	function startapp()
	{
		$.ajax(
		{
			url: pathcgi + "../cgi-bin/admin/vadpctrl.cgi?cmd=start&idx=" + ident + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
			success: function()
			{
				loadPanel.hide();
				DevExpress.ui.notify("Application restarted", "success", 600);
			}
		});
	}
	$("#icon-restart").dxButton(
	{
		type: "success",
		text: DevExpress.localization.formatMessage("Restart service"),
		onClick: function()
		{
			loadPanel.show();
			lp = loadPanel;
			restartapp();
		}
	});
	
	var saveopts;
	var logrefresh;
	if (DEFINE_INTERFACE == "AXIS")
	{
		// In Axis and Vicon cameras the CGI is a part of the VPARD Daemon
		saveopts = [DevExpress.localization.formatMessage("Service"), DevExpress.localization.formatMessage("Engine")];
	}
	else
	{
		saveopts = [DevExpress.localization.formatMessage("Manager"), DevExpress.localization.formatMessage("Service"), DevExpress.localization.formatMessage("Engine")];
	}
	
	var timer;
	var exampleTextArea = $("#example-textarea").dxTextArea(
	{
		value: "",
		readOnly: true,
		height: 550
	}).dxTextArea("instance");
	var glogs = $("#glog").dxTextArea(
	{
		value: "",
		readOnly: true,
		height: 550
	}).dxTextArea("instance");
	var glogsengine = $("#glogsengine").dxTextArea(
	{
		value: "",
		readOnly: true,
		height: 550
	}).dxTextArea("instance");
	var optlogs = -1;

	function timerfunc()
	{
		if (optlogs == 0)
		{
			jQuery.ajax(
			{
				async: false,
				url: pathcgi + 'cgi-bin/vparcgi.cgi?computerid=' + computerid + '&oper=cgilogs&d=' + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
					exampleTextArea.option("value", data);
					exampleTextArea.option("readOnly", true);
				}
			});
		}
		if (optlogs == 1)
		{
			jQuery.ajax(
			{
				async: false,
				url: pathcgi + 'cgi-bin/vparcgi.cgi?computerid=' + computerid + '&oper=vpardlogs&d=' + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
					glogs.option("value", data);
					glogs.option("readOnly", true);
				}
			});
		}
		if (optlogs == 2)
		{
			jQuery.ajax(
			{
				async: false,
				url: pathcgi + 'cgi-bin/vparcgi.cgi?computerid=' + computerid + '&oper=enginelogs&d=' + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
					glogsengine.option("value", data);
					glogsengine.option("readOnly", true);
				}
			});
		}
		timer = setTimeout(timerfunc, logrefresh);
		var rr = $(".dx-texteditor-input");
		rr[0].scrollTop = rr[0].scrollHeight;
		rr[1].scrollTop = rr[1].scrollHeight;
		rr[2].scrollTop = rr[2].scrollHeight;
	};
	$("#rtypelogs").dxRadioGroup(
	{
		items: saveopts,
		layout: "horizontal",
		onValueChanged: function(e)
		{
			if (e.value == DevExpress.localization.formatMessage("Manager"))
			{
				optlogs = 0;
				document.getElementById('denglogs').style.visibility = 'visible';
				document.getElementById('denglogs').style.display = 'block';
				document.getElementById('dgenlogs').style.visibility = 'hidden';
				document.getElementById('dgenlogs').style.display = 'none';
				document.getElementById('logsengine').style.visibility = 'hidden';
				document.getElementById('logsengine').style.display = 'none';
				jQuery.ajax(
				{
					url: pathcgi + 'cgi-bin/vparcgi.cgi?computerid=' + computerid + '&oper=cgilogs&d=' + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						if (CHECK_USER)
						{
							if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
							{
								var urlCam = window.location.href;
								console.log(urlCam);
								urlCam = urlCam.split(":8090")[0] + ":80";
								if (confirm(data))
								{
									window.location.href = urlCam;
								}
								else
								{
									window.location.href = urlCam;
								}
							}
						}
						exampleTextArea.option("value", data);
					}
				});
			}
			if (e.value == DevExpress.localization.formatMessage("Service"))
			{
				optlogs = 1;
				document.getElementById('dgenlogs').style.visibility = 'visible';
				document.getElementById('dgenlogs').style.display = 'block';
				document.getElementById('denglogs').style.visibility = 'hidden';
				document.getElementById('denglogs').style.display = 'none';
				document.getElementById('logsengine').style.visibility = 'hidden';
				document.getElementById('logsengine').style.display = 'none';
				jQuery.ajax(
				{
					url: pathcgi + 'cgi-bin/vparcgi.cgi?computerid=' + computerid + '&oper=vpardlogs&d=' + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						if (CHECK_USER)
						{
							if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
							{
								var urlCam = window.location.href;
								console.log(urlCam);
								urlCam = urlCam.split(":8090")[0] + ":80";
								if (confirm(data))
								{
									window.location.href = urlCam;
								}
								else
								{
									window.location.href = urlCam;
								}
							}
						}
						glogs.option("value", data);
					}
				});
			}
			if (e.value == DevExpress.localization.formatMessage("Engine"))
			{
				optlogs = 2;
				document.getElementById('dgenlogs').style.visibility = 'hidden';
				document.getElementById('dgenlogs').style.display = 'none';
				document.getElementById('denglogs').style.visibility = 'hidden';
				document.getElementById('denglogs').style.display = 'none';
				document.getElementById('logsengine').style.visibility = 'visible';
				document.getElementById('logsengine').style.display = 'block';
				jQuery.ajax(
				{
					url: pathcgi + 'cgi-bin/vparcgi.cgi?computerid=' + computerid + '&oper=enginelogs&d=' + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						if (CHECK_USER)
						{
							if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
							{
								var urlCam = window.location.href;
								console.log(urlCam);
								urlCam = urlCam.split(":8090")[0] + ":80";
								if (confirm(data))
								{
									window.location.href = urlCam;
								}
								else
								{
									window.location.href = urlCam;
								}
							}
						}
						glogsengine.option("value", data);
					}
				});
			}
		}
	});
	$("#Autorefresh").dxCheckBox(
	{
		text: DevExpress.localization.formatMessage("Enabled"),
		onValueChanged: function(e)
		{
			if (e.value == true)
			{
				timer = setTimeout(timerfunc, logrefresh);
			}
			else
			{
				clearTimeout(timer);
			}
		}
	});
	$("#icon-done_info").dxButton(
	{
		type: "success",
		text: DevExpress.localization.formatMessage("Download logs"),
		onClick: function()
		{
			window.location = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getlogtgz" + localStorage.getItem("TOKEN");
		}
	});
	$("#clear-logs").dxButton(
	{
		type: "success",
		text: DevExpress.localization.formatMessage("Clear logs"),
		onClick: function()
		{
			jQuery.ajax(
			{
				async: true,
				url: pathcgi + 'cgi-bin/vparcgi.cgi?computerid=' + computerid + '&oper=clearlogs&d=' + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
					DevExpress.ui.notify(DevExpress.localization.formatMessage("OperationOK"), "success", 600);
				}
			});
		}
	});
});