////////////////
// AUDIT PAGE //
////////////////

$(function()
{
	Init_translate();
	make_header("historic");
	$("#labelFrom").text(DevExpress.localization.formatMessage("From date") + ":");
	$("#labeltodate").text(DevExpress.localization.formatMessage("To date") + ":");
	$("#labelType").text(DevExpress.localization.formatMessage("Type") + ":");
	$("#shnumreg").text(DevExpress.localization.formatMessage("Show num registers:"));
	set_rcpopup();
	var priorities = [DevExpress.localization.formatMessage("export"), DevExpress.localization.formatMessage("import"), DevExpress.localization.formatMessage("action")];
	var sellist = 0;
	var dateact = new Date();
	var dateiniday;
	var dateendday;
	var results = [];
	var dictlist = {};
	var dictactions = {};
	var dictexports = {};
	var dictimports = {};
	var dict = {};
	var mostrarAnterior = false;
	var mostrarPosterior = false;
	var num_registros_consulta = 0;
	var num_pages = 0;
	var page_actual = 0;
	var num_regs = 10;
	
	//GET TIME
	$.ajax(
	{
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=gettime&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
		async: false,
		success: function(data)
		{
			if (CHECK_USER)
			{
				if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
				{
					var urlCam = window.location.href;
					console.log(urlCam);
					urlCam = urlCam.split(":8090")[0] + ":80";
					if (confirm(data))
					{
						window.location.href = urlCam;
					}
					else
					{
						window.location.href = urlCam;
					}
				}
			}
			d2 = new Date(data);
			dateiniday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 0, 0, 0);
			dateendday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 23, 59, 59);
		}
	});
	
	//Load list
	$.ajax(
	{
		dataType: "json",
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getconfig&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
		async: false,
		success: function(data)
		{
			if (CHECK_USER)
			{
				if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
				{
					var urlCam = window.location.href;
					console.log(urlCam);
					urlCam = urlCam.split(":8090")[0] + ":80";
					if (confirm(data))
					{
						window.location.href = urlCam;
					}
					else
					{
						window.location.href = urlCam;
					}
				}
			}
			$.each(data[0], function(i, item)
			{
				dictlist[item.id] = item.description;
			});
			$.each(data[2], function(i, item)
			{
				dictactions[item.actiontype] = item.text;
			});
			$.each(data[3], function(i, item)
			{
				dictexports[item.exporttype] = item.text;
			});
			$.each(data[4], function(i, item)
			{
				dictimports[item.importtype] = item.text;
			});
		}
	});
	
	var fdata1 = $("#data1").dxDateBox(
	{
		type: "datetime",
		displayFormat: "dd/MM/yyyy HH:mm:ss",
		value: dateiniday
	}).dxDateBox('instance');
	
	var fdata2 = $("#data2").dxDateBox(
	{
		type: "datetime",
		displayFormat: "dd/MM/yyyy HH:mm:ss",
		value: dateendday
	}).dxDateBox('instance');
	
	var paginitas = $("#paginitas").dxTextBox(
	{
		readOnly: true,
		width: 120,
		value: ""
	});
	
	$("#radio-group-simple").dxSelectBox(
	{
		dataSource: priorities,
		value: DevExpress.localization.formatMessage("export"),
	});
	
	$("#numreg").dxSelectBox(
	{
		items: [10, 20, 50, 100],
		value: 10
	});
	
	$("#medium-indicator").dxLoadIndicator(
	{
		height: 40,
		width: 40
	});
	$("#medium-indicator").hide();
	
	$("#export").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("ExportBut"),
		onClick: function()
		{
			var moreparams = "";
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var table = "";
			if (list == DevExpress.localization.formatMessage("action"))
			{
				table = "nlactionres";
			}
			else if (list == DevExpress.localization.formatMessage("import"))
			{
				table = "nlimportres";
			}
			else
			{
				table = "nlexportres";
			}
			var win = window.open(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportresults&table=" + table + "&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"), '_blank');
			if (win)
			{
				//Browser has allowed it to be opened
				win.focus();
			}
			else
			{
				//Browser has blocked it
				alert('Please allow popups for this website');
			}
		}
	});
	
	$("#FirstPage").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("First page"),
		onClick: function(data2)
		{
			page_actual = 1;
			$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
			var moreparams = "";
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var table = "";
			if (list == DevExpress.localization.formatMessage("action"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
				table = "nlactionres";
			}
			else if (list == DevExpress.localization.formatMessage("import"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlimportres";
			}
			else
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlexportres";
			}
			$.ajax(
			{
				dataType: "json",
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=" + table + "&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&maxvalues=" + num_regs + "&offset=" + ((page_actual - 1) * num_regs) + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
					var dataGrid = $('#gridContainer').dxDataGrid('instance');
					dataGrid.option("dataSource", data);
				}
			});
		}
	});
	
	$("#LastPage").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("Last page"),
		onClick: function(data2)
		{
			page_actual = num_pages;
			$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
			var moreparams = "";
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var table = "";
			if (list == DevExpress.localization.formatMessage("action"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
				table = "nlactionres";
			}
			else if (list == DevExpress.localization.formatMessage("import"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlimportres";
			}
			else
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlexportres";
			}
			$.ajax(
			{
				dataType: "json",
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=" + table + "&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&maxvalues=" + num_regs + "&offset=" + ((page_actual - 1) * num_regs) + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
					var dataGrid = $('#gridContainer').dxDataGrid('instance');
					dataGrid.option("dataSource", data);
				}
			});
		}
	});
	
	$("#PageAnt").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("<< Before"),
		onClick: function(data2)
		{
			if (page_actual > 1)
			{
				page_actual--;
			}
			$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
			var moreparams = "";
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var table = "";
			if (list == DevExpress.localization.formatMessage("action"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
				table = "nlactionres";
			}
			else if (list == DevExpress.localization.formatMessage("import"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlimportres";
			}
			else
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlexportres";
			}
			$.ajax(
			{
				dataType: "json",
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=" + table + "&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&maxvalues=" + num_regs + "&offset=" + ((page_actual - 1) * num_regs) + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
					var dataGrid = $('#gridContainer').dxDataGrid('instance');
					dataGrid.option("dataSource", data);
				}
			});
		}
	});
	
	$("#PageSig").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("Next >>"),
		onClick: function(data2)
		{
			if (page_actual < num_pages)
			{
				page_actual++;
			}
			$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
			var moreparams = "";
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var table = "";
			if (list == DevExpress.localization.formatMessage("action"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
				table = "nlactionres";
			}
			else if (list == DevExpress.localization.formatMessage("import"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlimportres";
			}
			else
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlexportres";
			}
			$.ajax(
			{
				dataType: "json",
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=" + table + "&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&maxvalues=" + num_regs + "&offset=" + ((page_actual - 1) * num_regs) + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				success: function(data)
				{
					if (CHECK_USER)
					{
						if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
						{
							var urlCam = window.location.href;
							console.log(urlCam);
							urlCam = urlCam.split(":8090")[0] + ":80";
							if (confirm(data))
							{
								window.location.href = urlCam;
							}
							else
							{
								window.location.href = urlCam;
							}
						}
					}
					var dataGrid = $('#gridContainer').dxDataGrid('instance');
					dataGrid.option("dataSource", data);
				}
			});
		}
	});
	$("#PageAnt").hide();
	$("#PageSig").hide();
	$("#paginitas").hide();
	$("#FirstPage").hide();
	$("#LastPage").hide();
	
	$("#icon-done_info").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("Search"),
		onClick: function(data2)
		{
			if (fdata1.option('value') > fdata2.option('value'))
			{
				DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("The 'from date' can not be greater than  'to date'"));
			}
			else
			{
				var i = 1;
				var moreparams = "";
				data2.component.option("text", DevExpress.localization.formatMessage("Searching"));
				$("#medium-indicator").show();
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				num_regs = $("#numreg").dxSelectBox('instance').option('value');
				var table = "";
				if (list == DevExpress.localization.formatMessage("action"))
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
					table = "nlactionres";
				}
				else if (list == DevExpress.localization.formatMessage("import"))
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
					table = "nlimportres";
				}
				else
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
					table = "nlexportres";
				}
				$("#PageSig").hide();
				$("#PageAnt").hide();
				$("#paginitas").hide();
				$("#FirstPage").hide();
				$("#LastPage").hide();
				$.ajax(
				{
					async: false,
					url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=count&table=" + table + "&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						if (CHECK_USER)
						{
							if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
							{
								var urlCam = window.location.href;
								console.log(urlCam);
								urlCam = urlCam.split(":8090")[0] + ":80";
								if (confirm(data))
								{
									window.location.href = urlCam;
								}
								else
								{
									window.location.href = urlCam;
								}
							}
						}
						num_registros_consulta = data;
					}
				});
				if (num_registros_consulta > 0)
				{
					$.ajax(
					{
						dataType: "json",
						url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=" + table + "&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&maxvalues=" + num_regs + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
						success: function(data)
						{
							if (CHECK_USER)
							{
								if ((typeof data === 'string') && data.toLowerCase().startsWith("not allow"))
								{
									var urlCam = window.location.href;
									console.log(urlCam);
									urlCam = urlCam.split(":8090")[0] + ":80";
									if (confirm(data))
									{
										window.location.href = urlCam;
									}
									else
									{
										window.location.href = urlCam;
									}
								}
							}
							data2.component.option("text", DevExpress.localization.formatMessage("Search"));
							$("#medium-indicator").hide();
							var dataGrid = $('#gridContainer').dxDataGrid('instance');
							dataGrid.option("dataSource", data);
							dataGrid.option('paging.pageSize', num_regs);
							page_actual = 1;
							num_pages = Math.ceil(num_registros_consulta / num_regs);
							$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
							if (num_pages > 1)
							{
								$("#PageAnt").show();
								$("#PageSig").show();
								$("#paginitas").show();
								$("#FirstPage").show();
								$("#LastPage").show();
							}
						}
					});
				}
				else
				{
					data2.component.option("text", DevExpress.localization.formatMessage("Search"));
					$("#medium-indicator").hide();
					var dataGrid = $('#gridContainer').dxDataGrid('instance');
					dataGrid.option("dataSource", []);
				}
			}
		}
	});
	
	$("#gridContainer").dxDataGrid(
	{
		dataSource: results,
		showBorders: true,
		showRowLines: true,
		keyExpr: "id",
		width: 1150,
		hoverStateEnabled: true,
		searchPanel:
		{
			visible: true,
			width: 240,
			placeholder: DevExpress.localization.formatMessage("Search...")
		},
		pager:
		{
			visible: false
		},
		columns: [
		{
			dataField: "id",
			caption: "ID",
			width: 80,
		},
		{
			dataField: "timestamp",
			dataType: "date",
			caption: DevExpress.localization.formatMessage("Time"),
			width: 180,
			format: "HH:mm:ss.SSS dd/MM/yyyy"
		},
		{
			width: 90,
			dataField: "status",
			caption: DevExpress.localization.formatMessage("Status"),
			cellTemplate: function(element, info)
			{
				element.append(DevExpress.localization.formatMessage(info.text));
			}
		},
		{
			width: 100,
			dataField: "subtype",
			caption: DevExpress.localization.formatMessage("Type"),
			cellTemplate: function(element, info)
			{
				if (typeof dictactions[info.text] !== 'undefined')
				{
					element.append(dictactions[info.text]);
				}
				else if (typeof dictexports[info.text] !== 'undefined')
				{
					element.append(dictexports[info.text]);
				}
				else
				{
					element.append(dictimports[info.text]);
				}
			}
		},
		{
			width: 80,
			dataField: "idresult",
			caption: DevExpress.localization.formatMessage("Res.")
		},
		{
			width: 140,
			dataField: "listid",
			caption: DevExpress.localization.formatMessage("List"),
			cellTemplate: function(element, info)
			{
				var listastring = dictlist[info.text];
				element.append(listastring);
			}
		},
		{
			width: 290,
			dataField: "description",
			caption: DevExpress.localization.formatMessage("Description")
		},
		{
			width: 60,
			dataField: "registers",
			caption: DevExpress.localization.formatMessage("Num.")
		},
		{
			width: 120,
			dataField: "resultfile",
			caption: DevExpress.localization.formatMessage("File"),
			cellTemplate: function(element, info)
			{
				if (info.text != "")
				{
					element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text + localStorage.getItem("TOKEN") + "' >" + DevExpress.localization.formatMessage("Get file") + "</a> ")
				}
			}
		}],

		onRowPrepared: function(row)
		{
			if (row.rowType == "data")
			{
				if (row.values[2] != "DONE")
				{
					row.rowElement.addClass('Red');
				}
			}
		}
	});
});