#!/bin/sh

cmd=${1}
pkgpath=${2}
new_package=${3}
prog="vpard"
progreload="vpardreload"
cgiprog="vparcgi.cgi"
finishfile="${pkgpath}/${prog}/finish"
binpath="${pkgpath}/${prog}/${prog} -- --supervisor"

export LD_LIBRARY_PATH=${pkgpath}:"${pkgpath}/${prog}/":"${pkgpath}/${prog}/lib/":"$LD_LIBRARY_PATH"


_Log()
{
	if [ -z "${SCRIPT_NAME}" ]; then
		echo "${1}"
	else
		echo "<script language='javaScript'>document.write('${1}')</script><br>"
	fi
}

_Log "Installing process [${cmd}] package [${pkgpath}] path [${binpath}] for [${prog}]"


case ${cmd} in
	start)
		_Log "Starting"
		rm -f $finishfile
		start-stop-daemon --start --quiet --background --name $prog --exec $binpath
		_Log "Started"
		echo "."
		;;
	stop)
		_Log "Stopping"
		touch $finishfile
		killall -q $progreload
		start-stop-daemon -K --signal 15 --quiet --name $prog
		_Log "Stopped"
		echo "."
		;;
	install)
		_Log "Install [${new_package}] - [${pkgpath}]"
		# Check platform information and install the correct binary.
		PLATFORM=`${pkgpath}/check_platform`
		[ -e ${pkgpath}/${prog}.${PLATFORM} ] || {
			[ -e ${pkgpath}/${prog} ] && {
				# The LPR package has been installed
				_Log "Finished install 2"
				exit 0
			}
			_Log "Platform ${PLATFORM} is not supported"
			exit 1
		}
		mv ${pkgpath}/${prog}.${PLATFORM} ${pkgpath}/${prog}
		mv ${pkgpath}/cgi-bin/${cgiprog}.${PLATFORM} ${pkgpath}/cgi-bin/${cgiprog}
		mv ${pkgpath}/www/data2.js.${PLATFORM} ${pkgpath}//www/data2.js
		rm -f ${pkgpath}/dos2unix.exe
		rm -rf ${pkgpath}/vpard.win
		_Log "Finished install"
		;;
	upgrade)
		_Log "Upgrade [${new_package}] - [${pkgpath}]"
		VERSION=`cat ${pkgpath}/version.txt`
		PLATFORM=`${pkgpath}/check_platform`
		case ${VERSION} in 
	  		1.* ) _Log "Update on version ${VERSION} is not supported" ;  exit 1 ;;
		esac
		cp -rf ${new_package}/* ${pkgpath}/.
		cp -rf ${new_package}/${prog}.${PLATFORM}/* ${pkgpath}/${prog}/.
		rm -rf ${pkgpath}/${prog}.${PLATFORM}
		cp -rf ${new_package}/cgi-bin/${cgiprog}.${PLATFORM} ${pkgpath}/cgi-bin/${cgiprog}
		rm -f ${pkgpath}/cgi-bin/${cgiprog}.${PLATFORM}
		cp -rf ${new_package}/www/data2.js.${PLATFORM} ${pkgpath}/www/data2.js
		rm -f ${pkgpath}/www/data2.js.${PLATFORM}
		rm -f ${pkgpath}/dos2unix.exe
		rm -r ${pkgpath}/vpard.win
		_Log "Finished upgrade"
		;;
	*)
		;;
esac

exit 0

