////////////////
// AUDIT PAGE //
////////////////

$(function()
{
	Init_translate();
	make_header("historic");
	$("#labelFrom").text(DevExpress.localization.formatMessage("From date") + ":");
	$("#labeltodate").text(DevExpress.localization.formatMessage("To date") + ":");
	$("#labelType").text(DevExpress.localization.formatMessage("Type") + ":");
	$("#shnumreg").text(DevExpress.localization.formatMessage("Show num registers:"));
	set_rcpopup();
	var priorities = [DevExpress.localization.formatMessage("export"), DevExpress.localization.formatMessage("import"), DevExpress.localization.formatMessage("action")];
	var sellist = 0;
	var dateact = new Date();
	var dateiniday;
	var dateendday;
	var results = [];
	var dictlist = {};
	var dictactions = {};
	var dictexports = {};
	var dictimports = {};
	var dict = {};
	var mostrarAnterior = false;
	var mostrarPosterior = false;
	var num_registros_consulta = 0;
	var num_pages = 0;
	var page_actual = 0;
	var num_regs = 10;
	var id_inicial = 0;
	var id_final = 0;
	var sortby_order="sortasc=id";

	//GET TIME
	if(DEFINE_INTERFACE == "HANWHA"){
		var msg = "";
		msg += "<GetSDK_APP_DATA>";
		msg += "<AppName>NeuralEdge</AppName>";
		msg += "<Data>computerid=" + computerid + "|oper=gettime|adinfo=notvalue</Data>";	
		msg += "</GetSDK_APP_DATA>";
		addToQueue(msg, function(response) {
			var data = response;
			console.log("Respuesta msgConf1: " + msg);
			console.log("Respuesta status: " + data);
			CheckTokenValidity(data);
			d2 = new Date(data);
			dateiniday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 0, 0, 0);
			dateendday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 23, 59, 59);

			fdata1 = $("#data1").dxDateBox(
			{
				type: "datetime",
				displayFormat: "dd/MM/yyyy HH:mm:ss",
				value: dateiniday
			}).dxDateBox('instance');
			
			fdata2 = $("#data2").dxDateBox(
			{
				type: "datetime",
				displayFormat: "dd/MM/yyyy HH:mm:ss",
				value: dateendday
			}).dxDateBox('instance');
			return;
		});
	}else{
		$.ajax(
		{
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=gettime&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				CheckTokenValidity(data);
				d2 = new Date(data);
				dateiniday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 0, 0, 0);
				dateendday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 23, 59, 59);
			}
		});
	}
	
	//Load list
	if(DEFINE_INTERFACE == "HANWHA"){
		//GET LISTAS
		var msgConf1 = "";
		msgConf1 += "<GetSDK_APP_DATA>";
		msgConf1 += "<AppName>NeuralEdge</AppName>";
		msgConf1 += "<Data>computerid=" + computerid + "|oper=select|table=nllist|maxvalues=50|adinfo=notvalue</Data>";	
		msgConf1 += "</GetSDK_APP_DATA>";
		addToQueue(msgConf1, function(response) {
			var config1 = response;
			console.log("Respuesta nllist: " + config1);
			try {  
			  config1 = JSON.parse(config1); 
			} catch (e) {  
			  console.log('invalid json'); 
			  return; 
			}
			CheckTokenValidity(config1);
			if(Array.isArray(config1)){
				if(config1.length>0){
					$.each(config1, function(i, item)
					{
						dictlist[item.id] = item.description;
					});
				}
			}	
		});
		//GET ACTIONS
		var msgConf3 = "";
		msgConf3 += "<GetSDK_APP_DATA>";
		msgConf3 += "<AppName>NeuralEdge</AppName>";
		msgConf3 += "<Data>computerid=" + computerid + "|oper=select|table=nlactiontype|maxvalues=20|adinfo=notvalue</Data>";	
		msgConf3 += "</GetSDK_APP_DATA>";
		addToQueue(msgConf3, function(response) {
			var config3 = response;
			config3 = config3.replace(/,,,,,,,,,,,/g, "");
			console.log("Respuesta msgConf3: " + msgConf3);
			console.log("Respuesta nlactiontype: " + config3);
			try {  
			  config3 = JSON.parse(config3); 
			} catch (e) {  
			  console.log('invalid json'); 
			  return; 
			}
			CheckTokenValidity(config3);
			if(Array.isArray(config3)){
				if(config3.length>0){
					$.each(config3, function(i, item)
					{
						dictactions[item.actiontype] = item.text;
					});
				}
			}
		});
		//GET EXPORTS
		var msgConf4 = "";
		msgConf4 += "<GetSDK_APP_DATA>";
		msgConf4 += "<AppName>NeuralEdge</AppName>";
		msgConf4 += "<Data>computerid=" + computerid + "|oper=select|table=nlexporttype|maxvalues=20|adinfo=notvalue</Data>";	
		msgConf4 += "</GetSDK_APP_DATA>";
		addToQueue(msgConf4, function(response) {
			var config4 = response;
			console.log("Respuesta nlexporttype: " + config4);
			try {  
			  config4 = JSON.parse(config4); 
			} catch (e) {  
			  console.log('invalid json'); 
			  return; 
			}
			CheckTokenValidity(config4);
			if(Array.isArray(config4)){
				if(config4.length>0){
					$.each(config4, function(i, item)
					{
						dictexports[item.exporttype] = item.text;
					});
				}
			}
		});
		//GET IMPORTS
		var msgConf5 = "";
		msgConf5 += "<GetSDK_APP_DATA>";
		msgConf5 += "<AppName>NeuralEdge</AppName>";
		msgConf5 += "<Data>computerid=" + computerid + "|oper=select|table=nlimporttype|maxvalues=20|adinfo=notvalue</Data>";	
		msgConf5 += "</GetSDK_APP_DATA>";
		addToQueue(msgConf5, function(response) {
			var config5 = response;
			console.log("Respuesta nlimporttype: " + config5);
			try {  
			  config5 = JSON.parse(config5); 
			} catch (e) {  
			  console.log('invalid json'); 
			  return; 
			}
			CheckTokenValidity(config5);
			if(Array.isArray(config5)){
				if(config5.length>0){
					$.each(config5, function(i, item)
					{
						dictimports[item.importtype] = item.text;
					});
				}
			}

	$("#gridContainer").dxDataGrid(
	{
		dataSource: results,
		showBorders: true,
		showRowLines: true,
		keyExpr: "id",
		width: 1150,
		hoverStateEnabled: true,
		searchPanel:
		{
			visible: true,
			width: 240,
			placeholder: DevExpress.localization.formatMessage("Search...")
		},
		pager:
		{
			visible: false
		},
		columns: [
		{
			dataField: "id",
			caption: "ID",
			width: 80,
		},
		{
			dataField: "timestamp",
			dataType: "date",
			caption: DevExpress.localization.formatMessage("Time"),
			width: 180,
			format: "HH:mm:ss.SSS dd/MM/yyyy"
		},
		{
			width: 90,
			dataField: "status",
			caption: DevExpress.localization.formatMessage("Status"),
			cellTemplate: function(element, info)
			{
				element.append(DevExpress.localization.formatMessage(info.text));
			}
		},
		{
			width: 100,
			dataField: "subtype",
			caption: DevExpress.localization.formatMessage("Type"),
			cellTemplate: function(element, info)
			{
				if (typeof dictactions[info.text] !== 'undefined')
				{
					element.append(dictactions[info.text]);
				}
				else if (typeof dictexports[info.text] !== 'undefined')
				{
					element.append(dictexports[info.text]);
				}
				else
				{
					element.append(dictimports[info.text]);
				}
			}
		},
		{
			width: 80,
			dataField: "idresult",
			caption: DevExpress.localization.formatMessage("Res.")
		},
		{
			width: 140,
			dataField: "listid",
			caption: DevExpress.localization.formatMessage("List"),
			cellTemplate: function(element, info)
			{
				var listastring = dictlist[info.text];
				element.append(listastring);
			}
		},
		{
			width: 290,
			dataField: "description",
			caption: DevExpress.localization.formatMessage("Description")
		},
		{
			width: 60,
			dataField: "registers",
			caption: DevExpress.localization.formatMessage("Num.")
		},
		{
			width: 120,
			dataField: "resultfile",
			caption: DevExpress.localization.formatMessage("File"),
			cellTemplate: function(element, info)
			{
				if (info.text != "")
				{
					element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text + localStorage.getItem("TOKEN") + "' >" + DevExpress.localization.formatMessage("Get file") + "</a> ")
				}
			}
		}],

		onRowPrepared: function(row)
		{
			if (row.rowType == "data")
			{
				if (row.values[2] != "DONE")
				{
					row.rowElement.addClass('Red');
				}
			}
		}
	});
		});
	}else{
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getconfig&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				CheckTokenValidity(data);
				$.each(data[0], function(i, item)
				{
					dictlist[item.id] = item.description;
				});
				$.each(data[2], function(i, item)
				{
					dictactions[item.actiontype] = item.text;
				});
				$.each(data[3], function(i, item)
				{
					dictexports[item.exporttype] = item.text;
				});
				$.each(data[4], function(i, item)
				{
					dictimports[item.importtype] = item.text;
				});
			}
		});
	}
	var fdata1 = $("#data1").dxDateBox(
	{
		type: "datetime",
		displayFormat: "dd/MM/yyyy HH:mm:ss",
		value: dateiniday
	}).dxDateBox('instance');
	
	var fdata2 = $("#data2").dxDateBox(
	{
		type: "datetime",
		displayFormat: "dd/MM/yyyy HH:mm:ss",
		value: dateendday
	}).dxDateBox('instance');
	
	
	var paginitas = $("#paginitas").dxTextBox(
	{
		readOnly: true,
		width: 120,
		value: ""
	});
	
	$("#radio-group-simple").dxSelectBox(
	{
		dataSource: priorities,
		value: DevExpress.localization.formatMessage("export"),
	});
	
	$("#numreg").dxSelectBox(
	{
		items: [10, 20, 50, 100],
		value: 10
	});
	
	$("#medium-indicator").dxLoadIndicator(
	{
		height: 40,
		width: 40
	});
	$("#medium-indicator").hide();
	
	$("#export").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("ExportBut"),
		onClick: function()
		{
			var moreparams = "";
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var table = "";
			if (list == DevExpress.localization.formatMessage("action"))
			{
				table = "nlactionres";
			}
			else if (list == DevExpress.localization.formatMessage("import"))
			{
				table = "nlimportres";
			}
			else
			{
				table = "nlexportres";
			}
			var win = window.open(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=exportresults&table=" + table + "&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"), '_blank');
			if (win)
			{
				//Browser has allowed it to be opened
				win.focus();
			}
			else
			{
				//Browser has blocked it
				alert('Please allow popups for this website');
			}
		}
	});
	
	$("#FirstPage").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("First page"),
		onClick: function(data2)
		{
			page_actual = 1;
			$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
			var moreparams = "";
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var table = "";
			if (list == DevExpress.localization.formatMessage("action"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
				table = "nlactionres";
			}
			else if (list == DevExpress.localization.formatMessage("import"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlimportres";
			}
			else
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlexportres";
			}
			if(DEFINE_INTERFACE == "HANWHA"){
				var msg = "";
				msg += "<GetSDK_APP_DATA>";
				msg += "<AppName>NeuralEdge</AppName>";
				msg += "<Data>computerid=" + computerid + "|oper=select|table=" + table + "|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "|maxvalues=" + num_regs + "|offset=" + ((page_actual - 1) * num_regs) + "|adinfo=notvalue</Data>";	
				msg += "</GetSDK_APP_DATA>";
				addToQueue(msg, function(response) {
					var data = response;
					console.log("Test search response: " + data);
					CheckTokenValidity(data);
					var json_data;
					try {  
					    json_data = JSON.parse(data); 
					} catch (e) {  
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
						DevExpress.ui.notify(e.name + ": " + e.message, "error", 1500);
					    console.log('invalid json'); 
					    return; 
					}
					var dataGrid = $('#gridContainer').dxDataGrid('instance');
					dataGrid.option("dataSource", json_data);
				});
			}else{
				$.ajax(
				{
					dataType: "json",
					url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=" + table + "&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&maxvalues=" + num_regs + "&offset=" + ((page_actual - 1) * num_regs) + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						CheckTokenValidity(data);
						var dataGrid = $('#gridContainer').dxDataGrid('instance');
						dataGrid.option("dataSource", data);
					}
				});
			}
		}
	});
	
	$("#LastPage").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("Last page"),
		onClick: function(data2)
		{
			page_actual = num_pages;
			$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
			var moreparams = "";
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var table = "";
			if (list == DevExpress.localization.formatMessage("action"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
				table = "nlactionres";
			}
			else if (list == DevExpress.localization.formatMessage("import"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlimportres";
			}
			else
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlexportres";
			}
			if(DEFINE_INTERFACE == "HANWHA"){
				var msg = "";
				msg += "<GetSDK_APP_DATA>";
				msg += "<AppName>NeuralEdge</AppName>";
				msg += "<Data>" + buildPageQueryByOffset(computerid, table, fdata1, fdata2, page_actual, num_regs, moreparams, sortby_order) + "|adinfo=notvalue</Data>";	
				msg += "</GetSDK_APP_DATA>";
				addToQueue(msg, function(response) {
					var data = response;
					console.log("Test search response: " + data);
					CheckTokenValidity(data);
					var json_data;
					try {  
					    json_data = JSON.parse(data); 
					} catch (e) {  
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
						DevExpress.ui.notify(e.name + ": " + e.message, "error", 1500);
					    console.log('invalid json'); 
					    return; 
					}
					var dataGrid = $('#gridContainer').dxDataGrid('instance');
					dataGrid.option("dataSource", json_data);
				});
			}else{
				$.ajax(
				{
					dataType: "json",
					url: pathcgi + "cgi-bin/vparcgi.cgi?" + buildPageQueryByOffset(computerid, table, fdata1, fdata2, page_actual, num_regs, moreparams, sortby_order) + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						CheckTokenValidity(data);
						var dataGrid = $('#gridContainer').dxDataGrid('instance');
						dataGrid.option("dataSource", data);
					}
				});
			}
		}
	});
	
	$("#PageAnt").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("<< Before"),
		onClick: function(data2)
		{
			if (page_actual > 1)
			{
				page_actual--;
			}
			$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
			var moreparams = "";
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var table = "";
			if (list == DevExpress.localization.formatMessage("action"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
				table = "nlactionres";
			}
			else if (list == DevExpress.localization.formatMessage("import"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlimportres";
			}
			else
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlexportres";
			}			
			if(DEFINE_INTERFACE == "HANWHA"){
				var msg = "";
				msg += "<GetSDK_APP_DATA>";
				msg += "<AppName>NeuralEdge</AppName>";
				msg += "<Data>" + buildPageQueryByOffset(computerid, table, fdata1, fdata2, page_actual, num_regs, moreparams, sortby_order) + "|adinfo=notvalue</Data>";
				msg += "</GetSDK_APP_DATA>";
				addToQueue(msg, function(response) {
					var data = response;
					console.log("Test search response: " + data);
					CheckTokenValidity(data);
					var json_data;
					try {  
					    json_data = JSON.parse(data); 
					} catch (e) {  
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
						DevExpress.ui.notify(e.name + ": " + e.message, "error", 1500);
					    console.log('invalid json'); 
					    return; 
					}
					var dataGrid = $('#gridContainer').dxDataGrid('instance');
					dataGrid.option("dataSource", json_data);
				});
			}else{
				$.ajax(
				{
					dataType: "json",
					url: pathcgi + "cgi-bin/vparcgi.cgi?" + buildPageQueryByOffset(computerid, table, fdata1, fdata2, page_actual, num_regs, moreparams, sortby_order) + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						CheckTokenValidity(data);
						var dataGrid = $('#gridContainer').dxDataGrid('instance');
						dataGrid.option("dataSource", data);
					}
				});
			}
		}
	});
	
	$("#PageSig").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("Next >>"),
		onClick: function(data2)
		{
			if (page_actual < num_pages)
			{
				page_actual++;
			}
			$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
			var moreparams = "";
			var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
			var table = "";
			if (list == DevExpress.localization.formatMessage("action"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
				table = "nlactionres";
			}
			else if (list == DevExpress.localization.formatMessage("import"))
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlimportres";
			}
			else
			{
				$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
				$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
				table = "nlexportres";
			}			
			if(DEFINE_INTERFACE == "HANWHA"){
				var msg = "";
				msg += "<GetSDK_APP_DATA>";
				msg += "<AppName>NeuralEdge</AppName>";
				msg += "<Data>" + buildPageQueryByOffset(computerid, table, fdata1, fdata2, page_actual, num_regs, moreparams, sortby_order) + "|adinfo=notvalue</Data>";
				msg += "</GetSDK_APP_DATA>";
				addToQueue(msg, function(response) {
					var data = response;
					console.log("Test search response: " + data);
					CheckTokenValidity(data);
					var json_data;
					try {  
					    json_data = JSON.parse(data); 
					} catch (e) {  
						DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
						DevExpress.ui.notify(e.name + ": " + e.message, "error", 1500);
					    console.log('invalid json'); 
					    return; 
					}
					var dataGrid = $('#gridContainer').dxDataGrid('instance');
					dataGrid.option("dataSource", json_data);
				});
			}else{
				$.ajax(
				{
					dataType: "json",
					url: pathcgi + "cgi-bin/vparcgi.cgi?" + buildPageQueryByOffset(computerid, table, fdata1, fdata2, page_actual, num_regs, moreparams, sortby_order) + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						CheckTokenValidity(data);
						var dataGrid = $('#gridContainer').dxDataGrid('instance');
						dataGrid.option("dataSource", data);
					}
				});
			}
		}
	});
	$("#PageAnt").hide();
	$("#PageSig").hide();
	$("#paginitas").hide();
	$("#FirstPage").hide();
	$("#LastPage").hide();
	
	$("#icon-done_info").dxButton(
	{
		type: "success",
		height: 40,
		text: DevExpress.localization.formatMessage("Search"),
		onClick: function(data2)
		{
			if (fdata1.option('value') > fdata2.option('value'))
			{
				DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("The 'from date' can not be greater than  'to date'"));
			}else if(fdata1.option('value') == undefined || fdata1.option('value') == "" || fdata2.option('value') == undefined || fdata2.option('value') == ""){
				DevExpress.ui.dialog.alert("Invalid dates.");
			}
			else
			{
				var i = 1;
				var moreparams = "";
				data2.component.option("text", DevExpress.localization.formatMessage("Searching"));
				$("#medium-indicator").show();
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				num_regs = $("#numreg").dxSelectBox('instance').option('value');
				var table = "";
				if (list == DevExpress.localization.formatMessage("action"))
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
					table = "nlactionres";
				}
				else if (list == DevExpress.localization.formatMessage("import"))
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
					table = "nlimportres";
				}
				else
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
					table = "nlexportres";
				}
				$("#PageSig").hide();
				$("#PageAnt").hide();
				$("#paginitas").hide();
				$("#FirstPage").hide();
				$("#LastPage").hide();

				if(DEFINE_INTERFACE == "HANWHA"){
					var msg = "";
					msg += "<GetSDK_APP_DATA>";
					msg += "<AppName>NeuralEdge</AppName>";
					msg += "<Data>computerid=" + computerid + "|oper=count|table=" + table + "|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "|adinfo=notvalue</Data>";	
					msg += "</GetSDK_APP_DATA>";
					addToQueue(msg, function(response) {
						var data = response;
						CheckTokenValidity(data);
						num_registros_consulta = data;

						if (num_registros_consulta > 0){
							var msg2 = "";
							msg2 += "<GetSDK_APP_DATA>";
							msg2 += "<AppName>NeuralEdge</AppName>";
							msg2 += "<Data>computerid=" + computerid + "|oper=select|table=" + table + "|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "|maxvalues=" + num_regs + "|adinfo=notvalue</Data>";	
							msg2 += "</GetSDK_APP_DATA>";
							addToQueue(msg2, function(response) {
								var data = response;
								console.log("Test search response: " + data);
								CheckTokenValidity(data);
								var json_data;
								try {  
								    json_data = JSON.parse(data); 
								} catch (e) {  
									DevExpress.ui.notify(DevExpress.localization.formatMessage("Cannot obtain the results"), "error", 1500);
									DevExpress.ui.notify(e.name + ": " + e.message, "error", 1500);
								    console.log('invalid json'); 
									data2.component.option("text", DevExpress.localization.formatMessage("Search"));
									$("#medium-indicator").hide();
								    return; 
								}
									data2.component.option("text", DevExpress.localization.formatMessage("Search"));
									$("#medium-indicator").hide();
									var dataGrid = $('#gridContainer').dxDataGrid('instance');
									dataGrid.option("dataSource", json_data);
									dataGrid.option('paging.pageSize', num_regs);
									page_actual = 1;
									num_pages = Math.ceil(num_registros_consulta / num_regs);
									$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
									if (num_pages > 1)
									{
										$("#PageAnt").show();
										$("#PageSig").show();
										$("#paginitas").show();
										$("#FirstPage").show();
										$("#LastPage").show();
									}
							});
						}
						else
						{
							data2.component.option("text", DevExpress.localization.formatMessage("Search"));
							$("#medium-indicator").hide();
							var dataGrid = $('#gridContainer').dxDataGrid('instance');
							dataGrid.option("dataSource", []);
						}

					});
				}else{
					$.ajax(
					{
						async: false,
						url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=count&table=" + table + "&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
						success: function(data)
						{
							CheckTokenValidity(data);
							num_registros_consulta = data;
						}
					});
					if (num_registros_consulta > 0)
					{
						$.ajax(
						{
							dataType: "json",
							url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=" + table + "&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) + moreparams + "&maxvalues=" + num_regs + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
							success: function(data)
							{
								CheckTokenValidity(data);
								data2.component.option("text", DevExpress.localization.formatMessage("Search"));
								$("#medium-indicator").hide();
								var dataGrid = $('#gridContainer').dxDataGrid('instance');
								dataGrid.option("dataSource", data);
								dataGrid.option('paging.pageSize', num_regs);
								page_actual = 1;
								num_pages = Math.ceil(num_registros_consulta / num_regs);
								$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
								if (num_pages > 1)
								{
									$("#PageAnt").show();
									$("#PageSig").show();
									$("#paginitas").show();
									$("#FirstPage").show();
									$("#LastPage").show();
								}
							}
						});
					}
					else
					{
						data2.component.option("text", DevExpress.localization.formatMessage("Search"));
						$("#medium-indicator").hide();
						var dataGrid = $('#gridContainer').dxDataGrid('instance');
						dataGrid.option("dataSource", []);
					}
				}
			}
		}
	});
	
	if (DEFINE_INTERFACE != "HANWHA"){
		$("#gridContainer").dxDataGrid(
			{
				dataSource: results,
				showBorders: true,
				showRowLines: true,
				keyExpr: "id",
				width: 1150,
				hoverStateEnabled: true,
				searchPanel:
				{
					visible: true,
					width: 240,
					placeholder: DevExpress.localization.formatMessage("Search...")
				},
				pager:
				{
					visible: false
				},
				columns: [
				{
					dataField: "id",
					caption: "ID",
					width: 80,
				},
				{
					dataField: "timestamp",
					dataType: "date",
					caption: DevExpress.localization.formatMessage("Time"),
					width: 180,
					format: "HH:mm:ss.SSS dd/MM/yyyy"
				},
				{
					width: 90,
					dataField: "status",
					caption: DevExpress.localization.formatMessage("Status"),
					cellTemplate: function(element, info)
					{
						element.append(DevExpress.localization.formatMessage(info.text));
					}
				},
				{
					width: 100,
					dataField: "subtype",
					caption: DevExpress.localization.formatMessage("Type"),
					cellTemplate: function(element, info)
					{
						if (typeof dictactions[info.text] !== 'undefined')
						{
							element.append(dictactions[info.text]);
						}
						else if (typeof dictexports[info.text] !== 'undefined')
						{
							element.append(dictexports[info.text]);
						}
						else
						{
							element.append(dictimports[info.text]);
						}
					}
				},
				{
					width: 80,
					dataField: "idresult",
					caption: DevExpress.localization.formatMessage("Res.")
				},
				{
					width: 140,
					dataField: "listid",
					caption: DevExpress.localization.formatMessage("List"),
					cellTemplate: function(element, info)
					{
						var listastring = dictlist[info.text];
						element.append(listastring);
					}
				},
				{
					width: 290,
					dataField: "description",
					caption: DevExpress.localization.formatMessage("Description")
				},
				{
					width: 60,
					dataField: "registers",
					caption: DevExpress.localization.formatMessage("Num.")
				},
				{
					width: 120,
					dataField: "resultfile",
					caption: DevExpress.localization.formatMessage("File"),
					cellTemplate: function(element, info)
					{
						if (info.text != "")
						{
							element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text + localStorage.getItem("TOKEN") + "' >" + DevExpress.localization.formatMessage("Get file") + "</a> ")
						}
					}
				}],

				onRowPrepared: function(row)
				{
					if (row.rowType == "data")
					{
						if (row.values[2] != "DONE")
						{
							row.rowElement.addClass('Red');
						}
					}
				}
			});
	}
	
});