////////////////////////////
// LPR CONFIGURATION PAGE //
////////////////////////////

$(function()
{
	Init_translate();
	make_header("camconfiguration");
	set_rcpopup();
	var locations;
	var resx = 0;
	var resy = 0;
	var dict = {};
	var multioptdict = {};
	var ident = 0;
	var countries;
	var regions;
	var selected_region = 0;
	var countriesds;
	var countryelem;
	var cross_lista;
	var crossdatagrid;
	var crosslineediting = -1;
	var actdict = {};
	var resolutions;
	var mincharh;
	/*var modearray = [
	{
		"id": 1,
		"description": DevExpress.localization.formatMessage("Entering")
	},
	{
		"id": 2,
		"description": DevExpress.localization.formatMessage("Leaving")
	},
	{
		"id": 3,
		"description": DevExpress.localization.formatMessage("Both")
	}];*/
	var aplication;
	if (DEFINE_INTERFACE == "VIVOTEK" || DEFINE_INTERFACE == "VIVOTEK_CV25")
	{
		aplication = getApplication();
	}else if(DEFINE_INTERFACE == "HANWHA"){
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			var msg = "";
			msg += "<GetSDK_APP_DATA>";
			msg += "<AppName>NeuralEdge</AppName>";
			msg += "<Data>computerid=" + computerid + "|oper=select|table=nlconfgeneral|camp0=id|value0=0|camp1=value|maxvalues=250|adinfo=notvalue</Data>";	
			msg += "</GetSDK_APP_DATA>";

			addToQueue(msg, function(response) {
				var resData = response; 
				console.log("Response in first query response: " + resData);
				console.log("Datos consulta: " + msg);
				resData = resData.replace(/,,/g, "");
				resData = resData.replace(/\},]/g, "\}]");
				console.log("Respuesta nlconfgeneral replace: " + resData);

	        	if(resData!=undefined && resData!=""){
					try {  
					  resData = JSON.parse(resData); 
					} catch (e) {  
					  console.log('invalid json'); 
					  return; 
					}
					if(Array.isArray(resData)){
						CheckTokenValidity(resData);
						aplication = resData[0].value;
					}
				} 
	    	}); 
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	}
	String.prototype.replaceAll = function(search, replacement)
	{
		var target = this;
		return target.replace(new RegExp(search, 'g'), replacement);
	};
	
	String.prototype.insert = function(index, string)
	{
		if (index > 0)
			return this.substring(0, index) + string + this.substring(index, this.length);
		return string + this;
	};

	var msg1 = "";
	if(DEFINE_INTERFACE=="VIVOTEK_CV25")
	{
		msg1 = DevExpress.localization.formatMessage("Service restarting CV25...");
	}
	else
	{
		msg1 = DevExpress.localization.formatMessage("Service restarting...");
	}

	var loadPanel = $(".loadpanel").dxLoadPanel(
	{
		shadingColor: "rgba(0,0,0,0.4)",
		visible: false,
		showIndicator: true,
		showPane: true,
		shading: true,
		width: 300,        
		onShown: function() {

			if(DEFINE_INTERFACE=="HANWHA")
				setTimeout(checkStatus, 40000);
			else
				setTimeout(checkStatus, 5000);

            setTimeout(function(){
				  loadPanel.hide();
				}, popupTime);
        },
		
		message: msg1,
		closeOnOutsideClick: false
	}).dxLoadPanel("instance");

	var tries = 0;
	function checkStatus(){
		var d = new Date();

		if(DEFINE_INTERFACE == "HANWHA"){
			var msg1 = "";
			msg1 += "<GetSDK_APP_DATA>";
			msg1 += "<AppName>NeuralEdge</AppName>";	
			msg1 += "<Data>computerid=" + computerid + "|oper=status|adinfo=notvalue</Data>";	
			msg1 += "</GetSDK_APP_DATA>";

			addToQueue(msg1, function(response) {
				var data = response; 
	        	if(data!=undefined){
	        		try{
        				data = JSON.parse(data);
	        		}catch(e){
	        			console("Invalid json");
	        			if(tries < 6){
							setTimeout(checkStatus, 5000);
							tries++;
						}else{
							tries = 0;
						}
	        			return;
	        		}
	        		console.log("Response Status: " + JSON.stringify(data));
	        		if(Array.isArray(data)){
	        			console.log("Data is array");
						for(var i = 0; i < data.length; i++){
							if(data[i].ident == "service"){
								if(data[i].value < 4 && data[i].value >= 0){
									loadPanel.hide();
									tries = 0;
								}else{
									if(tries < 6){
										setTimeout(checkStatus, 5000);
										tries++;
									}else{
										tries = 0;
									}
								}
							}
						}
	        		}else{
						if(tries < 6){
							setTimeout(checkStatus, 5000);
							tries++;
						}else{
							tries = 0;
						}
	        		}

				}else{
						if(tries < 6){
							setTimeout(checkStatus, 5000);
							tries++;
						}else{
							tries = 0;
						}
				}
	  		});	
		}else{

			$.ajax(
			{
				dataType: "json",
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=status&d=" + getStringNormalDate(d) + localStorage.getItem("TOKEN"),
				async: false,
				success: function(data)
				{
					for(var i = 0; i < data.length; i++){
						if(data[i].ident == "service"){
							if(data[i].value < 4 && data[i].value >= 0){
								loadPanel.hide();
								tries = 0;
							}else{
								if(tries < 6){
									setTimeout(checkStatus, 5000);
									tries++;
								}else{
									tries = 0;
								}
							}
						}
					}
				},
				error: function(){
					if(tries < 6){
						setTimeout(checkStatus, 5000);
						tries++;
					}else{
						tries = 0;
					}
				}
			});
		}
	}

	function simpleHanwhaUpdate(msg){
		addToQueue(msg1, function(response) {
			var resData = response; 
			console.log("Datos consulta: " + msg);
			console.log("Respuesta status: " + resData);
        	if(resData!=undefined && resData!=""){
				DevExpress.ui.notify("Data saved", "success", 600);
			}else{
				DevExpress.ui.notify("Data saving error", "error", 600);																
			}  
    	}); 
	}
	
	var btroi;


	if(DEFINE_INTERFACE == "HANWHA"){
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		var msg = "";
		msg += "<GetSDK_APP_DATA>";
		msg += "<AppName>NeuralEdge</AppName>";
		msg += "<Data>computerid=" + computerid + "|oper=select|table=nlregion|maxvalues=250|adinfo=notvalue</Data>";	
		msg += "</GetSDK_APP_DATA>";

		addToQueue(msg, function(response) {
			var resData = response; 
			console.log("Respuesta status: " + resData);
        	if(resData!=undefined && resData!=""){
				CheckTokenValidity(resData);
				regions = JSON.parse(resData);
				for(var i = 0; i < regions.length; i++){
				   var store = regionds.store();
				   console.log("Insert: " + regions[i] + " ------ " + regions[i].id + " - " + regions[i].description);
				    store.insert(regions[i])
				        .done(function (dataObj, key) {
			   				console.log("Inserted: " + dataObj);
				            regionds.reload();
				        })
				        .fail(function (error) { 
				        	console.log("Error: " + error);
				    	});
				}
			} 
    	}); 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	}else{
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlregion&maxvalues=250&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				CheckTokenValidity(data);
				regions = data;
			}
		});
	}
	String.prototype.includes = function(str)
	{
		var returnValue = false;
		if (this.indexOf(str) !== -1)
		{
			returnValue = true;
		}
		return returnValue;
	}

	if(DEFINE_INTERFACE == "HANWHA"){
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			var msg = "";
			msg += "<GetSDK_APP_DATA>";
			msg += "<AppName>NeuralEdge</AppName>";
			msg += "<Data>computerid=" + computerid + "|oper=select|table=nllocation|maxvalues=250|adinfo=notvalue</Data>";	
			msg += "</GetSDK_APP_DATA>";

			addToQueue(msg, function(response) {
				var resData = response; 
				console.log("Response in first query response: " + JSON.stringify(resData));
				console.log("Datos consulta: " + msg);
				console.log("Respuesta : " + JSON.stringify(resData));
				console.log("Respuesta status: " + resData);
	        	if(resData!=undefined && resData!=""){
					CheckTokenValidity(resData);
					locations = JSON.parse(resData);
					for(var i = 0; i < locations.length; i++){
					   var store = locationsds.store();
					   console.log("Insert: " + locations[i] + " ------ " + locations[i].id + " - " + locations[i].description);
					    store.insert(locations[i])
					        .done(function (dataObj, key) {
				   				console.log("Inserted: " + dataObj);
					            locationsds.reload();
					        })
					        .fail(function (error) { 
					        	console.log("Error: " + error);
					    	});
					}
				}  
	    	}); 
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	}else{
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nllocation&maxvalues=250&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				CheckTokenValidity(data);
				locations = data;
			}
		});
	}
	var locationsds = new DevExpress.data.DataSource(
	{
		store: locations,
		key: "id",
	});
	var regionds = new DevExpress.data.DataSource(
	{
		store: regions,
		key: "id",
	});

	if(DEFINE_INTERFACE == "HANWHA"){
				/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		var msg = "";
		msg += "<GetSDK_APP_DATA>";
		msg += "<AppName>NeuralEdge</AppName>";
		msg += "<Data>computerid=" + computerid + "|oper=getident|adinfo=notvalue</Data>";	
		msg += "</GetSDK_APP_DATA>";

		addToQueue(msg, function(response) {
			var resData = response; 
			console.log("Response in first query response: " + JSON.stringify(resData));
			console.log("Datos consulta: " + msg);
			console.log("Respuesta : " + JSON.stringify(resData));
			console.log("Respuesta status: " + resData);
        	if(resData!=undefined && resData!=""){
				CheckTokenValidity(resData);
				ident = resData;
			}			
    	}); 
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	}else{
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getident" + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				CheckTokenValidity(data);
				ident = data;
			}
		});
	}
	$("#restartserv").dxButton(
	{
		type: "success",
		text: DevExpress.localization.formatMessage("Restart service"),
		onClick: function()
		{
			loadPanel.show();
			// lp = loadPanel;

			//$("#popup" + i).append(data);
			// var poup = $("#restartpopup").dxPopup(
			// {
			// 	showTitle: true,
			// 	title: DevExpress.localization.formatMessage("Service restarting... the process may take a few seconds, please wait."),
			// 	visible: true,
			// 	loseOnOutsideClick: true
			// });
			// var restartpopup = $("#restartpopup").dxPopup("instance");
			// restartpopup.show();

			restartapp();
		}
	});
	$("#restartdefault").dxButton(
	{
		type: "default",
		text: DevExpress.localization.formatMessage("Restart default configuration"),
		onClick: function()
		{
			var result = DevExpress.ui.dialog.confirm(DevExpress.localization.formatMessage("Are you sure to restart default configuration?"), DevExpress.localization.formatMessage("Default configuration"));
			result.done(function(dialogResult)
			{
				if (dialogResult)
				{
					if(DEFINE_INTERFACE == "HANWHA"){
						/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
						var msg = "";
						msg += "<GetSDK_APP_DATA>";
						msg += "<AppName>NeuralEdge</AppName>";
						msg += "<Data>computerid=" + computerid + "|oper=defaultcameraconfig</Data>";	
						msg += "</GetSDK_APP_DATA>";

						addToQueue(msg, function(response) {
							var resData = response; 
							console.log("Datos consulta: " + msg);
							console.log("Respuesta status: " + resData);
				        	if(resData!=undefined && resData!=""){
								CheckTokenValidity(data);
			                    resetLANES();
								location.reload();
							} 
				    	}); 
						/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
					}else{
						$.ajax(
						{
							dataType: "json",
							url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=defaultcameraconfig" + localStorage.getItem("TOKEN"),
							async: false,
							success: function(data)
							{
								CheckTokenValidity(data);
							}
						});
		                resetLANES();
						location.reload();
					}
				}
			});
		}
	});

	function createFieldsHanwha(second, idx){
		var index = 0; 
		index = idx;
		var lastIndex = 0; 
		var secondCall = false;
		secondCall = second;

		var queryHalf = "minor";
		if(secondCall)
			queryHalf = "major";

		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		var msg = "";
		msg += "<GetSDK_APP_DATA>";
		msg += "<AppName>NeuralEdge</AppName>";
		msg += "<Data>computerid=" + computerid + "|oper=select|table=nlconfcamera|maxvalues=250|camp0=cameraid|comp0=minor|value0=2|camp1=id|comp1="+queryHalf+"|value1=50|adinfo=notvalue</Data>";	
		msg += "</GetSDK_APP_DATA>";

		addToQueue(msg, function(response) {
			var data = response;
			console.log("Response in first CREATE FIELDS: " + JSON.stringify(data));
			console.log("Datos consulta CREATE FIELDS: " + msg);
			console.log("Respuesta CREATE FIELDS: " + JSON.stringify(data));
			console.log("Respuesta status CREATE FIELDS: " + data);
			data = data.replace(",,,,,,,,,,,,,,,,,,,,", "");
	    	if(data!=undefined && data!=""){
				try {  
				  data = JSON.parse(data); 
				} catch (e) {  
				  console.log('invalid json'); 
				  return; 
				}
				if(Array.isArray(data)){
					//------------------------------------------------------------------------------------------------------------------------------------
						if(!second){
							$(".content_wrapper").append(" <div class='dx-fieldset-header cerrado' id='ROIheader' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Show Roi") + "</div> ");
							$(".content_wrapper").append(" <div class='dx-fieldset' id= 'fiedlROI'  ></div> ");
							$(".content_wrapper").append(" <div class='dx-fieldset-header cerrado' id='LH1' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Show Lanes") + "</div> ");
							$(".content_wrapper").append(" <div class='dx-fieldset' id= 'fiedlLANES'  ></div> ");
							$("#fiedlROI").hide();
							$("#fiedlLANES").hide();
							$("#LH1").click(function()
							{
								if ($("#LH1").hasClass("abierto"))
								{
									$(this).removeClass('abierto');
									$(this).addClass('cerrado');
									$("#fiedlLANES").hide();
								}
								else
								{
									$(this).addClass('abierto');
									$(this).removeClass('cerrado');
									$("#fiedlLANES").show();
								}
							});
							fillHanwhaFieldLanes();
						}
						//First bucle to create checkbox and div
						$.each(data, function(i, item)
						{
							lastIndex = i;
							if (item.grouppar != "")
							{
								if (typeof dict[item.grouppar] === "undefined")
								{
									item.indexg = i;
									dict[item.grouppar] = i;
									var toadd = "<div class='dx-fieldset-header cerrado' id='group" + (i + index) + "' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage(item.grouppar) + "</div> ";
									toadd += "<div class='dx-fieldset' id= 'fiedl" + (i + index) + "'  ></div>";
									$(".content_wrapper").append(toadd);
									$("#fiedl" + i).hide();
									$("#group" + i).click(function()
									{
										if ($("#group" + i).hasClass("abierto"))
										{
											$(this).removeClass('abierto');
											$(this).addClass('cerrado');
											$("#fiedl" + i).hide();
											listplatesabierto = false;
										}
										else
										{
											$(this).addClass('abierto');
											$(this).removeClass('cerrado');
											$("#fiedl" + i).show();
											listplatesabierto = true;
										}
									});
								}
								else
								{
									item.indexg = dict[item.grouppar];
								}
							}
							else
							{
								item.indexg = -1;
							}
							if (item.id == 57)
							{
								if (item.name.includes("umresolution"))
								{
									var resopt = (item.value).split("x");
									resx = resopt[0];
									resy = resopt[1];
									resolutions = (item.options).split(";");
								}
							}
						});
						$.each(data, function(i, item)
						{
							if (item.visible == 1)
							{
								if (item.typepar == "int")
								{
									var normalexper = "";
									if (item.indexg == -1)
									{
										normalexper = "#field";
									}
									else
									{
										normalexper = "#fiedl" + item.indexg;
									}
									$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + (i + index) + "'></div></div></div>");
									var valopt = (item.options).split(";");
									$("#elem" + (i + index)).dxNumberBox(
									{
										value: item.value,
										min: valopt[0],
										max: valopt[1],
										showSpinButtons: true,
										onValueChanged: function(e)
										{
											var previousValue = e.previousValue;
											var newValue = e.value;
											// Event handling commands go here

											var msg = "";
												msg += "<GetSDK_APP_DATA>";
												msg += "<AppName>NeuralEdge</AppName>";
												msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid+"</Data>";	
												msg += "</GetSDK_APP_DATA>";

												addToQueue(msg, function(response) {
													var resData = response; 
													console.log("Datos consulta: " + msg);
													console.log("Respuesta status: " + resData);
										        	if(resData!=undefined && resData!=""){
														DevExpress.ui.notify("Data saved", "success", 600);
													}else{
														DevExpress.ui.notify("Data saving error", "error", 600);																
													}   
										    	}); 
										}
									});
								}
								else if (item.typepar == "multioption")
								{
									var normalexper = "";
									if (item.indexg == -1)
									{
										normalexper = "#field";
									}
									else
									{
										normalexper = "#fiedl" + item.indexg;
									}
									$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value' id='multioption" + (i + index) + "'></div></div>");
									var valopt = (item.options).split(";");
									var valvalue = (item.value).split(";");
									var options_disabled = false;
									if (item.name == "trigger_io_type") //disable trigger options
									{
										options_disabled = true;
									}
									multioptdict["multioption" + i] = [];
									$.each(valvalue, function(k, itemvalue)
									{
										multioptdict["multioption" + i].push(itemvalue);
									});
									$.each(valopt, function(j, itemoptions)
									{
										$("#multioption" + i).append("<div id='elem" + (i + index) + "-" + j + "' style='float: left;margin-right: 10px;' ></div>");
										$("#elem" + (i + index) + "-" + j).dxCheckBox(
										{
											value: item.value.includes(itemoptions),
											text: itemoptions,
											disabled: options_disabled,
											onValueChanged: function(e)
											{
												var newValue = e.value;
												if (newValue)
												{
													multioptdict["multioption" + i].push(e.element[0].textContent);
												}
												else
												{
													var index = multioptdict["multioption" + i].indexOf(e.element[0].textContent);
													if (index > -1)
													{
														multioptdict["multioption" + i].splice(index, 1);
													}
												}

													/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
													var msg = "";
													msg += "<GetSDK_APP_DATA>";
													msg += "<AppName>NeuralEdge</AppName>";
													msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + multioptdict["multioption" + i].toString().replace(/,/g, ';') + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid + "</Data>";	
													msg += "</GetSDK_APP_DATA>";

													addToQueue(msg, function(response) {
														var resData = response; 
														console.log("Datos consulta: " + msg);
														console.log("Respuesta status: " + resData);
											        	if(resData!=undefined && resData!=""){
															DevExpress.ui.notify("Data saved", "success", 600);
														}else{
															DevExpress.ui.notify("Data saving error", "error", 600);																
														}  
											    	}); 

											}
										});
									});
								}
								else if (item.typepar == "nllocation")
								{
									var normalexper = "";
									if (item.indexg == -1)
									{
										normalexper = "#field";
									}
									else
									{
										normalexper = "#fiedl" + item.indexg;
									}
									$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + item.text + "</div><div class='dx-field-value'><div id='location'></div></div></div>");
									$("#location").dxSelectBox(
									{
										dataSource: locationsds,
										valueExpr: "id",
										searchEnabled: true,
										value: parseInt(item.value, 10),
										displayExpr: "description",
										onValueChanged: function(e)
										{
											var previousValue = e.previousValue;
											var newValue = e.value;
											// Event handling commands go here
												/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
												var msg = "";
												msg += "<GetSDK_APP_DATA>";
												msg += "<AppName>NeuralEdge</AppName>";
												msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid + "</Data>";	
												msg += "</GetSDK_APP_DATA>";

												addToQueue(msg, function(response) {
													var resData = response; 
													console.log("Datos consulta: " + msg);
													console.log("Respuesta status: " + resData);
										        	if(resData!=undefined && resData!=""){
														DevExpress.ui.notify("Data saved", "success", 600);
													}else{
														DevExpress.ui.notify("Data saving error", "error", 600);																
													} 
										    	}); 
												/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

										}
									});
								}
								else if (item.typepar == "nlregion")
								{
									var normalexper = "";
									if (item.indexg == -1)
									{
										normalexper = "#field";
									}
									else
									{
										normalexper = "#fiedl" + item.indexg;
									}
									$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='region'></div></div></div>");
									$("#region").dxSelectBox(
									{
										dataSource: regionds,
										valueExpr: "id",
										searchEnabled: true,
										value: parseInt(item.value, 10),
										displayExpr: "description",
										onValueChanged: function(e)
										{
											var previousValue = e.previousValue;
											var newValue = e.value;

											if(newValue != null)
											{

												/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
												var msg = "";
												msg += "<GetSDK_APP_DATA>";
												msg += "<AppName>NeuralEdge</AppName>";
												msg += "<Data>computerid=" + computerid + "|oper=select|table=nlcountry|comp0=equal|camp0=regionid|value0=" + newValue + "|maxvalues=250" + "</Data>";	
												msg += "</GetSDK_APP_DATA>";

												addToQueue(msg, function(response) {
													var resData = response; 
													console.log("Datos consulta: " + msg);
													console.log("Respuesta status: " + resData);
										        	if(resData!=undefined && resData!=""){
										        		resData = JSON.parse(resData);
														CheckTokenValidity(resData);
														$("#country").dxTagBox("instance").option("dataSource", resData);
														$("#country").dxTagBox("instance").reset();
													}  
										    	}); 

												var msg2 = "";
												msg2 += "<GetSDK_APP_DATA>";
												msg2 += "<AppName>NeuralEdge</AppName>";
												msg2 += "<Data>computerid=" + computerid + "|oper=update|table=nlconfcamera|camp0=id|value0=2|camp1=value|value1=|camp2=computerid|value2=" + computerid + "|camp3=cameraid|value3=-1</Data>";	
												msg2 += "</GetSDK_APP_DATA>";

												addToQueue(msg2, function(response) {
													var resData = response; 
													console.log("Datos consulta: " + msg2);
													console.log("Respuesta status: " + resData);
										        	if(resData!=undefined && resData!=""){
														CheckTokenValidity(resData);
														DevExpress.ui.notify("Data saved", "success", 600);
													}
										    	});

												var msg3 = "";
												msg3 += "<GetSDK_APP_DATA>";
												msg3 += "<AppName>NeuralEdge</AppName>";
												msg3 += "<Data>computerid=" + computerid + "|oper=update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=-1</Data>";	
												msg3 += "</GetSDK_APP_DATA>";
											
												addToQueue(msg3, function(response) {
													var resData = response; 
													console.log("Datos consulta: " + msg3);
													console.log("Respuesta status: " + resData);
										        	if(resData!=undefined && resData!=""){
														CheckTokenValidity(resData);
														DevExpress.ui.notify("Data saved", "success", 600);
													}
										    	}); 
												
												/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
											}
											else
											{
												DevExpress.ui.notify("Empty value: " + item.name, "error", 1200);
											}
										}
									});
									selected_region = item.value;

										/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
										var msg = "";
										msg += "<GetSDK_APP_DATA>";
										msg += "<AppName>NeuralEdge</AppName>";
										msg += "<Data>computerid=" + computerid + "|oper=select|table=nlcountry|comp0=equal|camp0=regionid|value0=" + selected_region + "|maxvalues=250</Data>";	
										msg += "</GetSDK_APP_DATA>";

										addToQueue(msg, function(response) {
											var resData = response; 
											console.log("Datos consulta: " + msg);
											console.log("Respuesta status: " + resData);
								        	if(resData!=undefined && resData!=""){
												CheckTokenValidity(data);
												countriesds = new DevExpress.data.DataSource(
												{
													store: data,
													key: "id",
												});
											} 
								    	}); 
										/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
								}
								else if (item.typepar == "nlcountry")
								{
									var normalexper = "";
									if (item.indexg == -1)
									{
										normalexper = "#field";
									}
									else
									{
										normalexper = "#fiedl" + item.indexg;
									}
									console.log("Test field name: " + item.text);
									$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='country'></div></div></div>");
									var valopt = (item.value).split(";");
									var valores = [];
									$.each(valopt, function(i, item)
									{
										valores.push(parseInt(item));
									});
									// Fix for bug #3314 regarding the presence of NaN in the list of countries
									if (valores.length >= 1)
									{
										if (isNaN(valores[0]))
										{
											valores = [];
										}
									}
									$("#country").dxTagBox(
									{
										dataSource: countriesds,
										valueExpr: "id",
										searchEnabled: true,
										value: valores,
										displayExpr: "description",
										onValueChanged: function(e)
										{
											var previousValue = e.previousValue;
											var newValue = e.value;

											if(newValue.length != 0)
											{
												var counts = "";
												$.each(newValue, function(i, item)
												{
													counts += item + ";";
												});
												counts = counts.substring(0, counts.length - 1);
												// Event handling commands go here
													/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
													var msg = "";
													msg += "<GetSDK_APP_DATA>";
													msg += "<AppName>NeuralEdge</AppName>";
													msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + counts + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=-1</Data>";	
													msg += "</GetSDK_APP_DATA>";

													addToQueue(msg, function(response) {
														var resData = response; 
														console.log("Datos consulta: " + msg);
														console.log("Respuesta status: " + resData);
														if(resData!=undefined && resData!=""){
															DevExpress.ui.notify("Data saved", "success", 600);
														}else{
															DevExpress.ui.notify("Data saving error", "error", 600);
														}
													}); 
													/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
											}
											else
											{
												DevExpress.ui.notify("Empty value: " + item.name, "error", 1200);
											}		
										}
									});
								}
								if (item.typepar == "bool")
								{
									var normalexper = "";
									if (item.indexg == -1)
									{
										normalexper = "#field";
									}
									else
									{
										normalexper = "#fiedl" + item.indexg;
									}
									var options_disabled = false;
									if (item.name == "vmake") //disable vehicle make
									{
										options_disabled = true;
									}
									$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + (i + index) + "' style='float:none'></div></div></div>");
									var isTrueSet = (item.value == 'true');
									$("#elem" + (i + index)).dxCheckBox(
									{
										value: isTrueSet,
										disabled: options_disabled,
										onValueChanged: function(e)
										{
											var previousValue = e.previousValue;
											var newValue = e.value;
											// Event handling commands go here
												/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
												var msg = "";
												msg += "<GetSDK_APP_DATA>";
												msg += "<AppName>NeuralEdge</AppName>";
												msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + counts + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=-1</Data>";	
												msg += "</GetSDK_APP_DATA>";

												addToQueue(msg, function(response) {
													var resData = response; 
													console.log("Datos consulta: " + msg);
													console.log("Respuesta status: " + resData);
										        	if(resData!=undefined && resData!=""){
														DevExpress.ui.notify("Data saved", "success", 600);
													}else{
														DevExpress.ui.notify("Data saving error", "error", 600);
													}
										    	}); 
												/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
											
										}
									});
								}
								if (item.typepar == "info")
								{
									var normalexper = "";
									if (item.indexg == -1)
									{
										normalexper = "#field";
									}
									else
									{
										normalexper = "#fiedl" + item.indexg;
									}
									$(normalexper).prepend(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + (i + index)+ "' style='float:none'></div><div id='popupinfo" + (i + index) + "' style='display:none' ></div></div></div>");
									var mh = 400;
									var mw = 600;
									if (item.help == "infoexpertcamera-c.html" || item.help == "infoexpertcamera-n.html" || item.help == "infoexpertcamera-v.html" || item.help == "infoexpertcamera-z.html")
									{
										mh = 700;
										mw = 600;
									}
									$("#elem" + (i + index)).dxButton(
									{
										icon: "help",
										type: "success",
										mode: "contained",
										onClick: function(e)
										{
											var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
												.done(function(data)
												{
													$("#popupinfo" + i).append(data);
													var poup = $("#popupinfo" + i).dxPopup(
													{
														showTitle: true,
														title: DevExpress.localization.formatMessage("Help"),
														visible: true,
														maxWidth: mw,
														maxHeight: mh,
														loseOnOutsideClick: true
													});
												});
										}
									});
								}
								if (item.typepar == "string")
								{
									var normalexper = "";
									if (item.indexg == -1)
									{
										normalexper = "#field";
									}
									else
									{
										normalexper = "#fiedl" + item.indexg;
									}
									$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + (i + index) + "' style='float:none'></div></div></div>");
									var passmode = "Text";
									if (item.text == "Password:") passmode = "password";
									$("#elem" + (i + index)).dxTextBox(
									{
										value: item.value,
										mode: passmode,
										onValueChanged: function(e)
										{
											var previousValue = e.previousValue;
											var newValue = e.value;
											newValue = newValue.replace(/\\/g, '/');
											// Event handling commands go here	
												/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
												var msg = "";
												msg += "<GetSDK_APP_DATA>";
												msg += "<AppName>NeuralEdge</AppName>";
												msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + encodeURIComponent(newValue) + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid + "</Data>";	
												msg += "</GetSDK_APP_DATA>";

												addToQueue(msg, function(response) {
													var resData = response; 
													console.log("Datos consulta: " + msg);
													console.log("Respuesta status: " + resData);
										        	if(resData!=undefined && resData!=""){
														DevExpress.ui.notify("Data saved", "success", 600);
													}else{
														DevExpress.ui.notify("Data saving error", "error", 600);
													}
										    	}); 
												/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
										
										}
									});
								}
								if (item.typepar == "option")
								{
									var valopt = (item.options).split(";");
									var normalexper = "";
									if (item.indexg == -1)
									{
										normalexper = "#field";
									}
									else
									{
										normalexper = "#fiedl" + item.indexg;
									}
									var helpdiv = "";
									if (item.help != "")
									{
										helpdiv = "<div id='icon" + (i + index) + "'></div><div id='popup" + (i + index) + "' style='display:none' ></div> ";
									}
									var item_name = DevExpress.localization.formatMessage(item.text);
									$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + item_name + "</div><div class='dx-field-value'><div id='elem" + (i + index) + "' style='float:none;display: inline-block;'></div> " + helpdiv + "</div></div>");
									if (item.help != "")
									{
										var mh = 250;
										var mw = 500;
										if (item.help == "help_mode_camera.html" || item.help == "help_installation_camera.html")
										{
											mh = 400;
											mw = 800;
										}
										$("#icon" + i).dxButton(
										{
											icon: "help",
											type: "success",
											mode: "contained",
											onClick: function(e)
											{
												var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
													.done(function(data)
													{
														$("#popup" + i).append(data);
														var poup = $("#popup" + i).dxPopup(
														{
															showTitle: true,
															title: DevExpress.localization.formatMessage("Help"),
															visible: true,
															maxWidth: mw,
															maxHeight: mh,
															loseOnOutsideClick: true
														});
													});
											}
										});
									}
									var isTrueSet = (item.value == 'true');
									//if (item.text.includes("umresolution")) {
									//    var resopt = (item.value).split("x");
									//    resx = resopt[0];
									//    resy = resopt[1];
									//}
									var dict_translations = {};
									var current_val;
									if (((item.name == 'resolution') && (item.value.toLowerCase().includes("motorbikes"))) || (item.name == 'camposition') || (item.name == 'ff_filtermode') || (item.name == 'installation'))
									{
										valopt.forEach(function(element, index)
										{
											dict_translations[DevExpress.localization.formatMessage(element)] = element;
											valopt[index] = DevExpress.localization.formatMessage(element);
										})
										current_val = DevExpress.localization.formatMessage(item.value);
									}
									else
									{
										valopt.forEach(function(element, index)
										{
											dict_translations[element] = element;
										})
										current_val = item.value
									}
									$("#elem" + (i + index)).dxRadioGroup(
									{
										items: valopt,
										value: current_val,
										layout: "horizontal",
										onValueChanged: function(e)
										{
											var previousValue = e.previousValue;
											var newValue = dict_translations[e.value];
											//if (newValue.includes("x")) {
											//    var resopt = (newValue).split("x");
											//    resx = resopt[0];
											//    resy = resopt[1];
											//}
											// Event handling commands go here	
												/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
												var msg = "";
												msg += "<GetSDK_APP_DATA>";
												msg += "<AppName>NeuralEdge</AppName>";
												msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid + "</Data>";	
												msg += "</GetSDK_APP_DATA>";

												addToQueue(msg, function(response) {
													var resData = response; 
													console.log("Datos consulta: " + msg);
													console.log("Respuesta status: " + resData);
										        	if(resData!=undefined && resData!=""){
														DevExpress.ui.notify("Data saved", "success", 600);
													}else{
														DevExpress.ui.notify("Data saving error", "error", 600);
													}
										    	}); 
										    	setTimeout(
										    		function(){
														if (item.id == 4)
														{
															if (newValue == 'Do not allow motorbikes')
															{
																newValue = resolutions[0];
															}
															else
															{
																newValue = resolutions[1];
															}
															var resopt = newValue.split("x");
															resx = resopt[0];
															resy = resopt[1];

															var msg = "";
															msg += "<GetSDK_APP_DATA>";
															msg += "<AppName>NeuralEdge</AppName>";
															msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfcamera|camp0=id|value0=57|camp1=value|value1=" + newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid + "</Data>";	
															msg += "</GetSDK_APP_DATA>";

															addToQueue(msg, function(response) {
																var resData = response; 
																console.log("Datos consulta: " + msg);
																console.log("Respuesta status: " + resData);
													        	if(resData!=undefined && resData!=""){
																	DevExpress.ui.notify("Data saved", "success", 600);
																}else{
																	DevExpress.ui.notify("Data saving error", "error", 600);
																}
													    	}); 
														}
										    		}
										    		,200);
												/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
										}
									});
								}
								if (item.typepar == "roi")
								{
									var normalexper = "";
									if (item.indexg == -1)
									{
										normalexper = "#field";
									}
									else
									{
										normalexper = "#fiedl" + item.indexg;
									}
									var serverName	= window.location.hostname;
							    	var serverType = "http://";
							    	var extention = "/livemjpeg";
							        var liveStreamURI = serverType + serverName + ":1234" + extention;
									//PENDING ROI IMAGE
									// $("#fiedlROI").append(" <div class='dx-field' id ='ROICANVAS'  ><div id='icon-done_info'></div><br><br><img src='./images/ROIGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvas' width='800' height='600' '></canvas><img id = 'mono' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'></div></div>");
									$("#fiedlROI").append(" <div class='dx-field' id ='ROICANVAS'  ><div id='icon-done_info'></div><br><br><img src='./images/ROIGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvas' width='800' height='600' '></canvas><img id = 'mono' src='"+liveStreamURI+"' width='800' height='600' style= 'visibility:hidden;display:none'></div></div>");
									$("#ROIheader").click(function()
									{
										if ($("#ROIheader").hasClass("abierto"))
										{
											$(this).removeClass('abierto');
											$(this).addClass('cerrado');
											$("#fiedlROI").hide();
										}
										else
										{
											$(this).addClass('abierto');
											$(this).removeClass('cerrado');
											$("#fiedlROI").show();
										}
									});
									var valopt = (item.value).split(";");
									var sroi = "";
									if (valopt[0] != 0 || valopt[1] != 0 || valopt[2] != 0 || valopt[3] != 0)
									{
										sroi = " (" + valopt[0] + ";" + valopt[1] + ";" + valopt[2] + ";" + valopt[3] + ")";
									}
									$("#ROIheader").text(DevExpress.localization.formatMessage("Show Roi") + sroi);
									btroi = $("#icon-done_info").dxButton(
									{
										type: "success",
										text: DevExpress.localization.formatMessage("Reset ROI"),
										onClick: function()
										{
											resetROI();
										}
									}).dxButton('instance');;
									var canvas = document.getElementById('canvas');
									var ctx = canvas.getContext('2d');
									var img = document.getElementById("mono");
									var tmpImg = new Image();
									tmpImg.src = $('#mono').attr('src');
									tmpImg.onload = function()
									{
										ctx.drawImage(img, 0, 0, 800, 600);
										var ppcX = parseFloat("0." + valopt[0]);
										var ppcY = parseFloat("0." + valopt[1]);
										var ppcwidth = parseFloat("0." + valopt[2]);
										var ppcheight = parseFloat("0." + valopt[3]);
										ctx.rect(ppcX * 800, ppcY * 600, ppcwidth * 800, ppcheight * 600);
										ctx.strokeStyle = 'red';
										ctx.lineWidth = 5;
										ctx.stroke();
									};
									//Variables
									var canvasx = $(canvas).offset().left;
									var canvasy = $(canvas).offset().top;
									var last_mousex = last_mousey = 0;
									var mousex = mousey = 0;
									var mousedown = false;
									//Mousedown
									$(canvas).on('mousedown', function(e)
									{
										last_mousex = e.offsetX;
										last_mousey = e.offsetY;
										mousedown = true;
									});
									//Mouseup
									$(canvas).on('mouseup', function(e)
									{
										console.log("TEST ENTRO A ROI mouseupmouseupmouseupmouseupmouseup");
										mousedown = false;
										var initpointx,
											initpointy,
											endpointx,
											endpointy;
										mousex = e.offsetX;
										mousey = e.offsetY;
										if (mousex > last_mousex)
										{
											initpointx = last_mousex;
											endpointx = mousex;
										}
										else
										{
											initpointx = mousex;
											endpointx = last_mousex;
										}
										if (mousey > last_mousey)
										{
											initpointy = last_mousey;
											endpointy = mousey;
										}
										else
										{
											initpointy = mousey;
											endpointy = last_mousey;
										}
										var pointXReal = Math.round(initpointx * (resx / 800));
										var pointYReal = Math.round(initpointy * (resy / 600));
										var endpointXReal = Math.round(endpointx * (resx / 800));
										var endpointYReal = Math.round(endpointy * (resy / 600));
										console.log("ROI DATA: ");
										console.log("pointXReal: " + pointXReal + " initpointx " + initpointx + " resx " + resx);
										console.log("pointYReal: " + pointYReal + " initpointy " + initpointy + " resy " + resy);
										console.log("endpointXReal: " + endpointXReal + " endpointx " + endpointx + " resx " + resx);
										console.log("endpointYReal: " + endpointYReal + " endpointy " + endpointy + " resy " + resy);
										if (pointXReal == endpointXReal || pointYReal == endpointYReal)
										{
											return;
										}
										if (pointXReal < 0)
										{
											pointXReal = 0;
										}
										if (pointYReal < 0)
										{
											pointYReal = 0;
										}
										var tpcx = (pointXReal / resx).toFixed(4);
										var tpcy = (pointYReal / resy).toFixed(4);
										var tpcwidth = ((endpointXReal - pointXReal) / resx).toFixed(4);
										var tpcheigth = ((endpointYReal - pointYReal) / resy).toFixed(4);
										var tpcx_dec = (tpcx + "").split(".")[1];
										var tpcy_dec = (tpcy + "").split(".")[1];
										var tpcwidth_dec = (tpcwidth + "").split(".")[1];
										var tpcheigth_dec = (tpcheigth + "").split(".")[1];
										var roi = tpcx_dec + ";" + tpcy_dec + ";" + tpcwidth_dec + ";" + tpcheigth_dec;
										$("#ROIheader").text(DevExpress.localization.formatMessage("Show Roi") + " (" + roi + ")");

											/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
											var msg = "";
											msg += "<GetSDK_APP_DATA>";
											msg += "<AppName>NeuralEdge</AppName>";
											msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfcamera|camp0=id|value0=" + item.id + "|camp1=value|value1=" + roi + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid + "</Data>";	
											msg += "</GetSDK_APP_DATA>";

											addToQueue(msg, function(response) {
												var resData = response; 
												console.log("Datos consulta: " + msg);
												console.log("Respuesta status: " + resData);
									        	if(resData!=undefined && resData!=""){
													DevExpress.ui.notify("Data saved", "success", 600);
												}else{
													DevExpress.ui.notify("Data saving error", "error", 600);
												}
									    	}); 
											/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
								
									});
									//Mousemove
									$(canvas).on('mousemove', function(e)
									{
										mousex = e.offsetX;
										mousey = e.offsetY;
										if (mousedown)
										{
											ctx.clearRect(0, 0, canvas.width, canvas.height); //clear canvas
											ctx.beginPath();
											var width = mousex - last_mousex;
											var height = mousey - last_mousey;
											ctx.rect(last_mousex, last_mousey, width, height);
											ctx.strokeStyle = 'red';
											ctx.lineWidth = 5;
											ctx.stroke();
											var img = document.getElementById("mono");
											ctx.drawImage(img, 0, 0, 800, 600);
											ctx.stroke();
										}
									});
								}
								////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
								if (item.typepar == "nlcameraspeed")
								{
									var msg = "";
									msg += "<GetSDK_APP_DATA>";
									msg += "<AppName>NeuralEdge</AppName>";
									msg += "<Data>computerid=" + computerid + "|oper=select|table=nlconfcameraspeed|maxvalues=250|adinfo=notvalue</Data>";	
									msg += "</GetSDK_APP_DATA>";

									addToQueue(msg, function(response) 
									{

										if(response!=undefined && response!="")
										{
											if(response != "table not found")
											{
												var data2 = JSON.parse(response);
												//console.log("Test nlconfcameraspeed: " + JSON.stringify(data2));
												ident = data2[0].id;
												var normalexper = "";
												if (item.indexg == -1)
												{
													normalexper = "#field";
												}
												else
												{
													normalexper = "#fiedl" + item.indexg;
												}

												$(normalexper).append("<div class='dx-field'> <div class='dx-field-label' id='speedHeader' style= 'padding: 10px 0px;width: 100%' >Speed calibration </div>  </div>");
												$(normalexper).append(" <div class='dx-fieldset' id= 'fiedlSpeed'  ></div> ");

												$("#fiedlSpeed").append(" <div class='dx-field' id ='ROISPEED'  ><div id='icon-done_info2'></div><br><br><img src='./images/speedGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvasSpeed' width='800' height='600' '></canvas><img id = 'monoSpd' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'></div></div>");
												$("#speedHeader").click(function()
												{
													if ($("#speedHeader").hasClass("abierto"))
													{
														$(this).removeClass('abierto');
														$(this).addClass('cerrado');
														$("#fiedlSpeed").hide();
													}
													else
													{
														$(this).addClass('abierto');
														$(this).removeClass('cerrado');
														$("#fiedlSpeed").show();
													}
												});
												var valopt = (item.value).split(";");
												
												btroi = $("#icon-done_info2").dxButton(
												{
													type: "success",
													text: DevExpress.localization.formatMessage("Reset Calibration"),
													onClick: function()
													{
														pointArray = [];
														resetCalibration();
													}
												}).dxButton('instance');;
												var canvas = document.getElementById('canvasSpeed');
												var ctx = canvas.getContext('2d');

												pointArray.push({x:data2[0].lpoint00X * (resx/1000), y:data2[0].lpoint00Y * (resy/1000)});
												pointArray.push({x:data2[0].lpoint01X * (resx/1000), y:data2[0].lpoint01Y * (resy/1000)});
												pointArray.push({x:data2[0].lpoint10X * (resx/1000), y:data2[0].lpoint10Y * (resy/1000)});
												pointArray.push({x:data2[0].lpoint11X * (resx/1000), y:data2[0].lpoint11Y * (resy/1000)});

												var img = document.getElementById("monoSpd");
												var tmpImg = new Image();
												tmpImg.src = $('#monoSpd').attr('src');
												tmpImg.onload = function()
												{
													ctx.drawImage(img, 0, 0, 800, 600);
													ctx.fillStyle="red";
													ctx.strokeStyle = 'red';
													ctx.lineWidth = 5;
													ctx.fillRect(pointArray[0].x-5, pointArray[0].y-5, 10,10);
													ctx.fillRect(pointArray[1].x-5, pointArray[1].y-5, 10,10);
													ctx.fillRect(pointArray[2].x-5, pointArray[2].y-5, 10,10);
													ctx.fillRect(pointArray[3].x-5, pointArray[3].y-5, 10,10);
													ctx.beginPath();
													ctx.moveTo(pointArray[3].x, pointArray[3].y);
													ctx.lineTo(pointArray[0].x, pointArray[0].y);
													ctx.lineTo(pointArray[1].x, pointArray[1].y);
													ctx.lineTo(pointArray[2].x, pointArray[2].y);
													ctx.lineTo(pointArray[3].x, pointArray[3].y);
													ctx.stroke();
												};

												var sroi = "";
												sroi = "Speed calibration [(" + pointArray[0].x + "," + pointArray[0].y + ") - (" + pointArray[1].x + "," + pointArray[1].y + ") - (" + pointArray[2].x + "," + pointArray[2].y + ") - (" + pointArray[3].x + "," + pointArray[3].y + ")]";
												$("#speedHeader").text(DevExpress.localization.formatMessage("Show Speed Calibration") + sroi);

												//Variables
												var canvasx = $(canvas).offset().left;
												var canvasy = $(canvas).offset().top;
												var last_mousex = last_mousey = 0;
												var mousex = mousey = 0;
												var mousedown = false;
												//Mousedown
												$(canvas).on('mousedown', function(e)
												{
													mousedown = true;
												});
												//Mouseup
												$(canvas).on('mouseup', function(e)
												{
													mousedown = false;
													var initpointx,
														initpointy,
														endpointx,
														endpointy;
													mousex = e.offsetX;
													mousey = e.offsetY;
													var pointXReal = Math.round(mousex * (resx / 800));
													var pointYReal = Math.round(mousey * (resy / 600));
													var roi = pointXReal + ";" + pointYReal;
													//console.log("points: " + roi);
													pointArray.push({x: mousex, y: mousey});
													//console.log(pointArray.length);
													if(pointArray.length == 5){
														ctx.clearRect(0, 0, canvas.width, canvas.height);
														var img = document.getElementById("monoSpd");
														var tmpImg = new Image();
														tmpImg.src = $('#monoSpd').attr('src');

														ctx.drawImage(img, 0, 0, 800, 600);
														pointArray = [];

														ctx.fillStyle="red";
														ctx.fillRect(mousex-5, mousey-5, 10,10);
														pointArray.push({x: mousex, y: mousey});
													}else if(pointArray.length == 4){
														console.log("Points Array: " + JSON.stringify(pointArray));
														//pointArray.sort((a, b) => Math.hypot(a.x, a.y) - Math.hypot(b.x, b.y));
														//var sortedPoints = [{},{},{},{}];

														// coger los 2 puntos de la izquierda
														var minX = Math.min.apply(Math, pointArray.map(function(o) { return o.x; }));
														var index = pointArray.findIndex(function(coord) {
														  return coord.x == minX
														});
														var minX1 = pointArray[index];
														pointArray.splice(index, 1);

														var minX = Math.min.apply(Math, pointArray.map(function(o) { return o.x; }));
														var index = pointArray.findIndex(function(coord) {
														  return coord.x == minX
														});
														/*var minX2 = pointArray[index];
														pointArray.splice(index, 1);

														if(minX1.y < minX2.y){
															sortedPoints[0] = minX1;
															sortedPoints[2] = minX2;
														}else{
															sortedPoints[2] = minX1;
															sortedPoints[0] = minX2;												
														}
														//0 == minx miny == top left
														//2 == minx maxy == bottom left

														var maxY = Math.max.apply(Math, pointArray.map(function(o) { return o.y; }));
														var index = pointArray.findIndex(function(coord) {
														  return coord.y == maxY
														});
														//los puntos restantes son los de la derecha, se cogen las Y
														sortedPoints[3] = pointArray[index];
														//3 == maxx maxy == bottom right
														pointArray.splice(index, 1);
														sortedPoints[1] = pointArray[0];
														//1 == maxx miny == top right*/

														//pointArray = sortedPoints;

														console.log("Sorted Array: " + JSON.stringify(sortedPoints));

														ctx.fillRect(mousex-5, mousey-5, 10,10);
														ctx.beginPath();
														ctx.lineTo(pointArray[0].x, pointArray[0].y);
														ctx.lineTo(pointArray[1].x, pointArray[1].y);
														//ctx.moveTo(pointArray[3].x, pointArray[3].y);
														ctx.lineTo(pointArray[2].x, pointArray[2].y);
														ctx.lineTo(pointArray[3].x, pointArray[3].y);
														ctx.stroke();

														for(var i = 0; i < pointArray.length; i++){
															var transformedx = 1000* (pointArray[i].x / resx).toFixed(4);
															var transformedy = 1000* (pointArray[i].y / resy).toFixed(4);
															pointArray[i].x = transformedx;
															pointArray[i].y = transformedy;
														}

														console.log("Percent Array: " + JSON.stringify(pointArray));
														var msg1 = "";
														msg1 += "<GetSDK_APP_DATA>";
														msg1 += "<AppName>NeuralEdge</AppName>";
														msg1 += "<Data>computerid=" + computerid + "|oper=update|table=nlcameraspeed|camp0=id|value0=" + data2[0].id + "|camp1=sendserver|value1=0|camp2=dateserver|value2=20180101000000";
														msg1 += "|camp3=reserve|value3=";
														msg1 += "|camp4=cameraid|value4=1";
														msg1 += "|camp5=computerid|value5=1";
														msg1 += "|camp6=lpoint00X|value6=" + pointArray[0].x;
														msg1 += "|camp7=lpoint00Y|value7=" + pointArray[0].y;
														msg1 += "|camp8=lpoint01X|value8=" + pointArray[1].x;
														msg1 += "|camp9=lpoint01Y|value9=" + pointArray[1].y;
														msg1 += "|camp10=lpoint10X|value10=" + pointArray[2].x;
														msg1 += "|camp11=lpoint10Y|value11=" + pointArray[2].y;
														msg1 += "|camp12=lpoint11X|value12=" + pointArray[3].x;
														msg1 += "|camp13=lpoint11Y|value13=" + pointArray[3].y;
														msg1 += "|camp14=calibrated|value14=1";
														msg1 += "</Data>";	
														msg1 += "</GetSDK_APP_DATA>";
														addToQueue(msg1, function(response) {
															if(response!=undefined){
																DevExpress.ui.notify("Data saved", "success", 600);
																sroi = "Speed calibration [(" + pointArray[0].x.toFixed(2) + "," + pointArray[0].y.toFixed(2) + ") - (" + pointArray[1].x.toFixed(2) + "," + pointArray[1].y.toFixed(2) + ") - (" + pointArray[2].x.toFixed(2) + "," + pointArray[2].y.toFixed(2) + ") - (" + pointArray[3].x.toFixed(2) + "," + pointArray[3].y.toFixed(2) + ")]";
																$("#speedHeader").text(DevExpress.localization.formatMessage("Show Speed Calibration") + sroi);
															}
														});
													}else{
														ctx.fillStyle="red";
														ctx.fillRect(mousex-5, mousey-5, 10,10);
													}
												});
									
											}

										}
									});
								}
								////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
								if (item.typepar == "nlcameralane")
								{
									/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
									var msg = "";
									msg += "<GetSDK_APP_DATA>";
									msg += "<AppName>NeuralEdge</AppName>";
									msg += "<Data>computerid=" + computerid + "|oper=getconfig|adinfo=notvalue</Data>";	
									msg += "</GetSDK_APP_DATA>";

									addToQueue(msg, function(response) {
											var data = response; 
											console.log("Response in first query response: " + JSON.stringify(data));
											console.log("Datos consulta: " + msg);
											console.log("Respuesta : " + JSON.stringify(data));
											console.log("Respuesta status: " + data);
								        	if(data!=undefined && data!=""){
												
											CheckTokenValidity(data);
											var normalexper = "";
											if (item.indexg == -1)
											{
												normalexper = "#field";
											}
											else
											{
												normalexper = "#fiedl" + item.indexg;
											}
											//PENDING ROI IMAGE
											var serverName	= window.location.hostname;
									    	var serverType = "http://";
									    	var extention = "/livemjpeg";
									        var liveStreamURI = serverType + serverName + ":1234" + extention;
											//$("#fiedlLANES").append(" <div class='dx-field' id ='LANECANVAS'  ><div id='ResetLan'></div><br><br><img src='./images/LANEGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvaslanes' width='800' height='600' ></canvas><img id = 'monolanes' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'></div></div>");
											$("#fiedlLANES").append(" <div class='dx-field' id ='LANECANVAS'  ><div id='ResetLan'></div><br><br><img src='./images/LANEGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvaslanes' width='800' height='600' ></canvas><img id = 'monolanes' src='"+liveStreamURI+"' width='800' height='600' style= 'visibility:hidden;display:none'></div></div>");
											$("#ResetLan").dxButton(
											{
												type: "success",
												text: DevExpress.localization.formatMessage("Delete Lanes"),
												onClick: function()
												{
													resetLANES();
												}
											});
											var canvas2 = document.getElementById('canvaslanes');
											var ctx2 = canvas2.getContext('2d');
											var img2 = document.getElementById("monolanes");
											var tmpImg2 = new Image();
											tmpImg2.src = $('#monolanes').attr('src');
											tmpImg2.onload = function()
											{
												ctx2.drawImage(img2, 0, 0, 800, 600);
												if (data.length > 0)
												{
													var p0;
													var p1;
													p0 = parseFloat(data[0].lpoint00X / 10000) * 800;
													p1 = parseFloat(data[0].lpoint01X / 10000) * 800;
													ctx2.moveTo(p0, 0);
													ctx2.lineTo(p1, 600);
													ctx2.strokeStyle = 'red';
													ctx2.lineWidth = 5;
													ctx2.font = "30px Arial";
													ctx2.fillStyle = "red";
													ctx2.textAlign = "left";
													ctx2.fillText("LANE1", 10, 25);
													ctx2.fillText("LANE2", 690, 25);
													$("#LH1").text(DevExpress.localization.formatMessage("Show Lanes") + " (" + data[0].lpoint00X + ";" + data[0].lpoint01X + ";" + data[0].lpoint01X + ";" + data[0].lpoint01Y + ")");
												}
												ctx2.stroke();
											};
											//Variables
											var canvasx2 = $(canvas2).offset().left;
											var canvasy2 = $(canvas2).offset().top;
											var last_mouse2x = last_mousey2 = 0;
											var mousex2 = mousey2 = 0;
											var mousedown2 = false;
											//Mousedown
											$(canvas2).on('mousedown', function(e)
											{
												last_mousex2 = e.offsetX;
												last_mousey2 = e.offsetY;
												mousedown2 = true;
											});
											//Mouseup
											$(canvas2).on('mouseup', function(e)
											{
												mousedown2 = false;
												var initpointx,
													initpointy,
													endpointx,
													endpointy;
												var initpointx1,
													initpointy1,
													endpointx1,
													endpointy1;
												mousex2 = e.offsetX;
												mousey2 = e.offsetY;
												initpointx1 = last_mousex2;
												endpointx1 = mousex2;
												initpointy1 = last_mousey2;
												endpointy1 = mousey2;
												if (initpointx1 <= endpointx1)
												{
													initpointx = initpointx1;
													initpointy = initpointy1;
													endpointx = endpointx1;
													endpointy = endpointy1;
												}
												else
												{
													initpointx = endpointx1;
													initpointy = endpointy1;
													endpointx = initpointx1;
													endpointy = initpointy1;
												}
												if ((endpointx - initpointx) == 0)
												{
													return;
												}
												var pendiente = (endpointy - initpointy) / (endpointx - initpointx);
												var b = endpointy - (pendiente * endpointx);
												ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
												ctx2.beginPath();
												var x0 = (-b / pendiente);
												var x1 = (600 - b) / pendiente;
												ctx2.moveTo(x0, 0);
												ctx2.lineTo(x1, 600);
												ctx2.strokeStyle = 'red';
												ctx2.lineWidth = 5;
												ctx2.stroke();
												var img2 = document.getElementById("monolanes");
												ctx2.drawImage(img2, 0, 0, 800, 600);
												ctx2.font = "30px Arial";
												ctx2.fillStyle = "red";
												ctx2.textAlign = "left";
												ctx2.fillText("LANE1", 10, 25);
												ctx2.fillText("LANE2", 690, 25);
												ctx2.stroke();
												var pointXReal = Math.round(x0 * (resx / 800));
												var endpointXReal = Math.round(x1 * (resx / 800));
												var endpointYReal = resy;
												var ltpcx = (pointXReal / resx).toFixed(4);
												var ltpcendx = (endpointXReal / resx).toFixed(4);
												var ltpcendy = (endpointYReal / resy).toFixed(4);
												var ltpcx_dec = ltpcx * 10000
												var ltpcendx_dec = ltpcendx * 10000
												var ltpcendy_dec = ltpcendy * 10000
												var lanestr = (ltpcx_dec + ";0;" + ltpcendx_dec + ";" + ltpcendy_dec);
												$("#LH1").text(DevExpress.localization.formatMessage("Show Lanes") + " (" + lanestr + ")");
																									$("#LH1").text(DevExpress.localization.formatMessage("Show Lanes") + " (" + lanestr + ")");

												/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
												var msg = "";
												msg += "<GetSDK_APP_DATA>";
												msg += "<AppName>NeuralEdge</AppName>";
												msg += "<Data>computerid=" + computerid + "|oper=delete|table=nlcameralane</Data>";	
												msg += "</GetSDK_APP_DATA>";

												$(this).sendCommandToServer({
													appname : appName,      
										  			      
													requestMessage:msg,
													success : function(response) {
														var resData = response.Data; 
														console.log("Response in first query response: " + JSON.stringify(resData));
														console.log("Datos consulta: " + msg);
														console.log("Respuesta : " + JSON.stringify(resData));
														console.log("Respuesta status: " + resData);
											        	if(resData!=undefined && resData!=""){
															
										        			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
															var msg1 = "";
															msg1 += "<GetSDK_APP_DATA>";
															msg1 += "<AppName>NeuralEdge</AppName>";
															msg1 += "<Data>computerid=" + computerid + "|oper=insert|table=nlcameralane|camp0=id|value0=-1|camp1=sendserver|value1=0|camp2=dateserver|value2=20180101000000";
															msg1 += "|camp3=reserve|value3=";
															msg1 += "|camp4=cameraid|value4=1";
															msg1 += "|camp5=computerid|value5=1";
															msg1 += "|camp6=name|value6=LANE1";
															msg1 += "|camp7=direction|value7=1";
															msg1 += "|camp8=lpoint00X|value8=" + ltpcx_dec;
															msg1 += "|camp9=lpoint00Y|value9=0";
															msg1 += "|camp10=lpoint01X|value10=" + ltpcendx_dec;
															msg1 += "|camp11=lpoint01Y|value11=" + ltpcendy_dec;
															msg1 += "|camp12=lpoint10X|value12=0";
															msg1 += "|camp13=lpoint10Y|value13=0";
															msg1 += "|camp14=lpoint11X|value14=0";
															msg1 += "|camp15=lpoint11Y|value15=0";
															msg1 += "|camp16=occoming|value16=1";
															msg1 += "|camp17=ocgoing|value17=1";
															msg1 += "|camp18=enabled|value18=1";
															msg1 += "</Data>";	
															msg1 += "</GetSDK_APP_DATA>";

															$(this).sendCommandToServer({
																appname : appName,      
													  			      
																requestMessage:msg1,
																success : function(response) {
																	var resData = response.Data; 
																	console.log("Response in first query response: " + JSON.stringify(resData));
																	console.log("Datos consulta: " + msg1);
																	console.log("Respuesta : " + JSON.stringify(resData));
																	console.log("Respuesta status: " + resData);
														        	if(resData!=undefined && resData!=""){
																	}   
																}
													    	}); 
															/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
												
															/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
															var msg2 = "";
															msg2 += "<GetSDK_APP_DATA>";
															msg2 += "<AppName>NeuralEdge</AppName>";
															msg2 += "<Data>computerid=" + computerid + "|oper=insert|table=nlcameralane|camp0=id|value0=-1|camp1=sendserver|value1=0|camp2=dateserver|value2=20180101000000";
															msg2 += "|camp3=reserve|value3=";
															msg2 += "|camp4=cameraid|value4=1";
															msg2 += "|camp5=computerid|value5=1";
															msg2 += "|camp6=name|value6=LANE2";
															msg2 += "|camp7=direction|value7=1";
															msg2 += "|camp8=lpoint00X|value8=0";
															msg2 += "|camp9=lpoint00Y|value9=0";
															msg2 += "|camp10=lpoint01X|value10=0";
															msg2 += "|camp11=lpoint01Y|value11=0";
															msg2 += "|camp12=lpoint10X|value12=" + ltpcx_dec;
															msg2 += "|camp13=lpoint10Y|value13=0";
															msg2 += "|camp14=lpoint11X|value14=" + ltpcendx_dec;
															msg2 += "|camp15=lpoint11Y|value15=" + ltpcendy_dec;
															msg2 += "|camp16=occoming|value16=1";
															msg2 += "|camp17=ocgoing|value17=1";
															msg2 += "|camp18=enabled|value18=1";
															msg2 += "</Data>";	
															msg2 += "</GetSDK_APP_DATA>";

															setTimeout(function(){
																$(this).sendCommandToServer({
																	appname : appName,      
														  			      
																	requestMessage:msg2,
																	success : function(response) {
																		var resData = response.Data; 
																		console.log("Response in first query response: " + JSON.stringify(resData));
																		console.log("Datos consulta: " + msg2);
																		console.log("Respuesta : " + JSON.stringify(resData));
																		console.log("Respuesta status: " + resData);
															        	if(resData!=undefined && resData!=""){
																		}   
																	}
														    	}); 
															}, 500);
															/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
												

														}   
													}
										    	}); 
												/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
												
											});
											//Mousemove
											$(canvas2).on('mousemove', function(e)
											{
												mousex2 = e.offsetX;
												mousey2 = e.offsetY;
												if (mousedown2)
												{
													ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
													ctx2.beginPath();
													var width2 = mousex2 - last_mousex2;
													var height2 = mousey2 - last_mousey2;
													ctx2.moveTo(last_mousex2, last_mousey2);
													ctx2.lineTo(mousex2, mousey2);
													ctx2.strokeStyle = 'red';
													ctx2.lineWidth = 5;
													ctx2.stroke();
													var img2 = document.getElementById("monolanes");
													ctx2.drawImage(img2, 0, 0, 800, 600);
													ctx2.stroke();
												}
											});
										

											}   
										
							    	}); 
									/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
								}
							}
						});
		
					//------------------------------------------------------------------------------------------------------------------------------------
				}else{
					console.log("No es array");
				}
			}  
			if(!secondCall) 
				createFieldsHanwha(true, lastIndex);
		});
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	}
	//$.getJSON(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlconfcamera&maxvalues=250&camp0=cameraid&comp0=minor&value0=2&d="+ getStringNormalDate(new Date())).done(function (data) {
	
	if(DEFINE_INTERFACE == "HANWHA"){
		createFieldsHanwha(false, 0);
	}else{
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlconfcamera&maxvalues=250&camp0=cameraid&comp0=minor&value0=2&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
			async: false,
			success: function(data)
			{
				$(".content_wrapper").append(" <div class='dx-fieldset-header cerrado' id='ROIheader' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Show Roi") + "hhhh</div> ");
				$(".content_wrapper").append(" <div class='dx-fieldset' id= 'fiedlROI'  ></div> ");
				$(".content_wrapper").append(" <div class='dx-fieldset-header cerrado' id='LH1' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Show Lanes") + "</div> ");
				$(".content_wrapper").append(" <div class='dx-fieldset' id= 'fiedlLANES'  ></div> ");
				$("#fiedlROI").hide();
				$("#fiedlLANES").hide();
				$("#LH1").click(function()
				{
					if ($("#LH1").hasClass("abierto"))
					{
						$(this).removeClass('abierto');
						$(this).addClass('cerrado');
						$("#fiedlLANES").hide();
					}
					else
					{
						$(this).addClass('abierto');
						$(this).removeClass('cerrado');
						$("#fiedlLANES").show();
					}
				});
				//First bucle to create checkbox and div
				$.each(data, function(i, item)
				{
					if (item.grouppar != "")
					{
						if (typeof dict[item.grouppar] === "undefined")
						{
							item.indexg = i;
							dict[item.grouppar] = i;
							var toadd = "<div class='dx-fieldset-header cerrado' id='group" + i + "' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage(item.grouppar) + "</div> ";
							toadd += "<div class='dx-fieldset' id= 'fiedl" + i + "'  ></div>";
							$(".content_wrapper").append(toadd);
							$("#fiedl" + i).hide();
							$("#group" + i).click(function()
							{
								if ($("#group" + i).hasClass("abierto"))
								{
									$(this).removeClass('abierto');
									$(this).addClass('cerrado');
									$("#fiedl" + i).hide();
									listplatesabierto = false;
								}
								else
								{
									$(this).addClass('abierto');
									$(this).removeClass('cerrado');
									$("#fiedl" + i).show();
									listplatesabierto = true;
								}
							});
						}
						else
						{
							item.indexg = dict[item.grouppar];
						}
					}
					else
					{
						item.indexg = -1;
					}
					if (item.id == 57)
					{
						if (item.name.includes("umresolution"))
						{
							var resopt = (item.value).split("x");
							resx = resopt[0];
							resy = resopt[1];
							resolutions = (item.options).split(";");
						}
					}
				});
				$.each(data, function(i, item)
				{
					if (item.visible == 1)
					{
						if (item.typepar == "int")
						{
							var normalexper = "";
							if (item.indexg == -1)
							{
								normalexper = "#field";
							}
							else
							{
								normalexper = "#fiedl" + item.indexg;
							}
							$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "'></div></div></div>");
							var valopt = (item.options).split(";");
							$("#elem" + i).dxNumberBox(
							{
								value: item.value,
								min: valopt[0],
								max: valopt[1],
								showSpinButtons: true,
								onValueChanged: function(e)
								{
									var is_changed = true;
									var is_correct = false;
									var previousValue = e.previousValue;
									var newValue = e.value;
									var res = 0;
									if (newValue != null)
									{
										if ((item.id == 10) || (item.id == 63))
										{
											if (newValue > data[i+1].value)
											{
												is_changed = false;
												DevExpress.ui.notify("ERROR: " + item.name + " > " + data[i+1].name, "error", 1000);
											}
										}
										else if ((item.id == 11) || (item.id == 64))
										{
											if (newValue < data[i-1].value)
											{
												is_changed = false;
												DevExpress.ui.notify("ERROR: " + data[i-1].name + " > " + item.name, "error", 1000);
											}
										}
										
										if (is_changed)
										{
											if(Number.isInteger(newValue))
											{
												data[i].value = newValue;
												// Event handling commands go here
												var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
												.done(function()
												{
													DevExpress.ui.notify("Data saved", "success", 600);
												})
												.fail(function()
												{
													DevExpress.ui.notify("Data saving error", "error", 600);
												});
											}
											else
											{
												DevExpress.ui.notify("Element is not an integer", "error", 600);
											}
										}

									}
									else
									{
										DevExpress.ui.notify("Empty value: " + item.name, "error", 1200);
									}
								}
							});
						}
						else if (item.typepar == "multioption")
						{
							var normalexper = "";
							if (item.indexg == -1)
							{
								normalexper = "#field";
							}
							else
							{
								normalexper = "#fiedl" + item.indexg;
							}
							$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value' id='multioption" + i + "'></div></div>");
							var valopt = (item.options).split(";");
							var valvalue = (item.value).split(";");
							var options_disabled = false;
							if (item.name == "trigger_io_type") //disable trigger options
							{
								options_disabled = true;
							}
							multioptdict["multioption" + i] = [];
							$.each(valvalue, function(k, itemvalue)
							{
								multioptdict["multioption" + i].push(itemvalue);
							});
							$.each(valopt, function(j, itemoptions)
							{
								$("#multioption" + i).append("<div id='elem" + i + "-" + j + "' style='float: left;margin-right: 10px;' ></div>");
								$("#elem" + i + "-" + j).dxCheckBox(
								{
									value: item.value.includes(itemoptions),
									text: itemoptions,
									disabled: options_disabled,
									onValueChanged: function(e)
									{
										var newValue = e.value;
										if (newValue)
										{
											multioptdict["multioption" + i].push(e.element[0].textContent);
										}
										else
										{
											var index = multioptdict["multioption" + i].indexOf(e.element[0].textContent);
											if (index > -1)
											{
												multioptdict["multioption" + i].splice(index, 1);
											}
										}
										var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + multioptdict["multioption" + i].toString().replace(/,/g, ';') + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
											.done(function()
											{
												DevExpress.ui.notify("Data saved", "success", 600);
											})
											.fail(function()
											{
												DevExpress.ui.notify("Data saving error", "error", 600);
											});
									}
								});
							});
						}
						else if (item.typepar == "nllocation")
						{
							var normalexper = "";
							if (item.indexg == -1)
							{
								normalexper = "#field";
							}
							else
							{
								normalexper = "#fiedl" + item.indexg;
							}
							$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + item.text + "</div><div class='dx-field-value'><div id='location'></div></div></div>");
							$("#location").dxSelectBox(
							{
								dataSource: locationsds,
								valueExpr: "id",
								searchEnabled: true,
								value: parseInt(item.value, 10),
								displayExpr: "description",
								onValueChanged: function(e)
								{
									var previousValue = e.previousValue;
									var newValue = e.value;
									// Event handling commands go here
									var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
										.done(function()
										{
											DevExpress.ui.notify("Data saved", "success", 600);
										})
										.fail(function()
										{
											DevExpress.ui.notify("Data saving error", "error", 600);
										});
								}
							});
						}
						else if (item.typepar == "nlregion")
						{
							var normalexper = "";
							if (item.indexg == -1)
							{
								normalexper = "#field";
							}
							else
							{
								normalexper = "#fiedl" + item.indexg;
							}
							$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='region'></div></div></div>");
							$("#region").dxSelectBox(
							{
								dataSource: regionds,
								valueExpr: "id",
								searchEnabled: true,
								value: parseInt(item.value, 10),
								displayExpr: "description",
								onValueChanged: function(e)
								{
									var previousValue = e.previousValue;
									var newValue = e.value;

									if(newValue != null)
									{
										$.ajax(
										{
											dataType: "json",
											url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcountry&comp0=equal&camp0=regionid&value0=" + newValue + "&maxvalues=250" + "&sortasc=description&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
											async: false,
											success: function(data)
											{
												CheckTokenValidity(data);
												$("#country").dxTagBox("instance").option("dataSource", data);
												$("#country").dxTagBox("instance").reset();
											}
										});
										var jqxhr = $.ajax(
										{
											url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=2&camp1=value&value1=&camp2=computerid&value2=" + computerid + "&camp3=cameraid&value3=-1" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
											async: false,
											success: function(data)
											{
												CheckTokenValidity(data);
												DevExpress.ui.notify("Data saved", "success", 600);
											}
										});
										var jqxhr = $.ajax(
										{
											url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=-1" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
											async: false,
											success: function(data)
											{
												CheckTokenValidity(data);
												DevExpress.ui.notify("Data saved", "success", 600);
											}
										});
									}
									else
									{
										DevExpress.ui.notify("Empty value: " + item.name, "error", 1200);
									}
								}
							});
							selected_region = item.value;

								$.ajax(
								{
									dataType: "json",
									url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcountry&comp0=equal&camp0=regionid&value0=" + selected_region + "&maxvalues=250" + "&sortasc=description&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
									async: false,
									success: function(data)
									{
										CheckTokenValidity(data);
										countriesds = new DevExpress.data.DataSource(
										{
											store: data,
											key: "id",
										});
									}
								});
						}
						else if (item.typepar == "nlcountry")
						{
							var normalexper = "";
							if (item.indexg == -1)
							{
								normalexper = "#field";
							}
							else
							{
								normalexper = "#fiedl" + item.indexg;
							}
							console.log("Test field name: " + item.text);
							if(item.text == "Countries:")
							$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage("CountryState") + ":</div><div class='dx-field-value'><div id='country'></div></div></div>");
							else
							$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='country'></div></div></div>");
							var valopt = (item.value).split(";");
							var valores = [];
							$.each(valopt, function(i, item)
							{
								valores.push(parseInt(item));
							});
							// Fix for bug #3314 regarding the presence of NaN in the list of countries
							if (valores.length >= 1)
							{
								if (isNaN(valores[0]))
								{
									valores = [];
								}
							}
							$("#country").dxTagBox(
							{
								dataSource: countriesds,
								valueExpr: "id",
								searchEnabled: true,
								value: valores,
								displayExpr: "description",
								onValueChanged: function(e)
								{
									var previousValue = e.previousValue;
									var newValue = e.value;

									if(newValue.length != 0)
									{
										var counts = "";
										$.each(newValue, function(i, item)
										{
											counts += item + ";";
										});
										counts = counts.substring(0, counts.length - 1);
										// Event handling commands go here
										var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + counts + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=-1" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
											.done(function()
											{
												DevExpress.ui.notify("Data saved", "success", 600);
											})
											.fail(function()
											{
												DevExpress.ui.notify("Data saving error", "error", 600);
											})
									}
									else
									{
										DevExpress.ui.notify("Empty value: " + item.name, "error", 1200);
									}
								}
							});
						}
						if (item.typepar == "bool")
						{
							var normalexper = "";
							if (item.indexg == -1)
							{
								normalexper = "#field";
							}
							else
							{
								normalexper = "#fiedl" + item.indexg;
							}
							var options_disabled = false;
							//if (item.name == "vmake") //disable vehicle make
							//{
							//	options_disabled = true;
							//}
							$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div></div></div>");
							var isTrueSet = (item.value == 'true');
							$("#elem" + i).dxCheckBox(
							{
								value: isTrueSet,
								disabled: options_disabled,
								onValueChanged: function(e)
								{
									var previousValue = e.previousValue;
									var newValue = e.value;
									// Event handling commands go here
									var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
										.done(function()
										{
											DevExpress.ui.notify("Data saved", "success", 600);
										})
										.fail(function()
										{
											DevExpress.ui.notify("Data saving error", "error", 600);
										});
								}
							});
						}
						if (item.typepar == "info")
						{
							var normalexper = "";
							if (item.indexg == -1)
							{
								normalexper = "#field";
							}
							else
							{
								normalexper = "#fiedl" + item.indexg;
							}
							$(normalexper).prepend(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div><div id='popupinfo" + i + "' style='display:none' ></div></div></div>");
							var mh = 400;
							var mw = 600;
							if (item.help == "infoexpertcamera-c.html" || item.help == "infoexpertcamera-n.html" || item.help == "infoexpertcamera-v.html" || item.help == "infoexpertcamera-z.html")
							{
								mh = 700;
								mw = 600;
							}

							$("#elem" + i).dxButton(
							{
								icon: "help",
								type: "success",
								mode: "contained",
								onClick: function(e)
								{
									var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
										.done(function(data)
										{
											$("#popupinfo" + i).append(data);
											var poup = $("#popupinfo" + i).dxPopup(
											{
												showTitle: true,
												title: DevExpress.localization.formatMessage("Help"),
												visible: true,
												maxWidth: mw,
												maxHeight: mh,
												loseOnOutsideClick: true
											});
										});
								}
							});
						}
						if (item.typepar == "string")
						{
							var normalexper = "";
							if (item.indexg == -1)
							{
								normalexper = "#field";
							}
							else
							{
								normalexper = "#fiedl" + item.indexg;
							}
							$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div></div></div>");
							var passmode = "Text";
							if (item.text == "Password:") passmode = "password";
							$("#elem" + i).dxTextBox(
							{
								value: item.value,
								mode: passmode,
								onValueChanged: function(e)
								{
									var previousValue = e.previousValue;
									var newValue = e.value;
									newValue = newValue.replace(/\\/g, '/');
									// Event handling commands go here
									var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + encodeURIComponent(newValue) + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
										.done(function()
										{
											DevExpress.ui.notify("Data saved", "success", 600);
										})
										.fail(function()
										{
											DevExpress.ui.notify("Data saving error", "error", 600);
										});
								}
							});
						}
						if (item.typepar == "option")
						{
							var valopt = (item.options).split(";");
							var normalexper = "";
							if (item.indexg == -1)
							{
								normalexper = "#field";
							}
							else
							{
								normalexper = "#fiedl" + item.indexg;
							}
							var helpdiv = "";
							if (item.help != "")
							{
								helpdiv = "<div id='icon" + i + "'></div><div id='popup" + i + "' style='display:none' ></div> ";
							}
							var item_name = DevExpress.localization.formatMessage(item.text);
							$(normalexper).append(" <div class='dx-field'><div class='dx-field-label'>" + item_name + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;'></div> " + helpdiv + "</div></div>");
							if (item.help != "")
							{
								var mh = 250;
								var mw = 500;
								if (item.help == "help_mode_camera.html" || item.help == "help_installation_camera.html")
								{
									mh = 400;
									mw = 800;
								}

								$("#icon" + i).dxButton(
								{
									icon: "help",
									type: "success",
									mode: "contained",
									onClick: function(e)
									{
										var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
											.done(function(data)
											{
												$("#popup" + i).append(data);
												var poup = $("#popup" + i).dxPopup(
												{
													showTitle: true,
													title: DevExpress.localization.formatMessage("Help"),
													visible: true,
													maxWidth: mw,
													maxHeight: mh,
													loseOnOutsideClick: true
												});
											});
									}
								});
							}
							var isTrueSet = (item.value == 'true');
							//if (item.text.includes("umresolution")) {
							//    var resopt = (item.value).split("x");
							//    resx = resopt[0];
							//    resy = resopt[1];
							//}
							var dict_translations = {};
							var current_val;
							if (((item.name == 'resolution') && (item.value.toLowerCase().includes("motorbikes"))) || (item.name == 'camposition') || (item.name == 'ff_filtermode') || (item.name == 'installation'))
							{
								valopt.forEach(function(element, index)
								{
									dict_translations[DevExpress.localization.formatMessage(element)] = element;
									valopt[index] = DevExpress.localization.formatMessage(element);
								})
								current_val = DevExpress.localization.formatMessage(item.value);
							}
							else
							{
								valopt.forEach(function(element, index)
								{
									dict_translations[element] = element;
								})
								current_val = item.value
							}
							$("#elem" + i).dxRadioGroup(
							{
								items: valopt,
								value: current_val,
								layout: "horizontal",
								onValueChanged: function(e)
								{
									var previousValue = e.previousValue;
									var newValue = dict_translations[e.value];
									//if (newValue.includes("x")) {
									//    var resopt = (newValue).split("x");
									//    resx = resopt[0];
									//    resy = resopt[1];
									//}
									// Event handling commands go here
									var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
										.done(function()
										{
											DevExpress.ui.notify("Data saved", "success", 600);
										})
										.fail(function()
										{
											DevExpress.ui.notify("Data saving error", "error", 600);
										});
									if (item.id == 4)
									{
										if (newValue == 'Do not allow motorbikes')
										{
											newValue = resolutions[0];
										}
										else
										{
											newValue = resolutions[1];
										}
										var resopt = newValue.split("x");
										resx = resopt[0];
										resy = resopt[1];
										var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=57&camp1=value&value1=" + newValue + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
											.done(function()
											{
												DevExpress.ui.notify("Data saved", "success", 600);
											})
											.fail(function()
											{
												DevExpress.ui.notify("Data saving error", "error", 600);
											});
									}
								}
							});
						}
						if (item.typepar == "roi")
						{
							var normalexper = "";
							if (item.indexg == -1)
							{
								normalexper = "#field";
							}
							else
							{
								normalexper = "#fiedl" + item.indexg;
							}
							$("#fiedlROI").append(" <div class='dx-field' id ='ROICANVAS'  ><div id='icon-done_info'></div><br><br><img src='./images/ROIGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvas' width='800' height='600' '></canvas><img id = 'mono' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'></div></div>");
							$("#ROIheader").click(function()
							{
								if ($("#ROIheader").hasClass("abierto"))
								{
									$(this).removeClass('abierto');
									$(this).addClass('cerrado');
									$("#fiedlROI").hide();
								}
								else
								{
									$(this).addClass('abierto');
									$(this).removeClass('cerrado');
									$("#fiedlROI").show();
								}
							});
							var valopt = (item.value).split(";");
							var sroi = "";
							if (valopt[0] != 0 || valopt[1] != 0 || valopt[2] != 0 || valopt[3] != 0)
							{
								sroi = " (" + valopt[0] + ";" + valopt[1] + ";" + valopt[2] + ";" + valopt[3] + ")";
							}
							$("#ROIheader").text(DevExpress.localization.formatMessage("Show Roi") + sroi);
							btroi = $("#icon-done_info").dxButton(
							{
								type: "success",
								text: DevExpress.localization.formatMessage("Reset ROI"),
								onClick: function()
								{
									resetROI();
								}
							}).dxButton('instance');;
							var canvas = document.getElementById('canvas');
							var ctx = canvas.getContext('2d');
							var img = document.getElementById("mono");
							var tmpImg = new Image();
							tmpImg.src = $('#mono').attr('src');
							tmpImg.onload = function()
							{
								ctx.drawImage(img, 0, 0);
								var ppcX = parseFloat("0." + valopt[0]);
								var ppcY = parseFloat("0." + valopt[1]);
								var ppcwidth = parseFloat("0." + valopt[2]);
								var ppcheight = parseFloat("0." + valopt[3]);
								ctx.rect(ppcX * 800, ppcY * 600, ppcwidth * 800, ppcheight * 600);
								ctx.strokeStyle = 'red';
								ctx.lineWidth = 5;
								ctx.stroke();
							};
							//Variables
							var canvasx = $(canvas).offset().left;
							var canvasy = $(canvas).offset().top;
							var last_mousex = last_mousey = 0;
							var mousex = mousey = 0;
							var mousedown = false;
							//Mousedown
							$(canvas).on('mousedown', function(e)
							{
								last_mousex = e.offsetX;
								last_mousey = e.offsetY;
								mousedown = true;
							});
							//Mouseup
							$(canvas).on('mouseup', function(e)
							{
								mousedown = false;
								var initpointx,
									initpointy,
									endpointx,
									endpointy;
								mousex = e.offsetX;
								mousey = e.offsetY;
								if (mousex > last_mousex)
								{
									initpointx = last_mousex;
									endpointx = mousex;
								}
								else
								{
									initpointx = mousex;
									endpointx = last_mousex;
								}
								if (mousey > last_mousey)
								{
									initpointy = last_mousey;
									endpointy = mousey;
								}
								else
								{
									initpointy = mousey;
									endpointy = last_mousey;
								}
								console.log("Init points:  x: " +initpointx+ " y: " +initpointy);
								console.log("Res:  x: " +resx+ " y: " +resy);
								console.log("End points:  x: " +endpointx+ " y: " +endpointy);
								var pointXReal = Math.round(initpointx * (resx / 800));
								var pointYReal = Math.round(initpointy * (resy / 600));
								var endpointXReal = Math.round(endpointx * (resx / 800));
								var endpointYReal = Math.round(endpointy * (resy / 600));
								if (pointXReal == endpointXReal || pointYReal == endpointYReal)
								{
									return;
								}
								if (pointXReal < 0)
								{
									pointXReal = 0;
								}
								if (pointYReal < 0)
								{
									pointYReal = 0;
								}
								var tpcx = (pointXReal / resx).toFixed(4);
								console.log("pointXReal " + pointXReal + "  tpcx" + tpcx);
								var tpcy = (pointYReal / resy).toFixed(4);
								console.log("pointYReal " + pointYReal + "  tpcy" + tpcy);
								var tpcwidth = ((endpointXReal - pointXReal) / resx).toFixed(4);
								console.log("endpointXReal " + endpointXReal + "  tpcwidth" + tpcwidth);
								var tpcheigth = ((endpointYReal - pointYReal) / resy).toFixed(4);
								console.log("endpointYReal " + endpointYReal + "  tpcheigth" + tpcheigth);
								var tpcx_dec = (tpcx + "").split(".")[1];
								var tpcy_dec = (tpcy + "").split(".")[1];
								var tpcwidth_dec = (tpcwidth + "").split(".")[1];
								var tpcheigth_dec = (tpcheigth + "").split(".")[1];
								var roi = tpcx_dec + ";" + tpcy_dec + ";" + tpcwidth_dec + ";" + tpcheigth_dec;
								console.log("roi " + roi);
								$("#ROIheader").text(DevExpress.localization.formatMessage("Show Roi") + " (" + roi + ")");
								var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=" + item.id + "&camp1=value&value1=" + roi + "&camp2=computerid&value2=" + item.computerid + "&camp3=cameraid&value3=" + item.cameraid + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
									.done(function()
									{
										DevExpress.ui.notify("Data saved", "success", 600);
									})
									.fail(function()
									{
										DevExpress.ui.notify("Data saving error", "error", 600);
									});
							});
							//Mousemove
							$(canvas).on('mousemove', function(e)
							{
								mousex = e.offsetX;
								mousey = e.offsetY;
								if (mousedown)
								{
									ctx.clearRect(0, 0, canvas.width, canvas.height); //clear canvas
									ctx.beginPath();
									var width = mousex - last_mousex;
									var height = mousey - last_mousey;
									ctx.rect(last_mousex, last_mousey, width, height);
									ctx.strokeStyle = 'red';
									ctx.lineWidth = 5;
									ctx.stroke();
									var img = document.getElementById("mono");
									ctx.drawImage(img, 0, 0);
									ctx.stroke();
								}
							});
						}
						/////////////////END ROI///////////////////////////////////////////////////////////////////////////////////////////////////////////////
						if (item.typepar == "nlcameraspeed")
						{
							var pointArray = [];
							$.ajax(
							{
								dataType: "json",
								url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcameraspeed&maxvalues=5&dcl=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
								async: false,
								success: function(data2)
								{
									//console.log("Test nlconfcameraspeed: " + JSON.stringify(data2));
									ident = data2[0].id;
									var normalexper = "";
									if (item.indexg == -1)
									{
										normalexper = "#field";
									}
									else
									{
										normalexper = "#fiedl" + item.indexg;
									}

									$(normalexper).append("<div class='dx-field'> <div class='dx-field-label' id='speedHeader' style= 'padding: 10px 0px;width: 100%' >Speed calibration </div>  </div>");
									$(normalexper).append(" <div class='dx-fieldset' id= 'fiedlSpeed'  ></div> ");

									$("#fiedlSpeed").append(" <div class='dx-field' id ='ROISPEED'  ><div id='icon-done_info2' style='width:155px; height:35px'></div><div id='icon-done_info3' style='margin-left:5px; width:155px; height:35px'></div><br><br><img src='./images/speedGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvasSpeed' width='800' height='600' '></canvas><img id = 'monoSpd' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'></div></div>");
									$("#speedHeader").click(function()
									{
										if ($("#speedHeader").hasClass("abierto"))
										{
											$(this).removeClass('abierto');
											$(this).addClass('cerrado');
											$("#fiedlSpeed").hide();
										}
										else
										{
											$(this).addClass('abierto');
											$(this).removeClass('cerrado');
											$("#fiedlSpeed").show();
										}
									});
									var valopt = (item.value).split(";");
									
									btroi = $("#icon-done_info2").dxButton(
									{
										type: "success",
										text: DevExpress.localization.formatMessage("Reset Calibration"),
										onClick: function()
										{
											pointArray = [];
											resetCalibration();
										}
									}).dxButton('instance');

									btroi = $("#icon-done_info3").dxButton(
									{
										type: "success",
										text: DevExpress.localization.formatMessage("Check Calibration"),
										onClick: function()
										{
											checkCalibration();
										}
									}).dxButton('instance');;
									var canvas = document.getElementById('canvasSpeed');
									var ctx = canvas.getContext('2d');
									
									var x = parseToFloat(data2[0].lpoint00X); var y = parseToFloat(data2[0].lpoint00Y); 
									pointArray.push({x:x * 800, y:y * 600});
									var x = parseToFloat(data2[0].lpoint01X); var y = parseToFloat(data2[0].lpoint01Y);
									pointArray.push({x:x * 800, y:y * 600});
									var x = parseToFloat(data2[0].lpoint10X); var y = parseToFloat(data2[0].lpoint10Y);
									pointArray.push({x:x * 800, y:y * 600});
									var x = parseToFloat(data2[0].lpoint11X); var y = parseToFloat(data2[0].lpoint11Y);
									pointArray.push({x:x * 800, y:y * 600});

									var img = document.getElementById("monoSpd");
									var tmpImg = new Image();
									tmpImg.src = $('#monoSpd').attr('src');
									var pendiente = 
									tmpImg.onload = function()
									{
										ctx.drawImage(img, 0, 0);
										ctx.fillStyle="red";
										ctx.strokeStyle = 'red';
										ctx.lineWidth = 5;
										ctx.fillRect(pointArray[0].x-5, pointArray[0].y-5, 10,10);
										ctx.fillRect(pointArray[1].x-5, pointArray[1].y-5, 10,10);
										ctx.fillRect(pointArray[2].x-5, pointArray[2].y-5, 10,10);
										ctx.fillRect(pointArray[3].x-5, pointArray[3].y-5, 10,10);
										ctx.beginPath();
										ctx.moveTo(pointArray[2].x, pointArray[2].y);
										ctx.lineTo(pointArray[0].x, pointArray[0].y);
										ctx.lineTo(pointArray[1].x, pointArray[1].y);
										ctx.lineTo(pointArray[3].x, pointArray[3].y);
										ctx.lineTo(pointArray[2].x, pointArray[2].y);
											
										ctx.stroke();
									};

									var sroi = "";
									sroi = "Speed calibration [(" + data2[0].lpoint00X + "," + data2[0].lpoint00Y + ") - (" + data2[0].lpoint01X + "," + data2[0].lpoint01Y + ") - (" + data2[0].lpoint10X + "," + data2[0].lpoint10Y + ") - (" + data2[0].lpoint11X + "," + data2[0].lpoint11Y + ")]";
									$("#speedHeader").text(DevExpress.localization.formatMessage("Show Speed Calibration") + sroi);

									//Variables
									var canvasx = $(canvas).offset().left;
									var canvasy = $(canvas).offset().top;
									var last_mousex = last_mousey = 0;
									var mousex = mousey = 0;
									var mousedown = false;
									//Mousedown
									$(canvas).on('mousedown', function(e)
									{
										mousedown = true;
									});
									//Mouseup
									$(canvas).on('mouseup', function(e)
									{
										mousedown = false;
										var initpointx,
											initpointy,
											endpointx,
											endpointy;
										mousex = e.offsetX;
										mousey = e.offsetY;
										console.log("mousex: " + mousex)
										console.log("mousey: " + mousey)
										console.log("resx: " + resx)
										console.log("resy: " + resy)
										var pointXReal = Math.round(mousex * (resx / 800));
										var pointYReal = Math.round(mousey * (resy / 600));
										var roi = pointXReal + ";" + pointYReal;
										//console.log("points: " + roi);
										pointArray.push({x: mousex, y: mousey});
										//console.log(pointArray.length);
										if(pointArray.length == 5)
										{
											ctx.clearRect(0, 0, canvas.width, canvas.height);
											var img = document.getElementById("monoSpd");
											var tmpImg = new Image();
											tmpImg.src = $('#monoSpd').attr('src');

											ctx.drawImage(img, 0, 0);
											pointArray = [];


											ctx.fillStyle="red";
											ctx.fillRect(mousex-5, mousey-5, 10,10);
											pointArray.push({x: mousex, y: mousey});
										}else if(pointArray.length == 4)
										{
											console.log("Points Array: " + JSON.stringify(pointArray));
											
											ctx.fillRect(mousex-5, mousey-5, 10,10);
											ctx.beginPath();
											ctx.moveTo(pointArray[2].x, pointArray[2].y);
											ctx.lineTo(pointArray[0].x, pointArray[0].y);
											ctx.lineTo(pointArray[1].x, pointArray[1].y);
											ctx.lineTo(pointArray[3].x, pointArray[3].y);
											ctx.lineTo(pointArray[2].x, pointArray[2].y);
											ctx.stroke();

											for(var i = 0; i < pointArray.length; i++)
											{
												var realX = Math.round(pointArray[i].x * (resx / 800));;
												var realY = Math.round(pointArray[i].y * (resy / 600));;
												var transformedx = (realX / resx).toFixed(4);
												var transformedy = (realY / resy).toFixed(4);
												pointArray[i].x = (transformedx + "").split(".")[1];
												pointArray[i].y = (transformedy + "").split(".")[1];
											}

											console.log("Percent Array: " + JSON.stringify(pointArray));

											var baseURLInsert = pathcgi + "cgi-bin/vparcgi.cgi";
											var urlinsert = "computerid=" + computerid + "&oper=update&table=nlcameraspeed&camp0=id&value0=" + data2[0].id + "&camp1=sendserver&value1=0&camp2=dateserver&value2=20180101000000" + localStorage.getItem("TOKEN");
											urlinsert += "&camp3=reserve&value3=";
											urlinsert += "&camp4=cameraid&value4=1";
											urlinsert += "&camp5=computerid&value5=1";
											urlinsert += "&camp6=lpoint00X&value6=" + pointArray[0].x;   //0
											urlinsert += "&camp7=lpoint00Y&value7=" + pointArray[0].y;   //0
											urlinsert += "&camp8=lpoint01X&value8=" + pointArray[1].x;   //1
											urlinsert += "&camp9=lpoint01Y&value9=" + pointArray[1].y;   //1
											urlinsert += "&camp10=lpoint10X&value10=" + pointArray[2].x; //2
											urlinsert += "&camp11=lpoint10Y&value11=" + pointArray[2].y; //2
											urlinsert += "&camp12=lpoint11X&value12=" + pointArray[3].x; //3
											urlinsert += "&camp13=lpoint11Y&value13=" + pointArray[3].y; //3
											urlinsert += "&camp14=calibrated&value14=1";
											//console.log("baseURLInsert "+baseURLInsert);
											//console.log("urlinsert "+urlinsert);
										
											var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?"+urlinsert)
											.done(function()
											{
												DevExpress.ui.notify("Data saved", "success", 600);
												sroi = "Speed calibration [(" + pointArray[0].x + "," + pointArray[0].y + ") - (" + pointArray[1].x + "," + pointArray[1].y + ") - (" + pointArray[2].x + "," + pointArray[2].y + ") - (" + pointArray[3].x+ "," + pointArray[3].y + ")]";
												$("#speedHeader").text(DevExpress.localization.formatMessage("Show Speed Calibration") + sroi);
											})
											.fail(function()
											{
												DevExpress.ui.notify("Data saving error", "error", 600);
											});
												

										}else
										{
											ctx.fillStyle="red";
											ctx.fillRect(mousex-5, mousey-5, 10,10);
										}
									});
								}
							});
						}
						////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
						if (item.typepar == "nlcameralane")
						{
							$.ajax(
							{
								dataType: "json",
								url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcameralane&maxvalues=250&dcl=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
								async: false,
								success: function(data2)
								{
									CheckTokenValidity(data);
									var normalexper = "";
									if (item.indexg == -1)
									{
										normalexper = "#field";
									}
									else
									{
										normalexper = "#fiedl" + item.indexg;
									}
									$("#fiedlLANES").append(" <div class='dx-field' id ='LANECANVAS'  ><div id='ResetLan'></div><br><br><img src='./images/LANEGIF.gif'> <div class='dx-field-value' style= ' width:auto' ><canvas id='canvaslanes' width='800' height='600' ></canvas><img id = 'monolanes' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'></div></div>");
									$("#ResetLan").dxButton(
									{
										type: "success",
										text: DevExpress.localization.formatMessage("Delete Lanes"),
										onClick: function()
										{
											resetLANES();
										}
									});
									var canvas2 = document.getElementById('canvaslanes');
									var ctx2 = canvas2.getContext('2d');
									var img2 = document.getElementById("monolanes");
									var tmpImg2 = new Image();
									tmpImg2.src = $('#monolanes').attr('src');
									tmpImg2.onload = function()
									{
										ctx2.drawImage(img2, 0, 0);
										if (data2.length > 0)
										{
											var p0;
											var p1;
											p0 = parseFloat(data2[0].lpoint00X / 10000) * 800;
											p1 = parseFloat(data2[0].lpoint01X / 10000) * 800;
											ctx2.moveTo(p0, 0);
											ctx2.lineTo(p1, 600);
											ctx2.strokeStyle = 'red';
											ctx2.lineWidth = 5;
											ctx2.font = "30px Arial";
											ctx2.fillStyle = "red";
											ctx2.textAlign = "left";
											ctx2.fillText("LANE1", 10, 25);
											ctx2.fillText("LANE2", 690, 25);
											$("#LH1").text(DevExpress.localization.formatMessage("Show Lanes") + " (" + data2[0].lpoint00X + ";" + data2[0].lpoint01X + ";" + data2[0].lpoint01X + ";" + data2[0].lpoint01Y + ")");
										}
										ctx2.stroke();
									};
									//Variables
									var canvasx2 = $(canvas2).offset().left;
									var canvasy2 = $(canvas2).offset().top;
									var last_mouse2x = last_mousey2 = 0;
									var mousex2 = mousey2 = 0;
									var mousedown2 = false;
									//Mousedown
									$(canvas2).on('mousedown', function(e)
									{
										last_mousex2 = e.offsetX;
										last_mousey2 = e.offsetY;
										mousedown2 = true;
									});
									//Mouseup
									$(canvas2).on('mouseup', function(e)
									{
										mousedown2 = false;
										var initpointx,
											initpointy,
											endpointx,
											endpointy;
										var initpointx1,
											initpointy1,
											endpointx1,
											endpointy1;
										mousex2 = e.offsetX;
										mousey2 = e.offsetY;
										initpointx1 = last_mousex2;
										endpointx1 = mousex2;
										initpointy1 = last_mousey2;
										endpointy1 = mousey2;
										if (initpointx1 <= endpointx1)
										{
											initpointx = initpointx1;
											initpointy = initpointy1;
											endpointx = endpointx1;
											endpointy = endpointy1;
										}
										else
										{
											initpointx = endpointx1;
											initpointy = endpointy1;
											endpointx = initpointx1;
											endpointy = initpointy1;
										}
										if ((endpointx - initpointx) == 0)
										{
											return;
										}
										var pendiente = (endpointy - initpointy) / (endpointx - initpointx);
										var b = endpointy - (pendiente * endpointx);
										ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
										ctx2.beginPath();
										var x0 = (-b / pendiente);
										var x1 = (600 - b) / pendiente;
										ctx2.moveTo(x0, 0);
										ctx2.lineTo(x1, 600);
										ctx2.strokeStyle = 'red';
										ctx2.lineWidth = 5;
										ctx2.stroke();
										var img2 = document.getElementById("monolanes");
										ctx2.drawImage(img2, 0, 0);
										ctx2.font = "30px Arial";
										ctx2.fillStyle = "red";
										ctx2.textAlign = "left";
										ctx2.fillText("LANE1", 10, 25);
										ctx2.fillText("LANE2", 690, 25);
										ctx2.stroke();
										var pointXReal = Math.round(x0 * (resx / 800));
										var endpointXReal = Math.round(x1 * (resx / 800));
										var endpointYReal = resy;
										var ltpcx = (pointXReal / resx).toFixed(4);
										var ltpcendx = (endpointXReal / resx).toFixed(4);
										var ltpcendy = (endpointYReal / resy).toFixed(4);
										var ltpcx_dec = ltpcx * 10000
										var ltpcendx_dec = ltpcendx * 10000
										var ltpcendy_dec = ltpcendy * 10000
										var lanestr = (ltpcx_dec + ";0;" + ltpcendx_dec + ";" + ltpcendy_dec);
										$("#LH1").text(DevExpress.localization.formatMessage("Show Lanes") + " (" + lanestr + ")");
										var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlcameralane&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN")).done(function()
											{
												var baseURLInsert = pathcgi + "cgi-bin/vparcgi.cgi";
												var urlinsert = "computerid=" + computerid + "&oper=insert&table=nlcameralane&camp0=id&value0=-1&camp1=sendserver&value1=0&camp2=dateserver&value2=20180101000000" + localStorage.getItem("TOKEN");
												// var urlinsert = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insert&table=nlcameralane&camp0=id&value0=-1&camp1=sendserver&value1=0&camp2=dateserver&value2=20180101000000" + localStorage.getItem("TOKEN");
												urlinsert += "&camp3=reserve&value3=";
												urlinsert += "&camp4=cameraid&value4=1";
												urlinsert += "&camp5=computerid&value5=1";
												urlinsert += "&camp6=name&value6=LANE1";
												urlinsert += "&camp7=direction&value7=1";
												urlinsert += "&camp8=lpoint00X&value8=" + ltpcx_dec;
												urlinsert += "&camp9=lpoint00Y&value9=0";
												urlinsert += "&camp10=lpoint01X&value10=" + ltpcendx_dec;
												urlinsert += "&camp11=lpoint01Y&value11=" + ltpcendy_dec;
												urlinsert += "&camp12=lpoint10X&value12=0";
												urlinsert += "&camp13=lpoint10Y&value13=0";
												urlinsert += "&camp14=lpoint11X&value14=0";
												urlinsert += "&camp15=lpoint11Y&value15=0";
												urlinsert += "&camp16=occoming&value16=1";
												urlinsert += "&camp17=ocgoing&value17=1";
												urlinsert += "&camp18=enabled&value18=1";
												console.log("baseURLInsert "+baseURLInsert);
													console.log("urlinsert "+urlinsert);
												if(DEFINE_INTERFACE == "VIVOTEK" || DEFINE_INTERFACE == "VIVOTEK_CV25"){
													
													var jqxhr = $.ajax({
													    type: "POST",
													    url: baseURLInsert, 
													    data: urlinsert, 
														async: false,
													    success:function(datos){ 
													     },
													    dataType: "text"
													})
												}else{
													var jqxhr = $.ajax(
													{
														url: baseURLInsert+"?"+urlinsert,
														async: false,
													});
												}

												// var jqxhr = $.ajax(
												// {
												// 	url: urlinsert,
												// 	async: false
												// });
												var urlinsert2 = "computerid=" + computerid + "&oper=insert&table=nlcameralane&camp0=id&value0=-1&camp1=sendserver&value1=0&camp2=dateserver&value2=20180101000000" + localStorage.getItem("TOKEN");
												// var urlinsert2 = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insert&table=nlcameralane&camp0=id&value0=-1&camp1=sendserver&value1=0&camp2=dateserver&value2=20180101000000" + localStorage.getItem("TOKEN");
												urlinsert2 += "&camp3=reserve&value3=";
												urlinsert2 += "&camp4=cameraid&value4=1";
												urlinsert2 += "&camp5=computerid&value5=1";
												urlinsert2 += "&camp6=name&value6=LANE2";
												urlinsert2 += "&camp7=direction&value7=1";
												urlinsert2 += "&camp8=lpoint00X&value8=0";
												urlinsert2 += "&camp9=lpoint00Y&value9=0";
												urlinsert2 += "&camp10=lpoint01X&value10=0";
												urlinsert2 += "&camp11=lpoint01Y&value11=0";
												urlinsert2 += "&camp12=lpoint10X&value12=" + ltpcx_dec;
												urlinsert2 += "&camp13=lpoint10Y&value13=0";
												urlinsert2 += "&camp14=lpoint11X&value14=" + ltpcendx_dec;
												urlinsert2 += "&camp15=lpoint11Y&value15=" + ltpcendy_dec;
												urlinsert2 += "&camp16=occoming&value16=1";
												urlinsert2 += "&camp17=ocgoing&value17=1";
												urlinsert2 += "&camp18=enabled&value18=1";

												if(DEFINE_INTERFACE == "VIVOTEK" || DEFINE_INTERFACE == "VIVOTEK_CV25"){
													//console.log("baseURLInsert "+baseURLInsert);
													//console.log("urlinsert2 "+urlinsert2);
													var jqxhr = $.ajax({
													    type: "POST",
													    url: baseURLInsert, 
													    data: urlinsert2, 
														async: false,
													    success:function(datos){ 
													     },
													    dataType: "text"
													})
												}else{
													var jqxhr2 = $.ajax(
													{
														url: baseURLInsert+"?"+urlinsert2,
														async: false,
													});
												}

												// var jqxhr2 = $.ajax(
												// {
												// 	url: urlinsert2,
												// 	async: false
												// });
												DevExpress.ui.notify("Data saved", "success", 600);
											})
											.fail(function()
											{
												DevExpress.ui.notify("Data saving error", "error", 600);
											});
									});
									//Mousemove
									$(canvas2).on('mousemove', function(e)
									{
										mousex2 = e.offsetX;
										mousey2 = e.offsetY;
										if (mousedown2)
										{
											ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
											ctx2.beginPath();
											var width2 = mousex2 - last_mousex2;
											var height2 = mousey2 - last_mousey2;
											ctx2.moveTo(last_mousex2, last_mousey2);
											ctx2.lineTo(mousex2, mousey2);
											ctx2.strokeStyle = 'red';
											ctx2.lineWidth = 5;
											ctx2.stroke();
											var img2 = document.getElementById("monolanes");
											ctx2.drawImage(img2, 0, 0);
											ctx2.stroke();
										}
									});
								}
							});
						}
					}
				});
			}
		});
	}
	
	function parseToFloat(numParse)
	{
		var decimal = "0."
		if (numParse < 1000)
		{
			decimal = "0.0"
		}
		return parseFloat(decimal + numParse);
	}

	function resetCalibration()
	{
		var canvas = document.getElementById('canvasSpeed');
		var ctx = canvas.getContext('2d');
		ctx.clearRect(0, 0, canvas.width, canvas.height);
		var img = document.getElementById("monoSpd");
		var tmpImg = new Image();
		tmpImg.src = $('#monoSpd').attr('src');

		ctx.drawImage(img, 0, 0);
		var pointArray = [];
		for(var i = 0; i < 4; i++)
		{
			pointArray.push({x: 0, y: 0})
		}
		
		if(DEFINE_INTERFACE == "HANWHA"){
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//To Do
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		}else{
			var urlinsert = "computerid=" + computerid + "&oper=update&table=nlcameraspeed&camp0=id&value0=" + ident + "&camp1=sendserver&value1=0&camp2=dateserver&value2=20180101000000" + localStorage.getItem("TOKEN");
			urlinsert += "&camp3=reserve&value3=";
			urlinsert += "&camp4=cameraid&value4=1";
			urlinsert += "&camp5=computerid&value5=1";
			urlinsert += "&camp6=lpoint00X&value6=0";
			urlinsert += "&camp7=lpoint00Y&value7=0";
			urlinsert += "&camp8=lpoint01X&value8=0";
			urlinsert += "&camp9=lpoint01Y&value9=0";
			urlinsert += "&camp10=lpoint10X&value10=0";
			urlinsert += "&camp11=lpoint10Y&value11=0";
			urlinsert += "&camp12=lpoint11X&value12=0";
			urlinsert += "&camp13=lpoint11Y&value13=0";
			urlinsert += "&camp14=calibrated&value14=0";
		
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?"+urlinsert)
			.done(function()
			{
				DevExpress.ui.notify("Data saved", "success", 600);
				var sroi = "";
				sroi = "Speed calibration [(0,0) - (0,0) - (0,0) - (0,0)]";
				$("#speedHeader").text(DevExpress.localization.formatMessage("Show Speed Calibration") + sroi);
			})
			.fail(function()
			{
				DevExpress.ui.notify("Data saving error", "error", 600);
			});
		}
	}

	function checkCalibration()
	{
		var pointArray = [];

		if(DEFINE_INTERFACE == "HANWHA")
		{
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//To Do
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		}
		else
		{
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=speedcalibrate"+ localStorage.getItem("TOKEN"))
			.done(function()
			{
				DevExpress.ui.notify("Calibrated Successful", "success", 600);
				$.ajax(
					{
						dataType: "json",
						url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcameraspeed&maxvalues=1" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
						async: false,
						success: function(data)
						{
							CheckTokenValidity(data);
							if (data.length > 0)
							{
								haveLanes = true;
							}
							
							DevExpress.ui.notify("Calibrated", "success", 600);
							var context2 = document.getElementById("canvasSpeed").getContext("2d");
							var x = parseToFloat(data[0].lpoint00X); var y = parseToFloat(data[0].lpoint00Y); 
							pointArray.push({x:x * 800, y:y * 600});
							var x = parseToFloat(data[0].lpoint01X); var y = parseToFloat(data[0].lpoint01Y);
							pointArray.push({x:x * 800, y:y * 600});
							var x = parseToFloat(data[0].lpoint10X); var y = parseToFloat(data[0].lpoint10Y);
							pointArray.push({x:x * 800, y:y * 600});
							var x = parseToFloat(data[0].lpoint11X); var y = parseToFloat(data[0].lpoint11Y);
							pointArray.push({x:x * 800, y:y * 600});
							
	
							var slope = (pointArray[2].y - pointArray[0].y)/(pointArray[2].x - pointArray[0].x)
							//y = mx + b | b = y - mx
							var intercept = pointArray[2].y - (slope * pointArray[2].x)
	
							function getY(x){ return (slope * x) + intercept; }
							function getX(y) { return (y - intercept)/slope; }
	
							// mark points in the canvas
							context2.fillStyle = "red";
							// draw a line between two points
							context2.beginPath();
							context2.strokeStyle = "blue";
							context2.lineWidth = 3;
							context2.moveTo(getX(0), 0);
							context2.lineTo(pointArray[0].x, pointArray[0].y);
							context2.lineTo(pointArray[2].x, pointArray[2].y);
							context2.lineTo(getX(context2.canvas.height), context2.canvas.height);
							context2.stroke();

							context2.beginPath();
							slope = (pointArray[3].y - pointArray[1].y)/(pointArray[3].x - pointArray[1].x)

							intercept = pointArray[3].y - (slope * pointArray[3].x)
							context2.strokeStyle = "blue";
							context2.lineWidth = 3;
							context2.moveTo(getX(0), 0);
							context2.lineTo(pointArray[1].x, pointArray[1].y);
							context2.lineTo(pointArray[3].x, pointArray[3].y);
							context2.lineTo(getX(context2.canvas.height), context2.canvas.height);
							context2.stroke();
							context2.beginPath();
							context2.fillStyle = "red";
							context2.strokeStyle = "red";
							context2.lineWidth = 5;
							context2.stroke();
							
						}
					});
			})
			.fail(function()
			{
				DevExpress.ui.notify("Calibration Error", "error", 600);
			});
		
			
		}
	}

	function resetROI()
	{
		var canvas = document.getElementById('canvas');
		var ctx = canvas.getContext('2d');
		ctx.clearRect(0, 0, canvas.width, canvas.height); //clear canvas
		ctx.beginPath();
		ctx.stroke();
		var img = document.getElementById("mono");
		ctx.drawImage(img, 0, 0);
		ctx.stroke();
		var roi = "0;0;0;0";
		$("#ROIheader").text(DevExpress.localization.formatMessage("Show Roi"));

		if(DEFINE_INTERFACE == "HANWHA"){
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			var msg = "";
			msg += "<GetSDK_APP_DATA>";
			msg += "<AppName>NeuralEdge</AppName>";
			msg += "<Data>computerid=" + computerid + "|oper=update|table=nlconfcamera|camp0=id|value0=5|camp1=value|value1=" + roi + "|camp2=computerid|value2=" + computerid + "|camp3=cameraid|value3=1</Data>";	
			msg += "</GetSDK_APP_DATA>";

			simpleHanwhaUpdate(msg)
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		}else{
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlconfcamera&camp0=id&value0=5&camp1=value&value1=" + roi + "&camp2=computerid&value2=" + computerid + "&camp3=cameraid&value3=1" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
			.done(function()
			{
				DevExpress.ui.notify("Data saved", "success", 600);
			})
			.fail(function()
			{
				DevExpress.ui.notify("Data saving error", "error", 600);
			});
		}
	}

	if (DEFINE_INTERFACE == "ZKTECO")
	{
		$("#fiedlLANES").after(" <div class='dx-fieldset-header cerrado' id='CrossLine' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Cross Line") + "</div> " +
		" <div class='dx-fieldset' id= 'fiedlCrossLine' > " +
		" 		<div id='crossdatagriddiv'></div>" +
		" <div id='crossdetaildiv' > " +
		" 	<div class='dx-fieldset-header abierto' id='crossdet' style='padding: 10px 40px; cursor: pointer;'>" + DevExpress.localization.formatMessage("Details") + "</div>" +
		" 	<div class='dx-fieldset' id='fiedlcrossdetails'> " +
		" <div class='dx-field' id ='CROSSLINE'  > " +
		"<div class='dx-field-label' style='width: auto;'>" + DevExpress.localization.formatMessage("Cross line:") +
		"<br><br><br><div id='ressetcrossline'></div> " +
		"</div>" +
		"<div class='dx-field-value' style= ' width:auto' >" +
		"<br><canvas id='canvascrossline' width='800' height='600' '></canvas><img id = 'crosslineimg' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'>" +
		"</div> " +
		"<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><div class='dx-field-label' >" + DevExpress.localization.formatMessage("Cross area:") +
		"<br><br><br><div id='ressetcrossarea'></div> " +
		"</div>" +
		"<div class='dx-field-value' style='width:auto;margin-top: 0px;' >" +
		"<canvas id='canvascrossarea' width='800' height='600' '></canvas><img id = 'crossareaimg' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'>" +
		"</div> " +
		"</div>" +
		"</div>" +
		"</div>" +
		" </div> ");
	}
	else if(DEFINE_INTERFACE == "HANWHA"){
			// console.log("TEST ENTRO canvascrossline");
			// $("#fiedlLANES").after(" <div class='dx-fieldset-header cerrado' id='CrossLine' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Cross Line") + "</div> " +
			// " <div class='dx-fieldset' id= 'fiedlCrossLine' > " +
			// " 		<div id='crossdatagriddiv'></div>" +
			// " <div id='crossdetaildiv' > " +
			// " 	<div class='dx-fieldset-header abierto' id='crossdet' style='padding: 10px 40px; cursor: pointer;'>" + DevExpress.localization.formatMessage("Details") + "</div>" +
			// " 	<div class='dx-fieldset' id='fiedlcrossdetails'> " +
			// " <div class='dx-field' id ='CROSSLINE'  > " +
			// "<div class='dx-field-label' style='width: auto;'>" + DevExpress.localization.formatMessage("Cross line:") +
			// "<br> <br><br><br><div id='ressetcrossline'></div> " +
			// "</div>" +
			// "<div class='dx-field-value' style= ' width:auto' >" +
			// "<canvas id='canvascrossline' width='800' height='600' '></canvas><img id = 'crosslineimg' src='https://paultan.org/image/2015/05/Plus-gateless-gantry-02-630x391.jpg' width='800' height='600' style= 'visibility:hidden;display:none'>" +
			// "</div> " +
			// "<br><br><br><div class='dx-field-label' >" + DevExpress.localization.formatMessage("Cross area:") +
			// "<br> <br><br><br><div id='ressetcrossarea'></div> " +
			// "</div>" +
			// "<div class='dx-field-value' style='width:auto;margin-top: -125px;' >" +
			// "<canvas id='canvascrossarea' width='800' height='600' '></canvas><img id = 'crossareaimg' src=' https://paultan.org/image/2015/05/Plus-gateless-gantry-02-630x391.jpg' width='800' height='600' style= 'visibility:hidden;display:none'>" +
			// "</div> " +
			// "</div>" +
			// "</div>" +
			// "</div>" +
			// " </div> ");
			// createFieldsHanwha(false, 0);
			// createFieldLanes();
			// loadHanwhaCross();

	} 
	else if ((!DEFINE_INTERFACE.includes("VIVOTEK")) || ((DEFINE_INTERFACE == "VIVOTEK"  || DEFINE_INTERFACE == "VIVOTEK_CV25") && (aplication != "eVivotek")))
	{
		$("#fiedlLANES").after(" <div class='dx-fieldset-header cerrado' id='CrossLine' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Cross Line") + "</div> " +
		" <div class='dx-fieldset' id= 'fiedlCrossLine' > " +
		" 		<div id='crossdatagriddiv'></div>" +
		" <div id='crossdetaildiv' > " +
		" 	<div class='dx-fieldset-header abierto' id='crossdet' style='padding: 10px 40px; cursor: pointer;'>" + DevExpress.localization.formatMessage("Details") + "</div>" +
		" 	<div class='dx-fieldset' id='fiedlcrossdetails'> " +
		" <div class='dx-field' id ='CROSSLINE'  > " +
		"<div class='dx-field-label' style='width: auto;'>" + DevExpress.localization.formatMessage("Cross line:") +
		"<br> <br><br><br><div id='ressetcrossline'></div> " +
		"</div>" +
		"<div class='dx-field-value' style= ' width:auto' >" +
		"<canvas id='canvascrossline' width='800' height='600' '></canvas><img id = 'crosslineimg' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'>" +
		"</div> " +
		"<br><br><br><div class='dx-field-label' >" + DevExpress.localization.formatMessage("Cross area:") +
		"<br> <br><br><br><div id='ressetcrossarea'></div> " +
		"</div>" +
		"<div class='dx-field-value' style='width:auto;margin-top: -125px;' >" +
		"<canvas id='canvascrossarea' width='800' height='600' '></canvas><img id = 'crossareaimg' src=' " + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN") + "' width='800' height='600' style= 'visibility:hidden;display:none'>" +
		"</div> " +
		"</div>" +
		"</div>" +
		"</div>" +
		" </div> ");
	}
	if(DEFINE_INTERFACE != "HANWHA"){
		$("#fiedlCrossLine").hide();
		$("#crossdetaildiv").hide();
		$("#CrossLine").click(function()
		{
			if ($("#CrossLine").hasClass("abierto"))
			{
				$(this).removeClass('abierto');
				$(this).addClass('cerrado');
				$("#fiedlCrossLine").hide();
			}
			else
			{
				$(this).addClass('abierto');
				$(this).removeClass('cerrado');
				$("#fiedlCrossLine").show();
			}
		});
		$("#crossdet").click(function()
		{
			if ($("#crossdet").hasClass("abierto"))
			{
				$(this).removeClass('abierto');
				$(this).addClass('cerrado');
				$("#fiedlcrossdetails").hide();
			}
			else
			{
				$(this).addClass('abierto');
				$(this).removeClass('cerrado');
				$("#fiedlcrossdetails").show();
			}
		});
		crossdatagrid = $("#crossdatagriddiv").dxDataGrid(
		{
			dataSource: cross_lista,
			showBorders: true,
			showRowLines: true,
			keyExpr: "id",
			hoverStateEnabled: true,
			paging:
			{
				pageSize: 10
			},
			searchPanel:
			{
				visible: true,
				width: 240,
			},
			columns: [
				{
					dataField: "id",
					caption: DevExpress.localization.formatMessage("ID"),
					width: 50,
					allowEditing: false
				},
				{
					width: "30%",
					dataField: "name",
					caption: DevExpress.localization.formatMessage("Name"),
					validationRules: [
					{
						type: "required"
					}]
				},
				{
					width: "15%",
					dataField: "triggermode",
					caption: DevExpress.localization.formatMessage("Mode"),
					validationRules: [
					{
						type: "required"
					}],
					lookup:
					{
						dataSource: [
							DevExpress.localization.formatMessage("Entering"),
							DevExpress.localization.formatMessage("Leaving"),
							DevExpress.localization.formatMessage("Both")
						]
						/*dataSource: modearray,
						displayExpr: "description",
						valueExpr: "id"*/
					}
				},
				/*{
	                    dataField: "lineheight",
	                    caption: DevExpress.localization.formatMessage("lineheight"),
					    dataType: "number",
	                    width: "10%",
	                    format: {
	                        type: "decimal",
	                        precision: 0
	                    },
	                    validationRules: [{
	                        type: "required"
	                    }]
	                },*/
				{
					dataField: "pixelchange",
					caption: DevExpress.localization.formatMessage("Pixel Change"),
					dataType: "number",
					width: "10%",
					format:
					{
						type: "decimal",
						precision: 0
					},
					validationRules: [
					{
						type: "required"
					}]
				},
				{
					dataField: "minchangepc",
					caption: DevExpress.localization.formatMessage("Min. change pc"),
					dataType: "number",
					width: "10%",
					format:
					{
						type: "decimal",
						precision: 0
					},
					validationRules: [
					{
						type: "required"
					}]
				}
			],
			editing:
			{
				mode: "row",
				allowUpdating: true,
				allowDeleting: true,
				texts:
				{
					confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the cross line?")
				},
				allowAdding: true
			},
			selection:
			{
				mode: "single"
			},
			onSelectionChanged: function(selectedItems)
			{
				var data = selectedItems.selectedRowsData[0];
				if (data)
				{
					$("#crossdetaildiv").show();
					crosslineediting = data.id;
					loadcrosslinedetails(data.id);
				}
			},
			onRowUpdating: function(e)
			{
				var description;
				if (typeof e.newData.name !== 'undefined')
				{
					description = e.newData.name.replaceAll('"', '').replaceAll('\'', '');
				}
				else
				{
					description = e.oldData.name.replaceAll('"', '').replaceAll('\'', '');
				}
				var pixelchange;
				if (typeof e.newData.pixelchange !== 'undefined')
				{
					pixelchange = e.newData.pixelchange;
				}
				else
				{
					pixelchange = e.oldData.pixelchange;
				}
				/*var lineheight;
	                if (typeof e.newData.lineheight !== 'undefined') {
	                    lineheight = e.newData.lineheight;
	                } else {
	                    lineheight = e.oldData.lineheight;
					}*/
				var triggermode;
				if (typeof e.newData.triggermode !== 'undefined')
				{
					triggermode = convertTriggermodeToInt(e.newData.triggermode);
				}
				else
				{
					triggermode = convertTriggermodeToInt(e.oldData.triggermode);
				}
				var minchangepc;
				if (typeof e.newData.minchangepc !== 'undefined')
				{
					minchangepc = e.newData.minchangepc;
				}
				else
				{
					minchangepc = e.oldData.minchangepc;
				}
				if(DEFINE_INTERFACE == "VIVOTEK" || DEFINE_INTERFACE == "VIVOTEK_CV25"){
					var urlUpdate = "computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + e.key +
						"&camp1=name&value1=" + description +
						"&camp2=computerid&value2=1" +
						"&camp3=cameraid&value3=1" +
						"&camp4=pixelchange&value4=" + pixelchange +
						//"&camp5=lineheight&value5="+lineheight+
						"&camp5=triggermode&value5=" + triggermode +
						"&camp6=minchangepc&value6=" + minchangepc +
						"&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN")
					console.log("urlUpdate "+urlUpdate);
					var jqxhr = $.ajax({
					    type: "POST",
					    url: pathcgi + "cgi-bin/vparcgi.cgi", 
					    data: urlUpdate, 
						async: false,
					    success:function(datos){ 
					    	console.log(datos);
					     },
					    dataType: "text"
					})
				}else{
					var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + e.key +
						"&camp1=name&value1=" + description +
						"&camp2=computerid&value2=1" +
						"&camp3=cameraid&value3=1" +
						"&camp4=pixelchange&value4=" + pixelchange +
						//"&camp5=lineheight&value5="+lineheight+
						"&camp5=triggermode&value5=" + triggermode +
						"&camp6=minchangepc&value6=" + minchangepc +
						"&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
				}
			},
			onRowInserting: function(e)
			{
				var triggermode = convertTriggermodeToInt(e.data.triggermode);
				var jqxhr = $.ajax(
				{
					url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insertcross&name=" + e.data.name.replaceAll('"', '').replaceAll('\'', '') + "&triggermode=" + triggermode + "&pixelchange=" + e.data.pixelchange + "&minchangepc=" + e.data.minchangepc + /*"&lineheight=" + e.data.lineheight+*/ "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						data = data.replaceAll('\r', '').replaceAll('\n', '');
						DevExpress.ui.notify("Data saved", "success", 600);
						loadcrossline();
					}
				});
			},
			onRowRemoving: function(e)
			{
				var jqxhr2 = $.ajax(
				{
					url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlcrossline&camp0=id&comp0=equal&value0=" + e.key + localStorage.getItem("TOKEN"),
					async: false
				});
				loadcrossline();
				$("#crossdetaildiv").hide();
			}
		}).dxDataGrid("instance");
	}

	function convertTriggermodeToInt(mode)
	{
		var value = 1;
		if (typeof mode !== 'undefined')
		{
			if (mode == DevExpress.localization.formatMessage("Entering"))
			{
				value = 1;
			}
			else if (mode == DevExpress.localization.formatMessage("Leaving"))
			{
				value = 2;
			}
			else if (mode == DevExpress.localization.formatMessage("Both"))
			{
				value = 3;
			}
		}
		return value;
	}
	function convertIntToTriggermode(value)
	{
		var mode = DevExpress.localization.formatMessage("Entering");
		if (value == 1)
		{
			mode = DevExpress.localization.formatMessage("Entering");
		}
		else if (value == 2)
		{
			mode = DevExpress.localization.formatMessage("Leaving");
		}
		else if (value == 3)
		{
			mode = DevExpress.localization.formatMessage("Both");
		}
		return mode;
	}
	function resetLANES()
	{
		var canvas2 = document.getElementById('canvaslanes');
		var ctx2 = canvas2.getContext('2d');
		ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
		ctx2.beginPath();
		ctx2.stroke();
		var img2 = document.getElementById("monolanes");
		ctx2.drawImage(img2, 0, 0);
		ctx2.stroke();
		$("#LH1").text(DevExpress.localization.formatMessage("Show Lanes"));
		if(DEFINE_INTERFACE == "HANWHA"){
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			var msg = "";
			msg += "<GetSDK_APP_DATA>";
			msg += "<AppName>NeuralEdge</AppName>";
			msg += "<Data>computerid=" + computerid + "|oper=delete|table=nlcameralane</Data>";	
			msg += "</GetSDK_APP_DATA>";

			addToQueue(msg, function(response) {
				var resData = response; 
				console.log("Datos consulta: " + msg);
				console.log("Respuesta status: " + resData);
	        	if(resData!=undefined && resData!=""){
					DevExpress.ui.notify("Data saved", "success", 600);
				}else{
					DevExpress.ui.notify("Data saving error", "error", 600);						
				}  
	    	}); 
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		}else{
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlcameralane" + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
				.done(function()
				{
					DevExpress.ui.notify("Data saved", "success", 600);
				})
				.fail(function()
				{
					DevExpress.ui.notify("Data saving error", "error", 600);
				});
			}
	}
	function loadcrossline()
	{
		if(DEFINE_INTERFACE == "HANWHA"){
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			var msg = "";
			msg += "<GetSDK_APP_DATA>";
			msg += "<AppName>NeuralEdge</AppName>";
			msg += "<Data>computerid=" + computerid + "|oper=select|table=nlcrossline|maxvalues=20|sortdesc=id|adinfo=notvalue</Data>";	
			msg += "</GetSDK_APP_DATA>";

			addToQueue(msg, function(response) {
				var resData = response; 
				console.log("Response in first query response: " + JSON.stringify(resData));
				console.log("Datos consulta: " + msg);
				console.log("Respuesta : " + JSON.stringify(resData));
				console.log("Respuesta status: " + resData);
	        	if(resData!=undefined && resData!=""){
					actdict = {};
					cross_lista = status;
					crossdatagrid.option("dataSource", cross_lista);
					$.each(resData, function(i, item)
					{
						resData[i].triggermode = convertIntToTriggermode(resData[i].triggermode);
						actdict["cross" + item.id] = item;
					});
				}  
	    	}); 
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		}else{
			var d = new Date();
			$.ajax(
			{
				dataType: "json",
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcrossline&maxvalues=20&sortdesc=id&date=" + getStringNormalDate(d) + localStorage.getItem("TOKEN"),
				success: function(data)
				{
					actdict = {};
					cross_lista = data;
					crossdatagrid.option("dataSource", cross_lista);
					$.each(data, function(i, item)
					{
						data[i].triggermode = convertIntToTriggermode(data[i].triggermode);
						actdict["cross" + item.id] = item;
					});
				}
			});
		}
	};
	
	function loadcrossline()
	{
		
		var d = new Date();
		$.ajax(
		{
			dataType: "json",
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcrossline&maxvalues=20&sortdesc=id&date=" + getStringNormalDate(d) + localStorage.getItem("TOKEN"),
			success: function(data)
			{
				actdict = {};
				cross_lista = data;
				crossdatagrid.option("dataSource", cross_lista);
				$.each(data, function(i, item)
				{
					data[i].triggermode = convertIntToTriggermode(data[i].triggermode);
					actdict["cross" + item.id] = item;
				});
			}
		});
		
	};
	
	function loadHanwhaCross(){

		console.log("call HANWHA loadHanwhaCross();");
		//loadcrossline(1000);
		var msg = "";
			msg += "<GetSDK_APP_DATA>";
			msg += "<AppName>NeuralEdge</AppName>";
			msg += "<Data>computerid=" + computerid + "|oper=select|table=nlcrossline|maxvalues=20|sortdesc=id|adinfo=notvalue</Data>";	
			msg += "</GetSDK_APP_DATA>";
			addToQueue(msg, function(response) {
				var data = response;
				if(data!=undefined && data!=""){
					actdict = {};
					cross_lista = status;

					if(crossdatagrid != undefined)
						crossdatagrid.option("dataSource", cross_lista);
					if(Array.isArray(data)){
						$.each(data, function(i, item)
						{
							data[i].triggermode = convertIntToTriggermode(resData[i].triggermode);
							actdict["cross" + item.id] = item;
						});
					}
				}

				var canvas2 = document.getElementById('canvascrossline');
				var ctx2 = canvas2.getContext('2d');
				var canvasx2 = $(canvas2).offset().left;
				var canvasy2 = $(canvas2).offset().top;
				var last_mousex2 = last_mousey2 = 0;
				var mousex2 = mousey2 = 0;
				var mousedown2 = false;
				//Mousedown
				$(canvas2).on('mousedown', function(e)
				{
					last_mousex2 = e.offsetX;
					last_mousey2 = e.offsetY;
					mousedown2 = true;
				});
				//Mouseup
				$(canvas2).on('mouseup', function(e)
				{
					mousedown2 = false;
					var initpointx,
						initpointy,
						endpointx,
						endpointy;
					var initpointx1,
						initpointy1,
						endpointx1,
						endpointy1;
					mousex2 = e.offsetX;
					mousey2 = e.offsetY;
					initpointx1 = last_mousex2;
					endpointx1 = mousex2;
					initpointy1 = last_mousey2;
					endpointy1 = mousey2;
					/*if (initpointx1 <= endpointx1) {*/
					initpointx = initpointx1;
					endpointx = endpointx1;
					initpointy = initpointy1;
					endpointy = endpointy1;
					/*} else {
						initpointx = endpointx1;
						endpointx = initpointx1;
					 
					}*/
					if ((endpointx - initpointx) == 0 || (endpointy - initpointy) == 0)
					{
						return;
					}
					ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
					ctx2.beginPath();
					var img2 = document.getElementById("crosslineimg");
					ctx2.drawImage(img2, 0, 0);
					ctx2.moveTo(initpointx, last_mousey2);
					ctx2.lineTo(endpointx, mousey2);
					ctx2.strokeStyle = 'red';
					ctx2.lineWidth = 5;
					ctx2.stroke();
					var pointXReal = Math.round(last_mousex2 * (resx / 800));
					var pointYReal = Math.round(last_mousey2 * (resy / 600));
					var endpointXReal = Math.round(endpointx * (resx / 800));
					var endpointYReal = Math.round(endpointy * (resy / 600));;
					var ltpcx = (pointXReal / resx).toFixed(4);
					var ltpcy = (pointYReal / resy).toFixed(4);
					var ltpcendx = (endpointXReal / resx).toFixed(4);
					var ltpcendy = (endpointYReal / resy).toFixed(4);

					/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
					var msg = "";
					msg += "<GetSDK_APP_DATA>";
					msg += "<AppName>NeuralEdge</AppName>";
					msg += "<Data>computerid=" + computerid + "|oper=update|table=nlcrossline|camp0=id|value0=" + crosslineediting + "|camp1=lineY0|value1=" + ltpcy + "|camp2=computerid|value2=1|camp3=cameraid|value3=1|camp4=lineX0|value4=" + ltpcx + "|camp5=lineY1|value5=" + ltpcendy + "|camp6=lineX1|value6=" + ltpcendx + "</Data>";	
					msg += "</GetSDK_APP_DATA>";

					simpleHanwhaUpdate(msg)
					/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

					actdict["cross" + crosslineediting].lineY0 = ltpcy;
					actdict["cross" + crosslineediting].lineX0 = ltpcx;
					actdict["cross" + crosslineediting].lineY1 = ltpcendy;
					actdict["cross" + crosslineediting].lineX1 = ltpcendx;
				});
				//Mousemove
				$(canvas2).on('mousemove', function(e)
				{
					mousex2 = e.offsetX;
					mousey2 = e.offsetY;
					if (mousedown2)
					{
						ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
						ctx2.beginPath();
						var width2 = mousex2 - last_mousex2;
						var height2 = mousey2 - last_mousey2;
						ctx2.moveTo(last_mousex2, last_mousey2);
						ctx2.lineTo(mousex2, mousey2);
						ctx2.strokeStyle = 'red';
						ctx2.lineWidth = 5;
						ctx2.stroke();
						var img2 = document.getElementById("crosslineimg");
						ctx2.drawImage(img2, 0, 0);
						ctx2.stroke();
					}
				});
				var canvas = document.getElementById('canvascrossarea');
				var ctx = canvas.getContext('2d');
				var canvasx = $(canvas).offset().left;
				var canvasy = $(canvas).offset().top;
				var last_mousex = last_mousey = 0;
				var mousex = mousey = 0;
				var mousedown = false;
				//Mousedown
				$(canvas).on('mousedown', function(e)
				{
					last_mousex = e.offsetX;
					last_mousey = e.offsetY;
					mousedown = true;
				});
				//Mouseup
				$(canvas).on('mouseup', function(e)
				{
					mousedown = false;
					var initpointx,
						initpointy,
						endpointx,
						endpointy;
					mousex = e.offsetX;
					mousey = e.offsetY;
					if (mousex > last_mousex)
					{
						initpointx = last_mousex;
						endpointx = mousex;
					}
					else
					{
						initpointx = mousex;
						endpointx = last_mousex;
					}
					if (mousey > last_mousey)
					{
						initpointy = last_mousey;
						endpointy = mousey;
					}
					else
					{
						initpointy = mousey;
						endpointy = last_mousey;
					}
					var pointXReal = Math.round(initpointx * (resx / 800));
					var pointYReal = Math.round(initpointy * (resy / 600));
					var endpointXReal = Math.round(endpointx * (resx / 800));
					var endpointYReal = Math.round(endpointy * (resy / 600));
					if (pointXReal == endpointXReal || pointYReal == endpointYReal)
					{
						return;
					}
					if (pointXReal < 0)
					{
						pointXReal = 0;
					}
					if (pointYReal < 0)
					{
						pointYReal = 0;
					}
					var tpcx = (pointXReal / resx).toFixed(4);
					var tpcy = (pointYReal / resy).toFixed(4);
					var tpcwidth = ((endpointXReal - pointXReal) / resx).toFixed(4);
					var tpcheigth = ((endpointYReal - pointYReal) / resy).toFixed(4);

					/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
					var msg = "";
					msg += "<GetSDK_APP_DATA>";
					msg += "<AppName>NeuralEdge</AppName>";
					msg += "<Data>computerid=" + computerid + "|oper=update|table=nlcrossline|camp0=id|value0=" + crosslineediting + "|camp1=roi1|value1=" + tpcx + "|camp2=computerid|value2=1|camp3=cameraid|value3=1|camp4=roi2|value4=" + tpcy + "|camp5=roi3|value5=" + tpcwidth + "|camp6=roi4|value6=" + tpcheigth + "</Data>";	
					msg += "</GetSDK_APP_DATA>";

					simpleHanwhaUpdate(msg)
					/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

					actdict["cross" + crosslineediting].roi1 = tpcx;
					actdict["cross" + crosslineediting].roi2 = tpcy;
					actdict["cross" + crosslineediting].roi3 = tpcwidth;
					actdict["cross" + crosslineediting].roi4 = tpcheigth;
				});
				//Mousemove
				$(canvas).on('mousemove', function(e)
				{
					mousex = e.offsetX;
					mousey = e.offsetY;
					if (mousedown)
					{
						ctx.clearRect(0, 0, canvas.width, canvas.height); //clear canvas
						ctx.beginPath();
						var width = mousex - last_mousex;
						var height = mousey - last_mousey;
						ctx.rect(last_mousex, last_mousey, width, height);
						ctx.strokeStyle = 'red';
						ctx.lineWidth = 5;
						ctx.stroke();
						var img = document.getElementById("crossareaimg");
						ctx.drawImage(img, 0, 0);
						ctx.stroke();
					}
				});
				$("#ressetcrossline").dxButton(
				{
					type: "success",
					text: DevExpress.localization.formatMessage("Delete line"),
					onClick: function()
					{
						resetLaneCross();
					}
				});
				$("#ressetcrossarea").dxButton(
				{
					type: "success",
					text: DevExpress.localization.formatMessage("Delete area"),
					onClick: function()
					{
						resetLaneArea();
					}
				});
		

		});   
		
	}
	/////////
	if(DEFINE_INTERFACE == "HANWHA"){
		// setTimeout(loadHanwhaCross, 5000);
	}else if ((!DEFINE_INTERFACE.includes("VIVOTEK")) || ((DEFINE_INTERFACE == "VIVOTEK" || DEFINE_INTERFACE == "VIVOTEK_CV25") && (aplication != "eVivotek")))
	{
		loadcrossline();
		var canvas2 = document.getElementById('canvascrossline');
		var ctx2 = canvas2.getContext('2d');
		var canvasx2 = $(canvas2).offset().left;
		var canvasy2 = $(canvas2).offset().top;
		var last_mousex2 = last_mousey2 = 0;
		var mousex2 = mousey2 = 0;
		var mousedown2 = false;
		//Mousedown
		$(canvas2).on('mousedown', function(e)
		{
			last_mousex2 = e.offsetX;
			last_mousey2 = e.offsetY;
			mousedown2 = true;
		});
		//Mouseup
		$(canvas2).on('mouseup', function(e)
		{
			mousedown2 = false;
			var initpointx,
				initpointy,
				endpointx,
				endpointy;
			var initpointx1,
				initpointy1,
				endpointx1,
				endpointy1;
			mousex2 = e.offsetX;
			mousey2 = e.offsetY;
			initpointx1 = last_mousex2;
			endpointx1 = mousex2;
			initpointy1 = last_mousey2;
			endpointy1 = mousey2;
			/*if (initpointx1 <= endpointx1) {*/
			initpointx = initpointx1;
			endpointx = endpointx1;
			initpointy = initpointy1;
			endpointy = endpointy1;
			/*} else {
				initpointx = endpointx1;
				endpointx = initpointx1;
			 
			}*/
			if ((endpointx - initpointx) == 0 || (endpointy - initpointy) == 0)
			{
				return;
			}
			ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx2.beginPath();
			var img2 = document.getElementById("crosslineimg");
			ctx2.drawImage(img2, 0, 0);
			ctx2.moveTo(initpointx, last_mousey2);
			ctx2.lineTo(endpointx, mousey2);
			ctx2.strokeStyle = 'red';
			ctx2.lineWidth = 5;
			ctx2.stroke();
			var pointXReal = Math.round(last_mousex2 * (resx / 800));
			var pointYReal = Math.round(last_mousey2 * (resy / 600));
			var endpointXReal = Math.round(endpointx * (resx / 800));
			var endpointYReal = Math.round(endpointy * (resy / 600));;
			var ltpcx = (pointXReal / resx).toFixed(4);
			var ltpcy = (pointYReal / resy).toFixed(4);
			var ltpcendx = (endpointXReal / resx).toFixed(4);
			var ltpcendy = (endpointYReal / resy).toFixed(4);
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + crosslineediting + "&camp1=lineY0&value1=" + ltpcy + "&camp2=computerid&value2=1&camp3=cameraid&value3=1&camp4=lineX0&value4=" + ltpcx + "&camp5=lineY1&value5=" + ltpcendy + "&camp6=lineX1&value6=" + ltpcendx + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
				.done(function()
				{
					DevExpress.ui.notify("Data saved", "success", 600);
				})
				.fail(function()
				{
					DevExpress.ui.notify("Data saving error", "error", 600);
				});
			actdict["cross" + crosslineediting].lineY0 = ltpcy;
			actdict["cross" + crosslineediting].lineX0 = ltpcx;
			actdict["cross" + crosslineediting].lineY1 = ltpcendy;
			actdict["cross" + crosslineediting].lineX1 = ltpcendx;
		});
		//Mousemove
		$(canvas2).on('mousemove', function(e)
		{
			mousex2 = e.offsetX;
			mousey2 = e.offsetY;
			if (mousedown2)
			{
				ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
				ctx2.beginPath();
				var width2 = mousex2 - last_mousex2;
				var height2 = mousey2 - last_mousey2;
				ctx2.moveTo(last_mousex2, last_mousey2);
				ctx2.lineTo(mousex2, mousey2);
				ctx2.strokeStyle = 'red';
				ctx2.lineWidth = 5;
				ctx2.stroke();
				var img2 = document.getElementById("crosslineimg");
				ctx2.drawImage(img2, 0, 0);
				ctx2.stroke();
			}
		});
		var canvas = document.getElementById('canvascrossarea');
		var ctx = canvas.getContext('2d');
		var canvasx = $(canvas).offset().left;
		var canvasy = $(canvas).offset().top;
		var last_mousex = last_mousey = 0;
		var mousex = mousey = 0;
		var mousedown = false;
		//Mousedown
		$(canvas).on('mousedown', function(e)
		{
			last_mousex = e.offsetX;
			last_mousey = e.offsetY;
			mousedown = true;
		});
		//Mouseup
		$(canvas).on('mouseup', function(e)
		{
			mousedown = false;
			var initpointx,
				initpointy,
				endpointx,
				endpointy;
			mousex = e.offsetX;
			mousey = e.offsetY;
			if (mousex > last_mousex)
			{
				initpointx = last_mousex;
				endpointx = mousex;
			}
			else
			{
				initpointx = mousex;
				endpointx = last_mousex;
			}
			if (mousey > last_mousey)
			{
				initpointy = last_mousey;
				endpointy = mousey;
			}
			else
			{
				initpointy = mousey;
				endpointy = last_mousey;
			}
			var pointXReal = Math.round(initpointx * (resx / 800));
			var pointYReal = Math.round(initpointy * (resy / 600));
			var endpointXReal = Math.round(endpointx * (resx / 800));
			var endpointYReal = Math.round(endpointy * (resy / 600));
			if (pointXReal == endpointXReal || pointYReal == endpointYReal)
			{
				return;
			}
			if (pointXReal < 0)
			{
				pointXReal = 0;
			}
			if (pointYReal < 0)
			{
				pointYReal = 0;
			}
			var tpcx = (pointXReal / resx).toFixed(4);
			var tpcy = (pointYReal / resy).toFixed(4);
			var tpcwidth = ((endpointXReal - pointXReal) / resx).toFixed(4);
			var tpcheigth = ((endpointYReal - pointYReal) / resy).toFixed(4);
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + crosslineediting + "&camp1=roi1&value1=" + tpcx + "&camp2=computerid&value2=1&camp3=cameraid&value3=1&camp4=roi2&value4=" + tpcy + "&camp5=roi3&value5=" + tpcwidth + "&camp6=roi4&value6=" + tpcheigth + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
				.done(function()
				{
					DevExpress.ui.notify("Data saved", "success", 600);
				})
				.fail(function()
				{
					DevExpress.ui.notify("Data saving error", "error", 600);
				});
			actdict["cross" + crosslineediting].roi1 = tpcx;
			actdict["cross" + crosslineediting].roi2 = tpcy;
			actdict["cross" + crosslineediting].roi3 = tpcwidth;
			actdict["cross" + crosslineediting].roi4 = tpcheigth;
		});
		//Mousemove
		$(canvas).on('mousemove', function(e)
		{
			mousex = e.offsetX;
			mousey = e.offsetY;
			if (mousedown)
			{
				ctx.clearRect(0, 0, canvas.width, canvas.height); //clear canvas
				ctx.beginPath();
				var width = mousex - last_mousex;
				var height = mousey - last_mousey;
				ctx.rect(last_mousex, last_mousey, width, height);
				ctx.strokeStyle = 'red';
				ctx.lineWidth = 5;
				ctx.stroke();
				var img = document.getElementById("crossareaimg");
				ctx.drawImage(img, 0, 0);
				ctx.stroke();
			}
		});
		$("#ressetcrossline").dxButton(
		{
			type: "success",
			text: DevExpress.localization.formatMessage("Delete line"),
			onClick: function()
			{
				resetLaneCross();
			}
		});
		$("#ressetcrossarea").dxButton(
		{
			type: "success",
			text: DevExpress.localization.formatMessage("Delete area"),
			onClick: function()
			{
				resetLaneArea();
			}
		});
	}

	function loadcrosslinedetails(idcross)
	{
		var cross = actdict["cross" + idcross];
		//Draw lane cross
		var canvas2 = document.getElementById('canvascrossline');
		var ctx2 = canvas2.getContext('2d');
		var img2 = document.getElementById("crosslineimg");
		var tmpImg2 = new Image();
		tmpImg2.src = $('#crosslineimg').attr('src');
		tmpImg2.onload = function()
		{
			ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx2.beginPath();
			ctx2.stroke();
			ctx2.drawImage(img2, 0, 0);
			var ppcX = parseFloat(cross.lineX0);
			var ppcX2 = parseFloat(cross.lineX1);
			var ppcY = parseFloat(cross.lineY0);
			var ppcY2 = parseFloat(cross.lineY1);
			ctx2.moveTo(ppcX * 800, ppcY * 600);
			ctx2.lineTo(ppcX2 * 800, ppcY2 * 600);
			ctx2.strokeStyle = 'red';
			ctx2.lineWidth = 5;
			ctx2.stroke();
		};
		var canvas = document.getElementById('canvascrossarea');
		var ctx = canvas.getContext('2d');
		var imgrect = document.getElementById("crossareaimg");
		var tmpImgrect = new Image();
		tmpImgrect.src = $('#crossareaimg').attr('src');
		tmpImgrect.onload = function()
		{
			ctx.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx.beginPath();
			ctx.stroke();
			ctx.drawImage(imgrect, 0, 0);
			var ppcX = parseFloat(cross.roi1);
			var ppcY = parseFloat(cross.roi2);
			var ppcwidth = parseFloat(cross.roi3);
			var ppcheight = parseFloat(cross.roi4);
			ctx.rect(ppcX * 800, ppcY * 600, ppcwidth * 800, ppcheight * 600);
			ctx.strokeStyle = 'red';
			ctx.lineWidth = 5;
			ctx.stroke();
		};
	}

	function resetLaneCross()
	{
		if(DEFINE_INTERFACE == "HANWHA"){
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			var canvas2 = document.getElementById('canvascrossline');
			var ctx2 = canvas2.getContext('2d');
			ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx2.beginPath();
			ctx2.stroke();
			var img2 = document.getElementById("crosslineimg");
			ctx2.drawImage(img2, 0, 0);
			ctx2.stroke();

			var msg = "";
			msg += "<GetSDK_APP_DATA>";
			msg += "<AppName>NeuralEdge</AppName>";
			msg += "<Data>computerid=" + computerid + "|oper=update|table=nlcrossline|camp0=id|value0=" + crosslineediting + "|camp1=lineY0|value1=0|camp2=computerid|value2=1|camp3=cameraid|value3=1|camp4=lineX0|value4=0|camp5=lineY1|value5=0|camp6=lineX1|value6=0</Data>";	
			msg += "</GetSDK_APP_DATA>";
			addToQueue(msg, function(response) {
				var data = response;
				if(data!=undefined && data!=""){
					DevExpress.ui.notify("Data saved", "success", 600);
				}else{
					DevExpress.ui.notify("Data saving error", "error", 600);
				}
			});

			actdict["cross" + crosslineediting].lineY = 0;
			actdict["cross" + crosslineediting].lineXleft = 0;
			actdict["cross" + crosslineediting].lineXright = 0;
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		}else{
			var canvas2 = document.getElementById('canvascrossline');
			var ctx2 = canvas2.getContext('2d');
			ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx2.beginPath();
			ctx2.stroke();
			var img2 = document.getElementById("crosslineimg");
			ctx2.drawImage(img2, 0, 0);
			ctx2.stroke();
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + crosslineediting + "&camp1=lineY0&value1=0&camp2=computerid&value2=1&camp3=cameraid&value3=1&camp4=lineX0&value4=0&camp5=lineY1&value5=0&camp6=lineX1&value6=0&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
				.done(function()
				{
					DevExpress.ui.notify("Data saved", "success", 600);
				})
				.fail(function()
				{
					DevExpress.ui.notify("Data saving error", "error", 600);
				});
			actdict["cross" + crosslineediting].lineY = 0;
			actdict["cross" + crosslineediting].lineXleft = 0;
			actdict["cross" + crosslineediting].lineXright = 0;
		}
	}

	function resetLaneArea()
	{
		if(DEFINE_INTERFACE == "HANWHA"){
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			var canvas2 = document.getElementById('canvascrossarea');
			var ctx2 = canvas2.getContext('2d');
			ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx2.beginPath();
			ctx2.stroke();
			var img2 = document.getElementById("crossareaimg");
			ctx2.drawImage(img2, 0, 0);
			ctx2.stroke();

			var msg = "";
			msg += "<GetSDK_APP_DATA>";
			msg += "<AppName>NeuralEdge</AppName>";
			msg += "<Data>computerid=" + computerid + "|oper=update|table=nlcrossline|camp0=id|value0=" + crosslineediting + "|camp1=roi1|value1=0|camp2=computerid|value2=1|camp3=cameraid|value3=1|camp4=roi2|value4=0|camp5=roi3|value5=0|camp6=roi4|value6=0</Data>";	
			msg += "</GetSDK_APP_DATA>";
			addToQueue(msg, function(response) {
				var data = response;

				if(data!=undefined && data!=""){
					DevExpress.ui.notify("Data saved", "success", 600);
				}else{
					DevExpress.ui.notify("Data saving error", "error", 600);
				}
			});
			actdict["cross" + crosslineediting].roi1 = 0;
			actdict["cross" + crosslineediting].roi2 = 0;
			actdict["cross" + crosslineediting].roi3 = 0;
			actdict["cross" + crosslineediting].roi4 = 0;
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		}else{
			var canvas2 = document.getElementById('canvascrossarea');
			var ctx2 = canvas2.getContext('2d');
			ctx2.clearRect(0, 0, canvas2.width, canvas2.height); //clear canvas
			ctx2.beginPath();
			ctx2.stroke();
			var img2 = document.getElementById("crossareaimg");
			ctx2.drawImage(img2, 0, 0);
			ctx2.stroke();
			var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + crosslineediting + "&camp1=roi1&value1=0&camp2=computerid&value2=1&camp3=cameraid&value3=1&camp4=roi2&value4=0&camp5=roi3&value5=0&camp6=roi4&value6=0&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
				.done(function()
				{
					DevExpress.ui.notify("Data saved", "success", 600);
				})
				.fail(function()
				{
					DevExpress.ui.notify("Data saving error", "error", 600);
				});
			actdict["cross" + crosslineediting].roi1 = 0;
			actdict["cross" + crosslineediting].roi2 = 0;
			actdict["cross" + crosslineediting].roi3 = 0;
			actdict["cross" + crosslineediting].roi4 = 0;
		}
	}

function fillHanwhaFieldLanes(){
			console.log("TEST ENTRO canvascrossline");
			var serverName	= window.location.hostname;
	    	var serverType = "http://";
	    	var extention = "/livemjpeg";
	        var liveStreamURI = serverType + serverName + ":1234" + extention;
			$("#fiedlLANES").after(" <div class='dx-fieldset-header cerrado' id='CrossLine' style= 'padding: 10px 40px; cursor: pointer;' >" + DevExpress.localization.formatMessage("Cross Line") + "</div> " +
			" <div class='dx-fieldset' id= 'fiedlCrossLine' > " +
			" 		<div id='crossdatagriddiv'></div>" +
			" <div id='crossdetaildiv' > " +
			" 	<div class='dx-fieldset-header abierto' id='crossdet' style='padding: 10px 40px; cursor: pointer;'>" + DevExpress.localization.formatMessage("Details") + "</div>" +
			" 	<div class='dx-fieldset' id='fiedlcrossdetails'> " +
			" <div class='dx-field' id ='CROSSLINE'  > " +
			"<div class='dx-field-label' style='width: auto;'>" + DevExpress.localization.formatMessage("Cross line:") +
			"<br> <br><br><br><div id='ressetcrossline'></div> " +
			"</div>" +
			"<div class='dx-field-value' style= ' width:auto' >" +
			"<canvas id='canvascrossline' width='800' height='600' '></canvas><img id = 'crosslineimg' src='"+liveStreamURI+"' width='800' height='600' style= 'visibility:hidden;display:none'>" +
			"</div> " +
			"<br><br><br><div class='dx-field-label' >" + DevExpress.localization.formatMessage("Cross area:") +
			"<br> <br><br><br><div id='ressetcrossarea'></div> " +
			"</div>" +
			"<div class='dx-field-value' style='width:auto;margin-top: -125px;' >" +
			"<canvas id='canvascrossarea' width='800' height='600' '></canvas><img id = 'crossareaimg' src='"+liveStreamURI+"' width='800' height='600' style= 'visibility:hidden;display:none'>" +
			"</div> " +
			"</div>" +
			"</div>" +
			"</div>" +
			" </div> ");
			createFieldLanes();
			loadHanwhaCross();
}
	function createFieldLanes(){
		$("#fiedlCrossLine").hide();
		$("#crossdetaildiv").hide();
		$("#CrossLine").click(function()
		{
			if ($("#CrossLine").hasClass("abierto"))
			{
				$(this).removeClass('abierto');
				$(this).addClass('cerrado');
				$("#fiedlCrossLine").hide();
			}
			else
			{
				$(this).addClass('abierto');
				$(this).removeClass('cerrado');
				$("#fiedlCrossLine").show();
			}
		});
		$("#crossdet").click(function()
		{
			if ($("#crossdet").hasClass("abierto"))
			{
				$(this).removeClass('abierto');
				$(this).addClass('cerrado');
				$("#fiedlcrossdetails").hide();
			}
			else
			{
				$(this).addClass('abierto');
				$(this).removeClass('cerrado');
				$("#fiedlcrossdetails").show();
			}
		});
		crossdatagrid = $("#crossdatagriddiv").dxDataGrid(
		{
			dataSource: cross_lista,
			showBorders: true,
			showRowLines: true,
			keyExpr: "id",
			hoverStateEnabled: true,
			paging:
			{
				pageSize: 10
			},
			searchPanel:
			{
				visible: true,
				width: 240,
			},
			columns: [
				{
					dataField: "id",
					caption: DevExpress.localization.formatMessage("ID"),
					width: 50,
					allowEditing: false
				},
				{
					width: "30%",
					dataField: "name",
					caption: DevExpress.localization.formatMessage("Name"),
					validationRules: [
					{
						type: "required"
					}]
				},
				{
					width: "15%",
					dataField: "triggermode",
					caption: DevExpress.localization.formatMessage("Mode"),
					validationRules: [
					{
						type: "required"
					}],
					lookup:
					{
						dataSource: [
							DevExpress.localization.formatMessage("Entering"),
							DevExpress.localization.formatMessage("Leaving"),
							DevExpress.localization.formatMessage("Both")
						]
						/*dataSource: modearray,
						displayExpr: "description",
						valueExpr: "id"*/
					}
				},
				/*{
	                    dataField: "lineheight",
	                    caption: DevExpress.localization.formatMessage("lineheight"),
					    dataType: "number",
	                    width: "10%",
	                    format: {
	                        type: "decimal",
	                        precision: 0
	                    },
	                    validationRules: [{
	                        type: "required"
	                    }]
	                },*/
				{
					dataField: "pixelchange",
					caption: DevExpress.localization.formatMessage("Pixel Change"),
					dataType: "number",
					width: "10%",
					format:
					{
						type: "decimal",
						precision: 0
					},
					validationRules: [
					{
						type: "required"
					}]
				},
				{
					dataField: "minchangepc",
					caption: DevExpress.localization.formatMessage("Min. change pc"),
					dataType: "number",
					width: "10%",
					format:
					{
						type: "decimal",
						precision: 0
					},
					validationRules: [
					{
						type: "required"
					}]
				}
			],
			editing:
			{
				mode: "row",
				allowUpdating: true,
				allowDeleting: true,
				texts:
				{
					confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the cross line?")
				},
				allowAdding: true
			},
			selection:
			{
				mode: "single"
			},
			onSelectionChanged: function(selectedItems)
			{
				var data = selectedItems.selectedRowsData[0];
				if (data)
				{
					$("#crossdetaildiv").show();
					crosslineediting = data.id;
					loadcrosslinedetails(data.id);
				}
			},
			onRowUpdating: function(e)
			{
				var description;
				if (typeof e.newData.name !== 'undefined')
				{
					description = e.newData.name.replaceAll('"', '').replaceAll('\'', '');
				}
				else
				{
					description = e.oldData.name.replaceAll('"', '').replaceAll('\'', '');
				}
				var pixelchange;
				if (typeof e.newData.pixelchange !== 'undefined')
				{
					pixelchange = e.newData.pixelchange;
				}
				else
				{
					pixelchange = e.oldData.pixelchange;
				}
				/*var lineheight;
	                if (typeof e.newData.lineheight !== 'undefined') {
	                    lineheight = e.newData.lineheight;
	                } else {
	                    lineheight = e.oldData.lineheight;
					}*/
				var triggermode;
				if (typeof e.newData.triggermode !== 'undefined')
				{
					triggermode = convertTriggermodeToInt(e.newData.triggermode);
				}
				else
				{
					triggermode = convertTriggermodeToInt(e.oldData.triggermode);
				}
				var minchangepc;
				if (typeof e.newData.minchangepc !== 'undefined')
				{
					minchangepc = e.newData.minchangepc;
				}
				else
				{
					minchangepc = e.oldData.minchangepc;
				}

				if(DEFINE_INTERFACE == "HANWHA"){
					/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
					var msg = "";
					msg += "<GetSDK_APP_DATA>";
					msg += "<AppName>NeuralEdge</AppName>";
					msg += "<Data>computerid=" + computerid + "|oper=update|table=nlcrossline|camp0=id|value0=" + e.key +
						"|camp1=name|value1=" + description +
						"|camp2=computerid|value2=1" +
						"|camp3=cameraid|value3=1" +
						"|camp4=pixelchange|value4=" + pixelchange +
						//"&camp5=lineheight&value5="+lineheight+
						"|camp5=triggermode|value5=" + triggermode +
						"|camp6=minchangepc|value6=" + minchangepc +"</Data>";	
					msg += "</GetSDK_APP_DATA>";

					addToQueue(msg, function(response) {
						var resData = response; 
						console.log("Response in first query response: " + JSON.stringify(resData));
						console.log("Datos consulta: " + msg);
						console.log("Respuesta : " + JSON.stringify(resData));
						console.log("Respuesta status: " + resData);
			        	if(resData!=undefined && resData!=""){
							console.log(resData); 
						}  
			    	}); 
					/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

				}else if(DEFINE_INTERFACE == "VIVOTEK" || DEFINE_INTERFACE == "VIVOTEK_CV25"){
					var urlUpdate = "computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + e.key +
						"&camp1=name&value1=" + description +
						"&camp2=computerid&value2=1" +
						"&camp3=cameraid&value3=1" +
						"&camp4=pixelchange&value4=" + pixelchange +
						//"&camp5=lineheight&value5="+lineheight+
						"&camp5=triggermode&value5=" + triggermode +
						"&camp6=minchangepc&value6=" + minchangepc +
						"&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN")
					console.log("urlUpdate "+urlUpdate);
					var jqxhr = $.ajax({
					    type: "POST",
					    url: pathcgi + "cgi-bin/vparcgi.cgi", 
					    data: urlUpdate, 
						async: false,
					    success:function(datos){ 
					    	console.log(datos);
					     },
					    dataType: "text"
					})
				}else{
					var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlcrossline&camp0=id&value0=" + e.key +
						"&camp1=name&value1=" + description +
						"&camp2=computerid&value2=1" +
						"&camp3=cameraid&value3=1" +
						"&camp4=pixelchange&value4=" + pixelchange +
						//"&camp5=lineheight&value5="+lineheight+
						"&camp5=triggermode&value5=" + triggermode +
						"&camp6=minchangepc&value6=" + minchangepc +
						"&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"))
				}
			},
			onRowInserting: function(e)
			{
				if(DEFINE_INTERFACE == "HANWHA"){
					/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
					var msg = "";
					msg += "<GetSDK_APP_DATA>";
					msg += "<AppName>NeuralEdge</AppName>";
					msg += "<Data>computerid=" + computerid + "|oper=insertcross|name=" + e.data.name.replaceAll('"', '').replaceAll('\'', '') + "|triggermode=" + triggermode + "|pixelchange=" + e.data.pixelchange + "|minchangepc=" + e.data.minchangepc + "</Data>";	
					msg += "</GetSDK_APP_DATA>";

					addToQueue(msg, function(response) {
						var resData = response; 
						resData = resData.replaceAll('\r', '').replaceAll('\n', '');
						console.log("Response in first query response: " + JSON.stringify(resData));
						console.log("Datos consulta: " + msg);
						console.log("Respuesta : " + JSON.stringify(resData));
						console.log("Respuesta status: " + resData);
			        	if(resData!=undefined && resData!=""){
							DevExpress.ui.notify("Data saved", "success", 600);
							loadHanwhaCross();
						} 
			    	}); 
					/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
				}else{
					var triggermode = convertTriggermodeToInt(e.data.triggermode);
					var jqxhr = $.ajax(
					{
						url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insertcross&name=" + e.data.name.replaceAll('"', '').replaceAll('\'', '') + "&triggermode=" + triggermode + "&pixelchange=" + e.data.pixelchange + "&minchangepc=" + e.data.minchangepc + /*"&lineheight=" + e.data.lineheight+*/ "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
						success: function(data)
						{
							data = data.replaceAll('\r', '').replaceAll('\n', '');
							DevExpress.ui.notify("Data saved", "success", 600);
							loadcrossline();
						}
					});
				}

			},
			onRowRemoving: function(e)
			{
				if(DEFINE_INTERFACE == "HANWHA"){

				}else{
					var jqxhr2 = $.ajax(
					{
						url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlcrossline&camp0=id&comp0=equal&value0=" + e.key + localStorage.getItem("TOKEN"),
						async: false
					});
					loadcrossline();
					$("#crossdetaildiv").hide();
				}
			}
		}).dxDataGrid("instance");

		console.log("Test crossdatagrid: " + crossdatagrid);
	}
});
