var vivotekrestart = false;
var liveVelocidad = false;
var lp;
var showHamwhaRes = true;
var cgiReturnValue;
var liveDateFormat ="HH:mm:ss.SSS dd/MM/yyyy"; 
var callstack = [];
var executing = false;
var async_response = "";
var tries = 0;
var currentLoadPanel;
var CHECKSTATUS_TIMEOUT = 5000;
var LOAD_PANEL_TIMEOUT;

if (DEFINE_INTERFACE === "HANWHA" || DEFINE_INTERFACE == "VIVOTEK_CV25")
{
	LOAD_PANEL_TIMEOUT = 120000;
}
else
{
	LOAD_PANEL_TIMEOUT = 60000;
}

if (CHECK_USER)
{
	var result = null,
		tmp = [];
	location.search
		.substr(1)
		.split("&")
		.forEach(function(item)
		{
			tmp = item.split("=");
			if (tmp[0] === "token") result = decodeURIComponent(tmp[1]);
		});
	if (result != null)
	{
		localStorage.setItem("TOKEN", "&token=" + result);
	}
}
else
{
	localStorage.setItem("TOKEN", "");
}

if (!String.prototype.startsWith)
{
	String.prototype.startsWith = function(searchString, position)
	{
		position = position || 0;
		return this.substr(position, searchString.length) === searchString;
	};
}

// Convert text to XML DOM
function text2xml(str) {
	// NOTE: I'd like to use jQuery for this, but jQuery makes all tags uppercase
	//return $(xml)[0];
	var xmlDocument;
	var xmlParser;
	try {
		if(window.ActiveXObject){	 //IE
			xmlDocument = new ActiveXObject('Microsoft.XMLDOM');
			xmlDocument.async = false;
		} else if (window.DOMParser) {   //Firefox, Netscape, Firefox
			xmlParser = new DOMParser();
		}
	} catch (e) {
		throw new Error("XML Parser could not be instantiated")
	};
	try {
		if(window.ActiveXObject){	 //IE
			xmlDocument.loadXML(str);
		} else if (window.DOMParser) {   //Firefox, Netscape, Firefox
			xmlDocument = xmlParser.parseFromString(str, 'text/xml');
		} else {
			return null;
		}
	} catch (e) {
		throw new Error("Error parsing XML string")
	};
	return xmlDocument;
}

var reqUrl = window.location.protocol+"//" + window.location.host + "/cgi-bin/stw.cgi";

 // converts xml documents and xml text to json object
function  xml2json(xml, extended) {
	if (!xml) return {}; // quick fail

	//### PARSER LIBRARY
	// Core function

	function parseXML(node, simple) {
		if (!node) return null;
		var txt = '',
			obj = null,
			att = null;
		var nt = node.nodeType,
			nn = jsVar(node.localName || node.nodeName);
		var nv = node.text || node.nodeValue || '';
		/*DBG*/ //if(window.console) console.log(['x2j',nn,nt,nv.length+' bytes']);
		if (node.childNodes) {
			if (node.childNodes.length > 0) {
				/*DBG*/ //if(window.console) console.log(['x2j',nn,'CHILDREN',node.childNodes]);
				$.each(node.childNodes, function (n, cn) {
					var cnt = cn.nodeType,
						cnn = jsVar(cn.localName || cn.nodeName);
					var cnv = cn.text || cn.nodeValue || '';
					/*DBG*/ //if(window.console) console.log(['x2j',nn,'node>a',cnn,cnt,cnv]);
					if (cnt == 8) {
						/*DBG*/ //if(window.console) console.log(['x2j',nn,'node>b',cnn,'COMMENT (ignore)']);
						return; // ignore comment node
					} else if (cnt == 3 || cnt == 4 || !cnn) {
						// ignore white-space in between tags
						if (cnv.match(/^\s+$/)) {
							/*DBG*/ //if(window.console) console.log(['x2j',nn,'node>c',cnn,'WHITE-SPACE (ignore)']);
							return;
						};
						/*DBG*/ //if(window.console) console.log(['x2j',nn,'node>d',cnn,'TEXT']);
						txt += cnv.replace(/^\s+/, '').replace(/\s+$/, '');
						// make sure we ditch trailing spaces from markup
					} else {
						/*DBG*/ //if(window.console) console.log(['x2j',nn,'node>e',cnn,'OBJECT']);
						obj = obj || {};
						if (obj[cnn]) {
							/*DBG*/ //if(window.console) console.log(['x2j',nn,'node>f',cnn,'ARRAY']);

							// http://forum.jquery.com/topic/jquery-jquery-xml2json-problems-when-siblings-of-the-same-tagname-only-have-a-textnode-as-a-child
							if (!obj[cnn].length) obj[cnn] = myArr(obj[cnn]);
							obj[cnn] = myArr(obj[cnn]);

							obj[cnn][obj[cnn].length] = parseXML(cn, true /* simple */ );
							obj[cnn].length = obj[cnn].length;
						} else {
							/*DBG*/ //if(window.console) console.log(['x2j',nn,'node>g',cnn,'dig deeper...']);
							obj[cnn] = parseXML(cn);
						};
					};
				});
			}; //node.childNodes.length>0
		}; //node.childNodes
		if (node.attributes) {
			if (node.attributes.length > 0) {
				/*DBG*/ //if(window.console) console.log(['x2j',nn,'ATTRIBUTES',node.attributes])
				att = {};
				obj = obj || {};
				$.each(node.attributes, function (a, at) {
					var atn = jsVar(at.name),
						atv = at.value;
					att[atn] = atv;
					if (obj[atn]) {
						/*DBG*/ //if(window.console) console.log(['x2j',nn,'attr>',atn,'ARRAY']);

						// http://forum.jquery.com/topic/jquery-jquery-xml2json-problems-when-siblings-of-the-same-tagname-only-have-a-textnode-as-a-child
						//if(!obj[atn].length) obj[atn] = myArr(obj[atn]);//[ obj[ atn ] ];
						obj[cnn] = myArr(obj[cnn]);

						obj[atn][obj[atn].length] = atv;
						obj[atn].length = obj[atn].length;
					} else {
						/*DBG*/ //if(window.console) console.log(['x2j',nn,'attr>',atn,'TEXT']);
						obj[atn] = atv;
					};
				});
				//obj['attributes'] = att;
			}; //node.attributes.length>0
		}; //node.attributes
		if (obj) {
			obj = $.extend((txt != '' ? new String(txt) : {}), /* {text:txt},*/ obj || {} /*, att || {}*/ );
			txt = (obj.text) ? (typeof (obj.text) == 'object' ? obj.text : [obj.text || '']).concat([txt]) : txt;
			if (txt) obj.text = txt;
			txt = '';
		};
		var out = obj || txt;
		//console.log([extended, simple, out]);
		if (extended) {
			if (txt) out = {}; //new String(out);
			txt = out.text || txt || '';
			if (txt) out.text = txt;
			if (!simple) out = myArr(out);
		};
		return out;
	}; // parseXML
	// Core Function End
	// Utility functions
	var jsVar = function (s) {
		return String(s || '').replace(/-/g, "_");
	};

	// NEW isNum function: 01/09/2010
	// Thanks to Emile Grau, GigaTecnologies S.L., www.gigatransfer.com, www.mygigamail.com

	function isNum(s) {
		// based on utility function isNum from xml2json plugin (http://www.fyneworks.com/ - diego@fyneworks.com)
		// few bugs corrected from original function :
		// - syntax error : regexp.test(string) instead of string.test(reg)
		// - regexp modified to accept  comma as decimal mark (latin syntax : 25,24 )
		// - regexp modified to reject if no number before decimal mark  : ".7" is not accepted
		// - string is "trimmed", allowing to accept space at the beginning and end of string
		var regexp = /^((-)?([0-9]+)(([\.\,]{0,1})([0-9]+))?$)/
		return (typeof s == "number") || regexp.test(String((s && typeof s == "string") ? jQuery.trim(s) : ''));
	};
	// OLD isNum function: (for reference only)
	//var isNum = function(s){ return (typeof s == "number") || String((s && typeof s == "string") ? s : '').test(/^((-)?([0-9]*)((\.{0,1})([0-9]+))?$)/); };

	var myArr = function (o) {

		// http://forum.jquery.com/topic/jquery-jquery-xml2json-problems-when-siblings-of-the-same-tagname-only-have-a-textnode-as-a-child
		//if(!o.length) o = [ o ]; o.length=o.length;
		if (!$.isArray(o)) o = [o];
		o.length = o.length;

		// here is where you can attach additional functionality, such as searching and sorting...
		return o;
	};
	// Utility functions End
	//### PARSER LIBRARY END

	// Convert plain text to xml
	if (typeof xml == 'string') xml = $.text2xml(xml);

	// Quick fail if not xml (or if this is a node)
	if (!xml.nodeType) return;
	if (xml.nodeType == 3 || xml.nodeType == 4) return xml.nodeValue;

	// Find xml root node
	var root = (xml.nodeType == 9) ? xml.documentElement : xml;

	// Convert xml to json
	var out = parseXML(root, true /* simple */ );

	// Clean-up memory
	xml = null;
	root = null;

	// Send output
	return out;
}

$.fn.sendCommandToServerSync = function (params) {
	var defaults = {
		requestMessage: null,
		datatype: "json"
	};
	params = $.extend(defaults, params);
	var requestMessage = params.requestMessage;
	if(requestMessage){
		$.ajax({
			type: "POST",
			cache: false,
			url: reqUrl,
			dataType: "text",
			async: false,
			data: encodeURI(requestMessage),
			success: function (response) {
				var jsonResponse = xml2json(response);
				//console.log(jsonResponse);
				if (params.success && typeof params.success == 'function') {
					if(params.datatype == 'json') {
						params.success(jsonResponse);
					} else {
						params.success(response);
					}
				}
			},
			error: function( jqXHR, textStatus, errorThrow){
				if (params.error && typeof params.error == 'function') {
					params.error(jqXHR, textStatus, errorThrow);						
				}
			}
		});
	}
	
};

function executeCGI_old(computerid, operation, date, token, is_json) {

	var data_type = "text";
	var dataReceived;
	if(is_json == true)
	{
		data_type = "json";
	}

	operation = operation.replace(/\|/g, "&");

    if (DEFINE_INTERFACE === "HANWHA") {
         $.ajax({
             url: pathcgi + "stw-cgi/openapp.cgi?AppID=NeuralEdge&command=computerid=" + computerid + "&oper=" + operation + "&dd" + date + token,
             async: false,
			dataType: data_type,
             success: function(response) {
				var data = response.Response;
				CheckTokenValidity(data);

				if(is_json == true)
				{
				try {  
					data = JSON.parse(data); 
				  } catch (e) {  
					console.log('invalid json'); 
					dataReceived = "error";
					return; 
				  }
				}

				 dataReceived = data;
             },
             error: function(error) {
				 dataReceived = "error";
                 return(error);
             }
         });     
     } else {
         $.ajax({
             url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=" + operation + "&dd" + date + token,
             async: false,
			dataType: data_type,
             success: function(data) {
				CheckTokenValidity(data);
				dataReceived = data;
             },
             error: function(error) {
				 dataReceived = "error";
                 return(error);
             }
         });
     }

	return dataReceived;
}
function updateTableValue(table, id, column, newValue)
{
	var response = executeCGI(computerid, "update|table=" + table + "|camp0=id|value0=" + id + "|camp1=" + column + "|value1=" + newValue, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
								
	if(response != "error")
	{
		DevExpress.ui.notify("Data saved", "success", 600);
	}
	else
	{
		DevExpress.ui.notify("Data saving error", "error", 600);
	}
}

function executeCGI(computerid, operation, date, token, is_json) {

	var data_type = "text";
	var dataReceived;
	if(is_json == true)
	{
		data_type = "json";
	}

    if (DEFINE_INTERFACE === "HANWHA") {
         var msg = "<GetSDK_APP_DATA>";
         msg += "<AppName>NeuralEdge</AppName>";
         msg += "<Data>computerid=" + computerid + "|oper=" + operation;
         msg += "|adinfo=notvalue</Data>";
         msg += "</GetSDK_APP_DATA>";

         $(this).sendCommandToServerSync({
             appname: appName,
             requestMessage: msg,
             success: function(response) {
                 var data = response.Data;
                 if (data != undefined && data != "") {
                     CheckTokenValidity(data);

					if(is_json == true)
					{
					try {  
						data = JSON.parse(data); 
					  } catch (e) {  
						console.log('invalid json'); 
						dataReceived = "error";
						return; 
					  }
					}

                     dataReceived = data;
                 } else {
					 dataReceived = "error";
                     return("No data received");
                 }
             },
             error: function(error) {
				dataReceived = "error";
                 return(error);
             }
         });
     } else {
		
		operation = operation.replace(/\|/g, "&");

         $.ajax({
			url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=" + operation + "&dd=" + date + token,
			async: false,
			dataType: data_type,
			success: function(data) 
			{
				CheckTokenValidity(data);
				dataReceived = data;
			},
			error: function(error) 
			{
				if (error.responseText.includes("Error"))
				{
					dataReceived = "error";
                	return(error);
				}
				else
				{
					if (typeof(error) == "object")
					{
						dataReceived = error.responseText;
					}
					else
					{
						dataReceived = "OK";
					}					
				}
				 
			}
         });
     }

	return dataReceived;
}

function getAsyncResponse()
 {
	return async_response;
 }

function executeCGIAsync(computerid, operation, date, token, is_json, ptr_function) {
	async_response = "";
	var data_type = "text";
	if(is_json == true)
	{
		data_type = "json";
	}

    if (DEFINE_INTERFACE === "HANWHA") {
         var msg = "<GetSDK_APP_DATA>";
         msg += "<AppName>NeuralEdge</AppName>";
         msg += "<Data>computerid=" + computerid + "|oper=" + operation;
         msg += "|adinfo=notvalue</Data>";
         msg += "</GetSDK_APP_DATA>";

         $(this).sendCommandToServer({
             appname: appName,
             requestMessage: msg,
             success: function(response) {
                 var data = response.Data;
                 if (data != undefined && data != "") {
                     CheckTokenValidity(data);

					if(is_json == true)
					{
					try {  
						data = JSON.parse(data); 
					  } catch (e) {  
						console.log('invalid json'); 
						async_response = "error";
						return; 
					  }
					}

					async_response = data;
					ptr_function();
                 } else {
					async_response = "error";
                     return("No data received");
                 }
             },
             error: function(error) {
				async_response = "error";
                 return(error);
             }
         });
     } else {
		
		operation = operation.replace(/\|/g, "&");

         $.ajax({
             url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=" + operation + "&dd" + date + token,
			dataType: data_type,
             success: function(data) {
                 CheckTokenValidity(data);
				 async_response = data;
				 ptr_function();
             },
             error: function(error) {
				async_response = "error";
                 return(error);
             }
         });
     }
}

function manageStatusError()
{
	if(tries < 6){
		setTimeout(checkStatus, CHECKSTATUS_TIMEOUT);
		tries++;
	}else{
		tries = 0;
	}
}
function checkStatus()
{
	var status = executeCGI(computerid, "status", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
	if(status == "error")
	{
		manageStatusError();
	}
	else
	{
		for(var i = 0; i < status.length; i++){
			if(status[i].ident == "service"){
				if(status[i].value < 4 && status[i].value >= 0){
					currentLoadPanel.hide();
					tries = 0;
				}else{
					manageStatusError();
				}

				return;
			}
		}
	}
}

function getLoadingPanel(loadingMessage)
{
	var loadPanel = $(".loadpanel").dxLoadPanel(
	{
		shadingColor: "rgba(0,0,0,0.4)",
		visible: false,
		showIndicator: true,
		showPane: true,
		shading: true,
		width: 300,        
		onShown: function() {
			
			setTimeout(checkStatus, CHECKSTATUS_TIMEOUT);

			setTimeout(function() {
				currentLoadPanel.hide();
				}, LOAD_PANEL_TIMEOUT);
		},
		message: loadingMessage,
		closeOnOutsideClick: false
	}).dxLoadPanel("instance");

	currentLoadPanel = loadPanel;

	return loadPanel;
}

function getUrlCgi()
{
	var urlCgi;

	if(DEFINE_INTERFACE == "HANWHA")
	{
		urlCgi = pathcgi + "stw-cgi/openapp.cgi?AppID=NeuralEdge&command=";
	}else
	{
		urlCgi = pathcgi + "cgi-bin/vparcgi.cgi?";
	}

	return urlCgi;
}

function getSnapshot()
{
	//TEMPORAL hasta que se puedan responder más de 1KB
	if(DEFINE_INTERFACE == "HANWHA")
	{
		return pathcgi + "stw-cgi/video.cgi?msubmenu=snapshot&action=view";
	}
	else
	{
		return getUrlCgi() + "computerid=" + computerid + "&oper=snapshot&resolution=800x600" + localStorage.getItem("TOKEN");
	}
 }

function getRestartingMessage()
{
	var restartingMessage;

	if(DEFINE_INTERFACE == "VIVOTEK_CV25")
	{
		restartingMessage = DevExpress.localization.formatMessage("Service restarting CV25...");
	}
	else
	{
		restartingMessage = DevExpress.localization.formatMessage("Service restarting...");
	}

	return restartingMessage;
}

function getSnapshotFromCamera(pathcgi, pathlive)
{
	var urlCameraSnapshot;

	if(DEFINE_INTERFACE == "HANWHA")
	{
		var serverName	= window.location.host;
		var serverType = "http://";
		urlCameraSnapshot = serverType + serverName + pathlive;
	}else
	{
		urlCameraSnapshot = pathcgi + pathlive + "&i=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
	}

	return urlCameraSnapshot;
}

function getImageFromCamera(pathcgi, computerid, pathImage)
{
	var urlCameraImage;

	if(DEFINE_INTERFACE == "HANWHA")
	{
		var serverName	= window.location.host;
		var serverType = "http://";
		var imgPath = pathImage.replace("/mnt/mmcblk0p1/opensdk/NeuralEdge/images/","/home/setup/opensdk/html/NeuralEdge/imagesres/")
		urlCameraImage = serverType + serverName + imgPath;
	}else
	{
		urlCameraImage = pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getimage&path=" + pathImage + localStorage.getItem("TOKEN");
	}

	return urlCameraImage;
}

function getimeCamera() 
{
    var dataCamara;

    dataCamara = executeCGI(computerid, "gettime", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
    dataCamara = new Date(dataCamara);

    return dataCamara;
}

function configureWebIcon()
{
	var link = document.querySelector("link[rel*='icon']") || document.createElement('link');
	link.type = 'image/png';
	link.rel = 'icon';
	link.href = '';

	if (DEFINE_INTERFACE == "VIVOTEK" || DEFINE_INTERFACE == "VIVOTEK_CV25")
	{
		aplication = getApplication();
		if (aplication != "eVivotek")
		{
			link.href = 'images/neural_icon.png';
		}
		else
		{
			link.href = 'images/favicon_vivotek_platform.png';
		}
	}
	else if(DEFINE_INTERFACE == "VICON")
	{
		link.href = 'images/vicon_icon.png';
	}
	else if(DEFINE_INTERFACE == "AXIS")
	{
		link.href = 'images/neural_icon.png';
	}
	else if(DEFINE_INTERFACE == "HANWHA")
	{
		link.href = 'images/icon.png';
	}
	
	document.getElementsByTagName('head')[0].appendChild(link);
}

function CheckTokenValidity (data)
{
	if (CHECK_USER)
	{
		if ((typeof data === 'string') && data.toLowerCase().startsWith("token"))
		{
			var urlCam = window.location.href;
			console.log(urlCam);
			urlCam = urlCam.split(":8090")[0] + "/#settings/apps/vpard";
			if (confirm(data))
			{
				window.location.href = urlCam;
			}
			else
			{
				window.location.href = urlCam;
			}
		}
	}
}

function sendHanwhaQuery(msg)
{
	$(this).sendCommandToServerSync({
		appname : appName,       
		requestMessage:msg,
		success : function(response) {
			var data = response.Data; 
	    	if(data!=undefined && data != ""){
				  return data;
			}else{
				return "error";
			}  
		}
	});	
}

function sendHanwhaQueryQueue(msg, cb)
{
	
	$(this).sendCommandToServer({
		appname : appName,       
		requestMessage:msg,
		success : function(response) {
			var data = response.Data; 
        	if(data!=undefined && data != ""){
				  cb(data);
				  callstack.shift();
				  if(callstack.length>0){
				  	setTimeout(sendHanwhaQueryQueue, 100, callstack[0].msg, callstack[0].cb);
				  }else{
				  	executing = false;
				  }
			}else{
				executing = false;
				return "error";
			} 
		}
	});	
}

function addToQueue(msg, cb)
{
	callstack.push({msg: msg, cb: cb});
	if(!executing){
		executing = true;
		setTimeout(sendHanwhaQueryQueue, 100, callstack[0].msg, callstack[0].cb);
	}
}

function existFile(filePath)
{
	var existFile = false;

	var dataReceived = executeCGI(computerid, "getfile|path=" + filePath, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

	if(dataReceived.indexOf("File not found") == -1)
	{
		existFile = true;
	}

	return existFile;
}
function getApplication()
{
	var application = "";

	application = executeCGI(computerid, "select|table=nlconfgeneral|camp0=name|comp0=equal|value0=aplication|maxvalues=1", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

	return application[0]["value"];
}

function buildPageQueryByOffset(table, fdata1, fdata2, page_actual, num_regs, moreparams, sortby_data)
{
	var pageQuery;
	var cgiCommand;
	if(sortby_data.includes("=id") == true)
	{
		cgiCommand = "selectid";
	}
	else
	{
		cgiCommand = "select";
	}
	
	pageQuery = cgiCommand + "|table=" + table;
	
	{
		pageQuery += "|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(fdata1.option('value')) + ";" + getStringNormalDate2(fdata2.option('value')) 
		+ moreparams 
		+ "|offset=" + ((page_actual - 1) * num_regs);
	}
	
	pageQuery += "|maxvalues=" + num_regs + "|date=" + getStringNormalDate(new Date()) + "|" + sortby_data;
					
	return pageQuery;
}

function getClassColorIcon(id, ClassVisible, ColorVisible){

	var fileName;
	if (id == "_"){
		fileName = "empty";
	}
	else if (id == "unknown_" && ClassVisible == true && ColorVisible == false){
		fileName = "empty";
	}
	else {
		var className = id.split("_")[0];
		var colorName = id.split("_")[1];

		if(ClassVisible == true && ColorVisible == true)
		{
			if(className.length == 0){
				fileName = "unknown" + id;
			}
			else if(colorName.length == 0){
				fileName = id + "white";
			}
			else
			{
				fileName = id;
			}
		}
		else
		{
			if(ClassVisible == true && ColorVisible == false)
			{
				if(className.length == 0)
				{
					fileName = "empty";
				}
				else
				{				
					fileName = className + "_white";
				}
			}
			else
			{
				if(colorName.length == 0)
				{
					fileName = "empty";
				}
				else
				{
					fileName = "unknown_" + colorName;
				}
			}
		}
	}
	
	return "images/" + fileName + ".png";
}

function getClassColorColumnName(ClassVisible, ColorVisible)
{
	var columnName = "";

	if(ClassVisible == true)
	{
		if(ColorVisible == true)
		{
			columnName = DevExpress.localization.formatMessage("Class") + "/" + DevExpress.localization.formatMessage("Color");
		}
		else
		{
			columnName = DevExpress.localization.formatMessage("Class");
		}
	}
	else
	{
		columnName = DevExpress.localization.formatMessage("Color");
	}

	return columnName;
}

function getIdent()
{
	var ident = executeCGI(computerid, "getident", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

	return ident;
}

function make_header(section)
{
	var hasEvidences = true;
	var data;
	data = executeCGI(computerid, "checkmodule|module1=evidence|module2=view|module3=logo|module4=dateformat|module5=timeformat", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

	if(data.includes("error"))
	{
		setTimeout(reloadpage, CHECKSTATUS_TIMEOUT);
		return;
	}

	if (data[0].evidence == "FAIL")
	{
		hasEvidences = false;
	}
	if (data[0].view == "LIST")
	{
		liveVelocidad = true;
	}

	if(data[0].dateformat != undefined && data[0].dateformat != "" && data[0].timeformat != undefined && data[0].timeformat != ""){
		if(data[0].timeformat == "24h")
			liveDateFormat= "HH:mm:ss.SSS " + data[0].dateformat.replace("mm", "MM");
		else if(data[0].timeformat == "12h")
			liveDateFormat= "hh:mm:ss.SSS " + data[0].dateformat.replace("mm", "MM");

		console.log("Date format: " + liveDateFormat);
	}

	if(DEFINE_INTERFACE == "HANWHA")
	{
		var serverName	= window.location.host;
						var serverType = "http://";
						var hanwhaurl = serverType + serverName;
						$(".sitetitle").attr('href', hanwhaurl);
	}

	if (DEFINE_INTERFACE == "AXIS")
	{
		$(".sitetitle").css("background", "url(images/tooplate_logo_axis.png) no-repeat top center");
		var urlCam = window.location.href;
		//console.log(urlCam);
		urlCam = urlCam.split(":8090")[0] + ":80";
		$(".sitetitle").attr('href', urlCam);
	}
	else
		$(".sitetitle").css("background", "url(images/" + data[0].logo + ") no-repeat top center");

	if (DEFINE_INTERFACE == "ZKTECO")
	{
		if (window.location !== window.parent.location)
		{
			// The page is in an iFrames 
		}
		else
		{
			// The page is not in an iFrame 
			window.location.href = window.location.origin;
		}
		$("#tooplate_header").hide();
		//TODO: Pendiente idiomas evExpress.localization.formatMessage("<TAG>")
		var header = "<div class='top_01'>" +
			"<div class='top_mt1'><img src='images/tooplate_logo_zkteco.png'></div>" +
			"<div class='top_mt2 bold f14'><label></label>&nbsp;&nbsp;<label style='display: none;''></label></div>" +
			"</div> " +
			"<div class='top_02'><div class='nav'>" +
			"<div class='nav_1' ><a>" + DevExpress.localization.formatMessage("Live") + "</a></div>" +
			"<div class='nav_1' ><a>" + DevExpress.localization.formatMessage("Playback") + "</a></div>" +
			"<div class='nav_1' ><a>" + DevExpress.localization.formatMessage("File") + "</a></div>" +
			"<div class='nav_1' ><a>" + DevExpress.localization.formatMessage("Setup") + "</a></div>" +
			"<div class='nav_1' ><a>" + DevExpress.localization.formatMessage("Log") + "</a></div>" +
			"<div class='nav_1' ><a>" + DevExpress.localization.formatMessage("Alarm") + "</a><div style='height: 100%; vertical-align: middle; display: inline-block;'><img src='images/32a.gif'></div></div>" +
			"<div class='nav_1' ><a>" + DevExpress.localization.formatMessage("Face") + "Face</a></div>" +
			"<div class='nav_2' id='liindex'><a id='aindex'  href='index.html'>" + DevExpress.localization.formatMessage("LPR") + "</a></div>" +
			"</div></div>";
		//"<br style='clear: left' />";
		var sideMenu = "<div class='main_right2 fl' style='height: 100%; '><div class='main_right_mid2 r_bg'>" +
			"<div id='side_menu_index' class='main_right_1'><a id='aindex' href='index.html' style='cursor: pointer;'>" + DevExpress.localization.formatMessage("Main") + "</a></div>" +
			//"<div id='side_menu_review' class='main_right_1'><a d='areview' href='review.html' style='cursor: pointer;'>Review</a></div>"+
			"<div id='side_menu_list' class='main_right_1'><a id='alist' href='lists.html' style='cursor: pointer;'>" + DevExpress.localization.formatMessage("Lists") + "</a></div>" +
			"<div id='side_menu_camconfiguration' class='main_right_1'><a id='acamconfiguration' href='camconfiguration.html' style='cursor: pointer;'>" + DevExpress.localization.formatMessage("Setup") + "</a></div>" +
			(hasEvidences ? ("<div id='side_menu_evidence' class='main_right_1'><a id='aevidence' href='evidence.html' style='cursor: pointer;'>" + DevExpress.localization.formatMessage("Evidence") + "</a></div>") : "") +
			"<div id='side_menu_configuration' class='main_right_1'><a id='aconfiguration' href='configuration.html' style='cursor: pointer;'>" + DevExpress.localization.formatMessage("Advanced Setup") + "</a></div>" +
			"<div id='side_menu_historic' class='main_right_1'><a id='ahistoric' href='historic.html' style='cursor: pointer;'>" + DevExpress.localization.formatMessage("Audit") + "</a></div>" +
			"<div id='side_menu_logs' class='main_right_1'><a id='alogs' href='logs.html' style='cursor: pointer;'>Debug</a></div>" +
			"</div></div>";
			
		//Elimianr header 
		//$( "#tooplate_header" ).empty();
		$("#tooplate_header").remove("#title");
		$("#tooplate_header").remove("#tooplate_menu");
		//Añadimos nuevo mení incluido imagen
		$("#tooplate_header").prepend(header);
		//Añadimos menú lateral
		$("#tooplate_container").prepend(sideMenu);
		//Seleccion de item
		$("#side_menu_" + section).addClass("main_right_1_current");
	}
	else if (DEFINE_INTERFACE == "VIVOTEK" ||DEFINE_INTERFACE == "VIVOTEK_CV25" || DEFINE_INTERFACE == "VICON" || DEFINE_INTERFACE == "HANWHA")
	{
		var header = "<ul>" +
			"<li id='liindex' ><a id='aindex'  href='index.html'  >" + DevExpress.localization.formatMessage("Live") + "</a></li>" +
			"<li id='lireview' ><a id='areview' href='review.html' >" + DevExpress.localization.formatMessage("Review") + "</a></li>" +
			"<li id='lilist' ><a id='alist' href='lists.html'  >" + DevExpress.localization.formatMessage("Lists") + "</a></li>" +
			"<li id='licamconfiguration'  ><a id='acamconfiguration' href='camconfiguration.html' >" + DevExpress.localization.formatMessage("LPR configuration") + "</a></li>" +
			(hasEvidences ? ("<li id='lievidence'  ><a id='aevidence' href='evidence.html' >" + DevExpress.localization.formatMessage("Evidence") + "</a></li>") : "") +
			"<li id='liconfiguration' ><a id='aconfiguration' href='configuration.html' >" + DevExpress.localization.formatMessage("General configuration") + "</a></li>" +
			"<li id='lihistoric'><a id='ahistoric' href='historic.html'>" + DevExpress.localization.formatMessage("Audit") + "</a></li>" +
			"<li id='lilogs'><a id='alogs' href='logs.html' >" + DevExpress.localization.formatMessage("Logs") + "</a></li>" +
			"</ul>" +
			"<br style='clear: left' />";
		$("#tooplate_menu").append(header);
		$("#li" + section).addClass("last");
		$("#a" + section).addClass("selected");
	}
	else if (DEFINE_INTERFACE == "AXIS")
	{
		var header = "<ul style='background:white'>" +
			"<li id='liindex' ><a id='aindex'  href='index.html' >" + DevExpress.localization.formatMessage("Live") + "</a></li>" +
			"<li id='lireview' ><a id='areview' href='review.html' >" + DevExpress.localization.formatMessage("Review") + "</a></li>" +
			"<li id='lilist' ><a id='alist' href='lists.html'  >" + DevExpress.localization.formatMessage("Lists") + "</a></li>" +
			"<li id='licamconfiguration'  ><a id='acamconfiguration' href='camconfiguration.html'>" + DevExpress.localization.formatMessage("LPR configuration") + "</a></li>" +
			(hasEvidences ? ("<li id='lievidence'  ><a id='aevidence' href='evidence.html' >" + DevExpress.localization.formatMessage("Evidence") + "</a></li>") : "") +
			"<li id='liconfiguration' ><a id='aconfiguration' href='configuration.html' >" + DevExpress.localization.formatMessage("General configuration") + "</a></li>" +
			"<li id='lihistoric'><a id='ahistoric' href='historic.html' >" + DevExpress.localization.formatMessage("Audit") + "</a></li>" +
			"<li id='lilogs'><a id='alogs' href='logs.html' >" + DevExpress.localization.formatMessage("Logs") + "</a></li>" +
			"</ul>" +
			"<br style='clear: left' />";
		$("#tooplate_menu").append(header);
		$("#li" + section).addClass("last");
		$("#a" + section).addClass("selected");
	}
}

function getStringNormalDate(date_input)
{
	var day = date_input.getDate();
	var days = day;
	if (day < 10)
	{
		days = "0" + day;
	}
	var month = date_input.getMonth() + 1;
	var months = month;
	if (month < 10)
	{
		months = "0" + month;
	}
	var year = date_input.getFullYear();
	var hour = date_input.getHours();
	var hours = hour;
	if (hour < 10)
	{
		hours = "0" + hour;
	}
	var minute = date_input.getMinutes();
	var minutes = minute;
	if (minute < 10)
	{
		minutes = "0" + minute;
	}
	var second = date_input.getSeconds();
	var seconds = second;
	if (second < 10)
	{
		seconds = "0" + second;
	}
	var miliseconds = date_input.getMilliseconds();
	if (miliseconds < 10)
	{
		miliseconds = "00" + miliseconds;
	}
	else if (miliseconds < 100)
	{
		miliseconds = "0" + miliseconds;
	}
	return year + "-" + months + "-" + days + "T" + hours + ":" + minutes + ":" + seconds + "." + miliseconds;
}

function getStringNormalDate2(date_input)
{
	var day = date_input.getDate();
	var days = day;
	if (day < 10)
	{
		days = "0" + day;
	}
	var month = date_input.getMonth() + 1;
	var months = month;
	if (month < 10)
	{
		months = "0" + month;
	}
	var year = date_input.getFullYear();
	var hour = date_input.getHours();
	var hours = hour;
	if (hour < 10)
	{
		hours = "0" + hour;
	}
	var minute = date_input.getMinutes();
	var minutes = minute;
	if (minute < 10)
	{
		minutes = "0" + minute;
	}
	var second = date_input.getSeconds();
	var seconds = second;
	if (second < 10)
	{
		seconds = "0" + second;
	}
	return year + "-" + months + "-" + days + "T" + hours + ":" + minutes + ":" + seconds + ".999";
}

function getStringNormalDateLive(date_input)
{
	var day = date_input.getDate();
	var days = day;
	if (day < 10)
	{
		days = "0" + day;
	}
	var month = date_input.getMonth() + 1;
	var months = month;
	if (month < 10)
	{
		months = "0" + month;
	}
	var year = date_input.getFullYear();
	var hour = date_input.getHours();
	var hours = hour;
	if (hour < 10)
	{
		hours = "0" + hour;
	}
	var minute = date_input.getMinutes();
	var minutes = minute;
	if (minute < 10)
	{
		minutes = "0" + minute;
	}
	var second = date_input.getSeconds();
	var seconds = second;
	if (second < 10)
	{
		seconds = "0" + second;
	}
	return year + "-" + months + "-" + days + " " + hours + ":" + minutes + ":" + seconds;
}

function checkstatus()
{
	$.ajax(
	{
		dataType: "json",
		url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getident&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
		async: false,
		success: function(data)
		{
			CheckTokenValidity(data);
			ident = data;
			$.ajax(
			{
				url: pathcgi + "/cgi-bin/vparcgi.cgi?computerid=1&oper=status&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				async: false,
				success: function(data)
				{
					CheckTokenValidity(data);
					if (data[11].value == -1)
					{
						$.ajax(
						{
							url: pathcgi + "/cgi-bin/vparcgi.cgi?computerid=1&oper=checkservice&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
							async: false
						});
					}
				},
				error: function()
				{
					$.ajax(
					{
						url: pathcgi + "/cgi-bin/vparcgi.cgi?computerid=1&oper=checkservice&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
						async: false,
						success: function(data)
						{
							CheckTokenValidity(data);
						}
					});
				}
			});
		}
	});
}

function stopapp()
{
		var msg = "";
		msg = "<StopSDK>";
		msg += "<AppName>NeuralEdge</AppName>";
		msg += "</StopSDK>";
		sendHanwhaQuery(msg);
}
function startapp()
{
	if(DEFINE_INTERFACE=="HANWHA"){
		var msg = "";
		msg = "<StartSDK>";
		msg += "<AppName>NeuralEdge</AppName>";
		msg += "</StartSDK>";
		sendHanwhaQuery(msg);
	}else{
		$.ajax(
		{
			url: pathcgi + "../cgi-bin/admin/vadpctrl.cgi?cmd=start&idx=" + ident + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
			success: function()
			{
				if (lp === undefined)
				{
					// se ejecutan estas instrucciones
				}
				else
				{
					lp.hide();
					DevExpress.ui.notify("Application restarted", "success", 2000);
				}
			}
		});
	}

}

function createRestartButton(name, loadPanel)
{
	$(name).dxButton(
	{
		type: "success",
		text: DevExpress.localization.formatMessage("Restart service"),
		onClick: function()
		{
			loadPanel.show();
			
			restartapp();
		}
	});
}

function restartapp()
{
	if (vivotekrestart)
	{
		$.ajax(
		{
			url: pathcgi + "../cgi-bin/admin/vadpctrl.cgi?cmd=stop&idx=" + ident + "&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
			success: function(data)
			{
				CheckTokenValidity(data);
			}
		});
		setTimeout(startapp, 2000);
	}
	else
	{
		if(DEFINE_INTERFACE == "HANWHA"){
			console.log("Restart with HANWHA");
			stopapp();
			startapp();
		}else{
			$.ajax(
			{
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=1&oper=restartservice&d=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				success: function(data)
				{
					CheckTokenValidity(data);
				}
			});
			if (lp === undefined)
			{
				// se ejecutan estas instrucciones
			}
			else
			{
				lp.hide();
			}
		}
	}
	DevExpress.ui.notify("Application restarted", "success", 600);
}

function CreateToolTip(id, evidences, imagepath, resultleft, resulttop, resultright, resultbottom, width, height)
{
	$("#tooltip" + id).dxTooltip(
	{
		target: "#icimg" + id,
		showEvent: "mouseenter",
		hideEvent: "mouseleave",
		position: "left",
		contentTemplate: function(data)
		{
			var widthdraw = 700;
			var heightdraw = 394;
			var hdr = 0;
			var wdr = 700;
			if (evidences == 0)
			{
				hdr = 395;
				wdr = 700;
			}
			if (evidences == 1)
			{
				hdr = (heightdraw * 0.75) * 2;
				wdr = wdr * 0.75;
				widthdraw = widthdraw * 0.75;
				heightdraw = heightdraw * 0.75;
			}
			if (evidences == 2)
			{
				hdr = (heightdraw * 0.6) * 3;
				wdr = wdr * 0.6;
				widthdraw = widthdraw * 0.60;
				heightdraw = heightdraw * 0.60;
			}
			data.html("<canvas id='cvas" + id + "' width='" + wdr + "' height='" + hdr + "' ></canvas>");
			var canvas = document.getElementById('cvas' + id);
			var ctx = canvas.getContext('2d');
			var tmpImg = new Image();
			tmpImg.src = getImageFromCamera(pathcgi, computerid, imagepath);
			
			tmpImg.onload = function()
			{
				ctx.beginPath();
				ctx.drawImage(tmpImg, 0, 0, widthdraw, heightdraw);
				ctx.rect(resultleft * (widthdraw / tmpImg.width), resulttop * (heightdraw / tmpImg.height), (resultright - resultleft) * (widthdraw / tmpImg.width), (resultbottom - resulttop) * (heightdraw / tmpImg.height));
				ctx.strokeStyle = 'green';
				ctx.lineWidth = 3;
				ctx.stroke();
			}
			if (evidences > 0)
			{
				var tmpImg2 = new Image();
				
				var pathImage = imagepath.substring(0, imagepath.length - 4) + "_ev1.jpg";
				
				if((evidences == 1) && (existFile(pathImage) == false))
				{
					pathImage = imagepath.substring(0, imagepath.length - 4) + "_ev2.jpg"
				}
				
				tmpImg2.src = getImageFromCamera(pathcgi, computerid, pathImage);
				tmpImg2.onload = function()
				{
					ctx.drawImage(tmpImg2, 0, heightdraw + 3, widthdraw, heightdraw);
					ctx.stroke();
				}
			}
			if (evidences > 1)
			{
				var tmpImg3 = new Image();
				tmpImg3.src = getImageFromCamera(pathcgi, computerid, imagepath.substring(0, imagepath.length - 4) + "_ev2.jpg");
				tmpImg3.onload = function()
				{
					ctx.drawImage(tmpImg3, 0, (heightdraw * 2) + 6, widthdraw, heightdraw);
					ctx.stroke();
				}
			}
		}
	});
}

function CreateToolTipTop(id, evidences, imagepath, resultleft, resulttop, resultright, resultbottom, width, height, jj)
{
	setTimeout(function(){
		$("#tooltipt" + id).dxTooltip(
			{
				target: "#icimgt" + id,
				showEvent: "mouseenter",
				hideEvent: "mouseleave",
				position: "top",
				contentTemplate: function(data)
				{
					var widthdraw = 700;
					var heightdraw = 394;
					var hdr = 395;
					var wdr = 700;
					if (evidences == 0)
					{
						hdr = 395;
						wdr = 700;
					}
					if (evidences == 1)
					{
						hdr = heightdraw * 0.75;
						wdr = (wdr * 0.75) * 2;
						widthdraw = widthdraw * 0.75;
						heightdraw = heightdraw * 0.75;
					}
					if (evidences == 2)
					{
						hdr = heightdraw * 0.6;
						wdr = (wdr * 0.6) * 3;
						widthdraw = widthdraw * 0.60;
						heightdraw = heightdraw * 0.60;
					}
					data.html("<canvas id='cvas" + id + "' width='" + wdr + "' height='" + hdr + "' ></canvas>");
					var canvas = document.getElementById('cvas' + id);
					var ctx = canvas.getContext('2d');
					var tmpImg = new Image();
					tmpImg.src = getImageFromCamera(pathcgi, computerid, imagepath);
					
					tmpImg.onload = function()
					{
						ctx.drawImage(tmpImg, 0, 0, widthdraw, heightdraw);
						ctx.rect(resultleft * (widthdraw / width), resulttop * (heightdraw / height), (resultright - resultleft) * (widthdraw / width), (resultbottom - resulttop) * (heightdraw / height));
						ctx.strokeStyle = 'green';
						ctx.lineWidth = 3;
						ctx.stroke();
					}
					if (evidences > 0)
					{
						var tmpImg2 = new Image();
				
						var pathImage = imagepath.substring(0, imagepath.length - 4) + "_ev1.jpg";
						
						if((evidences == 1) && (existFile(pathImage) == false))
						{
							pathImage = imagepath.substring(0, imagepath.length - 4) + "_ev2.jpg"
						}
						
						tmpImg2.src = getImageFromCamera(pathcgi, computerid, pathImage);
						tmpImg2.onload = function()
						{
							ctx.drawImage(tmpImg2, widthdraw + 3, 0, widthdraw, heightdraw);
							ctx.stroke();
						}
					}
					if (evidences > 1)
					{
						var tmpImg3 = new Image();
						tmpImg3.src = getImageFromCamera(pathcgi, computerid, imagepath.substring(0, imagepath.length - 4) + "_ev2.jpg");
						tmpImg3.onload = function()
						{
							ctx.drawImage(tmpImg3, (widthdraw * 2) + 6, 0, widthdraw, heightdraw);
							ctx.stroke();
						}
					}
				}
			});
	}, jj*75);
	
}


var appName = "NeuralEdge";

function get_response(response){
	if (!response["ErrorString"]) {
		var resData = JSON.parse(JSON.stringify(response)); 
		console.log(JSON.stringify(resData.appConfigData));        
		return resData.appConfigData;        
	}
}

function SDK_APPGetSettingsAjaxMsg(msg)
{
	$(this).sendCommandToServer({
		appname : appName,       
		requestMessage:msg,
		success : function(response) {
        if (response) {
			console.log(get_response(response));	
        }else{
			
		}
      }
      });  
}










