$(function()
{

	function getNumberOfEvidences()
	{
		var numberOfEvidenceCameras;
		$.ajax(
			{
				dataType: "json",
				url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=select&table=nlcamera&camp0=id&comp0=notequal&value0=1&maxvalues=10&dd=" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
				async: false,
				success: function(data)
				{
					CheckTokenValidity(data);
					evcameras = data;
					numberOfEvidenceCameras = evcameras.length;
				}
			});
		
			return numberOfEvidenceCameras;
	}

	function setPropertiesTexts()
	{
		$("#evcameras").text(DevExpress.localization.formatMessage("Evidence cameras"));
		$("#camdet").text(DevExpress.localization.formatMessage("Details"));
	}

	function createFields()
	{
		$("#evcameras").click(function()
		{
			if (listypesabierto)
			{
				$(this).removeClass('abierto');
				$(this).addClass('cerrado');
				$("#gridContainer").hide();
				listypesabierto = false;
			}
			else
			{
				$(this).addClass('abierto');
				$(this).removeClass('cerrado');
				$("#gridContainer").show();
				listypesabierto = true;
			}
		});
		$("#camdet").click(function()
		{
			if (detailsabierto)
			{
				$(this).removeClass('abierto');
				$(this).addClass('cerrado');
				$("#fiedl1").hide();
				detailsabierto = false;
			}
			else
			{
				$(this).addClass('abierto');
				$(this).removeClass('cerrado');
				$("#fiedl1").show();
				detailsabierto = true;
			}
		});

	}

	function createGridContainer()
	{
		var grid = $("#gridContainer").dxDataGrid(
		{
			dataSource: evcameras,
			showBorders: true,
			showRowLines: true,
			keyExpr: "id",
			hoverStateEnabled: true,
			paging:
			{
				pageSize: 10
			},
			searchPanel:
			{
				visible: true,
				width: 240,
				placeholder: DevExpress.localization.formatMessage("Search...")
			},
			columns: [
			{
				dataField: "id",
				caption: DevExpress.localization.formatMessage("ID"),
				width: 50,
				allowEditing: false
			},
			{
				dataField: "description",
				caption: DevExpress.localization.formatMessage("Name"),
				validationRules: [
				{
					type: "required"
				}]
			}],
			editing:
			{
				mode: "row",
				allowUpdating: true,
				allowDeleting: true,
				texts:
				{
					confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the camera?")
				},
				allowAdding: true
			},
			selection:
			{
				mode: "single"
			},
			onToolbarPreparing: function(e)
			{
				let toolbarItems = e.toolbarOptions.items;
				toolbarItems.forEach(function(item)
				{
					if (item.name === "addRowButton")
					{
						item.visible = showaddrow
					}
				});
			},
			onSelectionChanged: function(selectedItems)
			{
				var data = selectedItems.selectedRowsData[0];
				if(selectedItems != undefined)
				{
					evSelected = selectedItems.selectedRowsData[0].description;
				}
				if (data)
				{
					$("#plateslistdiv").show();
					loaddetailsEVCam(data.id)
				}
			},
			onRowUpdating: function(e)
			{
				var descritpion;
				if (typeof e.newData.description !== 'undefined')
				{
					description = e.newData.description.replaceAll('"', '').replaceAll('\'', '');
				}
				else
				{
					description = e.oldData.description.replaceAll('"', '').replaceAll('\'', '');
				}
				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=update&table=nlcamera&camp0=id&value0=" + e.oldData.id + "&camp1=description&value1=" + description + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"));
			},
			onRowInserting: function(e)
			{
				var jqxhr = $.ajax(
				{
					url: pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=insertevidence&name=" + e.data.description.replaceAll('"', '').replaceAll('\'', '') + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"),
					success: function(data)
					{
						CheckTokenValidity(data);
						if(data.indexOf("Maximum evidence cameras") == -1)
						{
							DevExpress.ui.notify("Evidence camera added succesfully", "success", 1000);
						}
						else
						{
							DevExpress.ui.notify(data, "error", 1000);
						}
	
						loadevcam();
					}
				});
			},
			onRowRemoving: function(e)
			{
				if(evSelected == e.data.description)
				{
					$("#plateslistdiv").hide();
				}
				currentNumberOfEvidences--;
				var jqxhr = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlconfcamera&camp0=cameraid&comp0=equal&value0=" + e.key + localStorage.getItem("TOKEN"));
				var jqxhr2 = $.ajax(pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=delete&table=nlcamera&camp0=id&comp0=equal&value0=" + e.key + localStorage.getItem("TOKEN"));
				//$("#plateslistdiv").hide();
				DevExpress.ui.notify("Evidence camera removed succesfully", "success", 1000);
				e.element.find(".dx-datagrid-addrow-button").show();
				showaddrow = true;
				var repaint = $("#gridContainer").dxDataGrid("repaint");
			},
			onRowInserted: function(e)
			{
				currentNumberOfEvidences++;
				var currentNumberOfEvidencesInBBDD = getNumberOfEvidences();
				
				if (currentNumberOfEvidencesInBBDD != currentNumberOfEvidences)
				{
					//IN CV25 is required to check because the bbdd update is slower
					currentNumberOfEvidencesInBBDD = getNumberOfEvidences();
				}
	
				if(currentNumberOfEvidencesInBBDD == max_num_evidence_cameras)
				{
					e.element.find(".dx-datagrid-addrow-button").hide();
				}
			}
		}).dxDataGrid("instance");

		return grid;
	}
	

	function loadevcam()
	{
		var data = executeCGI(computerid, "select|table=nlcamera|camp0=id|comp0=notequal|value0=1|maxvalues=10|dd=", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
		vlists.option("dataSource", data);
	}

	function loaddetailsEVCam(idcam)
	{
		$("#fiedl1").empty();
		var data = executeCGI(computerid, "select|table=nlconfcamera|camp0=cameraid|comp0=equal|value0=" + idcam + "|maxvalues=250|dd=", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
		
		$.each(data, function(i, item)
			{
				if (item.visible == 1)
				{
					if (item.typepar == "int")
					{
						$("#fiedl1").append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;' ></div></div></div>");
						var valopt = (item.options).split(";");
						$("#elem" + i).dxNumberBox(
						{
							value: item.value,
							min: valopt[0],
							max: valopt[1],
							showSpinButtons: true,
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								// Event handling commands go here
								
								updateTableValue("nlconfcamera", item.id, "value", newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid + "|dd=");
								
							}
						});
					}
					if (item.typepar == "option")
					{
						var valopt = (item.options).split(";");
						var indicef = 0;
						
						$("#fiedl1").append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none;display: inline-block;'></div> </div></div>");
						var isTrueSet = (item.value == 'true');
						$("#elem" + i).dxRadioGroup(
						{
							items: valopt,
							value: item.value,
							layout: "horizontal",
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								// Event handling commands go here
								updateTableValue("nlconfcamera", item.id, "value", newValue + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid + "|dd=");
								
							}
						});
					}
					if (item.typepar == "string")
					{
						$("#fiedl1").append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(item.text) + "</div><div class='dx-field-value'><div id='elem" + i + "' style='float:none'></div></div></div>");
						var passmode = "Text";
						if (item.name == "password") passmode = "password";
						$("#elem" + i).dxTextBox(
						{
							value: item.value,
							mode: passmode,
							onValueChanged: function(e)
							{
								var previousValue = e.previousValue;
								var newValue = e.value;
								newValue = newValue.replace(/\\/g, '/');
								// Event handling commands go here
								updateTableValue("nlconfcamera", item.id, "value", encodeURIComponent(newValue) + "|camp2=computerid|value2=" + item.computerid + "|camp3=cameraid|value3=" + item.cameraid + "|dd=");
							}
						});
					}
				}
			});
		
		$("#detailinfo").empty();
		$("#detailinfo").append(" <div class='dx-field'><div class='dx-field-label'></div><div class='dx-field-value'><div id='evcammess' style='float:none;display: inline-block;' >" + evcammaxresinfo + "</div></div></div>");
	}

	var dicttraducciones = {};
	var d2;
	var evcameras;
	var vlists;
	var loadPanel;
	var listypesabierto = true;
	var detailsabierto = true;
	var showaddrow = true;
	var max_num_evidence_cameras;
	var currentNumberOfEvidences = 0;
	var application = getApplication();
	var evSelected = "";

	Init_translate();
	make_header("evidence");
	
	setPropertiesTexts();
	var evcammaxresinfo = DevExpress.localization.formatMessage("The maximum resolution for the provided JPEG stream must be between 1 and 2 megapixels");
	set_rcpopup();
	

	String.prototype.replaceAll = function(search, replacement)
	{
		var target = this;
		return target.replace(new RegExp(search, 'g'), replacement);
	};
	configureWebIcon();
				
	if ((DEFINE_INTERFACE == "VIVOTEK"  || DEFINE_INTERFACE == "VIVOTEK_CV25" || DEFINE_INTERFACE == "ZKTECO" || DEFINE_INTERFACE == "AXIS") && (application != "eVivotek"))
	{
		max_num_evidence_cameras = 2;
	}
	else
	{
		max_num_evidence_cameras = 1;
	}

	loadPanel = getLoadingPanel(getRestartingMessage());

	createRestartButton("#icon-done_info", loadPanel);

	d2 = getimeCamera();

	currentNumberOfEvidences = getNumberOfEvidences();
	if (currentNumberOfEvidences == max_num_evidence_cameras)
	{
		showaddrow = false
	}
		
	createFields();

	vlists = createGridContainer();

});