/////////////////
// REVIEW PAGE //
/////////////////



$(function()
{
	function getOrder()
	{
		sortby_data = "sortasc=id";
		var isListMode;
		var data_url = "select|table=nlconfgeneral|camp0=name|comp0=equal|value0=view|maxvalues=" + num_regs;
		var data = executeCGI(computerid, data_url, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
		if(DEFINE_INTERFACE == "ZKTECO")
		{
			$.each(data, function(i, item)
			{
				isListMode = item.value;
			});
		}
		
		if((isListMode == "LIST") && (DEFINE_INTERFACE == "ZKTECO"))
		{
			if($(gridName + ' #dx-col-11').attr('aria-sort') == "descending")sortby_data = "sortdesc=id";
			if($(gridName + ' #dx-col-11').attr('aria-sort') == "ascending")sortby_data = "sortasc=id";
			
			if($(gridName + '#dx-col-12').attr('aria-sort') == "descending")sortby_data = "sortdesc=timestamp";
			if($(gridName + '#dx-col-12').attr('aria-sort') == "ascending")sortby_data = "sortasc=timestamp";
	
			if($(gridName+' #dx-col-13').attr('aria-sort') == "descending")sortby_data = "sortdesc=numberplate";
			if($(gridName+' #dx-col-13').attr('aria-sort') == "ascending")sortby_data = "sortasc=numberplate";
	
			if($(gridName+' #dx-col-14').attr('aria-sort') == "descending")sortby_data = "sortdesc=laneid";
			if($(gridName+' #dx-col-14').attr('aria-sort') == "ascending")sortby_data = "sortasc=laneid";
	
			if($(gridName+' #dx-col-15').attr('aria-sort') == "descending")sortby_data = "sortdesc=direction";
			if($(gridName+' #dx-col-15').attr('aria-sort') == "ascending")sortby_data = "sortasc=direction";
	
			if($(gridName+' #dx-col-16').attr('aria-sort') == "descending")sortby_data = "sortdesc=speed";
			if($(gridName+' #dx-col-16').attr('aria-sort') == "ascending")sortby_data = "sortasc=speed";
	
			if($(gridName+' #dx-col-17').attr('aria-sort') == "descending")sortby_data = "sortdesc=globalconfidence";
			if($(gridName+' #dx-col-17').attr('aria-sort') == "ascending")sortby_data = "sortasc=globalconfidence";
	
			if($(gridName+' #dx-col-18').attr('aria-sort') == "descending")sortby_data = "sortdesc=averagecharheight";
			if($(gridName+' #dx-col-18').attr('aria-sort') == "ascending")sortby_data = "sortasc=averagecharheight";
	
			if($(gridName+' #dx-col-19').attr('aria-sort') == "descending")sortby_data = "sortdesc=country";
			if($(gridName+' #dx-col-19').attr('aria-sort') == "ascending")sortby_data = "sortasc=country";
	
			if($(gridName+' #dx-col-20').attr('aria-sort') == "descending")sortby_data = "sortdesc=namelistid";
			if($(gridName+' #dx-col-20').attr('aria-sort') == "ascending")sortby_data = "sortasc=namelistid";
	
			if($(gridName+' #dx-col-21').attr('aria-sort') == "descending")sortby_data = "sortdesc=veclass";
			if($(gridName+' #dx-col-21').attr('aria-sort') == "ascending")sortby_data = "sortasc=veclass";
	
			if($(gridName+' #dx-col-22').attr('aria-sort') == "descending")sortby_data = "sortdesc=make";
			if($(gridName+' #dx-col-22').attr('aria-sort') == "ascending")sortby_data = "sortasc=make";
	
			if($(gridName+' #dx-col-23').attr('aria-sort') == "descending")sortby_data = "sortdesc=imageretailpath";
			if($(gridName+' #dx-col-23').attr('aria-sort') == "ascending")sortby_data = "sortasc=imageretailpath";
	
			if($(gridName+' #dx-col-24').attr('aria-sort') == "descending")sortby_data = "sortdesc=imagepath";
			if($(gridName+' #dx-col-24').attr('aria-sort') == "ascending")sortby_data = "sortasc=imagepath";
		}
		else
		{
			if($(gridName + ' #dx-col-1').attr('aria-sort') == "descending")sortby_data = "sortdesc=id";
			if($(gridName + ' #dx-col-1').attr('aria-sort') == "ascending")sortby_data = "sortasc=id";
			
			if($(gridName + '#dx-col-2').attr('aria-sort') == "descending")sortby_data = "sortdesc=timestamp";
			if($(gridName + '#dx-col-2').attr('aria-sort') == "ascending")sortby_data = "sortasc=timestamp";
	
			if($(gridName+' #dx-col-3').attr('aria-sort') == "descending")sortby_data = "sortdesc=numberplate";
			if($(gridName+' #dx-col-3').attr('aria-sort') == "ascending")sortby_data = "sortasc=numberplate";
	
			if($(gridName+' #dx-col-4').attr('aria-sort') == "descending")sortby_data = "sortdesc=laneid";
			if($(gridName+' #dx-col-4').attr('aria-sort') == "ascending")sortby_data = "sortasc=laneid";
	
			if($(gridName+' #dx-col-5').attr('aria-sort') == "descending")sortby_data = "sortdesc=direction";
			if($(gridName+' #dx-col-5').attr('aria-sort') == "ascending")sortby_data = "sortasc=direction";
	
			if($(gridName+' #dx-col-6').attr('aria-sort') == "descending")sortby_data = "sortdesc=speed";
			if($(gridName+' #dx-col-6').attr('aria-sort') == "ascending")sortby_data = "sortasc=speed";
	
			if($(gridName+' #dx-col-7').attr('aria-sort') == "descending")sortby_data = "sortdesc=globalconfidence";
			if($(gridName+' #dx-col-7').attr('aria-sort') == "ascending")sortby_data = "sortasc=globalconfidence";
	
			if($(gridName+' #dx-col-8').attr('aria-sort') == "descending")sortby_data = "sortdesc=averagecharheight";
			if($(gridName+' #dx-col-8').attr('aria-sort') == "ascending")sortby_data = "sortasc=averagecharheight";
	
			if($(gridName+' #dx-col-9').attr('aria-sort') == "descending")sortby_data = "sortdesc=country";
			if($(gridName+' #dx-col-9').attr('aria-sort') == "ascending")sortby_data = "sortasc=country";
	
			if($(gridName+' #dx-col-10').attr('aria-sort') == "descending")sortby_data = "sortdesc=namelistid";
			if($(gridName+' #dx-col-10').attr('aria-sort') == "ascending")sortby_data = "sortasc=namelistid";
	
			if($(gridName+' #dx-col-11').attr('aria-sort') == "descending")sortby_data = "sortdesc=veclass";
			if($(gridName+' #dx-col-11').attr('aria-sort') == "ascending")sortby_data = "sortasc=veclass";
	
			if($(gridName+' #dx-col-12').attr('aria-sort') == "descending")sortby_data = "sortdesc=make";
			if($(gridName+' #dx-col-12').attr('aria-sort') == "ascending")sortby_data = "sortasc=make";
	
			if($(gridName+' #dx-col-13').attr('aria-sort') == "descending")sortby_data = "sortdesc=imageretailpath";
			if($(gridName+' #dx-col-13').attr('aria-sort') == "ascending")sortby_data = "sortasc=imageretailpath";
	
			if($(gridName+' #dx-col-14').attr('aria-sort') == "descending")sortby_data = "sortdesc=imagepath";
			if($(gridName+' #dx-col-14').attr('aria-sort') == "ascending")sortby_data = "sortasc=imagepath";
		}
	}

	function setPropertiesTexts()
	{
		$("#lbfromdate").text(DevExpress.localization.formatMessage("From date"));
		$("#lbtodate").text(DevExpress.localization.formatMessage("To date"));
		$("#lbplate").text(DevExpress.localization.formatMessage("Plate"));
		$("#lblist").text(DevExpress.localization.formatMessage("List"));
		$("#lblane").text(DevExpress.localization.formatMessage("Lane"));
		$("#lbmaker").text(DevExpress.localization.formatMessage("Make"));
		$("#lbcolor").text(DevExpress.localization.formatMessage("Color"));
		$("#lbclass").text(DevExpress.localization.formatMessage("Class"));
		$("#lbspeed1").text(DevExpress.localization.formatMessage("Speed"));
		$("#shnumreg").text(DevExpress.localization.formatMessage("Show num registers:"));
		$("#lbdirection").text(DevExpress.localization.formatMessage("Direction"));
		if(DEFINE_INTERFACE == "HANWHA"){
			$("#shnumreg").hide();
			$("#numreg").hide();
		}
	}

	function isDebugOptionEnable()
	{

		if ($.urlParam('debugoptions') != null && $.urlParam('debugoptions') == 1)
		{
			debugoptions = true;
		}
	}

	function getVehicleClassTable()
	{
		return executeCGI(computerid, "select|table=nlvehicleclass|maxvalues=8", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
	}

	function getVehicleColorTable()
	{
		return executeCGI(computerid, "select|table=nlvehiclecolor|maxvalues=10", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
	}
	
	function getVehicleMakeTable()
	{
		return executeCGI(computerid, "select|table=nlvehiclemake|maxvalues=35", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
	}

	function loadVehicleFilters()
	{
		String.prototype.includes = function(str)
		{
			var returnValue = false;
			if (this.indexOf(str) !== -1)
			{
				returnValue = true;
			}
			return returnValue;
		}
	
		vehiclesclassds = new DevExpress.data.DataSource(
		{
			store: vehiclesclass,
			key: "id",
		});
	
		vehiclescolords = new DevExpress.data.DataSource(
		{
			store: vehiclescolor,
			key: "id",
		});
		
		vehiclesmakeds = new DevExpress.data.DataSource(
		{
			store: vehiclesmakes,
			key: "id",
		});
	}

	function reviewFields()
	{
		var loadData = executeCGI(computerid, "select|table=nlconfgeneral|camp0=name|comp0=equal|value0=reviewfields|maxvalues=1", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
		LaneVisible = loadData[0]["value"].includes("Lane");
		DirectionVisible = loadData[0]["value"].includes("Direction");
		ConfVisible = loadData[0]["value"].includes("Conf");
		SpeedVisible = loadData[0]["value"].includes("Speed");
		HeightVisible = loadData[0]["value"].includes("Height");
		console.log("HeightVisible:" + HeightVisible);
		CountryVisible = loadData[0]["value"].includes("Country");
		ListVisible = loadData[0]["value"].includes("List");
		ClassVisible = loadData[0]["value"].includes("Class");
		ColorVisible = loadData[0]["value"].includes("Color");
		MakeVisible = loadData[0]["value"].includes("Make");
	}

	function createMediumIndicator()
	{
		$("#medium-indicator").dxLoadIndicator(
		{
			height: 40,
			width: 40
		});
		$("#medium-indicator").hide();
	}

	function getApliLaneNames()
	{
		var loadLanes = executeCGI(computerid, "select|table=nlcameralane|maxvalues=10", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
		var name;
		console.log("LANENAMES: " + JSON.stringify(loadLanes));
		lanenames.push({ID: "", Name: ""});
		lanenames.push({ID: "LANE", Name: "No lane"});
		for(var i = 0; i < loadLanes.length; i++){
			if (loadLanes[i].name === "LANE1")
			{
				name = DevExpress.localization.formatMessage("LANE 1");
			}
			else
			{
				name = DevExpress.localization.formatMessage("LANE 2");
			}
			lanenames.push({ID: loadLanes[i].id, Name: name});
		}
		console.log("Lanenames: " + JSON.stringify(lanenames));
	}

	function loadConfigure()
	{
		var loadConfig = executeCGI(computerid, "getconfig", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
		$.each(loadConfig[1], function(i, item)
		{
			dict[item.id] = item.description;
		});
		$.each(loadConfig[0], function(i, item)
		{
			var elem = {};
			elem["ID"] = item.id;
			elem["description"] = item.description;
			listas.push(elem);
			dictlist["[" + item.id + "]"] = item.description;
		});

	}

	function createDateTime(name, dateValue)
	{
		var data = $(name).dxDateBox(
			{
				type: "datetime",
				displayFormat: "dd/MM/yyyy HH:mm:ss",
				value: dateValue
			}).dxDateBox('instance');
		return data;
	}

	function createPaginitas()
	{
		var paginitas = $("#paginitas").dxTextBox(
		{
			readOnly: true,
			width: 120,
			value: ""
		});
	}

	function enableListFilter(isVisible)
	{
		if(isVisible){
			if(listas.length > 0){
				$("#radio-group-simple").dxSelectBox(
				{
					dataSource: new DevExpress.data.ArrayStore(
					{
						data: listas,
						key: "ID"
					}),
					displayExpr: "description",
					valueExpr: "ID",
					value: listas[0].ID,
				});
			}
		}else{
			$("#radio-group-simple").parent().parent().remove();
		}
	}

	function enableVehicleFilters(enableClass, enableColor, enableMake, enableLane, enableSpeed)
	{
		if (!enableClass && !enableMake && !enableColor && !enableLane)
		{
			$("#col1").css({width: 540});
			$("#col2").remove();
			$("#col3").css({width: 550});
		}

		if(enableClass){
			var fClass = $("#class_list").dxSelectBox(
			{
				dataSource: vehiclesclassds,
				valueExpr: "id",
				searchEnabled: true,
				displayExpr: "description"
			});
		}else{
			$("#lbclass").parent().remove();
		}
		
		if(enableMake){
			var fMaker =  $("#maker_list").dxSelectBox(
			{
				dataSource: vehiclesmakeds,
				valueExpr: "id",
				searchEnabled: true,
				displayExpr: "description"
			});
		}else{
			$("#lbmaker").parent().remove();
		}

		if(enableColor){
			var fColor = $("#color_list").dxSelectBox(
			{
				dataSource: vehiclescolords,
				valueExpr: "id",
				searchEnabled: true,
				displayExpr: "description"
			});
		}else{
			$("#lbcolor").parent().remove();
		}

		if(enableLane){
			var dataLanes = [{ID: '',Name: ''}, {ID: 'LANE',Name: 'VACIO'}, {ID: 'LANE1',Name: '1'}, {ID: 'LANE2',Name: '2'}];
			var fLanes = $("#lane_list").dxSelectBox({
				dataSource: lanenames,
				valueExpr: "ID",
				displayExpr: "Name",
				value: lanenames[0].ID
			});
		}else{
			$("#lblane").parent().remove();
		}
		if(enableSpeed){
			var minSpeed = $("#speed1").dxNumberBox();
			var maxSpeed = $("#speed2").dxNumberBox();
		}else{
			$("#lbspeed1").parent().remove();
		}
	
	}

	function createShowNomRegister()
	{
		$("#numreg").dxSelectBox(
		{
			items: itemsNumReg,
			value: itemsNumReg[0]
		});
	}

	function directionFilter()
	{
		var itemsDirList = [DevExpress.localization.formatMessage("(All Directions)"), DevExpress.localization.formatMessage("Coming"), DevExpress.localization.formatMessage("No Direction"), DevExpress.localization.formatMessage("Going")];
		if (DEFINE_INTERFACE != "ZKTECO")
		{
			if(DirectionVisible){
				$("#dirlist").dxSelectBox(
				{
					items: itemsDirList,
					value: itemsDirList[0]
				});
			}else{
				$("#dirlist").parent().parent().remove();
			}
		}
	}

	function createExportButton()
	{
		$("#export").dxButton(
		{
			type: "success",
			height: 40,
			text: DevExpress.localization.formatMessage("ExportBut"),
			onClick: function()
			{
				var i = 1;
				var moreparams = "";
				var plate = $('#TxPlate').dxTextBox('instance').option('value');
				if(ListVisible)
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				var i_dir_selected = 0;
				if (DEFINE_INTERFACE != "ZKTECO")
				{
					if(DirectionVisible){
						dir_selected = $("#dirlist").dxSelectBox('instance').option('value');
						if (dir_selected == DevExpress.localization.formatMessage("Coming"))
						{
							i_dir_selected = 1;
						}
						else if (dir_selected == DevExpress.localization.formatMessage("Going"))
						{
							i_dir_selected = -1;
						}
					}
				}
				if (plate != "")
				{
					moreparams = "&camp" + i + "=numberplate&comp" + i + "=like&value" + i + "=" + plate;
					i++;
				}
				if (list != -2)
				{
					if(list!=undefined){
						moreparams += "&camp" + i + "=listid&comp" + i + "=like&value" + i + "=[" + list + "]";
						i++;
					}
				}
				if (dir_selected != DevExpress.localization.formatMessage("(All Directions)"))
				{
					moreparams += "&camp" + i + "=direction&comp" + i + "=equal&value" + i + "=" + i_dir_selected;
					i++;
				}
				if (debugoptions)
				{
					moreparams += "&debugoptions=1"
				}
	
				if(ColorVisible)
				{
					var colorValue = $("#color_list").dxSelectBox('instance').option('value')
					if ((colorValue >= 0) && (colorValue != null))
					{
						moreparams += "&camp" + i + "=color&comp" + i + "=equal&value" + i + "=" + colorValue;
						i++;
					}
				}
				if(MakeVisible)
				{
					var makerValue = $("#maker_list").dxSelectBox('instance').option('value')
					if ((makerValue >= 0) && (makerValue != null))
					{
						moreparams += "&camp" + i + "=make&comp" + i + "=equal&value" + i + "=" + makerValue;
						i++;
					}
				}
				if(ClassVisible)
				{
					var classValue = $("#class_list").dxSelectBox('instance').option('value')
					if ((classValue >= 0) && (classValue != null))
					{
						moreparams += "&camp" + i + "=veclass&comp" + i + "=equal&value" + i + "=" + classValue;
						i++;
					}
				}
				if(LaneVisible){
					var laneValue = $("#lane_list").dxSelectBox('instance').option('value')					
					if (laneValue != ""){
						if(laneValue=="LANE")
							laneValue = "";
						moreparams += "&camp" + i + "=laneid&comp" + i + "=equal&value" + i + "=" + laneValue;
						i++;
					}
				}
				if(SpeedVisible){
					var speed1 = $("#speed1").dxNumberBox('instance').option('value');					
					var speed2 = $("#speed2").dxNumberBox('instance').option('value');	
	
					if(speed1 > 0 && speed2 > 0){
						if(speed2 < speed1){
							DevExpress.ui.dialog.alert("Max. speed must be greater than Min. speed");
							data2.component.option("text", DevExpress.localization.formatMessage("Search"));
							$("#medium-indicator").hide();
							return;
						}	
						moreparams += "&camp" + i + "=speed&comp" + i + "=between&value" + i + "=" + speed1+";"+speed2;
						i++;
					}else{		
						if (speed1 > 0){
							moreparams += "&camp" + i + "=speed&comp" + i + "=major&value" + i + "=" + speed1;
							i++;
						}					
						if (speed2 > 0){
							moreparams += "&camp" + i + "=speed&comp" + i + "=minor&value" + i + "=" + speed2;
							i++;
						}
					}
				}
									
				var win = window.open(getUrlCgi() + "computerid=" + computerid + "&oper=exportresults&table=nlresult&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(initDayDate.option('value')) + ";" + getStringNormalDate2(finDayDate.option('value')) + moreparams + "&date=" + getStringNormalDate(new Date()) + "&" + sortby_data + localStorage.getItem("TOKEN"), '_blank');
				if (win)
				{
					//Browser has allowed it to be openedd
					win.focus();
				}
				else
				{
					//Browser has blocked it
					alert('Please allow popups for this website');
				}
			}
		});
	}

	function createFirstPageButton()
	{

		$("#FirstPage").dxButton(
		{
			type: "success",
			height: 40,
			text: DevExpress.localization.formatMessage("First page"),
			onClick: function(data2)
			{
				//getOrder();
	
				if($('#FirstPage').attr("sortby") != undefined){
					sortby_data = $('#FirstPage').attr("sortby");
				}
				page_actual = 1;
				$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
				var i = 1;
				var moreparams = "";
				var plate = $('#TxPlate').dxTextBox('instance').option('value');
				if(ListVisible)
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				var i_dir_selected = 0;
				if (DEFINE_INTERFACE != "ZKTECO")
				{
					if(DirectionVisible){
						dir_selected = $("#dirlist").dxSelectBox('instance').option('value');
						if (dir_selected == DevExpress.localization.formatMessage("Coming"))
						{
							i_dir_selected = 1;
						}
						else if (dir_selected == DevExpress.localization.formatMessage("Going"))
						{
							i_dir_selected = -1;
						}
					}
				}
	
				$("#medium-indicator").show();
	
				if (plate != "")
				{
					moreparams = "&camp" + i + "=numberplate&comp" + i + "=like&value" + i + "=" + plate;
					i++;
				}
				if (list != -2)
				{
					if(list!=undefined){
						moreparams += "&camp" + i + "=listid&comp" + i + "=like&value" + i + "=[" + list + "]";
						i++;
					}
				}
				if (dir_selected != DevExpress.localization.formatMessage("(All Directions)"))
				{
					moreparams += "&camp" + i + "=direction&comp" + i + "=equal&value" + i + "=" + i_dir_selected;
					i++;
				}
	
				if(ColorVisible){
					var colorValue = $("#color_list").dxSelectBox('instance').option('value')
					if ((colorValue >= 0) && (colorValue != null))
					{
						moreparams += "&camp" + i + "=color&comp" + i + "=equal&value" + i + "=" + colorValue;
						i++;
					}
				}
				if(MakeVisible){
					var makerValue = $("#maker_list").dxSelectBox('instance').option('value')				
					if ((makerValue >= 0) && (makerValue != null))
					{
						moreparams += "&camp" + i + "=make&comp" + i + "=equal&value" + i + "=" + makerValue;
						i++;
					}
				}
				if(ClassVisible){
					var classValue = $("#class_list").dxSelectBox('instance').option('value')					
					if ((classValue >= 0) && (classValue != null))
					{
						moreparams += "&camp" + i + "=veclass&comp" + i + "=equal&value" + i + "=" + classValue;
						i++;
					}
				}
				if(LaneVisible){
					var laneValue = $("#lane_list").dxSelectBox('instance').option('value')					
					if (laneValue != ""){
						if(laneValue=="LANE")
							laneValue = "";
						moreparams += "&camp" + i + "=laneid&comp" + i + "=equal&value" + i + "=" + laneValue;
						i++;
					}
				}
				if(SpeedVisible){
					var speed1 = $("#speed1").dxNumberBox('instance').option('value');					
					var speed2 = $("#speed2").dxNumberBox('instance').option('value');	
					if(speed1 > 0 && speed2 > 0){
						if(speed2 < speed1){
							DevExpress.ui.dialog.alert("Max. speed must be greater than Min. speed");
							data2.component.option("text", DevExpress.localization.formatMessage("Search"));
							$("#medium-indicator").hide();
							return;
						}		
						moreparams += "&camp" + i + "=speed&comp" + i + "=between&value" + i + "=" + speed1+";"+speed2;
						i++;
					}else{		
						if (speed1 > 0){
							moreparams += "&camp" + i + "=speed&comp" + i + "=major&value" + i + "=" + speed1;
							i++;
						}					
						if (speed2 > 0){
							moreparams += "&camp" + i + "=speed&comp" + i + "=minor&value" + i + "=" + speed2;
							i++;
						}
					}
				}
				
				moreparams = moreparams.replaceAll("&", "|");
				var response = executeCGI(computerid, "select|table=nlresult|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(initDayDate.option('value')) + ";" + getStringNormalDate2(finDayDate.option('value')) + moreparams + "|maxvalues=" + num_regs + "|offset=" + ((page_actual - 1) * num_regs) + "|" + sortby_data, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
				var dataGrid;
				if ($('#gridContainerReview').length == 0)
				{
					dataGrid = $('#gridContainer').dxDataGrid('instance');
				}
				else
				{
					dataGrid = $('#gridContainerReview').dxDataGrid('instance');
				}
				dataGrid.option("dataSource", response);
				$("#medium-indicator").hide();
			}
		});
	}

	function createLastPageButton()
	{

		$("#LastPage").dxButton(
		{
			type: "success",
			height: 40,
			text: DevExpress.localization.formatMessage("Last page"),
			onClick: function(data2)
			{
				if($('#FirstPage').attr("sortby") != undefined){
					sortby_data = $('#FirstPage').attr("sortby");
				}
				page_actual = num_pages;
				$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
				var i = 1;
				var moreparams = "";
				var plate = $('#TxPlate').dxTextBox('instance').option('value');
				if(ListVisible)
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				var i_dir_selected = 0;
				if (DEFINE_INTERFACE != "ZKTECO")
				{
					if(DirectionVisible){
						dir_selected = $("#dirlist").dxSelectBox('instance').option('value');
						if (dir_selected == DevExpress.localization.formatMessage("Coming"))
						{
							i_dir_selected = 1;
						}
						else if (dir_selected == DevExpress.localization.formatMessage("Going"))
						{
							i_dir_selected = -1;
						}
					}
				}
	
				$("#medium-indicator").show();
	
				if (plate != "")
				{
					moreparams = "&camp" + i + "=numberplate&comp" + i + "=like&value" + i + "=" + plate;
					i++;
				}
				if (list != -2)
				{
					if(list!=undefined){
						moreparams += "&camp" + i + "=listid&comp" + i + "=like&value" + i + "=[" + list + "]";
						i++;
					}
				}
				if (dir_selected != DevExpress.localization.formatMessage("(All Directions)"))
				{
					moreparams += "&camp" + i + "=direction&comp" + i + "=equal&value" + i + "=" + i_dir_selected;
					i++;
				}
				
				if(ColorVisible)
				{
					var colorValue = $("#color_list").dxSelectBox('instance').option('value')
					if ((colorValue >= 0) && (colorValue != null))
					{
						moreparams += "&camp" + i + "=color&comp" + i + "=equal&value" + i + "=" + colorValue;
						i++;
					}
				}
				if(MakeVisible)
				{
					var makerValue = $("#maker_list").dxSelectBox('instance').option('value')				
					if ((makerValue >= 0) && (makerValue != null))
					{
						moreparams += "&camp" + i + "=make&comp" + i + "=equal&value" + i + "=" + makerValue;
						i++;
					}
				}
				if(ClassVisible)
				{
					var classValue = $("#class_list").dxSelectBox('instance').option('value')					
					if ((classValue >= 0) && (classValue != null))
					{
						moreparams += "&camp" + i + "=veclass&comp" + i + "=equal&value" + i + "=" + classValue;
						i++;
					}
				}
				if(LaneVisible){
					var laneValue = $("#lane_list").dxSelectBox('instance').option('value')					
					if (laneValue != ""){
						if(laneValue=="LANE")
							laneValue = "";
						moreparams += "&camp" + i + "=laneid&comp" + i + "=equal&value" + i + "=" + laneValue;
						i++;
					}
				}
				if(SpeedVisible){
					var speed1 = $("#speed1").dxNumberBox('instance').option('value');					
					var speed2 = $("#speed2").dxNumberBox('instance').option('value');	
					if(speed1 > 0 && speed2 > 0){
						if(speed2 < speed1){
							DevExpress.ui.dialog.alert("Max. speed must be greater than Min. speed");
							data2.component.option("text", DevExpress.localization.formatMessage("Search"));
							$("#medium-indicator").hide();
							return;
						}		
						moreparams += "&camp" + i + "=speed&comp" + i + "=between&value" + i + "=" + speed1+";"+speed2;
						i++;
					}else{		
						if (speed1 > 0){
							moreparams += "&camp" + i + "=speed&comp" + i + "=major&value" + i + "=" + speed1;
							i++;
						}					
						if (speed2 > 0){
							moreparams += "&camp" + i + "=speed&comp" + i + "=minor&value" + i + "=" + speed2;
							i++;
						}
					}
				}
				moreparams = moreparams.replaceAll("&", "|");
								
				var response = executeCGI(computerid, buildPageQueryByOffset("nlresult", initDayDate, finDayDate, page_actual, num_regs, moreparams, sortby_data), getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
				var dataGrid;
				if ($('#gridContainerReview').length == 0)
				{
					dataGrid = $('#gridContainer').dxDataGrid('instance');
				}
				else
				{
					dataGrid = $('#gridContainerReview').dxDataGrid('instance');
				}
				dataGrid.option("dataSource", response);
				$("#medium-indicator").hide();
			}
		});
	}

	function createPageAntButton()
	{
		$("#PageAnt").dxButton(
		{
			type: "success",
			height: 40,
			text: DevExpress.localization.formatMessage("<< Before"),
			onClick:function(data2)
			{
				if($('#FirstPage').attr("sortby") != undefined){
					sortby_data = $('#FirstPage').attr("sortby");
				}
				if (page_actual > 1)
				{
					page_actual--;
				}
				$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
				var i = 1;
				var moreparams = "";
				var plate = $('#TxPlate').dxTextBox('instance').option('value');
				if(ListVisible)
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				var i_dir_selected = 0;
				if (DEFINE_INTERFACE != "ZKTECO")
				{
					if(DirectionVisible){
						dir_selected = $("#dirlist").dxSelectBox('instance').option('value');
						if (dir_selected == DevExpress.localization.formatMessage("Coming"))
						{
							i_dir_selected = 1;
						}
						else if (dir_selected == DevExpress.localization.formatMessage("Going"))
						{
							i_dir_selected = -1;
						}
					}
				}
	
				$("#medium-indicator").show();
	
				if (plate != "")
				{
					moreparams = "&camp" + i + "=numberplate&comp" + i + "=like&value" + i + "=" + plate;
					i++;
				}
				if (list != -2)
				{
					if(list!=undefined){
						moreparams += "&camp" + i + "=listid&comp" + i + "=like&value" + i + "=[" + list + "]";
						i++;
					}
				}
				if (dir_selected != DevExpress.localization.formatMessage("(All Directions)"))
				{
					moreparams += "&camp" + i + "=direction&comp" + i + "=equal&value" + i + "=" + i_dir_selected;
					i++;
				}
	
				if(ColorVisible){
					var colorValue = $("#color_list").dxSelectBox('instance').option('value')
					if ((colorValue >= 0) && (colorValue != null))
					{
						moreparams += "&camp" + i + "=color&comp" + i + "=equal&value" + i + "=" + colorValue;
						i++;
					}
				}
				if(MakeVisible){
					var makerValue = $("#maker_list").dxSelectBox('instance').option('value')				
					if ((makerValue >= 0) && (makerValue != null))
					{
						moreparams += "&camp" + i + "=make&comp" + i + "=equal&value" + i + "=" + makerValue;
						i++;
					}
				}
				if(ClassVisible){
					var classValue = $("#class_list").dxSelectBox('instance').option('value')					
					if ((classValue >= 0) && (classValue != null))
					{
						moreparams += "&camp" + i + "=veclass&comp" + i + "=equal&value" + i + "=" + classValue;
						i++;
					}
				}
				if(LaneVisible){
					var laneValue = $("#lane_list").dxSelectBox('instance').option('value')					
					if (laneValue != ""){
						if(laneValue=="LANE")
							laneValue = "";
						moreparams += "&camp" + i + "=laneid&comp" + i + "=equal&value" + i + "=" + laneValue;
						i++;
					}
				}
				if(SpeedVisible){
					var speed1 = $("#speed1").dxNumberBox('instance').option('value');					
					var speed2 = $("#speed2").dxNumberBox('instance').option('value');	
					if(speed1 > 0 && speed2 > 0){
						if(speed2 < speed1){
							DevExpress.ui.dialog.alert("Max. speed must be greater than Min. speed");
							data2.component.option("text", DevExpress.localization.formatMessage("Search"));
							$("#medium-indicator").hide();
							return;
						}		
						moreparams += "&camp" + i + "=speed&comp" + i + "=between&value" + i + "=" + speed1+";"+speed2;
						i++;
					}else{		
						if (speed1 > 0){
							moreparams += "&camp" + i + "=speed&comp" + i + "=major&value" + i + "=" + speed1;
							i++;
						}					
						if (speed2 > 0){
							moreparams += "&camp" + i + "=speed&comp" + i + "=minor&value" + i + "=" + speed2;
							i++;
						}
					}
				}
				moreparams = moreparams.replaceAll("&", "|");
				
				var response = executeCGI(computerid, buildPageQueryByOffset("nlresult", initDayDate, finDayDate, page_actual, num_regs, moreparams, sortby_data), getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
				var dataGrid;
				if ($('#gridContainerReview').length == 0)
				{
					dataGrid = $('#gridContainer').dxDataGrid('instance');
				}
				else
				{
					dataGrid = $('#gridContainerReview').dxDataGrid('instance');
				}
				dataGrid.option("dataSource", response);
				$("#medium-indicator").hide();
			}
		});
	}


	function createPageSigButton()
	{
		$("#PageSig").dxButton(
		{
			type: "success",
			height: 40,
			text: DevExpress.localization.formatMessage("Next >>"),
			onClick: function(data2)
			{
				if($('#FirstPage').attr("sortby") != undefined){
					sortby_data = $('#FirstPage').attr("sortby");
				}
				if (page_actual < num_pages)
				{
					page_actual++;
				}
				$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
				var i = 1;
				var moreparams = "";
				var plate = $('#TxPlate').dxTextBox('instance').option('value');
				if(ListVisible)
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				var i_dir_selected = 0;
				if (DEFINE_INTERFACE != "ZKTECO")
				{
					if(DirectionVisible){
						dir_selected = $("#dirlist").dxSelectBox('instance').option('value');
						if (dir_selected == DevExpress.localization.formatMessage("Coming"))
						{
							i_dir_selected = 1;
						}
						else if (dir_selected == DevExpress.localization.formatMessage("Going"))
						{
							i_dir_selected = -1;
						}
					}
				}
	
				$("#medium-indicator").show();
	
				if (plate != "")
				{
					moreparams = "&camp" + i + "=numberplate&comp" + i + "=like&value" + i + "=" + plate;
					i++;
				}
				if (list != -2)
				{
					if(list!=undefined){
						moreparams += "&camp" + i + "=listid&comp" + i + "=like&value" + i + "=[" + list + "]";
						i++;
					}
				}
				if (dir_selected != DevExpress.localization.formatMessage("(All Directions)"))
				{
					moreparams += "&camp" + i + "=direction&comp" + i + "=equal&value" + i + "=" + i_dir_selected;
					i++;
				}
	
				if(ColorVisible)
				{
					var colorValue = $("#color_list").dxSelectBox('instance').option('value')
					if ((colorValue >= 0) && (colorValue != null))
					{
						moreparams += "&camp" + i + "=color&comp" + i + "=equal&value" + i + "=" + colorValue;
						i++;
					}
				}
				if(MakeVisible)
				{
					var makerValue = $("#maker_list").dxSelectBox('instance').option('value')				
					if ((makerValue >= 0) && (makerValue != null))
					{
						moreparams += "&camp" + i + "=make&comp" + i + "=equal&value" + i + "=" + makerValue;
						i++;
					}
				}
				if(ClassVisible)
				{
					var classValue = $("#class_list").dxSelectBox('instance').option('value')					
					if ((classValue >= 0) && (classValue != null))
					{
						moreparams += "&camp" + i + "=veclass&comp" + i + "=equal&value" + i + "=" + classValue;
						i++;
					}
				}
				if(LaneVisible){
					var laneValue = $("#lane_list").dxSelectBox('instance').option('value')					
					if (laneValue != ""){
						if(laneValue=="LANE")
							laneValue = "";
						moreparams += "&camp" + i + "=laneid&comp" + i + "=equal&value" + i + "=" + laneValue;
						i++;
					}
				}
				if(SpeedVisible){
					var speed1 = $("#speed1").dxNumberBox('instance').option('value');					
					var speed2 = $("#speed2").dxNumberBox('instance').option('value');	
					if(speed1 > 0 && speed2 > 0){
						if(speed2 < speed1){
							DevExpress.ui.dialog.alert("Max. speed must be greater than Min. speed");
							data2.component.option("text", DevExpress.localization.formatMessage("Search"));
							$("#medium-indicator").hide();
							return;
						}		
						moreparams += "&camp" + i + "=speed&comp" + i + "=between&value" + i + "=" + speed1+";"+speed2;
						i++;
					}else{		
						if (speed1 > 0){
							moreparams += "&camp" + i + "=speed&comp" + i + "=major&value" + i + "=" + speed1;
							i++;
						}					
						if (speed2 > 0){
							moreparams += "&camp" + i + "=speed&comp" + i + "=minor&value" + i + "=" + speed2;
							i++;
						}
					}
				}
				moreparams = moreparams.replaceAll("&", "|");
				
				var response = executeCGI(computerid, buildPageQueryByOffset("nlresult", initDayDate, finDayDate, page_actual, num_regs, moreparams, sortby_data), getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
				var dataGrid;
				if ($('#gridContainerReview').length == 0)
				{
					dataGrid = $('#gridContainer').dxDataGrid('instance');
				}
				else
				{
					dataGrid = $('#gridContainerReview').dxDataGrid('instance');
				}
				dataGrid.option("dataSource", response);
				$("#medium-indicator").hide();
			}
		});
	}

	function hideAllButton()
	{
		$("#PageAnt").hide();
		$("#PageSig").hide();
		$("#paginitas").hide();
		$("#FirstPage").hide();
		$("#LastPage").hide();
		if (DEFINE_INTERFACE == "ZKTECO")
		{
			$("#export").hide();
		}
	}
	
	function showAllButton()
	{
		$("#PageAnt").show();
		$("#PageSig").show();
		$("#paginitas").show();
		$("#FirstPage").show();
		$("#LastPage").show();
		if (DEFINE_INTERFACE == "ZKTECO")
		{
			$("#export").show();
		}
	}

	function createIconDoneInfo()
	{
		$("#icon-done_info").dxButton(
		{
			type: "success",
			height: 40,
			text: DevExpress.localization.formatMessage("Search"),
			onClick: function(data2)
			{
				if($('#FirstPage').attr("sortby") != undefined){
					sortby_data = $('#FirstPage').attr("sortby");
				}
				if (initDayDate.option('value') > finDayDate.option('value'))
				{
					DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("The 'from date' can not be greater than  'to date'"));
				}
				else if(initDayDate.option('value') == undefined || initDayDate.option('value') == "" || finDayDate.option('value') == undefined || finDayDate.option('value') == "")
				{
					var msg1 = "";
					msg1 = DevExpress.localization.formatMessage("Invalid dates");
					
					DevExpress.ui.dialog.alert(msg1);
				}
				else
				{
					getOrder();
					var date_now = new Date();
					var date_search = new Date(finDayDate.option('value'));
					if(date_search > date_now){
						console.log("Date to use: " + date_now);
						actual_date = date_now;
					}else{
						console.log("Date to use: " + date_search);
						actual_date = date_search;
					}
					if(actual_date == "Invalid date"){
						DevExpress.ui.notify("Date must be selected.", "error", 1500);
						return;
					}
					var i = 1;
					var moreparams = "";
					var plate = $('#TxPlate').dxTextBox('instance').option('value');
					if(ListVisible)
					var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
					if(DEFINE_INTERFACE == "HANWHA")
						num_regs = 5;
					else
						num_regs = $("#numreg").dxSelectBox('instance').option('value');
					var i_dir_selected = 0;
					var show_results = false;
					var json_parse = true;
					if (DEFINE_INTERFACE != "ZKTECO")
					{
						if(DirectionVisible){
							dir_selected = $("#dirlist").dxSelectBox('instance').option('value');
							if (dir_selected == DevExpress.localization.formatMessage("Coming"))
							{
								i_dir_selected = 1;
							}
							else if (dir_selected == DevExpress.localization.formatMessage("Going"))
							{
								i_dir_selected = -1;
							}
						}
					}
					data2.component.option("text", DevExpress.localization.formatMessage("Searching"));
					$("#medium-indicator").show();
					if (plate != "")
					{
						moreparams = "&camp" + i + "=numberplate&comp" + i + "=like&value" + i + "=" + plate;
						i++;
					}
					console.log("list test: " + list);
					if (list != -2)
					{
						if(list!=undefined){
							moreparams += "&camp" + i + "=listid&comp" + i + "=like&value" + i + "=[" + list + "]";
							i++;
						}
					}
					if (dir_selected != DevExpress.localization.formatMessage("(All Directions)"))
					{
						moreparams += "&camp" + i + "=direction&comp" + i + "=equal&value" + i + "=" + i_dir_selected;
						i++;
					}

					hideAllButton();

					if(ColorVisible){
						var colorValue = $("#color_list").dxSelectBox('instance').option('value')
						if ((colorValue >= 0) && (colorValue != null))
						{
							moreparams += "&camp" + i + "=color&comp" + i + "=equal&value" + i + "=" + colorValue;
							i++;
						}
					}
					if(MakeVisible){
						var makerValue = $("#maker_list").dxSelectBox('instance').option('value')				
						if ((makerValue >= 0) && (makerValue != null))
						{
							moreparams += "&camp" + i + "=make&comp" + i + "=equal&value" + i + "=" + makerValue;
							i++;
						}
					}
					if(ClassVisible){
						var classValue = $("#class_list").dxSelectBox('instance').option('value')					
						if ((classValue >= 0) && (classValue != null))
						{
							moreparams += "&camp" + i + "=veclass&comp" + i + "=equal&value" + i + "=" + classValue;
							i++;
						}
					}
					if(LaneVisible){
						var laneValue = $("#lane_list").dxSelectBox('instance').option('value');
						if (laneValue != ""){
							if(laneValue=="LANE")
								laneValue = "";
							moreparams += "&camp" + i + "=laneid&comp" + i + "=equal&value" + i + "=" + laneValue;
							i++;
						}
					}
					if(SpeedVisible){
						var speed1 = $("#speed1").dxNumberBox('instance').option('value');					
						var speed2 = $("#speed2").dxNumberBox('instance').option('value');
						if(speed1 > 0 && speed2 > 0){
							if(speed2 < speed1){
								DevExpress.ui.dialog.alert("Max. speed must be greater than Min. speed");
								data2.component.option("text", DevExpress.localization.formatMessage("Search"));
								$("#medium-indicator").hide();
								return;
							}	
							moreparams += "&camp" + i + "=speed&comp" + i + "=between&value" + i + "=" + speed1+";"+speed2;
							i++;
						}else{		
							if (speed1 > 0){
								moreparams += "&camp" + i + "=speed&comp" + i + "=major&value" + i + "=" + speed1;
								i++;
							}					
							if (speed2 > 0){
								moreparams += "&camp" + i + "=speed&comp" + i + "=minor&value" + i + "=" + speed2;
								i++;
							}
						}
					}
					moreparams = moreparams.replaceAll("&", "|");
					
	
					num_registros_consulta = executeCGI(computerid, "count|table=nlresult|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(initDayDate.option('value')) + ";" + getStringNormalDate2(finDayDate.option('value')) + moreparams, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
					if (num_registros_consulta > 0)
					{
						var max_values_return = num_regs;
						if(DEFINE_INTERFACE == "HANWHA")
						{
							max_values_return = 5;
						}
						var json_data = executeCGI(computerid, "select|table=nlresult|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(initDayDate.option('value')) + ";" + getStringNormalDate2(finDayDate.option('value')) + moreparams + "|maxvalues=" + max_values_return, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
						data2.component.option("text", DevExpress.localization.formatMessage("Search"));
						$("#medium-indicator").hide();
						var dataGrid;
						if ($('#gridContainerReview').length == 0)
						{
							dataGrid = $('#gridContainer').dxDataGrid('instance');
						}
						else
						{
							dataGrid = $('#gridContainerReview').dxDataGrid('instance');
						}
						dataGrid.option('paging.pageSize', num_regs);
						page_actual = 1;
						num_pages = Math.ceil(num_registros_consulta / num_regs);
						$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
						if (num_pages > 1)
						{
							showAllButton()
						}
						dataGrid.option("dataSource", json_data);
					}
					else
					{
						data2.component.option("text", DevExpress.localization.formatMessage("Search"));
						$("#medium-indicator").hide();
						var dataGrid;
						if ($('#gridContainerReview').length == 0)
						{
							dataGrid = $('#gridContainer').dxDataGrid('instance');
						}
						else
						{
							dataGrid = $('#gridContainerReview').dxDataGrid('instance');
						}
						dataGrid.option("dataSource", []);
					}
				}
			}
		});
	}

	function createGridContainer()
	{
		$(gridName).dxDataGrid(
		{
			dataSource: results,
			showBorders: true,
			showRowLines: true,
			keyExpr: "id",
			hoverStateEnabled: true,
			searchPanel:
			{
				visible: true,
				width: 240,
				placeholder: DevExpress.localization.formatMessage("Search...")
			},
			pager:
			{
				visible: false
			},
			onToolbarPreparing: function(e)
			{
				var dataGrid = e.component;
				if (DEFINE_INTERFACE == "VIVOTEK" || DEFINE_INTERFACE == "AXIS" || DEFINE_INTERFACE == "VICON" || DEFINE_INTERFACE == "VIVOTEK_CV25" || DEFINE_INTERFACE == "HANWHA")
				{
					return;
				}
				e.toolbarOptions.items.unshift(
				{
					location: "center",
					widget: "dxTextBox",
					width: 120,
					readOnly: true,
					template: function()
					{
						var div = $("<div/>");
						div.attr('id', 'paginitas');
						div.dxTextBox(
						{
							readOnly: true,
							width: 120,
							value: ""
						});
						div.hide();
						return div;
					}
				});
			},
			columns: [
			{
				dataField: "id",
				caption: "ID",
				width: 80,
				alignment: 'center',
				calculateSortValue: function (rowData) {
					return rowData.id;
				}
			},
			{
				dataField: "timestamp",
				dataType: "date",
				caption: DevExpress.localization.formatMessage("Time"),
				width: 180,
				alignment: 'center',
				format: "HH:mm:ss.SSS dd/MM/yyyy",
				calculateSortValue: function (rowData) {
					return rowData.timestamp;
				}
			},
			{
				dataField: "numberplate",
				width: 100,
				alignment: 'center',
				caption: DevExpress.localization.formatMessage("Plate"),
				calculateSortValue: function (rowData) {
					return rowData.numberplate;
				}
			},
			{
				dataField: "laneid",
				width: 80,
				alignment: 'center',
				caption: DevExpress.localization.formatMessage("Lane"),
				visible: LaneVisible, 
				cellTemplate: function(element, info)
				{
					if (info.text == 0){
						element.append("");
					}
					else{
						var name = "";
						for(var i = 0; i < lanenames.length; i++){
							if(info.text == lanenames[i].ID){
								name = lanenames[i].Name;
							}
						}
						element.append(name);
					}
				},
				calculateSortValue: function (rowData) {
					return rowData.laneid;
				}
			},
			{
				dataField: "direction",
				width: 120,
				alignment: 'center',
				caption: DevExpress.localization.formatMessage("Direction"),
				visible: DirectionVisible,
				cellTemplate: function(element, info)
				{
					if (info.text == 0)
					{
						element.append(DevExpress.localization.formatMessage("No Direction"));
					}
					else if (info.text == 1)
					{
						element.append(DevExpress.localization.formatMessage("Coming"));
					}
					else if (info.text == -1)
					{
						element.append(DevExpress.localization.formatMessage("Going"));
					}
				},
				calculateSortValue: function (rowData) {
					return rowData.direction;
				}
			},
			{
				dataField: "speed",
				width: 100,
				alignment: 'center',
				visible: SpeedVisible, 
				caption: DevExpress.localization.formatMessage("Speed"),
				calculateSortValue: function (rowData) {
					return parseFloat(rowData.speed);
				}
			},
			{
				dataField: "globalconfidence",
				width: 100,
				alignment: 'center',
				caption: DevExpress.localization.formatMessage("Conf."),
				visible: ConfVisible,
				calculateSortValue: function (rowData) {
					return parseFloat(rowData.globalconfidence);
				}
			},
			{
				dataField: "averagecharheight",
				width: 60,
				alignment: 'center',
				caption: DevExpress.localization.formatMessage("Height"),
				visible: HeightVisible,
				calculateSortValue: function (rowData) {
					return parseFloat(rowData.averagecharheight);
				}
			}, 
			{
				dataField: "country",
				width: 150,
				alignment: 'center',
				caption: DevExpress.localization.formatMessage("CountryState"),
				visible: CountryVisible,
				cellTemplate: function(element, info)
				{
					//console.log(JSON.stringify(dict))
					element.append(dict[info.text]);
				},
				calculateSortValue: function (rowData) {
					return rowData.country;
				}
			},
			{
				dataField: "namelistid",
				width: 150,
				alignment: 'center',
				caption: DevExpress.localization.formatMessage("List"),
				visible: ListVisible,
				cellTemplate: function(element, info)
				{
					if (info.text != "not in list")
					{
						element.append(info.text);
					}
					else
					{
						element.append("");
					}
				},
				calculateSortValue: function (rowData) 
				{
					return rowData.namelistid;
				}
			},
			{
				dataField: "veclass_str",
				width: 100,
				alignment: 'center',
				caption: function() {
					
					return getClassColorColumnName(ClassVisible, ColorVisible);
				},
				calculateCellValue: function(rowData) {
					return rowData.veclass_str.replace(/NLVEHICLE_CLASS_/g,'').toLowerCase() +"_"+ rowData.color_str.toLowerCase();
				},
				cellTemplate: function(element, info)
				{	
					element.css({textAlign: "center"});
					var tooltipText = info.text.split("_")[0]+" - "+info.text.split("_")[1];
					if(tooltipText == " - ")
						tooltipText="";
					element.append("<img title='"+tooltipText+"' src='" + getClassColorIcon(info.text, ClassVisible, ColorVisible) + "' height = '20' width='20'>");
				},
				visible: (ClassVisible || ColorVisible)
			},
			{
				dataField: "make_str",
				width: 100,
				alignment: 'center',
				caption: DevExpress.localization.formatMessage("Make"),
				visible: MakeVisible
			},
			{
				dataField: "imageretailpath",
				caption: DevExpress.localization.formatMessage("Image"),
				width: 150,
				alignment: 'center',
				cellTemplate: function(element, info)
				{
					if (info.text != "")
					{
						if(DEFINE_INTERFACE == "HANWHA"){
							var serverName	= window.location.host;
							var serverType = "http://";
							var imgPath = info.text.replace("/mnt/mmcblk0p1/opensdk/NeuralEdge/images/","/home/setup/opensdk/html/NeuralEdge/imagesres/")
							
							console.log("new image path: " + serverType + serverName + imgPath);
							var tmpImg = serverType + serverName + imgPath;
												
							element.append("<img id='icimg" + info.key + "' src='" + tmpImg+ "' height = '20' width='125'><div id='tooltip" + info.key + "'></div>")
						}else{
								element.append("<img id='icimg" + info.key + "' src='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getimage&path=" + info.text + localStorage.getItem("TOKEN") + "' height = '20' width='125'><div id='tooltip" + info.key + "'></div>")
						}
						if (info.row.data.imagepath != "")
						{
							CreateToolTip(info.key, info.row.data.evidences, info.row.data.imagepath, info.row.data.resultleft, info.row.data.resulttop, info.row.data.resultright, info.row.data.resultbottom, info.row.data.width, info.row.data.height);
						}
					}
					else
					{
						element.append(DevExpress.localization.formatMessage("No image"));
					}
				},
				calculateSortValue: function (rowData) {
					return rowData.imageretailpath;
				}
			},
			{
				dataField: "imagepath",
				caption: DevExpress.localization.formatMessage("Image"),
				width: 100,
				alignment: 'center',

				cellTemplate: function(element, info)
				{
					if (info.text != "")
					{
						if(DEFINE_INTERFACE == "HANWHA"){
							var serverName	= window.location.host;
							var serverType = "http://";
							var imgPath = info.text.replace("/mnt/mmcblk0p1/opensdk/NeuralEdge/images/","/home/setup/opensdk/html/NeuralEdge/imagesres/")
							
							console.log("new image path: " + serverType + serverName + imgPath);
							var tmpImg = serverType + serverName + imgPath;
												
							element.append("<a  href='"+tmpImg+"' download>LPR</a>")
							var i;
							for (i = 1; i <= info.row.data.evidences; i++)
							{
								if((info.row.data.evidences == 1) && (existFile(info.text.substring(0, info.text.length - 4) + "_ev" + i + ".jpg") == false))
								{
									element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text.substring(0, info.text.length - 4) + "_ev" + 2 + ".jpg" + localStorage.getItem("TOKEN") + "'> EV" + 2 + "</a>")
								}
								else
								{
									element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text.substring(0, info.text.length - 4) + "_ev" + i + ".jpg" + localStorage.getItem("TOKEN") + "'> EV" + i + "</a>")
								}
							}
						}else{
							element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text + localStorage.getItem("TOKEN") + "'>LPR</a>")
							var i;
							for (i = 1; i <= info.row.data.evidences; i++)
							{
								if((info.row.data.evidences == 1) && (existFile(info.text.substring(0, info.text.length - 4) + "_ev" + i + ".jpg") == false))
								{
									element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text.substring(0, info.text.length - 4) + "_ev" + 2 + ".jpg" + localStorage.getItem("TOKEN") + "'> EV" + 2 + "</a>")
								}
								else
								{
									element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text.substring(0, info.text.length - 4) + "_ev" + i + ".jpg" + localStorage.getItem("TOKEN") + "'> EV" + i + "</a>")
								}
							}
						}
					}
					else
					{
						element.append(DevExpress.localization.formatMessage("No image"));
					}
				},
				calculateSortValue: function (rowData) {
					return rowData.imagepath;
				}
			}],
			onRowPrepared: function(row)
			{
				var order ="";
				sortby_data = "sortasc=id";
				var isListMode;
				if(DEFINE_INTERFACE == "ZKTECO")
				{
					var data = executeCGI(computerid, "select|table=nlconfgeneral|camp0=name|comp0=equal|value0=view|maxvalues=" + num_regs , getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
					$.each(data, function(i, item)
					{
						isListMode = item.value;
					});
				}
				if((isListMode == "LIST") && (DEFINE_INTERFACE == "ZKTECO"))
				{
					if($(gridName+' #dx-col-11').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-11').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-11').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-11').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=id"); $("#FirstPage").trigger("click"); return false;');
					
					if($(gridName+' #dx-col-12').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-12').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-12').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-12').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=timestamp"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-13').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-13').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-13').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-13').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=numberplate"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-14').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-14').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-14').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-14').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=laneid"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-15').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-15').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-15').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-15').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=direction"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-16').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-16').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-16').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-16').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=speed"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-17').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-17').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-17').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-17').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=globalconfidence"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-18').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-18').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-18').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-18').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=averagecharheight"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-19').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-19').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-19').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-19').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=country"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-20').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-20').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-20').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-20').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=namelistid"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-21').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-21').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-21').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-21').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=veclass"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-22').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-22').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-22').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-22').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=make"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-23').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-23').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-23').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-23').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=imageretailpath"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-24').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-24').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-24').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-24').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=imagepath"); $("#FirstPage").trigger("click"); return false;');
				}
				else
				{
					if($(gridName+' #dx-col-1').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-1').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-1').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-1').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=id"); $("#FirstPage").trigger("click"); return false;');
					
					if($(gridName+' #dx-col-2').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-2').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-2').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-2').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=timestamp"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-3').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-3').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-3').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-3').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=numberplate"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-4').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-4').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-4').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-4').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=laneid"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-5').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-5').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-5').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-5').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=direction"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-6').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-6').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-6').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-6').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=speed"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-7').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-7').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-7').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-7').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=globalconfidence"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-8').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-8').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-8').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-8').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=averagecharheight"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-9').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-9').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-9').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-9').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=country"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-10').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-10').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-10').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-10').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=namelistid"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-11').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-11').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-11').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-11').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=veclass"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-12').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-12').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-12').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-12').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=make"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-13').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-13').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-13').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-13').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=imageretailpath"); $("#FirstPage").trigger("click"); return false;');

					if($(gridName+' #dx-col-14').attr('aria-sort') == "none")order = "sortasc";
					if($(gridName+' #dx-col-14').attr('aria-sort') == "descending")order = "sortasc";
					if($(gridName+' #dx-col-14').attr('aria-sort') == "ascending")order = "sortdesc";
					$(gridName+' #dx-col-14').attr('onclick','$("#FirstPage").attr("sortby", "'+order+'=imagepath"); $("#FirstPage").trigger("click"); return false;');
				}
					
				if (row.rowType == "data")
				{
					if(ListVisible)
					{
						if(row.data.listid != "[-1]")
						{
							row.rowElement.addClass('Red');
						}
					}
				}
			}
		});
	}

	var priorities = [DevExpress.localization.formatMessage("All"), DevExpress.localization.formatMessage("In list"), DevExpress.localization.formatMessage("Not in list")];
	var sellist = 0;
	var dateact = new Date();
	var dateiniday;
	var dateendday;
	var results = [];
	var dictlist = {};
	var dict = {};
	var listas = [];
	var d2;
	var mostrarAnterior = false;
	var mostrarPosterior = false;
	var num_registros_consulta = 0;
	var num_pages = 0;
	var page_actual = 0;
	var id_inicial = 0;
	var id_final = 0;
	var num_regs = 10;
	var dir_selected = DevExpress.localization.formatMessage("(All Directions)");
	var application = "";
	var debugoptions = false;
	var json_data;
	var vehiclesclass;
	var vehiclescolor;
	var vehiclesmakes;
	var vehiclesclassds;
	var vehiclescolords;	
	var vehiclesmakeds;

	//Visibility Options
	var LaneVisible = false;
	var DirectionVisible = false;
	var ConfVisible = false;
	var SpeedVisible = false;
	var HeightVisible = false;
	var CountryVisible = false;
	var ListVisible = false;
	var ClassVisible = false;
	var ColorVisible = false;
	var MakeVisible = false;

	//lane names
	var lanenames = [];

	var actual_date;
	var sortby_data="id";
	var sortby_order="sortdesc";
	var lastsort = "timestamp";
	var repeat_idx = 0;

	var itemsNumReg = [10, 20, 50, 100];
	if (DEFINE_INTERFACE == "ZKTECO")
	{
		itemsNumReg = [5];
	}

	var gridName = "#gridContainerReview";
	if ($(gridName).length == 0)
	{
		gridName = "#gridContainer";
	}

	var selectfield = "|selectfield=id;timestamp;numberplate;laneid;direction;speed;globalconfidence;averagecharheight;country;namelistid;veclass_str;make_str;color_str;imageretailpath;imagepath;resultleft;resulttop;resultright;resultbottom;width;height";
	$.urlParam = function(name)
	{
		var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.href);
		if (results == null)
		{
			return null;
		}
		else
		{
			return results[1] || 0;
		}
	}

	if (DEFINE_INTERFACE == "ZKTECO")
	{
		$("#htmlcentral").width(1800);
	}
	else
	{
		Init_translate();
		make_header("review");
	}
	setPropertiesTexts();
	
	
	if (DEFINE_INTERFACE != "ZKTECO")
	{
		set_rcpopup();
	}

	configureWebIcon();
	
	isDebugOptionEnable();
	
	if (DEFINE_INTERFACE == "HANWHA" || DEFINE_INTERFACE == "VIVOTEK_CV25")
	{
		vehiclesclass = getVehicleClassTable();
		vehiclescolor = getVehicleColorTable();
		vehiclesmakes = getVehicleMakeTable();
	}
	
	loadVehicleFilters();
	
	reviewFields();

	d2 = getimeCamera();
	dateiniday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 0, 0, 0);
	dateendday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 23, 59, 59);
	
	
	loadConfigure();
	application = getApplication();

	getApliLaneNames();

	var initDayDate = createDateTime("#data1", dateiniday);
	var finDayDate = createDateTime("#data2", dateendday);

	var fentitat = $("#TxPlate").dxTextBox();
	var fdir = $("#TxDir").dxTextBox();
	
	createPaginitas();
	
	enableListFilter(ListVisible);
	
	enableVehicleFilters(ClassVisible, ColorVisible, MakeVisible, LaneVisible, SpeedVisible)
	
	createShowNomRegister();

	directionFilter();

	createMediumIndicator();

	createExportButton();
		
	createFirstPageButton();

	createLastPageButton();

	createPageAntButton();

	createPageSigButton();

	createGridContainer();

	hideAllButton();

	var dir_visible = true;
	
	createIconDoneInfo();

	
});
