////////////////
// LISTS PAGE //
////////////////
$(function()
{
	function getNumberOfLists()
	{
		var numberOfLists = executeCGI(computerid, "select|table=nllist|maxvalues=" + max_num_lists, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
		return numberOfLists.length;
	}

	function getNumberOfActions()
	{
		var numberOfTotalActions = executeCGI(computerid, "select|table=nlaction|camp0=id|comp0=notequal|value0=1|maxvalues=12", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
		return numberOfTotalActions.length;
	}

	function getNumberOfExports()
	{
		var numberOfTotalExports = executeCGI(computerid, "select|table=nlexport|camp0=id|comp0=notequal|value0=1|maxvalues=8", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
		return numberOfTotalExports.length;
	}

	function getNumberOfImports()
	{
		var numberOfTotalImports = executeCGI(computerid, "select|table=nlimport|camp0=id|comp0=notequal|value0=1|maxvalues=8", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
		return numberOfTotalImports.length;
	}

	function isEmptyActionList(id_list)
	{
		var numberOfActions = executeCGI(computerid, "count|table=nlaction|camp0=listid|comp0=equal|value0=" + id_list + "|sortdesc=id", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
		return (numberOfActions == 0);
	}

	function isEmptyExportList(id_list)
	{
		var numberOfActions = executeCGI(computerid, "count|table=nlexport|camp0=listid|comp0=equal|value0=" + id_list + "|sortdesc=id", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
		return (numberOfActions == 0);
	}

	function checkExportActionButtons(id_list)
	{
		var isEmptyActions = false;

		if(id_list == -2)
		{
			var totalOfActions = executeCGI(computerid, "count|table=nlaction", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
			
			if(totalOfActions == 0)
			{
				isEmptyActions = true;
			}
		}
		else
		{
			if(isEmptyActionList(id_list) == true)
			{
				isEmptyActions = true;
			}
		}

		if(isEmptyActions == true)
		{
			$("#ExportActionsXML").dxButton("instance").option("disabled", true);
			$("#ExportActionsCSV").dxButton("instance").option("disabled", true);
		}
		else
		{
			$("#ExportActionsXML").dxButton("instance").option("disabled", false);
			$("#ExportActionsCSV").dxButton("instance").option("disabled", false);
		}
	}

	function checkExportButtons(id_list)
	{
		var isEmptyExports = false;
		var isEmptyPlates = false;

		if(id_list == -2)
		{
			var totalOfExports = executeCGI(computerid, "count|table=nlexport", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
	
			if(totalOfExports == 0)
			{
				isEmptyExports = true;
			}

			var numberOfPlates = executeCGI(computerid, "count|table=nlelemlist|camp0=listid|sortdesc=id", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

			if(numberOfPlates == 0)
			{
				isEmptyPlates = true;
			}

		}
		else
		{
			if(isEmptyExportList(id_list) == true)
			{
				isEmptyExports = true;
			}

			if(isEmptyPlatesList(id_list) == true)
			{
				isEmptyPlates = true;
			}
		}

		if(isEmptyExports == true && isEmptyPlates == true)
		{
			$("#ExportXML").dxButton("instance").option("disabled", true);
			$("#ExportCSV").dxButton("instance").option("disabled", true);
		}
		else
		{
			$("#ExportXML").dxButton("instance").option("disabled", false);
			$("#ExportCSV").dxButton("instance").option("disabled", false);
		}
		
	}

	function isEmptyPlatesList(id_list)
	{
		var numberOfPlates = executeCGI(computerid, "count|table=nlelemlist|camp0=listid|comp0=equal|value0=" + id_list + "|sortdesc=id", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
		return (numberOfPlates == 0);
	}

	function checkExportPlateButton(id_list)
	{
		$("#gridContainer2").dxDataGrid({
			onExporting: function(e) {
				e.cancel = isEmptyPlatesList(id_list);
			}
		});
	}

	function getTriggerMode()
	{
		var isTrigger = false;
		var data = executeCGI(computerid, "count|table=nlconfcamera|camp0=name|comp0=like|value0=mode|camp1=value|comp1=like|value1=TRIGGER", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
	
		if (data == 1)
		{
			isTrigger = true;
		}
		else
		{
			isTrigger = false;
		}
		
		return isTrigger;
	}

	function getreservationscheduler(dia, mascara)
	{
		var $rsvns = [];
		var i = 0;
		var duracion = 0;
		var inicio = -1;
		for (i = 0; i < 24; i++)
		{
			//elemento con hora
			if (mascara.charAt(i) == '1')
			{
				if (inicio == -1)
				{
					inicio = i;
				}
				duracion++;
			}
			else
			{
				if (inicio != -1)
				{
					var $rsvn = $("<div></div>"),
						top = dia * 30,
						height = 30 + 1,
						left = inicio * 44,
						width = duracion * 44 + 1;
					$rsvn.addClass("reservation").addClass("reservation-final")
						.css(
						{
							top: top,
							height: height,
							left: left,
							width: width
						});
					$rsvns.push($rsvn);
					inicio = -1;
					duracion = 0;
				}
			}
		}
		if (mascara.charAt(23) == '1' && inicio != -1)
		{
			var $rsvn = $("<div></div>"),
				top = dia * 30,
				height = 30 + 1,
				left = inicio * 44,
				width = duracion * 44 + 1;
			$rsvn.addClass("reservation").addClass("reservation-final")
				.css(
				{
					top: top,
					height: height,
					left: left,
					width: width
				});
			$rsvns.push($rsvn);
		}
		return $rsvns;
	}

	function setbinddiv(divintro, text, i, columna, options, selectedvalue, table, help)
	{
		var valopt = options.split(";");
		var helpdiv = "";
		if (help != "")
		{
			helpdiv = "<div id='icon" + columna + i + "'></div><div id='popup" + columna + i + "' style='display:none' ></div> ";
		}
		$("#" + divintro).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(text) + "</div><div class='dx-field-value'><div id='elemb" + columna + i + "' style='float:none;display: inline-block; ' ></div> <div id='elem" + columna + i + "' style='display: inline-block;' ><div>" + helpdiv + "</div></div>");
		if (help != "")
		{
			$("#icon" + columna + i).dxButton(
			{
				icon: "help",
				type: "success",
				mode: "contained",
				onClick: function(e)
				{
					var jqxhr = $.ajax("help/" + help.replace(".html", "_" + getLocale() + ".html"))
						.done(function(data)
						{
							$("#popup" + columna + i).append(data);
							var poup = $("#popup" + columna + i).dxPopup(
							{
								showTitle: true,
								title: DevExpress.localization.formatMessage("Help"),
								visible: true,
								maxWidth: 500,
								maxHeight: 500,
								loseOnOutsideClick: true
							});
						});
				}
			});
		}
		
		$("#elem" + columna + i).text(selectedvalue);
		$("#elemb" + columna + i).dxButton(
		{
			text: DevExpress.localization.formatMessage("Bind"),
			type: "success",
			//text: "Bind", 
			onClick: function(e)
			{
				var data = executeCGI(computerid, "oper=pssbind|idaction=" + idaction, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

				if(data != "error")
				{
					$("#elem" + columna + i).text(data);
				}
			}
		});
	}

	function setoptiondiv(divintro, text, i, columna, options, selectedvalue, table, help)
	{
		var valopt = options.split(";");
		var helpdiv = "";
		if (help != "")
		{
			helpdiv = "<div id='icon" + columna + i + "'></div><div id='popup" + columna + i + "' style='display:none' ></div> ";
		}
		$("#" + divintro).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(text) + "</div><div class='dx-field-value'><div id='elem" + columna + i + "' style='float:none;display: inline-block;'></div> " + helpdiv + "</div></div>");
		if (help != "")
		{
			$("#icon" + columna + i).dxButton(
			{
				icon: "help",
				type: "success",
				mode: "contained",
				onClick: function(e)
				{
					var jqxhr = $.ajax("help/" + help.replace(".html", "_" + getLocale() + ".html"))
						.done(function(data)
						{
							$("#popup" + columna + i).append(data);
							var poup = $("#popup" + columna + i).dxPopup(
							{
								showTitle: true,
								title: DevExpress.localization.formatMessage("Help"),
								visible: true,
								maxWidth: 700,
								maxHeight: 300,
								loseOnOutsideClick: true
							});
						});
				}
			});
		}
		
		$("#elem" + columna + i).dxRadioGroup(
		{
			items: valopt,
			value: selectedvalue,
			layout: "horizontal",
			onValueChanged: function(e)
			{
				var newValue = e.value;
				var idactexp;
				// Event handling commands go here
				if (table == "nlaction")
				{
					setCheckBoxToRadioButton("actions", newValue, columna);
					actdict["act" + idaction][columna] = newValue;
					idactexp = idaction;
				}
				else if (table == "nlimport")
				{
					impdict["imp" + idimport][columna] = newValue;
					idactexp = idimport;
				}
				else
				{
					expdict["exp" + idexport][columna] = newValue;
					idactexp = idexport;
				}

				updateTableValue(table, idactexp, columna, newValue);
			}
		});
	}

	function setmultioptiondiv(divintro, text, i, columna, options, selectedvalue, table, help)
	{

        ///////////////////////////
		var valopt = options.split(";");
		var helpdiv = "";
		if (help != "")
		{
			helpdiv = "<div id='icon" + columna + i + "'></div><div id='popup" + columna + i + "' style='display:none' ></div> ";
		}					
		$("#" + divintro).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(text) + "</div><div class='dx-field-value'><div class='dx-field-value' id='elem" + columna + i + "' style='float:none;display: inline-block;'></div> " + helpdiv + "</div></div>");
		if (help != "")
		{
			$("#icon" + columna + i).dxButton(
			{
				icon: "help",
				type: "success",
				mode: "contained",
				onClick: function(e)
				{
					var jqxhr = $.ajax("help/" + help.replace(".html", "_" + getLocale() + ".html"))
						.done(function(data)
						{
							$("#popup" + columna + i).append(data);
							var poup = $("#popup" + columna + i).dxPopup(
							{
								showTitle: true,
								title: DevExpress.localization.formatMessage("Help"),
								visible: true,
								maxWidth: 500,
								maxHeight: 500,
								loseOnOutsideClick: true
							});
						});
				}
			});
		}
		$.each(valopt, function(j, itemoptions)
		{
			//console.log(selectedvalue);
			$("#elem" + columna + i).append("<div id='elem" + columna + i +"-"+ j + "' style='float: left;margin-right: 10px;' ></div>");				
			$("#elem" + columna + i +"-"+ j).dxCheckBox(
			{
				value: selectedvalue.includes(itemoptions),
				text: itemoptions,
				name: itemoptions,
				layout: "horizontal",
				onValueChanged: function(e)
				{
					if(!loadingChBx){
						var previousValue = e.previousValue;
						var newValue = e.value;
						var idactexp;
						var insertValue;
						// Event handling commands go here
						if (newValue){
							//Control of checkbox
							if (table == "nlaction"){
								setCheckBoxClicked("actions", columna, i, j, e.element[0].textContent);
								// actdict["act" + idaction][columna] = newValue;
								insertValue = actdict["act" + idaction][columna];
								if(insertValue == "")
								{
									insertValue = e.element[0].textContent;
								}
								else
								{
									insertValue = insertValue + ";" + e.element[0].textContent;
								}
								actdict["act" + idaction][columna] = insertValue;
								idactexp = idaction;
								
							}
							else if (table == "nlimport")
							{
								// impdict["imp" + idimport][columna] = newValue;
								insertValue = impdict["imp" + idimport][columna];
								if(insertValue == "")
								{
									insertValue = e.element[0].textContent;
								}
								else
								{
									insertValue = insertValue + ";" + e.element[0].textContent;
								}
								impdict["imp" + idimport][columna] = insertValue;
								idactexp = idimport;
							}
							else
							{
								setCheckBoxClicked("exports", columna, i, j, e.element[0].textContent);
								// expdict["exp" + idexport][columna] = newValue;
								insertValue = expdict["exp" + idexport][columna];
								if(insertValue == "")
								{
									insertValue = e.element[0].textContent;
								}
								else
								{
									insertValue = insertValue + ";" + e.element[0].textContent;
								}
								expdict["exp" + idexport][columna] = insertValue;
								idactexp = idexport;
							}
						}
						else
						{
							if (table == "nlaction")
							{
								// actdict["act" + idaction][columna] = newValue;
								insertValue = actdict["act" + idaction][columna];
								
								var re = new RegExp(e.element[0].textContent, "g");
								insertValue = insertValue.replaceAll(re, "");
								while(insertValue.includes(";;"))
								{
									insertValue = insertValue.replaceAll(";;",";");
								}
								if(insertValue.indexOf(";") == 0)
								{
									insertValue = insertValue.slice(1);
								}
								if(insertValue == ";")
								{
									insertValue = "";
								}
								actdict["act" + idaction][columna] = insertValue;
								idactexp = idaction;
							}
							else if (table == "nlimport")
							{
								// impdict["imp" + idimport][columna] = newValue;
								insertValue = impdict["imp" + idimport][columna];

								var re = new RegExp(e.element[0].textContent, "g");
								insertValue = insertValue.replaceAll(re, "");
								while(insertValue.includes(";;"))
								{
									insertValue = insertValue.replaceAll(";;",";");
								}
								if(insertValue.indexOf(";") == 0)
								{
									insertValue = insertValue.slice(1);
								}
								if(insertValue == ";")
								{
									insertValue = "";
								}
								impdict["imp" + idimport][columna] = insertValue;
								idactexp = idimport;
							}
							else
							{
								// expdict["exp" + idexport][columna] = newValue;
								insertValue = expdict["exp" + idexport][columna];
								
								var re = new RegExp(e.element[0].textContent, "g");
								insertValue = insertValue.replaceAll(re, "");
								while(insertValue.includes(";;"))
								{
									insertValue = insertValue.replaceAll(";;",";");
								}
								if(insertValue.indexOf(";") == 0)
								{
									insertValue = insertValue.slice(1);
								}
								if(insertValue == ";")
								{
									insertValue = "";
								}
								expdict["exp" + idexport][columna] = insertValue;
								idactexp = idexport;
							}
						}
						if(updated == true)
						{
							if((insertValue != "") || (isDisable == true))
							{
								updateTableValue(table, idactexp, columna, insertValue);
							}
							else
							{
								DevExpress.ui.notify("Empty Value", "error", 600);
							}
						}
					}
				}
			});
		});
	}

	function setintdiv(divintro, text, i, columna, options, selectedvalue, table, help)
	{
		var valopt = options.split(";");
		var helpdiv = "";
		if (help != "")
		{
			helpdiv = "<div id='icon" + columna + i + "'></div><div id='popup" + columna + i + "' style='display:none' ></div> ";
		}
		$("#" + divintro).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(text) + "</div><div class='dx-field-value'><div id='elem" + columna + i + "' style='float:none;display: inline-block;' ></div>" + helpdiv + "</div></div>");
		if (help != "")
		{
			$("#icon" + columna + i).dxButton(
			{
				icon: "help",
				type: "success",
				mode: "contained",
				onClick: function(e)
				{
					var jqxhr = $.ajax("help/" + help.replace(".html", "_" + getLocale() + ".html"))
						.done(function(data)
						{
							$("#popup" + columna + i).append(data);
							var poup = $("#popup" + columna + i).dxPopup(
							{
								showTitle: true,
								title: DevExpress.localization.formatMessage("Help"),
								visible: true,
								maxWidth: 500,
								maxHeight: 500,
								loseOnOutsideClick: true
							});
						});
				}
			});
		}
		
		$("#elem" + columna + i).dxNumberBox(
		{
			value: selectedvalue,
			min: valopt[0],
			max: valopt[1],
			showSpinButtons: true,
			onValueChanged: function(e)
			{
				var previousValue = e.previousValue;
				var newValue = e.value;
				if (e.value === null || typeof e.value === 'undefined') 
				{
					DevExpress.ui.notify("Empty required field", "error", 600);
					newValue = previousValue;
					//$("#elem" + columna + i).dxNumberBox("instance").option("value", previousValue);
				}
				
				var idactexp;
				// Event handling commands go here
				if (table == "nlaction")
				{
					actdict["act" + idaction][columna] = newValue;
					idactexp = idaction;
				}
				else if (table == "nlimport")
				{
					impdict["imp" + idimport][columna] = newValue;
					idactexp = idimport;
				}
				else
				{
					expdict["exp" + idexport][columna] = newValue;
					idactexp = idexport;
				}
				
				if((newValue != null) && (newValue != previousValue))
				{
					if(Number.isInteger(parseInt(newValue)))
					{
						updateTableValue(table, idactexp, columna, newValue);
					}
					else
					{
						DevExpress.ui.notify("Element is not an integer", "error", 600);
					}
				}
			}
		});
	}

	function setstringdiv(divintro, text, i, columna, options, selectedvalue, table, help)
	{
		var valopt = options.split(";");
		var helpdiv = "";
		if (help != "")
		{
			helpdiv = "<div id='icon" + columna + i + "'></div><div id='popup" + columna + i + "' style='display:none' ></div> ";
		}
		$("#" + divintro).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(text) + "</div><div class='dx-field-value'><div id='elem" + columna + i + "' style='float:none;display: inline-block; width:92%' ></div>" + helpdiv + "</div></div>");
		if (help != "")
		{
			$("#icon" + columna + i).dxButton(
			{
				icon: "help",
				type: "success",
				mode: "contained",
				onClick: function(e)
				{
					var jqxhr = $.ajax("help/" + help.replace(".html", "_" + getLocale() + ".html"))
						.done(function(data)
						{
							$("#popup" + columna + i).append(data);
							var poup = $("#popup" + columna + i).dxPopup(
							{
								showTitle: true,
								title: DevExpress.localization.formatMessage("Help"),
								visible: true,
								maxWidth: 500,
								maxHeight: 500,
								loseOnOutsideClick: true
							});
						});
				}
			});
		}
		
		var passmode = "Text";
		if (text == "Password:") passmode = "password";
		$("#elem" + columna + i).dxTextBox(
		{
			value: selectedvalue,
			mode: passmode,
			onValueChanged: function(e)
			{
				var newValue;
				var pulsed = columna + i;
				if ((pulsed === "param3200") || (pulsed === "param4200") || (pulsed === "param3201") || (pulsed === "param4201"))
				{
					newValue = encodeURIComponent(e.value.replaceAll('"', '').replaceAll("'", '').replace(/\\/g, '/'));
				}
				else
				{
					newValue = e.value.replaceAll('"', '').replaceAll("'", '').replace(/\\/g, '/');
				}
				var idactexp;
				// Event handling commands go here
				if (table == "nlaction")
				{
					actdict["act" + idaction][columna] = newValue;
					idactexp = idaction;
				}
				else if (table == "nlimport")
				{
					impdict["imp" + idimport][columna] = newValue;
					idactexp = idimport;
				}
				else
				{
					expdict["exp" + idexport][columna] = newValue;
					idactexp = idexport;
				}
				// Event handling commands go here
				if(((columna == "host") || (columna == "port") || ((columna == "param3") && (idactexp == 7)) || 
				   ((columna == "param2") && (idactexp == 8))) && (newValue == ""))
				{
					DevExpress.ui.notify("Empty required field", "error", 600);
				}
				else
				{
					updateTableValue(table, idactexp, columna, newValue);
				}
			}
		});
	}

	function sethttpdiv(divintro, text, i, columna, options, selectedvalue, table, help)
	{
		var valopt = options.split(";");
		var helpdiv = "";
		if (help != "")
		{
			helpdiv = "<div id='icon" + columna + i + "'></div><div id='popup" + columna + i + "' style='display:none' ></div> ";
		}
		$("#" + divintro).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(text) + "</div><div class='dx-field-value'><div id='elem" + columna + i + "' style='float:none;display: inline-block; width:92%' ></div>" + helpdiv + "</div></div>");
		if (help != "")
		{
			$("#icon" + columna + i).dxButton(
			{
				icon: "help",
				type: "success",
				mode: "contained",
				onClick: function(e)
				{
					var jqxhr = $.ajax("help/" + help.replace(".html", "_" + getLocale() + ".html"))
						.done(function(data)
						{
							$("#popup" + columna + i).append(data);
							var poup = $("#popup" + columna + i).dxPopup(
							{
								showTitle: true,
								title: DevExpress.localization.formatMessage("Help"),
								visible: true,
								maxWidth: 500,
								maxHeight: 500,
								loseOnOutsideClick: true
							});
						});
				}
			});
		}
		
		var passmode = "Text";
		if (text == "Password:") passmode = "password";
		$("#elem" + columna + i).dxTextBox(
		{
			value: selectedvalue,
			mode: "Text",
			onValueChanged: function(e)
			{
				var newValue = e.value;
				var idactexp;
				// Event handling commands go here
				if (table == "nlaction")
				{
					actdict["act" + idaction][columna] = newValue;
					idactexp = idaction;
				}
				else if (table == "nlimport")
				{
					impdict["imp" + idimport][columna] = newValue;
					idactexp = idimport;
				}
				else
				{
					expdict["exp" + idexport][columna] = newValue;
					idactexp = idexport;
				}

				updateTableValue(table, idactexp, columna, newValue);
			}
		});
	}

	function setfilediv(divintro, text, i, columna, options, selectedvalue, table, help)
	{
		var valopt = options.split(";");
		var helpdiv = "";
		if (help != "")
		{
			helpdiv = "<div id='icon" + columna + i + "'></div><div id='popup" + columna + i + "' style='display:none' ></div> ";
		}
		$("#" + divintro).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage(text) + "</div><div class='dx-field-value'><div id='elem" + columna + i + "' style='float:none;display: inline-block; width:92%' ></div>" + helpdiv + "</div></div>");
		if (help != "")
		{
			$("#icon" + columna + i).dxButton(
			{
				icon: "help",
				type: "success",
				mode: "contained",
				onClick: function(e)
				{
					var jqxhr = $.ajax("help/" + help.replace(".html", "_" + getLocale() + ".html"))
						.done(function(data)
						{
							$("#popup" + columna + i).append(data);
							var poup = $("#popup" + columna + i).dxPopup(
							{
								showTitle: true,
								title: DevExpress.localization.formatMessage("Help"),
								visible: true,
								maxWidth: 500,
								maxHeight: 500,
								loseOnOutsideClick: true
							});
						});
				}
			});
		}
		
		$("#elem" + columna + i).dxTextBox(
		{
			value: selectedvalue,
			onValueChanged: function(e)
			{
				var newValue = e.value.replaceAll('"', '').replaceAll("'", '').replace(/\\/g, '/').replace(/[=*+?^{}()|]/g, '').replace(/[\t]/g, '');
				var idactexp;
				// Event handling commands go here
				if (table == "nlaction")
				{
					actdict["act" + idaction][columna] = newValue;
					idactexp = idaction;
				}
				else if (table == "nlimport")
				{
					impdict["imp" + idimport][columna] = newValue;
					idactexp = idimport;
				}
				else
				{
					expdict["exp" + idexport][columna] = newValue;
					idactexp = idexport;
				}

				updateTableValue(table, idactexp, columna, newValue);
			}
		});
	}

	function validateFields(buttonInstance, validatorInstance, enteredValue) 
	{		
		// Validate the entered value using dxValidator
		var validationResults = validatorInstance.validate();
		var isFieldValid = validationResults.isValid;
		
		// Set the value to null if it is not a valid email
		if (!isFieldValid) {
			buttonInstance.option("value", "");
		}
		else
		{
			buttonInstance.option("value", enteredValue);
		}
	}

	function updateSelectedExportInterface(selectedexport)
	{
		if (selectedexport.exporttype == "LOCAL_EXPORT")
		{
			$("#elemparam1100").dxRadioGroup("instance").option("value", selectedexport.param1);
			$("#elemparam2100").dxRadioGroup("instance").option("value", selectedexport.param2);
		}
		
		if (selectedexport.exporttype == "LOCAL_DATA_EXPORT")
		{
			$("#elemparam1102").dxRadioGroup("instance").option("value", selectedexport.param1);
		}

		var exporttype;

		if (selectedexport.exporttype == "FTP_EXPORT") exporttype = "1";
		if (selectedexport.exporttype == "FTP_DATA_EXPORT") exporttype = "3";

		if (selectedexport.exporttype == "FTP_EXPORT" || selectedexport.exporttype == "FTP_DATA_EXPORT")
		{
			$("#elemhost10" + exporttype).dxTextBox("instance").option("value", selectedexport.host);
			$("#elemport10" + exporttype).dxNumberBox("instance").option("value", selectedexport.port);
			$("#elemparam110" + exporttype).dxRadioGroup("instance").option("value", selectedexport.param1);

			if (selectedexport.exporttype == "FTP_EXPORT")
			{
				loadingChBx = true;
				var searchEles = document.getElementById("elemparam210" + exporttype).children;
				for(var i = 0; i < searchEles.length; i++) {
					if(selectedexport.param2.includes(searchEles[i].getElementsByTagName('input')[0].name)){
						$("#elemparam210" + exporttype + "-" + i).dxCheckBox("instance").option("value", true);
					}else{
						$("#elemparam210" + exporttype + "-" + i).dxCheckBox("instance").option("value", false);
					}
				}
				loadingChBx = false;
			}

			$("#elemparam310" + exporttype).dxTextBox("instance").option("value", selectedexport.param3);
			$("#elemparam410" + exporttype).dxTextBox("instance").option("value", (selectedexport.param4));
			$("#elemparam510" + exporttype).dxTextBox("instance").option("value", (selectedexport.param5));
			$("#elemparam610" + exporttype).dxRadioGroup("instance").option("value", selectedexport.param6);
			$("#elemparam710" + exporttype).dxRadioGroup("instance").option("value", selectedexport.param7);
		}
	}

	function updateSelectedImportInterface(selectedimport)
	{
		if (selectedimport.importtype == "FTP_DATA_IMPORT")
		{
			$("#elemhost200").dxTextBox("instance").option("value", selectedimport.host);
			$("#elemport200").dxNumberBox("instance").option("value", selectedimport.port);
			$("#elemparam1200").dxRadioGroup("instance").option("value", selectedimport.param1);
			$("#elemparam2200").dxTextBox("instance").option("value", selectedimport.param2);
			$("#elemparam3200").dxTextBox("instance").option("value", decodeURIComponent(selectedimport.param3));
			$("#elemparam4200").dxTextBox("instance").option("value", decodeURIComponent(selectedimport.param4));
			$("#elemparam5200").dxRadioGroup("instance").option("value", selectedimport.param5);
			$("#elemparam6200").dxRadioGroup("instance").option("value", selectedimport.param6);
		}
		if (selectedimport.importtype == "SINCRO")
		{
			$("#elemhost201").dxTextBox("instance").option("value", selectedimport.host);
			$("#elemparam2201").dxTextBox("instance").option("value", selectedimport.param2);
			$("#elemparam3201").dxTextBox("instance").option("value", decodeURIComponent(selectedimport.param3));
			$("#elemparam4201").dxTextBox("instance").option("value", decodeURIComponent(selectedimport.param4));
		}
	}

	//Loads
	function loadactions(id, name_lista)
	{
		//esconder conditiondiv
		$("#conditiontitle").hide();
		$("#conditiondiv").hide();
		conditiondivabierto = true;
		
		$("#schedulertitle").removeClass('abierto');
		$("#schedulertitle").addClass('cerrado');
		$("#schedulertitle").show();
		$("#schedulerdiv").hide();
		schedulerdivabierto = false;

		var data = executeCGI(computerid, "select|table=nlaction|camp0=listid|comp0=equal|value0=" + id + "|maxvalues=20|sortdesc=id", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

		if(data != "error")
		{
			actdict = {};
			actions_listas = data;
			$('#actionlist').text(DevExpress.localization.formatMessage('Action for the list') + ': ' + name_lista + " (" + actions_listas.length + ")");
			actions.option("dataSource", actions_listas);
			$.each(data, function(i, item)
			{
				actdict["act" + item.id] = item;
			});
		}
	};

	//Loads
	function getNumberOfActionsScheduler(id)
	{
		//esconder conditiondiv
		$("#conditiontitle").hide();
		$("#conditiondiv").hide();
		conditiondivabierto = true;
		
		$("#schedulertitle").removeClass('abierto');
		$("#schedulertitle").addClass('cerrado');
		$("#schedulertitle").show();
		$("#schedulerdiv").hide();
		schedulerdivabierto = false;
		
		return executeCGI(computerid, "count|table=nlaction|camp0=listid|comp0=equal|value0=" + id + "|sortdesc=id", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
	};

	function loadexports(id, name_lista)
	{
		var data = executeCGI(computerid, "select|table=nlexport|camp0=listid|comp0=equal|value0=" + id + "|maxvalues=20|sortdesc=id", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

		if(data != "error")
		{
			expdict = {};
			exports_listas = data;
			$('#exportstitle').text(DevExpress.localization.formatMessage('Exports for the list') + ': ' + name_lista + " (" + exports_listas.length + ")");
			exports.option("dataSource", exports_listas);
			$.each(data, function(i, item)
			{
				expdict["exp" + item.id] = item;
			});
		}
	};

	function loadimports(id, name_lista)
	{
		var data = executeCGI(computerid, "select|table=nlimport|camp0=listid|comp0=equal|value0=" + id + "|maxvalues=20|sortdesc=id", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

		if(data != "error")
		{
			impdict = {};
			imports_listas = data;
			$('#importstitle').text(DevExpress.localization.formatMessage('Imports for the list') + ': ' + name_lista + " (" + imports_listas.length + ")");
			imports.option("dataSource", imports_listas);
			$.each(data, function(i, item)
			{
				impdict["imp" + item.id] = item;
			});
		}
	};
	
	function loadelemslist(id, name_lista)
	{	
		var num_registros_consulta = executeCGI(computerid, "count|table=nlelemlist|camp0=listid|comp0=equal|value0=" + id + "|sortdesc=id", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

		if (num_registros_consulta >= 0)
		{
			var data = executeCGI(computerid, "select|table=nlelemlist|camp0=listid|comp0=equal|value0=" + id + "|maxvalues=" + num_registros_consulta, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

			if(data != "error")
			{
				elem_listas = data;
				$('#plateslist').text(DevExpress.localization.formatMessage('List of the license plates') + ': ' + name_lista + " (" + elem_listas.length + ")");
				plates.option("dataSource", elem_listas);
			}
			else
			{
				console.log('something went wrong in loadelemlist');
			}
		}
	};

	function loadlists()
	{
		var data = executeCGI(computerid, "select|table=nllist|maxvalues=" + max_num_lists + "|sortasc=id", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

		if(data != "error")
		{
			vlists.option("dataSource", data);
		}
		else
		{
			console.log('something went wrong in loadlists');
		}
	}

	function updateConfidence(e, actualmin, actualmax, ismin)
	{
		var confstr;

		if(ismin == true)
		{
			confstr = "minconf";
			actualmin = e.value;
		}
		else
		{
			confstr = "maxconf";
			actualmax = e.value;
		}

		if (actualmin <= actualmax)
		{
			var newValue = e.value;
			if (newValue == null) newValue = e.previousValue;

			if(ismin == true)
			{
				actdict["act" + idaction].minconf = newValue;
			}
			else
			{
				actdict["act" + idaction].maxconf = newValue;
			}

			if(Number.isInteger(parseInt(newValue)))
			{
				var response = executeCGI(computerid, "update|table=nlaction|camp0=id|value0=" + idaction + "|camp1=listid|value1=" + id_lista + "|camp2=" + confstr + "|value2=" + newValue, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

				if(response != "error")
				{
					DevExpress.ui.notify("Data saved", "success", 600);
				}
				else
				{
					DevExpress.ui.notify("Data saving error", "error", 600);
				}
			}
			else
			{
				DevExpress.ui.notify("Element is not an integer", "error", 600);
			}
		}
		else
		{
			e.value = e.previousValue;
			if(ismin == true)
			{
				actualmin = e.previousValue;
			}
			else
			{
				actualmax = e.previousValue;
			}
			
			DevExpress.ui.notify(DevExpress.localization.formatMessage("Minimum Confidence shall be less or equal than Maximum Confidence"), "error", 1500);
		}

		if(ismin == true)
		{
			return actualmin;
		}
		else
		{
			return actualmax;
		}
	}

	function LoadConfidence(currentminconf, currentmaxconf)
	{
		var actualmin = 0;
		var actualmax = 100;

		//initialise minconf field
		$("#elemminconf").dxNumberBox(
		{
			value: currentminconf,
			min: 0,
			max: 100,
			showSpinButtons: true,
			onValueChanged: function(e)
			{
				actualmin = updateConfidence(e, actualmin, actualmax, true);
			}
		}).dxValidator(
		{
			validationRules: [{
				type: "custom",
				validationCallback: function(e)
				{
					actualmin = e.value;
					return ((actualmin <= actualmax) ? true : false);
				}
			}]
		});
	
		//initialise maxconf field
		$("#elemmaxconf").dxNumberBox(
		{
			value: currentmaxconf,
			min: 0,
			max: 100,
			showSpinButtons: true,
			onValueChanged: function(e)
			{
				actualmax = updateConfidence(e, actualmin, actualmax, false);
			}
		}).dxValidator(
		{
			validationRules: [{
				type: "custom",
				validationCallback: function(e)
				{
					actualmax = e.value;
					return ((actualmin <= actualmax) ? true : false);
				}
			}]
		});

		actualmin = currentminconf;
		actualmax = currentmaxconf;
	}
	
	function setCheckBoxClicked(elem, columna, i, j, name)
	{
		if (elem === "actions")
		{
			selected = selectedaction.actiontype;
		}
		else if (elem === "imports")
		{
			selected = selectedimport.importtype;
		}
		else
		{
			selected = selectedexport.exporttype;
		}
		if((selected == "SOCKET_CLIENT_ACTION") || (selected == "SOCKET_SERVER_ACTION") || (selected == "FTP_ACTION") || 
		   (selected == "HTTP_ACTION") || (selected == "TRIGGER_SERVER_ACTION") || (selected == "FTP_EXPORT"))
		{

			if(name == "NONE")
			{
				updated = false;
				$("#elem" + columna + i +"-"+ (j)).dxCheckBox("instance").option("value", true);
				$("#elem" + columna + i +"-"+ (j + 1)).dxCheckBox("instance").option("value", false);
				$("#elem" + columna + i +"-"+ (j + 2)).dxCheckBox("instance").option("value", false);
				if(selected == "HTTP_ACTION")
				{
					httpImgOldValue[0] = true;
					httpImgOldValue[1] = false;
					httpImgOldValue[2] = false;
				}
				if(selected == "FTP_ACTION")
				{
					ftpImgOldValue[0] = true;
					ftpImgOldValue[1] = false;
					ftpImgOldValue[2] = false;
				}
				if(selected == "FTP_EXPORT")
				{
					ftpExpImgOldValue[0] = true;
					ftpExpImgOldValue[1] = false;
					ftpExpImgOldValue[2] = false;
				}
			}
			if(name == "IMG_ORIG")
			{
				updated = false;
				$("#elem" + columna + i +"-"+ (j)).dxCheckBox("instance").option("value", true);
				$("#elem" + columna + i +"-"+ (j - 1)).dxCheckBox("instance").option("value", false);
				if(selected == "HTTP_ACTION")
				{
					httpImgOldValue[0] = false;
					httpImgOldValue[1] = true;
				}
				if(selected == "FTP_ACTION")
				{
					ftpImgOldValue[0] = false;
					ftpImgOldValue[1] = true;
				}
				if(selected == "FTP_EXPORT")
				{
					ftpExpImgOldValue[0] = false;
					ftpExpImgOldValue[1] = true;
				}
			}
			if(name == "IMG_CUT")
			{
				updated = false;
				$("#elem" + columna + i +"-"+ (j)).dxCheckBox("instance").option("value", true);
				$("#elem" + columna + i +"-"+ (j - 2)).dxCheckBox("instance").option("value", false);
				if(selected == "HTTP_ACTION")
				{
					httpImgOldValue[0] = false;
					httpImgOldValue[2] = true;
				}
				if(selected == "FTP_ACTION")
				{
					ftpImgOldValue[0] = false;
					ftpImgOldValue[2] = true;
				}
				if(selected == "FTP_EXPORT")
				{
					ftpExpImgOldValue[0] = false;
					ftpExpImgOldValue[2] = true;
				}
			}
			updated = true;
		}
		if(selected == "NETWORK_OPTIX")
		{
			if(name == "ALL")
			{
				updated = false;
				$("#elem" + columna + i +"-"+ (j)).dxCheckBox("instance").option("value", true);
				var searchEles = document.getElementById("elemparam323").children;
				for (let index = 1; index < searchEles.length; index++) 
				{
					$("#elem" + columna + i +"-"+ (j + index)).dxCheckBox("instance").option("value", false);
				}
			}
			else if((name == "CLASS") || (name == "SPEED") || (name == "COLOR") || (name == "MAKE"))
			{
				updated = false;
				$("#elem" + columna + i +"-"+ (j)).dxCheckBox("instance").option("value", true);
				$("#elem" + columna + i +"-"+ (0)).dxCheckBox("instance").option("value", false);
			}
			updated = true;
		}
		if(selected == "TWINCAMERA_ACTION")
		{
			if(name == "ALL")
			{

				updated = false;
				$("#elem" + columna + i +"-"+ (j)).dxCheckBox("instance").option("value", true);
				var searchEles = document.getElementById("elemparam321").children;
				for (let index = 1; index < searchEles.length; index++) 
				{
					$("#elem" + columna + i +"-"+ (j + index)).dxCheckBox("instance").option("value", false);
				}
			}
			else
			{
				updated = false;
				$("#elem" + columna + i +"-"+ (j)).dxCheckBox("instance").option("value", true);
				$("#elem" + columna + i +"-"+ (0)).dxCheckBox("instance").option("value", false);
			}
			updated = true;
		}
	}

	function setCheckBoxToRadioButton(elem, filter, columna)
	{
		if (elem === "actions")
		{
			selected = selectedaction.actiontype;
		}
		else if (elem === "imports")
		{
			selected = selectedimport.importtype;
		}
		else
		{
			selected = selectedexport.exporttype;
		}

		if(selected == "HTTP_ACTION")
		{
			if(columna == "param1")
			{
				if((filter == "GET") || (filter == "POST_PARAM"))
				{
					isDisable = true;
					$("#elemparam25-0").dxCheckBox("instance").option("disabled", true);
					$("#elemparam25-0").dxCheckBox("instance").option("value", false);
					$("#elemparam25-1").dxCheckBox("instance").option("disabled", true);
					$("#elemparam25-1").dxCheckBox("instance").option("value", false);
					$("#elemparam25-2").dxCheckBox("instance").option("disabled", true);
					$("#elemparam25-2").dxCheckBox("instance").option("value", false);
					isDisable = false;
					httpImgOldValue[0] = false;
					httpImgOldValue[1] = false;
					httpImgOldValue[2] = false;
				}
				else
				{
					$("#elemparam25-0").dxCheckBox("instance").option("disabled", false);
					$("#elemparam25-1").dxCheckBox("instance").option("disabled", false);
					$("#elemparam25-2").dxCheckBox("instance").option("disabled", false);
					if((httpImgOldValue[0] == false) && (httpImgOldValue[1] == false) && (httpImgOldValue[2] == false))
					{
						$("#elemparam25-0").dxCheckBox("instance").option("value", true);
					}
				}
				if((filter == "GET") || (filter == "POST"))
				{
					$("#elemparam45").dxTextBox("instance").option("disabled", true);
				}
				else
				{
					$("#elemparam45").dxTextBox("instance").option("disabled", false);
				}

				if(filter == "POST_PARAM")
				{
					$("#elemhost5").dxRadioGroup("instance").option("disabled", true);
				}
				else
				{
					$("#elemhost5").dxRadioGroup("instance").option("disabled", false);
				}
			}
		}

		if(selected == "FTP_ACTION")
		{
			if(columna == "param1")
			{
				if(filter == "IMAGE")
				{
					isDisable = true;
					$("#elemparam24-0").dxCheckBox("instance").option("value", false);
					$("#elemparam24-0").dxCheckBox("instance").option("disabled", true);
					isDisable = false;
					if((ftpImgOldValue[1] == false) && (ftpImgOldValue[2] == false))
					{
						$("#elemparam24-1").dxCheckBox("instance").option("value", true);
						ftpImgOldValue[1] = true;
					}
				}
				else
				{
					$("#elemparam24-0").dxCheckBox("instance").option("disabled", false);
				}
			}
		}
		
		if(selected == "TRIGGER_SERVER_ACTION")
		{
			if(columna == "param1")
			{
				if(filter == "SIMPLE")
				{
					isDisable = true;
					$("#elemparam29-0").dxCheckBox("instance").option("value", true);
					$("#elemparam29-1").dxCheckBox("instance").option("value", false);
					$("#elemparam29-1").dxCheckBox("instance").option("disabled", true);
					$("#elemparam29-2").dxCheckBox("instance").option("value", false);
					$("#elemparam29-2").dxCheckBox("instance").option("disabled", true);
					$("#elemparam49").dxTextBox("instance").option("disabled", false);
					$("#elemparam59").dxTextBox("instance").option("disabled", false);
					isDisable = false;
				}
				else
				{
					$("#elemparam29-1").dxCheckBox("instance").option("disabled", false);
					$("#elemparam29-2").dxCheckBox("instance").option("disabled", false);
					$("#elemparam49").dxTextBox("instance").option("disabled", true);
					$("#elemparam59").dxTextBox("instance").option("disabled", true);
				}
			}
		}
	}

	function getNumbersOfAllLists()
	{
		currentNumberOfLists = getNumberOfLists();
		if (currentNumberOfLists == max_num_lists)
		{
			showaddrow = false
		}

		currentNumberOfActions = getNumberOfActions();
		if (currentNumberOfActions == MAX_TOTAL_ACTIONS)
		{
			showaddrowActions = false
		}

		currentNumberOfExports = getNumberOfExports();
		if (currentNumberOfExports == MAX_TOTAL_EXPORTS)
		{
			showaddrowExports = false
		}

		currentNumberOfImports = getNumberOfImports();
		if (currentNumberOfImports == MAX_TOTAL_IMPORTS)
		{
			showaddrowImports = false
		}
	}

	function createPlatesGrid()
	{
		var plates = $("#gridContainer2").dxDataGrid(
		{
			dataSource: elem_listas,
			showBorders: true,
			showRowLines: true,
			keyExpr: "id",
			hoverStateEnabled: true,
			paging:
			{
				pageSize: 10
			},
			searchPanel:
			{
				visible: true,
				width: 240,
				placeholder: DevExpress.localization.formatMessage("Search...")
			},
			pager:
			{
				showPageSizeSelector: true,
				allowedPageSizes: [5, 10, 20],
				showInfo: true
			},
			columns: [
			{
				dataField: "numberplate",
				caption: DevExpress.localization.formatMessage("Plate"),
				width: "15%",
				validationRules: [
				{
					type: "required"
				}]
			},
			{
				width: "10%",
				dataField: "description",
				caption: DevExpress.localization.formatMessage("Description")
			},
			{
				width: "20%",
				dataField: "timestamp",
				caption: DevExpress.localization.formatMessage("Insert Date"),
				dataType: "date",
				format: "dd/MM/yyyy HH:mm:ss",
				allowEditing: false
			},
			{
				width: "20%",
				dataField: "startvaliditydate",
				caption: DevExpress.localization.formatMessage("Start validity date"),
				dataType: "datetime",
				format: "dd/MM/yyyy HH:mm:ss",
				allowEditing: true,
			},
			{
				width: "20%",
				dataField: "endvaliditydate",
				caption: DevExpress.localization.formatMessage("End validity date"),
				dataType: "datetime",
				format: "dd/MM/yyyy HH:mm:ss",
				allowEditing: true,
			}],
			editing:
			{
				mode: "row",
				allowUpdating: true,
				allowDeleting: true,
				texts:
				{
					confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the plate from list?")
				},
				allowAdding: true
			},
			onExporting: function(e) {
				e.cancel = isEmptyPlatesList(id_lista);
			},
			onRowValidating: function(e)
			{
				var startdate;
				var enddate;
				var plt = "invalid";
				var rowIndex = plates.getRowIndexByKey(e.key)
				if (typeof e.newData.numberplate !== 'undefined')
				{
					plt = e.newData.numberplate;

					var response = executeCGI(computerid, "select|table=nlelemlist|maxvalues=1|camp0=numberplate|value0=" + plt + "|comp0=equal|camp1=listid|comp1=equal|value1=" + id_lista, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

					if(response != "error")
					{
						if (response.length > 0)
						{
							e.isValid = false;
							plates.getCellElement(rowIndex, "numberplate").find("input").css("background", "rgba(255, 0, 0, 0.5)");
							DevExpress.ui.notify("The plate already exist at list", "error", 1500);
						}
					}
				}

				d2 = getimeCamera();

				if (typeof e.newData.startvaliditydate !== 'undefined')
				{
					startdate = new Date(e.newData.startvaliditydate);
				}
				else if (typeof e.oldData !== 'undefined' && typeof e.oldData.startvaliditydate == 'undefined')
				{
					startdate = new Date(e.oldData.startvaliditydate);
				}
				if (startdate !== 'undefined')
				{
					var nowdate = d2;
					//nowdate.setMinutes(nowdate.getMinutes() - 10);
					if (startdate < nowdate)
					{
						e.isValid = false;
						plates.getCellElement(rowIndex, "startvaliditydate").find("input").css("background", "rgba(255, 0, 0, 0.5)");
						DevExpress.ui.notify(DevExpress.localization.formatMessage("The start validity date can not be lower than actual date"), "error", 1500);
					}
				}
				if (typeof e.newData.endvaliditydate !== 'undefined')
				{
					enddate = new Date(e.newData.endvaliditydate);
				}
				else if (typeof e.oldData !== 'undefined' && typeof e.oldData.endvaliditydate == 'undefined')
				{
					enddate = new Date(e.oldData.endvaliditydate);
				}
				if (enddate !== 'undefined')
				{
					if (enddate < d2)
					{
						e.isValid = false;
						plates.getCellElement(rowIndex, "endvaliditydate").find("input").css("background", "rgba(255, 0, 0, 0.5)");
						DevExpress.ui.notify(DevExpress.localization.formatMessage("The end validity date can not be lower than actual date"), "error", 1500);
					}
				}
				if (enddate !== 'undefined' && startdate !== 'undefined')
				{
					if (enddate < startdate)
					{
						e.isValid = false;
						plates.getCellElement(rowIndex, "endvaliditydate").find("input").css("background", "rgba(255, 0, 0, 0.5)");
						plates.getCellElement(rowIndex, "startvaliditydate").find("input").css("background", "rgba(255, 0, 0, 0.5)");
						DevExpress.ui.notify(DevExpress.localization.formatMessage("The end validity date can not be lower than start validity date"), "error", 1500);
					}
				}
			},
			"export":
			{
				enabled: true,
				allowExportSelectedData: false,
				printingEnabled: true,
			},
			onRowUpdating: function(e)
			{
				var numberplate;
				var description;
				var startdate;
				var enddate;
				if (typeof e.newData.numberplate !== 'undefined')
				{
					numberplate = e.newData.numberplate;
				}
				else
				{
					numberplate = e.oldData.numberplate;
				}
				if (typeof e.newData.description !== 'undefined')
				{
					description = e.newData.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
				}
				else
				{
					description = e.oldData.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
				}
				if (typeof e.newData.startvaliditydate !== 'undefined')
				{
					startdate = getStringNormalDate(new Date(e.newData.startvaliditydate));
				}
				else
				{
					startdate = getStringNormalDate(new Date(e.oldData.startvaliditydate));
				}
				if (typeof e.newData.endvaliditydate !== 'undefined')
				{
					enddate = getStringNormalDate(new Date(e.newData.endvaliditydate));
				}
				else
				{
					enddate = getStringNormalDate(new Date(e.oldData.endvaliditydate));
				}
				description = encodeURIComponent(description);

				executeCGI(computerid, "update|table=nlelemlist|camp0=id|value0=" + e.oldData.id + "|camp1=listid|value1=" + e.oldData.listid + "|camp2=numberplate|value2=" + numberplate.trim().toUpperCase() + "|camp3=description|value3=" + description + "|camp4=startvaliditydate|value4=" + startdate + "|camp5=endvaliditydate|value5=" + enddate, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
			},
			onRowInserting: function(e)
			{
				var insertdate = getStringNormalDate(getimeCamera());
				var starvaliditydate;
				var endvaliditydate;
				var descrip;

				d2 = getimeCamera();

				if (typeof e.data.startvaliditydate !== 'undefined')
				{
					starvaliditydate = getStringNormalDate(new Date(e.data.startvaliditydate));
				}
				else
				{
					starvaliditydate = getStringNormalDate(d2);
				}
				if (typeof e.data.endvaliditydate !== 'undefined')
				{
					endvaliditydate = getStringNormalDate(new Date(e.data.endvaliditydate));
				}
				else
				{
					endvaliditydate = "3000-01-01T00:00:00.000";
				}
				if (typeof e.data.description !== 'undefined')
				{
					descrip = e.data.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
				}
				else
				{
					descrip = "";
				}
				descrip = encodeURIComponent(descrip);

				var response = executeCGI(computerid, "insert|table=nlelemlist|camp0=id|value0=-1|camp1=listid|value1=" + id_lista + "|camp2=numberplate|value2=" + e.data.numberplate.trim().toUpperCase() + "|camp3=description|value3=" + descrip + "|camp4=startvaliditydate|value4=" + starvaliditydate + "|camp5=endvaliditydate|value5=" + endvaliditydate + "|camp6=timestamp|value6=" + insertdate + "|camp7=estado|value7=0|camp8=sendserver|value8=0|camp9=dateserver|value9=" + insertdate, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

				if(response == "Error en insert\r\n")
				{
					DevExpress.ui.notify("Error at insert", "error", 2000);
				}

				loadelemslist(id_lista, name_lista);
				checkExportPlateButton(id_lista);
				checkExportButtons(id_lista);
			},
			onRowRemoving: function(e)
			{
				executeCGI(computerid, "delete|table=nlelemlist|camp0=id|comp0=equal|value0=" + e.key + "|camp1=listid|comp1=equal|value1=" + id_lista, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

				loadelemslist(id_lista, name_lista);
				checkExportPlateButton(id_lista);
				checkExportButtons(id_lista);
			}
		}).dxDataGrid("instance");

		return plates;
	}

	function setPropertiesTexts()
	{
		$("#listtypes").text(DevExpress.localization.formatMessage("List types"));
		$("#schedulertitle").text(DevExpress.localization.formatMessage("Scheduler"));
		$("#lactprop").text(DevExpress.localization.formatMessage("Action properties"));
		$("#lbExportprop").text(DevExpress.localization.formatMessage("Export properties"));
		$("#lbImportprop").text(DevExpress.localization.formatMessage("Import properties"));
		$("#minconflabel").text(DevExpress.localization.formatMessage('Minimum Confidence:'));
		$("#maxconflabel").text(DevExpress.localization.formatMessage('Maximum Confidence:'));
		$("#conditiontitle").text(DevExpress.localization.formatMessage('Action Conditions'));
	}

	function createListsGrid()
	{
		var vlists = $("#gridContainer").dxDataGrid(
			{
				dataSource: listas,
				showBorders: true,
				showRowLines: true,
				keyExpr: "id",
				hoverStateEnabled: true,
				paging:
				{
					pageSize: 10
				},
				searchPanel:
				{
					visible: true,
					width: 240,
					placeholder: DevExpress.localization.formatMessage("Search...")
				},
				pager:
				{
					showPageSizeSelector: true,
					allowedPageSizes: [5, 10, 20],
					showInfo: true
				},
				columns: [
				{
					dataField: "id",
					caption: DevExpress.localization.formatMessage("ID"),
					width: 50,
					allowEditing: false
				},
				{
					dataField: "description",
					caption: DevExpress.localization.formatMessage("Name"),
					validationRules: [
					{
						type: "required"
					}]
				},
				{
					dataField: "levenshteindist",
					caption: DevExpress.localization.formatMessage("Levenshtein distance"),
					dataType: "number",
					width: 300,
					validationRules: [
					{
						type: "required"
					}]
				}],
				editing:
				{
					mode: "row",
					allowUpdating: true,
					allowDeleting: true,
					texts:
					{
						confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the list?")
					},
					allowAdding: true
				},
				"export":
				{
					enabled: true,
					allowExportSelectedData: false,
					printingEnabled: true,
				},
				selection:
				{
					mode: "single"
				},
				onInitNewRow: function(e)
				{ 
					console.log("Entro add list");
				},  
				onSelectionChanged: function(selectedItems)
				{
					var data = selectedItems.selectedRowsData[0];
					if (data)
					{
						plates.filter(["listid", "=", data.id]);
						if (data.id == -1)
						{
							$("#plateslistdiv").hide();
							$("#imports").hide();
							$("#importsdiv").hide();
							$("#importsbuttons").show();
						}
						else if (data.id == -2)
						{
							$("#plateslistdiv").hide();
							$("#imports").hide();
							$("#importsdiv").show();
							$("#importsbuttons").show();
						}
						else
						{
							$("#plateslistdiv").show();
							$("#imports").show();
							$("#importsdiv").show();
							$("#importsbuttons").show();
						}
						actions.deselectRows(idaction);
						id_lista = data.id;
						importbutton.option("uploadUrl", getUrlCgi() + "computerid=" + computerid + "&oper=importlistblob&listid=" + id_lista + "&delete=" + delete_list + localStorage.getItem("TOKEN"));
						importactionbutton.option("uploadUrl", getUrlCgi() + "computerid=" + computerid + "&oper=importlistactionblob&listid=" + id_lista + "&delete=" + delete_action_list + localStorage.getItem("TOKEN"));
						name_lista = data.description;
						loadelemslist(id_lista, name_lista);
						loadactions(id_lista, name_lista);
						loadexports(id_lista, name_lista);
						loadimports(id_lista, name_lista);
		
						checkExportActionButtons(id_lista);
						checkExportButtons(id_lista);
		
						$("#actions").hide();
						$("#exports").hide();
						$("#imports").hide();
					}
				},
				onRowUpdating: function(e)
				{
					var description;
					if (typeof e.newData.description !== 'undefined')
					{
						description = e.newData.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
					}
					else
					{
						description = e.oldData.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
					}
					var levenshteindist;
					if (typeof e.newData.levenshteindist !== 'undefined')
					{
						levenshteindist = e.newData.levenshteindist;
					}
					else
					{
						levenshteindist = e.oldData.levenshteindist;
					}

					executeCGI(computerid, "update|table=nllist|camp0=id|value0=" + e.oldData.id + "|camp1=description|value1=" + description + "|camp2=levenshteindist|value2=" + levenshteindist, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
					loadelemslist(id_lista, description);
					loadactions(id_lista, description);
					loadexports(id_lista, description);
					loadimports(id_lista, description);
				},	
				onRowInserting: function(e)
				{
					executeCGIAsync(computerid, "insert|table=nllist|camp0=id|value0=-1|camp1=sendserver|value1=0|camp2=dateserver|value2=20180101000000|camp3=reserve|value3=|camp4=description|value4=" + e.data.description.replaceAll('"', '').replaceAll('\'', '') + "|camp5=levenshteindist|value5=" + e.data.levenshteindist, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false, loadlists);
					var response = getAsyncResponse();
					if(response != "error")
					{
						if(response.indexOf("Max elems") == -1)
						{
							DevExpress.ui.notify("List added succesfully", "success", 1000);
						}
						else
						{
							DevExpress.ui.notify("Maximum number of lists limited to" + response.substr(10), "error", 1000);
							e.element.find(".dx-datagrid-addrow-button").hide();
						}
					}
				},
				onRowRemoving: function(e)
				{
					if (e.key < 0)
					{
						DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("This list can not be deleted"));
						e.component.cancelEditData();
						e.cancel = true;
					}
					else
					{
						executeCGI(computerid, "delete&table=nllist|camp0=id|comp0=equal|value0=" + e.key, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
						executeCGI(computerid, "delete|table=nlelemlist|camp0=listid|comp0=equal|value0=" + e.key, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
						executeCGI(computerid, "delete|table=nlaction|camp0=listid|comp0=equal|value0=" + e.key, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
						executeCGI(computerid, "delete|table=nlexport|camp0=listid|comp0=equal|value0=" + e.key, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
						executeCGI(computerid, "delete|table=nlimport|camp0=listid|comp0=equal|value0=" + e.key, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
			
						id_lista = -1;
						loadelemslist(id_lista,"not in list");
						loadactions(id_lista, "not in list");
						loadexports(id_lista, "not in list");
						loadimports(id_lista, "not in list");
						vlists.selectRows([-1]);
		
						currentNumberOfLists--;
						e.element.find(".dx-datagrid-addrow-button").show();
						showaddrow = true;
					}
				},
				onRowInserted: function(e)
				{
					currentNumberOfLists++;
					var currentNumberOfListsInBBDD = getNumberOfLists();
					
					if (currentNumberOfListsInBBDD != currentNumberOfLists)
					{
						currentNumberOfListsInBBDD = getNumberOfLists();
					}
		
					if(currentNumberOfListsInBBDD == max_num_lists)
					{
						e.element.find(".dx-datagrid-addrow-button").hide();
					}
				},
				onToolbarPreparing: function(e)
				{
					let toolbarItems = e.toolbarOptions.items;
					toolbarItems.forEach(function(item)
					{
						if (item.name === "addRowButton")
						{
							item.visible = showaddrow;
						}
					});
				}
			}).dxDataGrid("instance");

		return vlists;
	}

	function createActionsGrid()
	{
		var actions = $("#gridContainer3").dxDataGrid(
		{
			dataSource: actions_listas,
			showBorders: true,
			showRowLines: true,
			keyExpr: "id",
			hoverStateEnabled: true,
			searchPanel:
			{
				visible: true,
				width: 240,
				placeholder: DevExpress.localization.formatMessage("Search...")
			},
			columns: [
			{
				dataField: "id",
				caption: "ID",
				width: "10%",
				allowEditing: false
			},
			{
				width: "30%",
				dataField: "description",
				caption: DevExpress.localization.formatMessage("Description"),
				validationRules: [
				{
					type: "required"
				}]
			},
			{
				width: "20%",
				dataField: "actiontype",
				caption: DevExpress.localization.formatMessage("Action type"),
				validationRules: [
				{
					type: "required"
				}],
				lookup:
				{
					dataSource: optionactions,
					displayExpr: "description",
					valueExpr: "id"
				}
			},
			{
				width: "20%",
				dataField: "enabled",
				caption: DevExpress.localization.formatMessage("Active"),
				validationRules: [
				{
					type: "required"
				}],
				lookup:
				{
					dataSource: enabledarray,
					displayExpr: "description",
					valueExpr: "id"
				}
			}],
			editing:
			{
				mode: "row",
				allowUpdating: true,
				allowDeleting: true,
				texts:
				{
					confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the action from list?")
				},
				allowAdding: true
			},
			onToolbarPreparing: function(e)
			{
				let toolbarItemsActions = e.toolbarOptions.items;
				toolbarItemsActions.forEach(function(item)
				{
					if (item.name === "addRowButton")
					{
						item.visible = showaddrowActions;
					}
				});
			},
			onInitNewRow: function(e)
			{ 
				var count = getNumberOfActionsScheduler(id_lista);
				//console.log(count);
					
				if(DEFINE_INTERFACE == "VICON"){
					if(optionactions.filter(function(e2){return e2.id === "VALERUS"}).length > 0)
						e.data.actiontype = "VALERUS";
				}
			},  
			onRowUpdating: function(e)
			{
				var description;
				var active;
				var type;
				idaction = e.oldData.id;
				if (typeof e.newData.description !== 'undefined')
				{
					description = e.newData.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
				}
				else
				{
					description = e.oldData.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
				}
				if (typeof e.newData.enabled !== 'undefined')
				{
					active = e.newData.enabled;
				}
				else
				{
					active = e.oldData.enabled;
				}
				if (typeof e.newData.actiontype !== 'undefined')
				{
					type = e.newData.actiontype;
					//change groupbox to selected
					$.each(optionactions, function(i, item)
					{
						$("#" + item.id).hide();
					});
					$("#" + type).show();
					actdict["act" + idaction].actiontype = type;
					actdict["act" + idaction].host = actdefaultdict[type].host_default;
					actdict["act" + idaction].port = actdefaultdict[type].port_default;
					actdict["act" + idaction].param1 = actdefaultdict[type].param1_default;
					actdict["act" + idaction].param2 = actdefaultdict[type].param2_default;
					actdict["act" + idaction].param3 = actdefaultdict[type].param3_default;
					actdict["act" + idaction].param4 = actdefaultdict[type].param4_default;
					actdict["act" + idaction].param5 = actdefaultdict[type].param5_default;
					actdict["act" + idaction].param6 = actdefaultdict[type].param6_default;
					actdict["act" + idaction].param7 = actdefaultdict[type].param7_default;
					actdict["act" + idaction].param8 = actdefaultdict[type].param8_default;

					executeCGI(computerid, "update|table=nlaction|camp0=id|value0=" + idaction + "|camp1=host|value1=" + actdefaultdict[type].host_default + "|camp2=port|value2=" + actdefaultdict[type].port_default + "|camp3=param1|value3=" + actdefaultdict[type].param1_default + "|camp4=param2|value4=" + actdefaultdict[type].param2_default + "|camp5=actiontype|value5=" + type + "|camp6=param3|value6=" + actdefaultdict[type].param3_default + "|camp7=param4|value7=" + actdefaultdict[type].param4_default + "|camp8=param5|value8=" + actdefaultdict[type].param5_default + "|camp9=param6|value9=" + actdefaultdict[type].param6_default + "|camp10=param7|value10=" + actdefaultdict[type].param7_default + "|camp11=param8|value11=" + actdefaultdict[type].param8_default, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
				}
				else
				{
					type = e.oldData.actiontype;
				}

				executeCGI(computerid, "update|table=nlaction|camp0=id|value0=" + e.oldData.id + "|camp1=listid|value1=" + e.oldData.listid + "|camp2=description|value2=" + description + "|camp3=enabled|value3=" + active + "|camp4=actiontype|value4=" + type, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
			},
			onRowInserting: function(e)
			{
				var cmdInsert = "";
				cmdInsert += "insert|table=nlaction|camp0=id|value0=-1|camp1=sendserver|value1=0|camp2=dateserver|value2=20180101T000000|loglevel=debug" + localStorage.getItem("TOKEN");

				cmdInsert += "|camp3=reserve|value3=";
				cmdInsert += "|camp4=initdate|value4=20000101T000000";
				cmdInsert += "|camp5=enddate|value5=30000101T000000";
				cmdInsert += "|camp6=sunday|value6=111111111111111111111111";
				cmdInsert += "|camp7=monday|value7=111111111111111111111111";
				cmdInsert += "|camp8=tuesday|value8=111111111111111111111111";
				cmdInsert += "|camp9=wednesday|value9=111111111111111111111111";
				cmdInsert += "|camp10=thursday|value10=111111111111111111111111";
				cmdInsert += "|camp11=friday|value11=111111111111111111111111";
				cmdInsert += "|camp12=saturday|value12=111111111111111111111111";
				cmdInsert += "|camp13=listid|value13=" + id_lista;
				cmdInsert += "|camp14=description|value14=" + e.data.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
				cmdInsert += "|camp15=actiontype|value15=" + e.data.actiontype;
				cmdInsert += "|camp16=host|value16=" + actdefaultdict[e.data.actiontype].host_default;
				cmdInsert += "|camp17=port|value17=" + actdefaultdict[e.data.actiontype].port_default;
				cmdInsert += "|camp18=param1|value18=" + actdefaultdict[e.data.actiontype].param1_default;
				cmdInsert += "|camp19=param2|value19=" + actdefaultdict[e.data.actiontype].param2_default;
				cmdInsert += "|camp20=param3|value20=" + actdefaultdict[e.data.actiontype].param3_default;
				cmdInsert += "|camp21=param4|value21=" + actdefaultdict[e.data.actiontype].param4_default;
				cmdInsert += "|camp22=param5|value22=" + actdefaultdict[e.data.actiontype].param5_default;
				cmdInsert += "|camp23=param6|value23=" + actdefaultdict[e.data.actiontype].param6_default;
				cmdInsert += "|camp24=param7|value24=" + actdefaultdict[e.data.actiontype].param7_default;
				cmdInsert += "|camp25=param8|value25=" + actdefaultdict[e.data.actiontype].param8_default;
				cmdInsert += "|camp26=enabled|value26=" + e.data.enabled;
				cmdInsert += "|camp27=minconf|value27=0";
				cmdInsert += "|camp28=maxconf|value28=100";	


				if(DEFINE_INTERFACE == "VIVOTEK")
				{
					var baseURLInsert = pathcgi + "cgi-bin/vparcgi.cgi";
					cmdInsert = cmdInsert.replace(/\|/g, "&");
					var urlinsert = "computerid=" + computerid + "&oper=";
					urlinsert += cmdInsert;

					//console.log("baseURLInsert "+baseURLInsert);
					//console.log("urlinsert "+urlinsert);
					var jqxhr = $.ajax({
					    type: "POST",
					    url: baseURLInsert, 
					    data: urlinsert, 
						async: true,
					    success:function(datos)
						{ 
							var response = getAsyncResponse();
							if(response != "error")
							{
								loadactions(id_lista, name_lista);
							}
					    },
					    dataType: "text"
					})					
				}
				else
				{
					executeCGIAsync(computerid, cmdInsert, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false, 
					function(){ loadactions(id_lista, name_lista) });
				}
			},
			onRowRemoving: function(e)
			{
				var actionselected = "";
				if(selectedaction != undefined)
				{
					actionselected = selectedaction.actiontype;
				}
				if((currentNumberOfActions == 2) && (actionselected != e.data.actiontype))
				{
					$("#actions").show();
				}
				else
				{
					$("#actions").hide();
				}

				var cmdDelete = "";
				cmdDelete += "delete|table=nlaction|camp0=id|comp0=equal|value0=" + e.key + "|camp1=listid|comp1=equal|value1=" + id_lista;

				executeCGI(computerid, cmdDelete, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);

				loadactions(id_lista, name_lista);
				currentNumberOfActions--;
				e.element.find(".dx-datagrid-addrow-button").show();
				showaddrowActions = true;
				var repaint = $("#gridContainer3").dxDataGrid("repaint");
				checkExportActionButtons(id_lista);
				
			},
			onRowInserted: function(e)
			{
				currentNumberOfActions++;
				var currentNumberOfActionsInBBDD = getNumberOfActions();
				
				if (currentNumberOfActionsInBBDD != currentNumberOfActions)
				{
					currentNumberOfActionsInBBDD = getNumberOfActions();
				}

				if(currentNumberOfActionsInBBDD == MAX_TOTAL_ACTIONS)
				{
					e.element.find(".dx-datagrid-addrow-button").hide();
					DevExpress.ui.notify("Reached maximum number of Actions", "success", 1000);
				}

				checkExportActionButtons(id_lista);
			},
			selection:
			{
				mode: "single"
			},
			onSelectionChanged: function(selectedItems)
			{
				var data = selectedItems.selectedRowsData[0];
				if (data)
				{
					idaction = data.id;
					selectedaction = actdict["act" + idaction];
					$("#actions").show();
					$.each(optionactions, function(i, item)
					{
						$("#" + item.id).hide();
					});

					//mostrar conditiontitle
					$("#conditiontitle").show();
					$("#conditiondiv").show()

					//load min and max conf fields:
					LoadConfidence(actdict["act" + idaction].minconf, actdict["act" + idaction].maxconf);

					$("#" + selectedaction.actiontype).show();
					$("#scheduler").find(".reservation").remove();
					var $rsvns = getreservationscheduler(0, selectedaction.sunday);
					for (i = 0; i < $rsvns.length; i++)
					{
						$(".rsvn-container").append($rsvns[i]);
					}
					var $rsvns1 = getreservationscheduler(1, selectedaction.monday);
					for (i = 0; i < $rsvns1.length; i++)
					{
						$(".rsvn-container").append($rsvns1[i]);
					}
					var $rsvns2 = getreservationscheduler(2, selectedaction.tuesday);
					for (i = 0; i < $rsvns2.length; i++)
					{
						$(".rsvn-container").append($rsvns2[i]);
					}
					var $rsvns3 = getreservationscheduler(3, selectedaction.wednesday);
					for (i = 0; i < $rsvns3.length; i++)
					{
						$(".rsvn-container").append($rsvns3[i]);
					}
					var $rsvns4 = getreservationscheduler(4, selectedaction.thursday);
					for (i = 0; i < $rsvns4.length; i++)
					{
						$(".rsvn-container").append($rsvns4[i]);
					}
					var $rsvns5 = getreservationscheduler(5, selectedaction.friday);
					for (i = 0; i < $rsvns5.length; i++)
					{
						$(".rsvn-container").append($rsvns5[i]);
					}
					var $rsvns6 = getreservationscheduler(6, selectedaction.saturday);
					for (i = 0; i < $rsvns6.length; i++)
					{
						$(".rsvn-container").append($rsvns6[i]);
					}
					if (selectedaction.actiontype == "SOCKET_CLIENT_ACTION")
					{
						$("#elemhost0").dxTextBox("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport0").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam10").dxRadioGroup("instance").option("value", selectedaction.param1);
						loadingChBx = true;
						var searchEles = document.getElementById("elemparam20").children;
						for(var i = 0; i < searchEles.length; i++) {
							if(selectedaction.param2.includes(searchEles[i].getElementsByTagName('input')[0].name)){
								$("#elemparam20-"+i).dxCheckBox("instance").option("value", true);
							}else{
								$("#elemparam20-"+i).dxCheckBox("instance").option("value", false);
							}
						}
						loadingChBx = false;
					}
					if (selectedaction.actiontype == "SOCKET_SERVER_ACTION")
					{
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport1").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam11").dxRadioGroup("instance").option("value", selectedaction.param1);
						loadingChBx = true;
						var searchEles = document.getElementById("elemparam21").children;
						for(var i = 0; i < searchEles.length; i++) {
							if(selectedaction.param2.includes(searchEles[i].getElementsByTagName('input')[0].name)){
								$("#elemparam21-"+i).dxCheckBox("instance").option("value", true);
							}else{
								$("#elemparam21-"+i).dxCheckBox("instance").option("value", false);
							}
						}
						loadingChBx = false;
					}
					if (selectedaction.actiontype == "ONVIF_EVENT_ACTION")
					{
						$("#elemparam12").dxRadioGroup("instance").option("value", selectedaction.param1);
					}
					if (selectedaction.actiontype == "IO_ACTION")
					{
						$("#elemparam13").dxRadioGroup("instance").option("value", selectedaction.param1);
						if (DEFINE_INTERFACE != "VICON")
						{
							if (selectedaction.param2 == "null") selectedaction.param2 = 1;
							$("#elemparam23").dxNumberBox("instance").option("value", selectedaction.param2);
						}
						if (selectedaction.param3 == "null") selectedaction.param3 = 1;
						$("#elemparam33").dxNumberBox("instance").option("value", selectedaction.param3);
						if (DEFINE_INTERFACE == "VIVOTEK" || DEFINE_INTERFACE == "VIVOTEK_CV25" || DEFINE_INTERFACE == "HANWHA")
						{
							if (selectedaction.param4 == "null") selectedaction.param4 = 1;
							$("#elemparam43").dxNumberBox("instance").option("value", selectedaction.param4);
						}
					}
					if (selectedaction.actiontype == "FTP_ACTION")
					{
						$("#elemhost4").dxTextBox("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport4").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam14").dxRadioGroup("instance").option("value", selectedaction.param1);
						loadingChBx = true;
						var searchEles = document.getElementById("elemparam24").children;
						for(var i = 0; i < searchEles.length; i++) {
							if(selectedaction.param2.includes(searchEles[i].getElementsByTagName('input')[0].name)){
								$("#elemparam24-"+i).dxCheckBox("instance").option("value", true);
							}else{
								$("#elemparam24-"+i).dxCheckBox("instance").option("value", false);
							}
						}
						loadingChBx = false;
						$("#elemparam34").dxTextBox("instance").option("value", selectedaction.param3);
						$("#elemparam44").dxTextBox("instance").option("value", selectedaction.param4);
						$("#elemparam54").dxTextBox("instance").option("value", selectedaction.param5);
						$("#elemparam64").dxRadioGroup("instance").option("value", selectedaction.param6);
						$("#elemparam74").dxRadioGroup("instance").option("value", selectedaction.param7);
					}
					if (selectedaction.actiontype == "HTTP_ACTION")
					{
						$("#elemhost5").dxRadioGroup("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = "NONE";
						$("#elemport5").dxRadioGroup("instance").option("value", selectedaction.port);
						$("#elemparam15").dxRadioGroup("instance").option("value", selectedaction.param1);
						setCheckBoxToRadioButton("actions", selectedaction.param1,"param1");
						loadingChBx = true;
						var searchEles = document.getElementById("elemparam25").children;
						for(var i = 0; i < searchEles.length; i++) {
							if(selectedaction.param2.includes(searchEles[i].getElementsByTagName('input')[0].name)){
								$("#elemparam25-"+i).dxCheckBox("instance").option("value", true);
							}else{
								$("#elemparam25-"+i).dxCheckBox("instance").option("value", false);
							}
						}
						loadingChBx = false;
						$("#elemparam35").dxTextBox("instance").option("value", selectedaction.param3);
						$("#elemparam45").dxTextBox("instance").option("value", selectedaction.param4);
						$("#elemparam55").dxTextBox("instance").option("value", selectedaction.param5);
						$("#elemparam65").dxTextBox("instance").option("value", selectedaction.param6);
						$("#elemparam75").dxRadioGroup("instance").option("value", selectedaction.param7);
					}
					if (selectedaction.actiontype == "MILESTONE")
					{
						$("#elemhost6").dxTextBox("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport6").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam16").dxRadioGroup("instance").option("value", selectedaction.param1);
						$("#elemparam26").dxTextBox("instance").option("value", selectedaction.param2);
						$("#elemparam36").dxTextBox("instance").option("value", selectedaction.param3);
					}
					if (selectedaction.actiontype == "WIEGAND")
					{
						$("#elemhost7").dxTextBox("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport7").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam17").dxRadioGroup("instance").option("value", selectedaction.param1);
						$("#elemparam27").dxRadioGroup("instance").option("value", selectedaction.param2);
					}
					if (selectedaction.actiontype == "VAST")
					{
						$("#elemhost8").dxTextBox("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport8").dxNumberBox("instance").option("value", selectedaction.port);
					}
					if (selectedaction.actiontype == "TRIGGER_SERVER_ACTION")
					{
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport9").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam19").dxRadioGroup("instance").option("value", selectedaction.param1);
						setCheckBoxToRadioButton("actions", selectedaction.param1, "param1");
						loadingChBx = true;
						var searchEles = document.getElementById("elemparam29").children;
						for(var i = 0; i < searchEles.length; i++) {
							if(selectedaction.param2.includes(searchEles[i].getElementsByTagName('input')[0].name)){
								$("#elemparam29-"+i).dxCheckBox("instance").option("value", true);
							}else{
								$("#elemparam29-"+i).dxCheckBox("instance").option("value", false);
							}
						}
						loadingChBx = false;
						$("#elemparam39").dxTextBox("instance").option("value", selectedaction.param3);
						$("#elemparam49").dxTextBox("instance").option("value", selectedaction.param4);
						$("#elemparam59").dxTextBox("instance").option("value", selectedaction.param5);
					}
					if (selectedaction.actiontype == "MEYPAR_SERVER_ACTION")
					{
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport10").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam110").dxNumberBox("instance").option("value", selectedaction.param1);
						$("#elemparam210").dxTextBox("instance").option("value", selectedaction.param2);
						$("#elemparam310").dxNumberBox("instance").option("value", selectedaction.param3);
					}
					if (selectedaction.actiontype == "WIEGAND_SOYAL_ACTION")
					{
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemhost11").dxTextBox("instance").option("value", selectedaction.host);
						$("#elemport11").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam111").dxRadioGroup("instance").option("value", selectedaction.param1);
						$("#elemparam211").dxRadioGroup("instance").option("value", selectedaction.param2);
					}
					if (selectedaction.actiontype == "FTP_JPG_MTT_ACTION")
					{
						$("#elemhost12").dxTextBox("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport12").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam112").dxRadioGroup("instance").option("value", selectedaction.param1);
						$("#elemparam212").dxTextBox("instance").option("value", selectedaction.param2);
						$("#elemparam312").dxTextBox("instance").option("value", selectedaction.param3);
						$("#elemparam412").dxTextBox("instance").option("value", selectedaction.param4);
					}
					if (selectedaction.actiontype == "EMAIL_ACTION")
					{
						var validatorInstance = $("#elemparam213, #elemparam313, #elemparam513").dxValidator({
							validationRules: [
							{
								type: "required",
								message: DevExpress.localization.formatMessage("Email is required"),
							},
							{
								type: "email",
								message: DevExpress.localization.formatMessage("Email is invalid"),
							},
							],
							validationGroup: "emailValidationGroup", 
						}).dxValidator("instance");

						$("#elemparam213").on("click", function() {
							var buttonInstance = $("#elemparam213").dxTextBox("instance");
							var enteredValue = buttonInstance.option("value");
							validateFields(buttonInstance, validatorInstance, enteredValue);
						});

						$("#elemparam313").on("click", function() {
							var buttonInstance = $("#elemparam313").dxTextBox("instance");
							var enteredValue = buttonInstance.option("value");
							validateFields(buttonInstance, validatorInstance, enteredValue);
						});

						$("#elemparam513").on("click", function() {
							var buttonInstance = $("#elemparam513").dxTextBox("instance");
							var enteredValue = buttonInstance.option("value");
							validateFields(buttonInstance, validatorInstance, enteredValue);
						});

						// Associate the dxValidator instance with dxTextBox
						$("#elemparam213").dxTextBox({
							placeholder: "example@mail.com",
							validator: validatorInstance,
						});

						$("#elemparam313").dxTextBox({
							placeholder: "example@mail.com",
							validator: validatorInstance,
						});

						$("#elemparam513").dxTextBox({
							placeholder: "example@mail.com",
							validator: validatorInstance,
						});
						
						// Optional: Specify the validation group for dxTextBox
						$("#elemparam213").dxTextBox("instance").option("validationGroup", "emailValidationGroup");
						$("#elemparam313").dxTextBox("instance").option("validationGroup", "emailValidationGroup");
						$("#elemparam513").dxTextBox("instance").option("validationGroup", "emailValidationGroup");

						$("#elemhost13").dxTextBox("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport13").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam113").dxRadioGroup("instance").option("value", selectedaction.param1);

						$("#elemparam213").dxTextBox("instance").option("value", selectedaction.param2);
						$("#elemparam313").dxTextBox("instance").option("value", selectedaction.param3);
						$("#elemparam413").dxTextBox("instance").option("value", selectedaction.param4);
						$("#elemparam513").dxTextBox("instance").option("value", selectedaction.param5);
						

						$("#elemparam613").dxTextBox("instance").option("value", selectedaction.param6);
						$("#elemparam713").dxTextBox("instance").option("value", selectedaction.param7);
					}
					if (selectedaction.actiontype == "FTP_JPG_MTTCL_ACTION")
					{
						$("#elemhost14").dxTextBox("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport14").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam114").dxRadioGroup("instance").option("value", selectedaction.param1);
						$("#elemparam214").dxTextBox("instance").option("value", selectedaction.param2);
						$("#elemparam314").dxTextBox("instance").option("value", selectedaction.param3);
						$("#elemparam414").dxTextBox("instance").option("value", selectedaction.param4);
						$("#elemparam514").dxRadioGroup("instance").option("value", selectedaction.param5);
					}
					if (selectedaction.actiontype == "PROTOCOL_PSS_ACTION")
					{
						$("#elemhost15").dxTextBox("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport15").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam115").dxTextBox("instance").option("value", selectedaction.param1);
						$("#elemparam215").dxTextBox("instance").option("value", selectedaction.param2);
						$("#elemparam315").text(selectedaction.param3);
					}
					if (selectedaction.actiontype == "ZKTECOBIO_ACTION")
					{
						$("#elemhost16").dxTextBox("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport16").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam116").dxRadioGroup("instance").option("value", selectedaction.param1);
					}
					if (selectedaction.actiontype == "VALERUS")
					{
						$("#elemhost17").dxTextBox("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport17").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam117").dxRadioGroup("instance").option("value", selectedaction.param1);
						$("#elemparam217").dxTextBox("instance").option("value", selectedaction.param2);
						$("#elemparam317").dxTextBox("instance").option("value", selectedaction.param3);
						$("#elemparam417").dxTextBox("instance").option("value", selectedaction.param4);
					}
					if (selectedaction.actiontype == "ZKLEDSCREEN_ACTION")
					{
						$("#elemhost18").dxRadioGroup("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = "Offline";
						$("#elemport18").dxRadioGroup("instance").option("value", selectedaction.port);
						$("#elemparam118").dxNumberBox("instance").option("value", selectedaction.param1);
						$("#elemparam218").dxTextBox("instance").option("value", selectedaction.param2);
						$("#elemparam318").dxNumberBox("instance").option("value", selectedaction.param3);
						$("#elemparam418").dxTextBox("instance").option("value", selectedaction.param4);
						$("#elemparam518").dxTextBox("instance").option("value", selectedaction.param5);
						$("#elemparam618").dxTextBox("instance").option("value", selectedaction.param6);
						$("#elemparam718").dxTextBox("instance").option("value", selectedaction.param7);
					}
					if (selectedaction.actiontype == "NAVIC_ACTION")
					{
						$("#elemport19").dxRadioGroup("instance").option("value", selectedaction.port);
						$("#elemparam119").dxTextBox("instance").option("value", selectedaction.param1);
						$("#elemparam219").dxRadioGroup("instance").option("value", selectedaction.param2);
						$("#elemparam419").dxTextBox("instance").option("value", selectedaction.param4);
						$("#elemparam519").dxTextBox("instance").option("value", selectedaction.param5);
					}
					if (selectedaction.actiontype == "ZKREADER_ACTION")
					{
						$("#elemparam120").dxNumberBox("instance").option("value", selectedaction.param1); //Direccion del reader(1-8 ; default=1)
						$("#elemparam220").dxNumberBox("instance").option("value", selectedaction.param2); //Modo de verificacion (1-255 ; default=6)
						$("#elemparam320").dxNumberBox("instance").option("value", selectedaction.param3); //Tipo de reader 485 (1-255 ; default=1) 
						$("#elemparam420").dxNumberBox("instance").option("value", selectedaction.param4);//Tipo de datos (1-255 ; default=4)
						$("#elemparam520").dxNumberBox("instance").option("value", selectedaction.param5);//Longitud de datos (1-15 ; default=8)
					}
					if (selectedaction.actiontype == "TWINCAMERA_ACTION") 
					{
						$("#elemhost21").dxTextBox("instance").option("value", selectedaction.host);
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport21").dxNumberBox("instance").option("value", selectedaction.port); 
						$("#elemparam121").dxNumberBox("instance").option("value", selectedaction.param1); 
						$("#elemparam221").dxNumberBox("instance").option("value", selectedaction.param2); 
						//$("#elemparam321").dxCheckBox("instance").option("value", selectedaction.param3);
						loadingChBx = true;
						var searchEles = document.getElementById("elemparam321").children;
						for(var i = 0; i < searchEles.length; i++) {
							if(selectedaction.param3.includes(searchEles[i].getElementsByTagName('input')[0].name)){
								$("#elemparam321-"+i).dxCheckBox("instance").option("value", true);
							}else{
								$("#elemparam321-"+i).dxCheckBox("instance").option("value", false);
							}
						}
						loadingChBx = false;
					}
					if (selectedaction.actiontype == "CAME_ACTION")
					{
						if (selectedaction.port == "null") selectedaction.port = 1;
						$("#elemport22").dxNumberBox("instance").option("value", selectedaction.port);
						$("#elemparam122").dxNumberBox("instance").option("value", selectedaction.param1); 
						if(getTriggerMode())
						{
							$("#elemparam222").dxNumberBox("instance").option("disabled", true);
							$("#elemparam322").dxNumberBox("instance").option("disabled", true);
						}
						else
						{
							$("#elemparam222").dxNumberBox("instance").option("disabled", false);
							$("#elemparam322").dxNumberBox("instance").option("disabled", false);
						}
						$("#elemparam222").dxNumberBox("instance").option("value", selectedaction.param2); 
						$("#elemparam322").dxNumberBox("instance").option("value", selectedaction.param3); 
					}
					
					if (selectedaction.actiontype == "NETWORK_OPTIX")
					{
						$("#elemhost23").dxTextBox("instance").option("value", selectedaction.host);
						$("#elemparam123").dxRadioGroup("instance").option("value", selectedaction.param1); 
						loadingChBx = true;
						var searchEles1 = document.getElementById("elemparam223").children;
						for(var i = 0; i < searchEles1.length; i++) {
							if(selectedaction.param2.includes(searchEles1[i].getElementsByTagName('input')[0].name)){
								$("#elemparam223-"+i).dxCheckBox("instance").option("value", true);
							}else{
								$("#elemparam223-"+i).dxCheckBox("instance").option("value", false);
							}
						}
						if(DEFINE_INTERFACE == "VIVOTEK_CV25")
						{
							var searchEles2 = document.getElementById("elemparam323").children;
							for(var j = 0; j < searchEles2.length; j++) {
								if(selectedaction.param3.includes(searchEles2[j].getElementsByTagName('input')[0].name)){
									$("#elemparam323-"+j).dxCheckBox("instance").option("value", true);
								}else{
									$("#elemparam323-"+j).dxCheckBox("instance").option("value", false);
								}
							}
						}
						loadingChBx = false;
						$("#elemparam423").dxTextBox("instance").option("value", selectedaction.param4);
						$("#elemparam523").dxTextBox("instance").option("value", selectedaction.param5);
						$("#elemparam623").dxTextBox("instance").option("value", selectedaction.param6);
					}
				}
			},
		}).dxDataGrid("instance");

		return	actions;
	}

	function createExportsGrid()
	{
		var exports = $("#gridContainer4").dxDataGrid(
		{
			dataSource: exports_listas,
			showBorders: true,
			showRowLines: true,
			keyExpr: "id",
			hoverStateEnabled: true,
			searchPanel:
			{
				visible: true,
				width: 240,
				placeholder: DevExpress.localization.formatMessage("Search...")
			},
			columns: [
			{
				dataField: "id",
				caption: DevExpress.localization.formatMessage("ID"),
				width: "5%",
				allowEditing: false
			},
			{
				width: "20%",
				dataField: "description",
				caption: DevExpress.localization.formatMessage("Description"),
				validationRules: [
				{
					type: "required"
				}]
			},
			{
				width: "20%",
				dataField: "exporttype",
				caption: DevExpress.localization.formatMessage("Export type"),
				validationRules: [
				{
					type: "required"
				}],
				lookup:
				{
					dataSource: optionexports,
					displayExpr: "description",
					valueExpr: "id"
				}
			},
			{
				width: "20%",
				dataField: "interval",
				caption: DevExpress.localization.formatMessage("Interval"),
				validationRules: [
				{
					type: "required"
				}],
				lookup:
				{
					dataSource: intervalarray,
					displayExpr: "description",
					valueExpr: "id"
				}
			},
			{
				width: "20%",
				dataField: "enabled",
				caption: DevExpress.localization.formatMessage("Active"),
				validationRules: [
				{
					type: "required"
				}],
				lookup:
				{
					dataSource: enabledarrayexport,
					displayExpr: "description",
					valueExpr: "id"
				}
			}],
			editing:
			{
				mode: "row",
				allowUpdating: true,
				allowDeleting: true,
				texts:
				{
					confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the export from list?")
				},
				allowAdding: true
			},
			onToolbarPreparing: function(e)
			{
				let toolbarItemsExports = e.toolbarOptions.items;
				toolbarItemsExports.forEach(function(item)
				{
					if (item.name === "addRowButton")
					{
						item.visible = showaddrowExports;
					}
				});
			},
			onRowUpdating: function(e)
			{
				var description;
				var active;
				var type;
				var interval;
				idexport = e.oldData.id;
				if (typeof e.newData.description !== 'undefined')
				{
					description = e.newData.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
				}
				else
				{
					description = e.oldData.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
				}
				if (typeof e.newData.enabled !== 'undefined')
				{
					active = e.newData.enabled;
				}
				else
				{
					active = e.oldData.enabled;
				}
				if (typeof e.newData.interval !== 'undefined')
				{
					interval = e.newData.interval;
				}
				else
				{
					interval = e.oldData.interval;
				}
				if (typeof e.newData.exporttype !== 'undefined')
				{
					type = e.newData.exporttype;
					//change groupbox to selected
					$.each(optionexports, function(i, item)
					{
						$("#" + item.id).hide();
					});
					$("#" + type).show();
					expdict["exp" + idexport].exporttype = type;
					expdict["exp" + idexport].host = expdefaultdict[type].host_default;
					expdict["exp" + idexport].port = expdefaultdict[type].port_default;
					expdict["exp" + idexport].param1 = expdefaultdict[type].param1_default;
					expdict["exp" + idexport].param2 = expdefaultdict[type].param2_default;
					expdict["exp" + idexport].param3 = expdefaultdict[type].param3_default;
					expdict["exp" + idexport].param4 = expdefaultdict[type].param4_default;
					expdict["exp" + idexport].param5 = expdefaultdict[type].param5_default;
					expdict["exp" + idexport].param6 = expdefaultdict[type].param6_default;
					expdict["exp" + idexport].param7 = expdefaultdict[type].param7_default;
					updateSelectedExportInterface(expdict["exp" + idexport]);

					var cmdUpdate = "update|table=nlexport|camp0=id|value0=" + idexport; 
					cmdUpdate += "|camp1=host|value1=" + expdefaultdict[type].host_default;
					cmdUpdate += "|camp2=port|value2=" + expdefaultdict[type].port_default; 
					cmdUpdate += "|camp3=param1|value3=" + expdefaultdict[type].param1_default;
					cmdUpdate += "|camp4=param2|value4=" + expdefaultdict[type].param2_default;
					cmdUpdate += "|camp5=exporttype|value5=" + type;
					cmdUpdate += "|camp6=param3|value6=" + expdefaultdict[type].param3_default;
					cmdUpdate += "|camp7=param4|value7=" + expdefaultdict[type].param4_default
					cmdUpdate += "|camp8=param5|value8=" + expdefaultdict[type].param5_default 
					cmdUpdate += "|camp9=param6|value9=" + expdefaultdict[type].param6_default 
					cmdUpdate += "|camp10=param7|value10=" + expdefaultdict[type].param7_default;

					executeCGI(computerid, cmdUpdate, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
				}
				else
				{
					type = e.oldData.exporttype;
				}			

				var cmdUpdate = "update|table=nlexport|camp0=id|value0=" + e.oldData.id; 
				cmdUpdate += "|camp1=listid|value1=" + e.oldData.listid; 
				cmdUpdate += "|camp2=description|value2=" + description; 
				cmdUpdate += "|camp3=enabled|value3=" + active; 
				cmdUpdate += "|camp4=exporttype|value4=" + type; 
				cmdUpdate += "|camp5=interval|value5=" + interval;

				executeCGI(computerid, cmdUpdate, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
			},
			onRowInserting: function(e)
			{
				var urlinsert = "";
				urlinsert += "insert|table=nlexport|camp0=id|value0=-1|camp1=sendserver|value1=0|camp2=dateserver|value2=20180101T000000";
				urlinsert += "|camp3=reserve|value3=";
				urlinsert += "|camp4=initdate|value4=20000101T000000";
				urlinsert += "|camp5=enddate|value5=30000101T000000";
				urlinsert += "|camp6=interval|value6=" + e.data.interval;
				urlinsert += "|camp7=listid|value7=" + id_lista;
				urlinsert += "|camp8=description|value8=" + e.data.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
				urlinsert += "|camp9=exporttype|value9=" + e.data.exporttype;
				urlinsert += "|camp10=host|value10=" + expdefaultdict[e.data.exporttype].host_default;
				urlinsert += "|camp11=port|value11=" + expdefaultdict[e.data.exporttype].port_default;
				urlinsert += "|camp12=param1|value12=" + expdefaultdict[e.data.exporttype].param1_default;
				urlinsert += "|camp13=param2|value13=" + expdefaultdict[e.data.exporttype].param2_default;
				urlinsert += "|camp14=param3|value14=" + expdefaultdict[e.data.exporttype].param3_default;
				urlinsert += "|camp15=param4|value15=" + expdefaultdict[e.data.exporttype].param4_default;
				urlinsert += "|camp16=param5|value16=" + expdefaultdict[e.data.exporttype].param5_default;
				urlinsert += "|camp17=param6|value17=" + expdefaultdict[e.data.exporttype].param6_default;	
				urlinsert += "|camp18=param7|value18=" + expdefaultdict[e.data.exporttype].param7_default;	
				urlinsert += "|camp19=enabled|value19=" + e.data.enabled;

				executeCGIAsync(computerid, urlinsert, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false, 
				function(){ loadexports(id_lista, name_lista) });
			},
			onRowRemoving: function(e)
			{
				var exportselected = "";
				if(selectedexport != undefined)
				{
					exportselected = selectedexport.actiontype;
				}
				if((currentNumberOfExports == 2) && (exportselected != e.data.actiontype))
				{
					$("#exports").show();
				}
				else
				{
					$("#exports").hide();
				}

				var urldelete = "";
				urldelete += "delete|table=nlexport|camp0=id|comp0=equal|value0=" + e.key + "|camp1=listid|comp1=equal|value1=" + id_lista;
				executeCGI(computerid, urldelete, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
				loadexports(id_lista, name_lista);
				currentNumberOfExports--;
				e.element.find(".dx-datagrid-addrow-button").show();
				showaddrowExports = true;
				var repaint = $("#gridContainer4").dxDataGrid("repaint");

				checkExportButtons(id_lista);
			},
			onRowInserted: function(e)
			{
				currentNumberOfExports++;
				var currentNumberOfExportsInBBDD = getNumberOfExports();
				
				if (currentNumberOfExportsInBBDD != currentNumberOfExports)
				{
					currentNumberOfExportsInBBDD = getNumberOfExports();
				}

				if(currentNumberOfExportsInBBDD == MAX_TOTAL_EXPORTS)
				{
					e.element.find(".dx-datagrid-addrow-button").hide();
					DevExpress.ui.notify("Reached maximum number of Exports", "success", 1000);
				}

				checkExportButtons(id_lista);
			},
			selection:
			{
				mode: "single"
			},
			onSelectionChanged: function(selectedItems)
			{
				var data = selectedItems.selectedRowsData[0];
				if (data)
				{
					idexport = data.id;
					selectedexport = expdict["exp" + idexport];
					$("#exports").show();
					$.each(optionexports, function(i, item)
					{
						$("#" + item.id).hide();
					});
					$("#" + selectedexport.exporttype).show();
					updateSelectedExportInterface(selectedexport);
				}
			}
		}).dxDataGrid("instance");

		return exports;
	}

	function createImportsGrid()
	{	
		var imports = $("#gridContainer5").dxDataGrid(
		{
			dataSource: imports_listas,
			showBorders: true,
			showRowLines: true,
			keyExpr: "id",
			hoverStateEnabled: true,
			searchPanel:
			{
				visible: true,
				width: 240,
				placeholder: DevExpress.localization.formatMessage("Search...")
			},
			columns: [
			{
				dataField: "id",
				caption: DevExpress.localization.formatMessage("ID"),
				width: "5%",
				allowEditing: false
			},
			{
				width: "20%",
				dataField: "description",
				caption: DevExpress.localization.formatMessage("Description"),
				validationRules: [
				{
					type: "required"
				}]
			},
			{
				width: "20%",
				dataField: "importtype",
				caption: DevExpress.localization.formatMessage("Import type"),
				validationRules: [
				{
					type: "required"
				}],
				lookup:
				{
					dataSource: optionimports,
					displayExpr: "description",
					valueExpr: "id"
				}
			},
			{
				width: "20%",
				dataField: "interval",
				caption: DevExpress.localization.formatMessage("Interval"),
				validationRules: [
				{
					type: "required"
				}],
				lookup:
				{
					dataSource: intervalarray,
					displayExpr: "description",
					valueExpr: "id"
				}
			},
			{
				width: "20%",
				dataField: "enabled",
				caption: DevExpress.localization.formatMessage("Active"),
				validationRules: [
				{
					type: "required"
				}],
				lookup:
				{
					dataSource: enabledarrayexport,
					displayExpr: "description",
					valueExpr: "id"
				}
			}],
			editing:
			{
				mode: "row",
				allowUpdating: true,
				allowDeleting: true,
				texts:
				{
					confirmDeleteMessage: DevExpress.localization.formatMessage("Are you sure to delete the import from list?")
				},
				allowAdding: true
			},
			onToolbarPreparing: function(e)
			{
				let toolbarItemsImports = e.toolbarOptions.items;
				toolbarItemsImports.forEach(function(item)
				{
					if (item.name === "addRowButton")
					{
						item.visible = showaddrowImports;
					}
				});
			},
			onRowUpdating: function(e)
			{
				var description;
				var active;
				var type;
				var interval;
				idimport = e.oldData.id;
				if (typeof e.newData.description !== 'undefined')
				{
					description = e.newData.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
				}
				else
				{
					description = e.oldData.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
				}
				if (typeof e.newData.enabled !== 'undefined')
				{
					active = e.newData.enabled;
				}
				else
				{
					active = e.oldData.enabled;
				}
				if (typeof e.newData.interval !== 'undefined')
				{
					interval = e.newData.interval;
				}
				else
				{
					interval = e.oldData.interval;
				}
				if (typeof e.newData.importtype !== 'undefined')
				{
					type = e.newData.importtype;
					//change groupbox to selected
					$.each(optionimports, function(i, item)
					{
						$("#" + item.id).hide();
					});
					$("#" + type).show();
					impdict["imp" + idimport].importtype = type;
					impdict["imp" + idimport].host = impdefaultdict[type].host_default;
					impdict["imp" + idimport].port = impdefaultdict[type].port_default;
					impdict["imp" + idimport].param1 = impdefaultdict[type].param1_default;
					impdict["imp" + idimport].param2 = impdefaultdict[type].param2_default;
					impdict["imp" + idimport].param3 = impdefaultdict[type].param3_default;
					impdict["imp" + idimport].param4 = impdefaultdict[type].param4_default;
					impdict["imp" + idimport].param5 = impdefaultdict[type].param5_default;
					impdict["imp" + idimport].param6 = impdefaultdict[type].param6_default;
					updateSelectedImportInterface(impdict["imp" + idimport]);

					var cmdUpdate = "";
					cmdUpdate += "update|table=nlimport|camp0=id|value0=" + idimport + "|camp1=host|value1=" + impdefaultdict[type].host_default + "|camp2=port|value2=" + impdefaultdict[type].port_default; 
					cmdUpdate += "|camp3=param1|value3=" + impdefaultdict[type].param1_default;
					cmdUpdate += "|camp4=param2|value4=" + impdefaultdict[type].param2_default; 
					cmdUpdate += "|camp5=importtype|value5=" + type; 
					cmdUpdate += "|camp6=param3|value6=" + impdefaultdict[type].param3_default; 
					cmdUpdate += "|camp7=param4|value7=" + impdefaultdict[type].param4_default;
					cmdUpdate += "|camp8=param5|value8=" + impdefaultdict[type].param5_default;
					cmdUpdate += "|camp9=param6|value9=" + impdefaultdict[type].param6_default;

					executeCGI(computerid, cmdUpdate, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
				}
				else
				{
					type = e.oldData.importtype;
				}	

				var cmdUpdate = "";
				cmdUpdate += "update|table=nlimport|camp0=id|value0=" + e.oldData.id; 
				cmdUpdate += "|camp1=listid|value1=" + e.oldData.listid; 
				cmdUpdate += "|camp2=description|value2=" + description; 
				cmdUpdate += "|camp3=enabled|value3=" + active; 
				cmdUpdate += "|camp4=importtype|value4=" + type; 
				cmdUpdate += "|camp5=interval|value5=" + interval;

				executeCGI(computerid, cmdUpdate, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
			},
			onRowInserting: function(e)
			{
				var urlinsert = "";
				urlinsert += "insert|table=nlimport|camp0=id|value0=-1|camp1=sendserver|value1=0|camp2=dateserver|value2=20180101T000000";

				urlinsert += "|camp3=reserve|value3=";
				urlinsert += "|camp4=initdate|value4=20000101T000000";
				urlinsert += "|camp5=enddate|value5=30000101T000000";
				urlinsert += "|camp6=interval|value6=" + e.data.interval;
				urlinsert += "|camp7=listid|value7=" + id_lista;
				urlinsert += "|camp8=description|value8=" + e.data.description.replaceAll('"', '').replaceAll('\'', '').replace(/[\t]/g, '');
				urlinsert += "|camp9=importtype|value9=" + e.data.importtype;
				urlinsert += "|camp10=host|value10=" + impdefaultdict[e.data.importtype].host_default;
				urlinsert += "|camp11=port|value11=" + impdefaultdict[e.data.importtype].port_default;
				urlinsert += "|camp12=param1|value12=" + impdefaultdict[e.data.importtype].param1_default;
				urlinsert += "|camp13=param2|value13=" + impdefaultdict[e.data.importtype].param2_default;
				urlinsert += "|camp14=param3|value14=" + impdefaultdict[e.data.importtype].param3_default;
				urlinsert += "|camp15=param4|value15=" + impdefaultdict[e.data.importtype].param4_default;
				urlinsert += "|camp16=param5|value16=" + impdefaultdict[e.data.importtype].param5_default;
				urlinsert += "|camp17=enabled|value17=" + e.data.enabled;
				urlinsert += "|camp18=param6|value18=" + impdefaultdict[e.data.importtype].param6_default;	

				executeCGIAsync(computerid, urlinsert, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false, 
				function(){ loadimports(id_lista, name_lista) });
			},
			onRowRemoving: function(e)
			{
				var importselected = "";
				if(selectedimport != undefined)
				{
					importselected = selectedimport.actiontype;
				}
				if((currentNumberOfImports == 2) && (importselected != e.data.actiontype))
				{
					$("#imports").show();
				}
				else
				{
					$("#imports").hide();
				}

				var urldelete = "";
				urldelete += "delete|table=nlimport|camp0=id|comp0=equal|value0=" + e.key + "|camp1=listid|comp1=equal|value1=" + id_lista;
				executeCGI(computerid, urldelete, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);	
				loadimports(id_lista, name_lista);
				currentNumberOfImports--;
				e.element.find(".dx-datagrid-addrow-button").show();
				showaddrowImports = true;
				var repaint = $("#gridContainer5").dxDataGrid("repaint");
				
			},
			onRowInserted: function(e)
			{
				currentNumberOfImports++;
				var currentNumberOfImportsInBBDD = getNumberOfImports();
				
				if (currentNumberOfImportsInBBDD != currentNumberOfImports)
				{
					currentNumberOfImportsInBBDD = getNumberOfImports();
				}

				if(currentNumberOfImportsInBBDD == MAX_TOTAL_IMPORTS)
				{
					e.element.find(".dx-datagrid-addrow-button").hide();
					DevExpress.ui.notify("Reached maximum number of Imports", "success", 1000);
				}
			},
			selection:
			{
				mode: "single"
			},
			onSelectionChanged: function(selectedItems)
			{
				var data = selectedItems.selectedRowsData[0];
				if (data)
				{
					idimport = data.id;
					selectedimport = impdict["imp" + idimport];
					$("#imports").show();
					$.each(optionimports, function(i, item)
					{
						$("#" + item.id).hide();
					});
					$("#" + selectedimport.importtype).show();
					updateSelectedImportInterface(selectedimport);
					
				}
			}
		}).dxDataGrid("instance");

		return imports;
	}

	function loadAllLists()
	{
		var data = executeCGI(computerid, "getconfig", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);

		actionlist = data[2];

		$.each(data[2], function(i, item)
		{
			if (item.enabled == 1)
			{
				//console.log(JSON.stringify(item));
				var action = {};
				action["id"] = item.actiontype;
				action["description"] = item.text;
				actdefaultdict[item.actiontype] = item;
				optionactions.push(action);
				var div = "<div class='dx-fieldset' id= '" + item.actiontype + "'  ></div>";
				//var div = "<div class='dx-fieldset' id= '" + item.actiontype + "'  ></div>";
				$("#actions").append(div);
				$("#" + item.actiontype).hide();
				$("#" + item.actiontype).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage("Action Info") + "</div><div class='dx-field-value'><div id='iconinfo" + i + "' style='float: none;' ></div><div id='popupinfo" + i + "' style='display:none' ></div></div></div>");
				$("#iconinfo" + i).dxButton(
				{
					icon: "help",
					type: "success",
					mode: "contained",
					onClick: function(e)
					{
						var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
							.done(function(data)
							{
								$("#popupinfo" + i).append(data);
								var poup = $("#popupinfo" + i).dxPopup(
								{
									showTitle: true,
									title: DevExpress.localization.formatMessage("Help"),
									visible: true,
									maxWidth: 500,
									maxHeight: 700,
									loseOnOutsideClick: true
								});
							});
					}
				});
				
				if (item.host != "")
				{
					if (item.host_type == "option")
					{
						setoptiondiv(item.actiontype, item.host, i, "host", item.host_options, item.host_default, "nlaction", "")
					}
					if (item.host_type == "multioption")
					{
						setmultioptiondiv(item.actiontype, item.host, i, "host", item.host_options, item.host_default, "nlaction", "")
					}
					if (item.host_type == "int")
					{
						setintdiv(item.actiontype, item.host, i, "host", item.host_options, item.host_default, "nlaction", "")
					}
					if (item.host_type == "string")
					{
						setstringdiv(item.actiontype, item.host, i, "host", item.host_options, item.host_default, "nlaction", "")
					}
					if (item.host_type == "file")
					{
						setfilediv(item.actiontype, item.host, i, "host", item.host_options, item.host_default, "nlaction", "")
					}
				}
				
				if (item.port != "")
				{
					if (item.port_type == "option")
					{
						setoptiondiv(item.actiontype, item.port, i, "port", item.port_options, item.port_default, "nlaction", "")
					}
					if (item.port_type == "multioption")
					{
						setmultioptiondiv(item.actiontype, item.port, i, "port", item.port_options, item.port_default, "nlaction", "")
					}
					if (item.port_type == "int")
					{
						setintdiv(item.actiontype, item.port, i, "port", item.port_options, item.port_default, "nlaction", "")
					}
					if (item.port_type == "string")
					{
						setstringdiv(item.actiontype, item.port, i, "port", item.port_options, item.port_default, "nlaction", "")
					}
					if (item.port_type == "file")
					{
						setfilediv(item.actiontype, item.port, i, "port", item.port_options, item.port_default, "nlaction", "")
					}
				}
				
				if (item.param1 != "")
				{
					if (item.param1_type == "option")
					{
						setoptiondiv(item.actiontype, item.param1, i, "param1", item.param1_options, item.param1_default, "nlaction", item.param1_help)
					}
					if (item.param1_type == "multioption")
					{
						setmultioptiondiv(item.actiontype, item.param1, i, "param1", item.param1_options, item.param1_default, "nlaction", item.param1_help)
					}
					if (item.param1_type == "int")
					{
						setintdiv(item.actiontype, item.param1, i, "param1", item.param1_options, item.param1_default, "nlaction", item.param1_help)
					}
					if (item.param1_type == "string")
					{
						setstringdiv(item.actiontype, item.param1, i, "param1", item.param1_options, item.param1_default, "nlaction", item.param1_help)
					}
					if (item.param1_type == "file")
					{
						setfilediv(item.actiontype, item.param1, i, "param1", item.param1_options, item.param1_default, "nlaction", item.param1_help)
					}
					if (item.param1_type == "buttonbind")
					{
						setbinddiv(item.actiontype, item.param1, i, "param1", item.param1_options, item.param1_default, "nlaction", item.param1_help)
					}
				}
				
				if (item.param2 != "")
				{
					if (item.param2_type == "option")
					{
						setoptiondiv(item.actiontype, item.param2, i, "param2", item.param2_options, item.param2_default, "nlaction", item.param2_help)
					}
					if (item.param2_type == "multioption")
					{
						setmultioptiondiv(item.actiontype, item.param2, i, "param2", item.param2_options, item.param2_default, "nlaction", item.param2_help)
					}
					if (item.param2_type == "int")
					{
						setintdiv(item.actiontype, item.param2, i, "param2", item.param2_options, item.param2_default, "nlaction", item.param2_help)
					}
					if (item.param2_type == "string")
					{
						setstringdiv(item.actiontype, item.param2, i, "param2", item.param2_options, item.param2_default, "nlaction", item.param2_help)
					}
					if (item.param2_type == "file")
					{
						setfilediv(item.actiontype, item.param2, i, "param2", item.param2_options, item.param2_default, "nlaction", item.param2_help)
					}
					if (item.param2_type == "buttonbind")
					{
						setbinddiv(item.actiontype, item.param2, i, "param2", item.param1_options, item.param1_default, "nlaction", item.param2_help)
					}
				}
				
				if (item.param3 != "")
				{
					if (item.param3_type == "option")
					{
						setoptiondiv(item.actiontype, item.param3, i, "param3", item.param3_options, item.param3_default, "nlaction", item.param3_help)
					}
					if (item.param3_type == "multioption")
					{
						setmultioptiondiv(item.actiontype, item.param3, i, "param3", item.param3_options, item.param3_default, "nlaction", item.param3_help)
					}
					if (item.param3_type == "int")
					{
						setintdiv(item.actiontype, item.param3, i, "param3", item.param3_options, item.param3_default, "nlaction", item.param3_help)
					}
					if (item.param3_type == "string")
					{
						setstringdiv(item.actiontype, item.param3, i, "param3", item.param3_options, item.param3_default, "nlaction", item.param3_help)
					}
					if (item.param3_type == "file")
					{
						setfilediv(item.actiontype, item.param3, i, "param3", item.param3_options, item.param3_default, "nlaction", item.param3_help)
					}
					if (item.param3_type == "buttonbind")
					{
						setbinddiv(item.actiontype, item.param3, i, "param3", item.param1_options, item.param1_default, "nlaction", item.param3_help)
					}
				}
				
				if (item.param4 != "")
				{
					if (item.param4_type == "option")
					{
						setoptiondiv(item.actiontype, item.param4, i, "param4", item.param4_options, item.param4_default, "nlaction", item.param4_help)
					}
					if (item.param4_type == "multioption")
					{
						setmultioptiondiv(item.actiontype, item.param4, i, "param4", item.param4_options, item.param4_default, "nlaction", item.param4_help)
					}
					if (item.param4_type == "int")
					{
						setintdiv(item.actiontype, item.param4, i, "param4", item.param4_options, item.param4_default, "nlaction", item.param4_help)
					}
					if (item.param4_type == "string")
					{
						setstringdiv(item.actiontype, item.param4, i, "param4", item.param4_options, item.param4_default, "nlaction", item.param4_help)
					}
					if (item.param4_type == "file")
					{
						setfilediv(item.actiontype, item.param4, i, "param4", item.param4_options, item.param4_default, "nlaction", item.param4_help)
					}
					if (item.param4_type == "buttonbind")
					{
						setbinddiv(item.actiontype, item.param4, i, "param4", item.param1_options, item.param1_default, "nlaction", item.param4_help)
					}
					if (item.param4_type == "http")
					{
						sethttpdiv(item.actiontype, item.param4, i, "param4", item.param4_options, item.param4_default, "nlaction", item.param4_help)
					}
				}
				
				if (item.param5 != "")
				{
					if (item.param5_type == "option")
					{
						setoptiondiv(item.actiontype, item.param5, i, "param5", item.param5_options, item.param5_default, "nlaction", item.param5_help)
					}
					if (item.param5_type == "multioption")
					{
						setmultioptiondiv(item.actiontype, item.param5, i, "param5", item.param5_options, item.param5_default, "nlaction", item.param5_help)
					}
					if (item.param5_type == "int")
					{
						setintdiv(item.actiontype, item.param5, i, "param5", item.param5_options, item.param5_default, "nlaction", item.param5_help)
					}
					if (item.param5_type == "string")
					{
						setstringdiv(item.actiontype, item.param5, i, "param5", item.param5_options, item.param5_default, "nlaction", item.param5_help)
					}
					if (item.param5_type == "file")
					{
						setfilediv(item.actiontype, item.param5, i, "param5", item.param5_options, item.param5_default, "nlaction", item.param5_help)
					}
					if (item.param5_type == "buttonbind")
					{
						setbinddiv(item.actiontype, item.param5, i, "param5", item.param1_options, item.param1_default, "nlaction", item.param5_help)
					}
				}
				
				if (item.param6 != "")
				{
					if (item.param6_type == "option")
					{
						setoptiondiv(item.actiontype, item.param6, i, "param6", item.param6_options, item.param6_default, "nlaction", item.param6_help)
					}
					if (item.param6_type == "multioption")
					{
						setmultioptiondiv(item.actiontype, item.param6, i, "param6", item.param6_options, item.param6_default, "nlaction", item.param6_help)
					}
					if (item.param6_type == "int")
					{
						setintdiv(item.actiontype, item.param6, i, "param6", item.param6_options, item.param6_default, "nlaction", item.param6_help)
					}
					if (item.param6_type == "string")
					{
						setstringdiv(item.actiontype, item.param6, i, "param6", item.param6_options, item.param6_default, "nlaction", item.param6_help)
					}
					if (item.param6_type == "file")
					{
						setfilediv(item.actiontype, item.param6, i, "param6", item.param6_options, item.param6_default, "nlaction", item.param6_help)
					}
					if (item.param6_type == "buttonbind")
					{
						setbinddiv(item.actiontype, item.param6, i, "param6", item.param1_options, item.param1_default, "nlaction", item.param6_help)
					}
				}
				
				if (item.param7 != "")
				{
					if (item.param7_type == "option")
					{
						setoptiondiv(item.actiontype, item.param7, i, "param7", item.param7_options, item.param7_default, "nlaction", item.param7_help)
					}
					if (item.param7_type == "multioption")
					{
						setmultioptiondiv(item.actiontype, item.param7, i, "param7", item.param7_options, item.param7_default, "nlaction", item.param7_help)
					}
					if (item.param7_type == "int")
					{
						setintdiv(item.actiontype, item.param7, i, "param7", item.param7_options, item.param7_default, "nlaction", item.param7_help)
					}
					if (item.param7_type == "string")
					{
						setstringdiv(item.actiontype, item.param7, i, "param7", item.param7_options, item.param7_default, "nlaction", item.param7_help)
					}
					if (item.param7_type == "file")
					{
						setfilediv(item.actiontype, item.param7, i, "param7", item.param7_options, item.param7_default, "nlaction", item.param7_help)
					}
					if (item.param7_type == "buttonbind")
					{
						setbinddiv(item.actiontype, item.param7, i, "param7", item.param1_options, item.param1_default, "nlaction", item.param7_help)
					}
				}
				
				if (item.param8 != "")
				{
					if (item.param8_type == "option")
					{
						setoptiondiv(item.actiontype, item.param8, i, "param8", item.param8_options, item.param8_default, "nlaction", item.param8_help)
					}
					if (item.param8_type == "multioption")
					{
						setmultioptiondiv(item.actiontype, item.param8, i, "param8", item.param8_options, item.param8_default, "nlaction", item.param8_help)
					}
					if (item.param8_type == "int")
					{
						setintdiv(item.actiontype, item.param8, i, "param8", item.param8_options, item.param8_default, "nlaction", item.param8_help)
					}
					if (item.param8_type == "string")
					{
						setstringdiv(item.actiontype, item.param8, i, "param8", item.param8_options, item.param8_default, "nlaction", item.param8_help)
					}
					if (item.param8_type == "file")
					{
						setfilediv(item.actiontype, item.param8, i, "param8", item.param8_options, item.param8_default, "nlaction", item.param8_help)
					}
					if (item.param8_type == "buttonbind")
					{
						setbinddiv(item.actiontype, item.param8, i, "param8", item.param1_options, item.param1_default, "nlaction", item.param8_help)
					}
				}
			}
		});
					
		exportlist = data[3];

		$.each(data[3], function(i, item)
		{
			if (item.enabled == 1)
			{
				var action = {};
				action["id"] = item.exporttype;
				action["description"] = item.text;
				expdefaultdict[item.exporttype] = item;
				optionexports.push(action);
				var div = "<div class='dx-fieldset' id= '" + item.exporttype + "'  ></div>";
				//var div = "<div class='dx-fieldset' id= '" + item.actiontype + "'  ></div>";
				$("#exports").append(div);
				$("#" + item.exporttype).hide();
				$("#" + item.exporttype).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage("Export Info") + "</div><div class='dx-field-value'><div id='iconinfo" + (i + 100) + "' style='float: none;' ></div><div id='popupinfo" + (i + 100) + "' style='display:none' ></div></div></div>");
				$("#iconinfo" + (i + 100)).dxButton(
				{
					icon: "help",
					type: "success",
					mode: "contained",
					onClick: function(e)
					{
						var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
							.done(function(data)
							{
								$("#popupinfo" + (i + 100)).append(data);
								var poup = $("#popupinfo" + (i + 100)).dxPopup(
								{
									showTitle: true,
									title: DevExpress.localization.formatMessage("Help"),
									visible: true,
									maxWidth: 500,
									maxHeight: 500,
									loseOnOutsideClick: true
								});
							});
					}
				});
				
				if (item.host != "")
				{
					if (item.host_type == "option")
					{
						setoptiondiv(item.exporttype, item.host, i + 100, "host", item.host_options, item.host_default, "nlexport", "")
					}
					if (item.host_type == "multioption")
					{
						setmultioptiondiv(item.exporttype, item.host, i + 100, "host", item.host_options, item.host_default, "nlexport", "")
					}
					if (item.host_type == "int")
					{
						setintdiv(item.exporttype, item.host, i + 100, "host", item.host_options, item.host_default, "nlexport", "")
					}
					if (item.host_type == "string")
					{
						setstringdiv(item.exporttype, item.host, i + 100, "host", item.host_options, item.host_default, "nlexport", "")
					}
					if (item.host_type == "file")
					{
						setfilediv(item.exporttype, item.host, i + 100, "host", item.host_options, item.host_default, "nlexport", "")
					}
				}
				
				if (item.port != "")
				{
					if (item.port_type == "option")
					{
						setoptiondiv(item.exporttype, item.port, i + 100, "port", item.port_options, item.port_default, "nlexport", "")
					}
					if (item.port_type == "multioption")
					{
						setmultioptiondiv(item.exporttype, item.port, i + 100, "port", item.port_options, item.port_default, "nlexport", "")
					}
					if (item.port_type == "int")
					{
						setintdiv(item.exporttype, item.port, i + 100, "port", item.port_options, item.port_default, "nlexport", "")
					}
					if (item.port_type == "string")
					{
						setstringdiv(item.exporttype, item.port, i + 100, "port", item.port_options, item.port_default, "nlexport", "")
					}
					if (item.port_type == "file")
					{
						setfilediv(item.exporttype, item.port, i + 100, "port", item.port_options, item.port_default, "nlexport", "")
					}
				}
				
				if (item.param1 != "")
				{
					if (item.param1_type == "option")
					{
						setoptiondiv(item.exporttype, item.param1, i + 100, "param1", item.param1_options, item.param1_default, "nlexport", item.param1_help)
					}
					if (item.param1_type == "multioption")
					{
						setmultioptiondiv(item.exporttype, item.param1, i + 100, "param1", item.param1_options, item.param1_default, "nlexport", item.param1_help)
					}
					if (item.param1_type == "int")
					{
						setintdiv(item.exporttype, item.param1, i + 100, "param1", item.param1_options, item.param1_default, "nlexport", item.param1_help)
					}
					if (item.param1_type == "string")
					{
						setstringdiv(item.exporttype, item.param1, i + 100, "param1", item.param1_options, item.param1_default, "nlexport", item.param1_help)
					}
					if (item.param1_type == "file")
					{
						setfilediv(item.exporttype, item.param1, i + 100, "param1", item.param1_options, item.param1_default, "nlexport", item.param1_help)
					}
				}
				
				if (item.param2 != "")
				{
					if (item.param2_type == "option")
					{
						setoptiondiv(item.exporttype, item.param2, i + 100, "param2", item.param2_options, item.param2_default, "nlexport", item.param2_help)
					}
					if (item.param2_type == "multioption")
					{
						setmultioptiondiv(item.exporttype, item.param2, i + 100, "param2", item.param2_options, item.param2_default, "nlexport", item.param2_help)
					}
					if (item.param2_type == "int")
					{
						setintdiv(item.exporttype, item.param2, i + 100, "param2", item.param2_options, item.param2_default, "nlexport", item.param2_help)
					}
					if (item.param2_type == "string")
					{
						setstringdiv(item.exporttype, item.param2, i + 100, "param2", item.param2_options, item.param2_default, "nlexport", item.param2_help)
					}
					if (item.param2_type == "file")
					{
						setfilediv(item.exporttype, item.param2, i + 100, "param2", item.param2_options, item.param2_default, "nlexport", item.param2_help)
					}
				}
				
				if (item.param3 != "")
				{
					if (item.param3_type == "option")
					{
						setoptiondiv(item.exporttype, item.param3, i + 100, "param3", item.param3_options, item.param3_default, "nlexport", item.param3_help)
					}
					if (item.param3_type == "multioption")
					{
						setmultioptiondiv(item.exporttype, item.param3, i + 100, "param3", item.param3_options, item.param3_default, "nlexport", item.param3_help)
					}
					if (item.param3_type == "int")
					{
						setintdiv(item.exporttype, item.param3, i + 100, "param3", item.param3_options, item.param3_default, "nlexport", item.param3_help)
					}
					if (item.param3_type == "string")
					{
						setstringdiv(item.exporttype, item.param3, i + 100, "param3", item.param3_options, item.param3_default, "nlexport", item.param3_help)
					}
					if (item.param3_type == "file")
					{
						setfilediv(item.exporttype, item.param3, i + 100, "param3", item.param3_options, item.param3_default, "nlexport", item.param3_help)
					}
				}
				
				if (item.param4 != "")
				{
					if (item.param4_type == "option")
					{
						setoptiondiv(item.exporttype, item.param4, i + 100, "param4", item.param4_options, item.param4_default, "nlexport", item.param4_help)
					}
					if (item.param4_type == "multioption")
					{
						setmultioptiondiv(item.exporttype, item.param4, i + 100, "param4", item.param4_options, item.param4_default, "nlexport", item.param4_help)
					}
					if (item.param4_type == "int")
					{
						setintdiv(item.exporttype, item.param4, i + 100, "param4", item.param4_options, item.param4_default, "nlexport", item.param4_help)
					}
					if (item.param4_type == "string")
					{
						setstringdiv(item.exporttype, item.param4, i + 100, "param4", item.param4_options, item.param4_default, "nlexport", item.param4_help)
					}
					if (item.param4_type == "file")
					{
						setfilediv(item.exporttype, item.param4, i + 100, "param4", item.param4_options, item.param4_default, "nlexport", item.param4_help)
					}
				}
				
				if (item.param5 != "")
				{
					if (item.param5_type == "option")
					{
						setoptiondiv(item.exporttype, item.param5, i + 100, "param5", item.param5_options, item.param5_default, "nlexport", item.param5_help)
					}
					if (item.param5_type == "multioption")
					{
						setmultioptiondiv(item.exporttype, item.param5, i + 100, "param5", item.param5_options, item.param5_default, "nlexport", item.param5_help)
					}
					if (item.param5_type == "int")
					{
						setintdiv(item.exporttype, item.param5, i + 100, "param5", item.param5_options, item.param5_default, "nlexport", item.param5_help)
					}
					if (item.param5_type == "string")
					{
						setstringdiv(item.exporttype, item.param5, i + 100, "param5", item.param5_options, item.param5_default, "nlexport", item.param5_help)
					}
					if (item.param5_type == "file")
					{
						setfilediv(item.exporttype, item.param5, i + 100, "param5", item.param5_options, item.param5_default, "nlexport", item.param5_help)
					}
				}
				
				if (item.param6 != "")
				{
					if (item.param6_type == "option")
					{
						setoptiondiv(item.exporttype, item.param6, i + 100, "param6", item.param6_options, item.param6_default, "nlexport", "")
					}
					if (item.param6_type == "multioption")
					{
						setmultioptiondiv(item.exporttype, item.param6, i + 100, "param6", item.param6_options, item.param6_default, "nlexport", "")
					}
					if (item.param6_type == "int")
					{
						setintdiv(item.exporttype, item.param6, i + 100, "param6", item.param6_options, item.param6_default, "nlexport", "")
					}
					if (item.param6_type == "string")
					{
						setstringdiv(item.exporttype, item.param6, i + 100, "param6", item.param6_options, item.param6_default, "nlexport", "")
					}
					if (item.param6_type == "file")
					{
						setfilediv(item.exporttype, item.param6, i + 100, "param6", item.param6_options, item.param6_default, "nlexport", "")
					}
				}
	
				if (item.param7 != "")
				{
					if (item.param7_type == "option")
					{
						setoptiondiv(item.exporttype, item.param7, i + 100, "param7", item.param7_options, item.param7_default, "nlexport", "")
					}
					if (item.param7_type == "multioption")
					{
						setmultioptiondiv(item.exporttype, item.param7, i + 100, "param7", item.param7_options, item.param7_default, "nlexport", "")
					}
					if (item.param7_type == "int")
					{
						setintdiv(item.exporttype, item.param7, i + 100, "param7", item.param7_options, item.param7_default, "nlexport", "")
					}
					if (item.param7_type == "string")
					{
						setstringdiv(item.exporttype, item.param7, i + 100, "param7", item.param7_options, item.param7_default, "nlexport", "")
					}
					if (item.param7_type == "file")
					{
						setfilediv(item.exporttype, item.param7, i + 100, "param7", item.param7_options, item.param7_default, "nlexport", "")
					}
				}
			}
		});
		
		importlist = data[4];
		$.each(importlist, function(i, item)
		{
			if (item.enabled == 1)
			{
				var action = {};
				action["id"] = item.importtype;
				action["description"] = item.text;
				impdefaultdict[item.importtype] = item;
				optionimports.push(action);
				var div = "<div class='dx-fieldset' id= '" + item.importtype + "'  ></div>";
				$("#imports").append(div);
				$("#" + item.importtype).hide();
				$("#" + item.importtype).append(" <div class='dx-field'><div class='dx-field-label'>" + DevExpress.localization.formatMessage("Import Info") + "</div><div class='dx-field-value'><div id='iconinfo" + (i + 200) + "' style='float: none;' ></div><div id='popupinfo" + (i + 200) + "' style='display:none' ></div></div></div>");
				$("#iconinfo" + (i + 200)).dxButton(
				{
					icon: "help",
					type: "success",
					mode: "contained",
					onClick: function(e)
					{
						var jqxhr = $.ajax("help/" + item.help.replace(".html", "_" + getLocale() + ".html"))
							.done(function(data)
							{
								$("#popupinfo" + (i + 200)).append(data);
								var poup = $("#popupinfo" + (i + 200)).dxPopup(
								{
									showTitle: true,
									title: DevExpress.localization.formatMessage("Help"),
									visible: true,
									maxWidth: 500,
									maxHeight: 500,
									loseOnOutsideClick: true
								});
							});
					}
				});
				
				if (item.host != "")
				{
					if (item.host_type == "option")
					{
						setoptiondiv(item.importtype, item.host, i + 200, "host", item.host_options, item.host_default, "nlimport", "")
					}
					if (item.host_type == "multioption")
					{
						setmultioptiondiv(item.importtype, item.host, i + 200, "host", item.host_options, item.host_default, "nlimport", "")
					}
					if (item.host_type == "int")
					{
						setintdiv(item.importtype, item.host, i + 200, "host", item.host_options, item.host_default, "nlimport", "")
					}
					if (item.host_type == "string")
					{
						setstringdiv(item.importtype, item.host, i + 200, "host", item.host_options, item.host_default, "nlimport", "")
					}
					if (item.host_type == "file")
					{
						setfilediv(item.importtype, item.host, i + 200, "host", item.host_options, item.host_default, "nlimport", "")
					}
				}
				
				if (item.port != "")
				{
					if (item.port_type == "option")
					{
						setoptiondiv(item.importtype, item.port, i + 200, "port", item.port_options, item.port_default, "nlimport", "")
					}
					if (item.port_type == "multioption")
					{
						setmultioptiondiv(item.importtype, item.port, i + 200, "port", item.port_options, item.port_default, "nlimport", "")
					}
					if (item.port_type == "int")
					{
						setintdiv(item.importtype, item.port, i + 200, "port", item.port_options, item.port_default, "nlimport", "")
					}
					if (item.port_type == "string")
					{
						setstringdiv(item.importtype, item.port, i + 200, "port", item.port_options, item.port_default, "nlimport", "")
					}
					if (item.port_type == "file")
					{
						setfilediv(item.importtype, item.port, i + 200, "port", item.port_options, item.port_default, "nlimport", "")
					}
				}
				
				if (item.param1 != "")
				{
					if (item.param1_type == "option")
					{
						setoptiondiv(item.importtype, item.param1, i + 200, "param1", item.param1_options, item.param1_default, "nlimport", item.param1_help)
					}
					if (item.param1_type == "multioption")
					{
						setmultioptiondiv(item.importtype, item.param1, i + 200, "param1", item.param1_options, item.param1_default, "nlimport", item.param1_help)
					}
					if (item.param1_type == "int")
					{
						setintdiv(item.importtype, item.param1, i + 200, "param1", item.param1_options, item.param1_default, "nlimport", item.param1_help)
					}
					if (item.param1_type == "string")
					{
						setstringdiv(item.importtype, item.param1, i + 200, "param1", item.param1_options, item.param1_default, "nlimport", item.param1_help)
					}
					if (item.param1_type == "file")
					{
						setfilediv(item.importtype, item.param1, i + 200, "param1", item.param1_options, item.param1_default, "nlimport", item.param1_help)
					}
				}
				
				if (item.param2 != "")
				{
					if (item.param2_type == "option")
					{
						setoptiondiv(item.importtype, item.param2, i + 200, "param2", item.param2_options, item.param2_default, "nlimport", item.param2_help)
					}
					if (item.param2_type == "multioption")
					{
						setmultioptiondiv(item.importtype, item.param2, i + 200, "param2", item.param2_options, item.param2_default, "nlimport", item.param2_help)
					}
					if (item.param2_type == "int")
					{
						setintdiv(item.importtype, item.param2, i + 200, "param2", item.param2_options, item.param2_default, "nlimport", item.param2_help)
					}
					if (item.param2_type == "string")
					{
						setstringdiv(item.importtype, item.param2, i + 200, "param2", item.param2_options, item.param2_default, "nlimport", item.param2_help)
					}
					if (item.param2_type == "file")
					{
						setfilediv(item.importtype, item.param2, i + 200, "param2", item.param2_options, item.param2_default, "nlimport", item.param2_help)
					}
				}
				
				if (item.param3 != "")
				{
					if (item.param3_type == "option")
					{
						setoptiondiv(item.importtype, item.param3, i + 200, "param3", item.param3_options, item.param3_default, "nlimport", item.param3_help)
					}
					if (item.param3_type == "multioption")
					{
						setmultioptiondiv(item.importtype, item.param3, i + 200, "param3", item.param3_options, item.param3_default, "nlimport", item.param3_help)
					}
					if (item.param3_type == "int")
					{
						setintdiv(item.importtype, item.param3, i + 200, "param3", item.param3_options, item.param3_default, "nlimport", item.param3_help)
					}
					if (item.param3_type == "string")
					{
						setstringdiv(item.importtype, item.param3, i + 200, "param3", item.param3_options, item.param3_default, "nlimport", item.param3_help)
					}
					if (item.param3_type == "file")
					{
						setfilediv(item.importtype, item.param3, i + 200, "param3", item.param3_options, item.param3_default, "nlimport", item.param3_help)
					}
				}
				
				if (item.param4 != "")
				{
					if (item.param4_type == "option")
					{
						setoptiondiv(item.importtype, item.param4, i + 200, "param4", item.param4_options, item.param4_default, "nlimport", item.param4_help)
					}
					if (item.param4_type == "multioption")
					{
						setmultioptiondiv(item.importtype, item.param4, i + 200, "param4", item.param4_options, item.param4_default, "nlimport", item.param4_help)
					}
					if (item.param4_type == "int")
					{
						setintdiv(item.importtype, item.param4, i + 200, "param4", item.param4_options, item.param4_default, "nlimport", item.param4_help)
					}
					if (item.param4_type == "string")
					{
						setstringdiv(item.importtype, item.param4, i + 200, "param4", item.param4_options, item.param4_default, "nlimport", item.param4_help)
					}
					if (item.param4_type == "file")
					{
						setfilediv(item.importtype, item.param4, i + 200, "param4", item.param4_options, item.param4_default, "nlimport", item.param4_help)
					}
				}
				
				if (item.param5 != "")
				{
					if (item.param5_type == "option")
					{
						setoptiondiv(item.importtype, item.param5, i + 200, "param5", item.param5_options, item.param5_default, "nlimport", item.param5_help)
					}
					if (item.param5_type == "multioption")
					{
						setmultioptiondiv(item.importtype, item.param5, i + 200, "param5", item.param5_options, item.param5_default, "nlimport", item.param5_help)
					}
					if (item.param5_type == "int")
					{
						setintdiv(item.importtype, item.param5, i + 200, "param5", item.param5_options, item.param5_default, "nlimport", item.param5_help)
					}
					if (item.param5_type == "string")
					{
						setstringdiv(item.importtype, item.param5, i + 200, "param5", item.param5_options, item.param5_default, "nlimport", item.param5_help)
					}
					if (item.param5_type == "file")
					{
						setfilediv(item.importtype, item.param5, i + 200, "param5", item.param5_options, item.param5_default, "nlimport", item.param5_help)
					}
				}
				
				if (item.param6 != "")
				{
					if (item.param6_type == "option")
					{
						setoptiondiv(item.importtype, item.param6, i + 200, "param6", item.param6_options, item.param6_default, "nlimport", "")
					}
					if (item.param6_type == "multioption")
					{
						setmultioptiondiv(item.importtype, item.param6, i + 200, "param6", item.param6_options, item.param6_default, "nlimport", "")
					}
					if (item.param6_type == "int")
					{
						setintdiv(item.importtype, item.param6, i + 200, "param6", item.param6_options, item.param6_default, "nlimport", "")
					}
					if (item.param6_type == "string")
					{
						setstringdiv(item.importtype, item.param6, i + 200, "param6", item.param6_options, item.param6_default, "nlimport", "")
					}
					if (item.param6_type == "file")
					{
						setfilediv(item.importtype, item.param6, i + 200, "param6", item.param6_options, item.param6_default, "nlimport", "")
					}
				}
			}
		});

		listas = data[0];
		vlists.option("dataSource", listas);
		vlists.selectRows([-1]);
	}

	function loadNotInListGrids()
	{
		loadelemslist(-1, "not in list");
		loadactions(-1, "not in list");
		loadexports(-1, "not in list");
		loadimports(-1, "not in list");
	}

	function hideAllGrids()
	{
		$("#gridactionlist").hide();
		$("#gridexportlists").hide();
		$("#gridplateslist").hide();
		$("#gridimportlists").hide();
		$("#plateslistdiv").hide();
		$("#imports").hide();
	}

	function configureListClick(objectName, gridName, isOpen)
	{
		$(objectName).click(function()
		{
			if (isOpen)
			{
				$(this).removeClass('abierto');
				$(this).addClass('cerrado');
				$(gridName).hide();
				isOpen = false;
			}
			else
			{
				$(this).addClass('abierto');
				$(this).removeClass('cerrado');
				$(gridName).show();
				isOpen = true;
			}
		});

		return isOpen;
	}

	function createSchedulerButton()
	{
		//initialise scheduler button
		$("#svcheduler").dxButton(
		{
			icon: "check",
			type: "success",
			text: DevExpress.localization.formatMessage("Save scheduler"),
			onClick: function()
			{
				var reservation = $(".reservation-final");
				var finalcal = ["000000000000000000000000", "000000000000000000000000", "000000000000000000000000", "000000000000000000000000", "000000000000000000000000", "000000000000000000000000", "000000000000000000000000", "000000000000000000000000"];
				$.each(reservation, function(i, item)
				{
					var day = parseInt(item.style.top.slice(0, -2)) / 30;
					var starthour = parseInt(item.style.left.slice(0, -2)) / 44;
					var duration = (parseInt(item.style.width.slice(0, -2)) - 1) / 44;
					var i;
					for (i = 0; i < duration; i++)
					{
						finalcal[day] = finalcal[day].replaceAt(starthour + i, "1");
					}
				});


				var query = "update|table=nlaction|camp0=id|value0=" + idaction + "|camp1=listid|value1=" + id_lista;
				query += "|camp2=sunday|value2=" + finalcal[0];
				query += "|camp3=monday|value3=" + finalcal[1];
				query += "|camp4=tuesday|value4=" + finalcal[2];
				query += "|camp5=wednesday|value5=" + finalcal[3];
				query += "|camp6=thursday|value6=" + finalcal[4];
				query += "|camp7=friday|value7=" + finalcal[5];
				query += "|camp8=saturday|value8=" + finalcal[6];
				actdict["act" + idaction].sunday = finalcal[0];
				actdict["act" + idaction].monday = finalcal[1];
				actdict["act" + idaction].tuesday = finalcal[2];
				actdict["act" + idaction].wednesday = finalcal[3];
				actdict["act" + idaction].thursday = finalcal[4];
				actdict["act" + idaction].friday = finalcal[5];
				actdict["act" + idaction].saturday = finalcal[6];

				var response = executeCGI(computerid, query, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);	

				if(response != "error")
				{
					DevExpress.ui.notify("Data saved", "success", 600);
				}
				else
				{
					DevExpress.ui.notify("Data saving error", "error", 600);
				}
			}
		});
	}

	function createImportButton()
	{
		//TODO: Check how to do in Hanwha!! 
		var importbutton = $("#Importbutton").dxFileUploader(
		{
			accept: ".xml, .csv",
			multiple: false,
			value: [],
			width: "50%",
			uploadMode: "instantly",
			selectButtonText: DevExpress.localization.formatMessage("Select import XML/CSV file"),
			labelText: DevExpress.localization.formatMessage("or Drop import XML/CSV file here"),
			invalidFileExtensionMessage: "File type is not allowed",
			allowedFileExtensions: [".XML", ".CSV"],
			chunkSize: 200000,
			uploadUrl: getUrlCgi() + "computerid=" + computerid + "&oper=importlistblob&listid=" + id_lista + "&delete=" + delete_list + localStorage.getItem("TOKEN"),
			showFileList: false,
			onUploaded: function(data)
			{
				loadPanelImports.hide();
				if (data.request.responseText == "format error\r\n")
				{
					DevExpress.ui.notify(data.request.responseText, "error", 1500);
				}
				else
				{
					DevExpress.ui.notify(data.request.responseText, "success", 1500);
				}
				loadelemslist(id_lista, name_lista);
				loadlists();
				checkExportButtons(id_lista);
			},
			onUploadError: function(e)
			{
				loadPanelImports.hide();
				DevExpress.ui.notify("Error uploading file", "error", 1000);
			},
			onUploadStarted: function(e)
			{
				loadPanelImports.show();
			}
		}).dxFileUploader("instance");

		return importbutton;
	}

	function createImportActionButton()
	{
		//TODO: Check how to do in Hanwha!! 
		var importactionbutton = $("#ImportActionsbutton").dxFileUploader(
		{
			accept: ".xml, .csv",
			multiple: false,
			value: [],
			width: "50%",
			uploadMode: "instantly",
			selectButtonText: DevExpress.localization.formatMessage("Select import XML/CSV file"),
			labelText: DevExpress.localization.formatMessage("or Drop import XML/CSV file here"),
			invalidFileExtensionMessage: "File type is not allowed",
			allowedFileExtensions: [".XML", ".CSV"],
			chunkSize: 200000,
			uploadUrl: getUrlCgi() + "computerid=" + computerid + "&oper=importlistactionblob&listid=" + id_lista + "&delete=" + delete_action_list + localStorage.getItem("TOKEN"),
			showFileList: false,
			onUploaded: function(data)
			{
				loadPanelPlatesList.hide();
				if (data.request.responseText == "format error\r\n")
				{
					DevExpress.ui.notify(data.request.responseText, "error", 1500);
				}
				else
				{
					DevExpress.ui.notify(data.request.responseText, "success", 1500);
				}
				loadactions(id_lista, name_lista);
				loadlists();
				checkExportActionButtons(id_lista);
			},
			onUploadError: function(e)
			{
				loadPanelPlatesList.hide();
				DevExpress.ui.notify("Error uploading file", "error", 1000);
			},
			onUploadStarted: function(e)
			{
				loadPanelPlatesList.show();
			}
		}).dxFileUploader("instance");

		return importactionbutton;
	}

	function configureCSS()
	{
		$(".dx-fileuploader-input-wrapper .dx-button").css(
		{
			"background-color": "#5cb85c",
			"border-color": "transparent",
			"color": "#fff"
		});
		
		$(".dx-fileuploader-content > .dx-fileuploader-upload-button").css(
		{
			"background-color": "#5cb85c",
			"border-color": "transparent",
			"color": "#fff"
		});
		
		$(".dx-fileuploader-file-container .dx-button").css(
		{
			"background-color": "#5cb85c",
			"border-color": "transparent",
			"color": "#fff"
		});
	}

	function configureClickButtons()
	{
		$("#ExportXML").dxButton(
		{
			text: DevExpress.localization.formatMessage("Export to XML file"),
			onClick: function()
			{
				window.location = getUrlCgi() + "computerid=" + computerid + "&oper=exportlist&format=XML&listid=" + id_lista + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
			}
		});
		
		$("#ExportCSV").dxButton(
		{
			text: DevExpress.localization.formatMessage("Export to CSV file"),
			onClick: function()
			{
				window.location = getUrlCgi() + "computerid=" + computerid + "&oper=exportlist&format=CSV&listid=" + id_lista + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
			}
		});
		
		$("#ExportActionsXML").dxButton(
		{
			text: DevExpress.localization.formatMessage("Export to XML file"),
			onClick: function()
			{
				window.location = getUrlCgi() + "computerid=" + computerid + "&oper=exportactionlist&format=XML&listid=" + id_lista + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
			}
		});
		
		$("#ExportActionsCSV").dxButton(
		{
			text: DevExpress.localization.formatMessage("Export to CSV file"),
			onClick: function()
			{
				window.location = getUrlCgi() + "computerid=" + computerid + "&oper=exportactionlist&format=CSV&listid=" + id_lista + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN");
			}
		});
	}

	function loadPanelPosition()
	{
		loadPanelPlatesList = $(".loadpanel").dxLoadPanel(
		{
			shadingColor: "rgba(0,0,0,0.4)",
			position:
			{
				of: "#gridplateslist"
			},
			visible: false,
			showIndicator: true,
			showPane: true,
			shading: true,
			message: DevExpress.localization.formatMessage("Importing..."),
			closeOnOutsideClick: false
		}).dxLoadPanel("instance");
		
		loadPanelImports = $(".loadpanel").dxLoadPanel(
		{
			shadingColor: "rgba(0,0,0,0.4)",
			position:
			{
				of: "#importsdiv"
			},
			visible: false,
			showIndicator: true,
			showPane: true,
			shading: true,
			message: DevExpress.localization.formatMessage("Importing..."),
			closeOnOutsideClick: false
		}).dxLoadPanel("instance");
	}

	function initializeScheduler()
	{
		// Array of sample items
		var Days = [DevExpress.localization.formatMessage('Sun'), DevExpress.localization.formatMessage('Mon'), DevExpress.localization.formatMessage('Tue'), DevExpress.localization.formatMessage('Wed'), DevExpress.localization.formatMessage('Thu'), DevExpress.localization.formatMessage('Fri'), DevExpress.localization.formatMessage('Sat')];
		
		// Initialize
		var sch = $("#scheduler").scheduler(
		{
			items: Days,
			startDate: new Date(),
			startTime: '00:00',
			endTime: '24:00',
			use24Hour: true,
			timeslotHeight: 30,
			timeslotWidth: 44
		});
		
		// Allows for reservation deletion
		$(document).on('click', ".reservation", function()
		{
			$(this).remove();
		});
	}

	String.prototype.replaceAll = function(search, replacement)
	{
		var target = this;
		return target.replace(new RegExp(search, 'g'), replacement);
	};
	
	String.prototype.includes = function(str)
	{
		var returnValue = false;
		if (this.indexOf(str) !== -1)
		{
			returnValue = true;
		}
		return returnValue;
	}

	String.prototype.replaceAt = function(index, replacement)
	{
		return this.substr(0, index) + replacement + this.substr(index + replacement.length);
	}

	var MAX_TOTAL_ACTIONS = 12 // IMPORTANTE!!! MANTENER ESTE VALOR EN CONSONANCIA CON EL BACK-END----> declarado en dbtableaction.h linea 7 {const int MAX_ACTIONS = 12}
	var currentNumberOfActions = 0;
	var MAX_TOTAL_EXPORTS = 200; //IDEM QUE ANTES, MANTENER ESTOS VALORES CON LOS DEL BACK-END
	var currentNumberOfExports = 0;
	var MAX_TOTAL_IMPORTS = 200;
	var currentNumberOfImports = 0;

	var id_lista = -1;
	var name_lista = "";
	var elem_listas;
	var listas;
	var actions_listas;
	var exports_listas;
	var imports_listas;
	var delete_list = false;
	var delete_action_list = false;
	var listypesabierto = true;
	var listplatesabierto = false;
	var listactionsabierto = false;
	var listexportsabierto = false;
	var listimportsabierto = false;
	var schedulerdivabierto = false;
	var conditiondivabierto = true;
	var idaction = 1;
	var idexport = 1;
	var optionactions = [];
	var optionexports = [];
	var optionimports = [];
	var importlist;
	var selectedaction;
	var selectedexport;
	var selectedimport;
	var actdict = {};
	var expdict = {};
	var impdict = {};
	var actdefaultdict = {};
	var expdefaultdict = {};
	var impdefaultdict = {};
	var d2;
	var loadingChBx = false;
	var updated = true;
	var isDisable = false;
	var httpImgOldValue = [false,false,false];
	var ftpImgOldValue = [false,false,false];
	var ftpExpImgOldValue = [false,false,false];
	var currentNumberOfLists = 0;
	var max_num_lists = 200;
	var showaddrow = true;

	var showaddrowActions = true;
	var showaddrowExports = true;
	var showaddrowImports = true;

	var loadPanelPlatesList;
	var loadPanelImports;

	Init_translate();

	var enabledarray = [
	{
		"id": 0,
		"description": DevExpress.localization.formatMessage("Disabled")
	},
	{
		"id": 1,
		"description": DevExpress.localization.formatMessage("Enabled")
	}];
	
	var enabledarrayexport = [
	{
		"id": 0,
		"description": DevExpress.localization.formatMessage("Disabled")
	},
	{
		"id": 1,
		"description": DevExpress.localization.formatMessage("Enabled")
	},
	{
		"id": 2,
		"description": DevExpress.localization.formatMessage("Enabled if change")
	}];
	
	var intervalarray = [
	{
		"id": "minute",
		"description": DevExpress.localization.formatMessage("Minute")
	},
	{
		"id": "minute3",
		"description": DevExpress.localization.formatMessage("3 minutes")
	},
	{
		"id": "minute5",
		"description": DevExpress.localization.formatMessage("5 minutes")
	},
	{
		"id": "minute10",
		"description": DevExpress.localization.formatMessage("10 minutes")
	},
	{
		"id": "minute15",
		"description": DevExpress.localization.formatMessage("15 minutes")
	},
	{
		"id": "minute30",
		"description": DevExpress.localization.formatMessage("30 minutes")
	},
	{
		"id": "hour",
		"description": DevExpress.localization.formatMessage("Hour")
	},
	{
		"id": "day",
		"description": DevExpress.localization.formatMessage("Day")
	},
	{
		"id": "week",
		"description": DevExpress.localization.formatMessage("Week")
	},
	{
		"id": "month",
		"description": DevExpress.localization.formatMessage("Month")
	}];

	make_header("list");

	setPropertiesTexts();

	set_rcpopup();

	configureWebIcon();

	d2 = getimeCamera();

	getNumbersOfAllLists();

	$("#actions").hide();

	var importbutton = createImportButton();

	var importactionbutton = createImportActionButton();

	var plates = createPlatesGrid();

	var vlists = createListsGrid();

	var actions = createActionsGrid();

	var exports = createExportsGrid();

	var imports = createImportsGrid();

	loadAllLists();

	loadNotInListGrids();

	hideAllGrids();

	listypesabierto = configureListClick("#listtypes", "#gridlistytpes", listypesabierto);

	listplatesabierto = configureListClick("#plateslist", "#gridplateslist", listplatesabierto);

	listactionsabierto = configureListClick("#actionlist", "#gridactionlist", listactionsabierto);

	listexportsabierto = configureListClick("#exportstitle", "#gridexportlists", listexportsabierto);
	
	listimportsabierto = configureListClick("#importstitle", "#gridimportlists", listimportsabierto);

	schedulerdivabierto = configureListClick("#schedulertitle", "#schedulerdiv", schedulerdivabierto);
	
	conditiondivabierto = configureListClick("#conditiontitle", "#conditiondiv", conditiondivabierto);

	initializeScheduler();

	createSchedulerButton();

	configureCSS();

	configureClickButtons();

	loadPanelPosition();
});