////////////////
// AUDIT PAGE //
////////////////

$(function()
{
	function setPropertiesTexts()
	{
		$("#labelFrom").text(DevExpress.localization.formatMessage("From date") + ":");
		$("#labeltodate").text(DevExpress.localization.formatMessage("To date") + ":");
		$("#labelType").text(DevExpress.localization.formatMessage("Type") + ":");
		$("#shnumreg").text(DevExpress.localization.formatMessage("Show num registers:"));
	}

	function createExportButton()
	{
		$("#export").dxButton(
		{
			type: "success",
			height: 40,
			text: DevExpress.localization.formatMessage("ExportBut"),
			onClick: function()
			{
				var moreparams = "";
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				var table = "";
				if (list == DevExpress.localization.formatMessage("action"))
				{
					table = "nlactionres";
				}
				else if (list == DevExpress.localization.formatMessage("import"))
				{
					table = "nlimportres";
				}
				else
				{
					table = "nlexportres";
				}
				var win = window.open(getUrlCgi() + "computerid=" + computerid + "&oper=exportresults&table=" + table + "&camp0=timestamp&comp0=between&value0=" + getStringNormalDate(initDayDate.option('value')) + ";" + getStringNormalDate2(finDayDate.option('value')) + "&dd" + getStringNormalDate(new Date()) + localStorage.getItem("TOKEN"), '_blank');
				if (win)
				{
					//Browser has allowed it to be opened
					win.focus();
				}
				else
				{
					//Browser has blocked it
					alert('Please allow popups for this website');
				}
			}
		});
	}

	function createFirstPageButton()
	{
		$("#FirstPage").dxButton(
		{
			type: "success",
			height: 40,
			text: DevExpress.localization.formatMessage("First page"),
			onClick: function(data2)
			{
				page_actual = 1;
				$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
				var moreparams = "";
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				var table = "";
				if (list == DevExpress.localization.formatMessage("action"))
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
					table = "nlactionres";
				}
				else if (list == DevExpress.localization.formatMessage("import"))
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
					table = "nlimportres";
				}
				else
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
					table = "nlexportres";
				}
				
				var dataValue = executeCGI(computerid, "select|table=" + table + "|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(initDayDate.option('value')) + ";" + getStringNormalDate2(finDayDate.option('value')) + moreparams + "|maxvalues=" + num_regs + "|offset=" + ((page_actual - 1) * num_regs) + "|dd", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
				var dataGrid = $('#gridContainer').dxDataGrid('instance');
				dataGrid.option("dataSource", dataValue);
			}
		});
	}

	function createLastPageButton()
	{
		$("#LastPage").dxButton(
		{
			type: "success",
			height: 40,
			text: DevExpress.localization.formatMessage("Last page"),
			onClick: function(data2)
			{
				page_actual = num_pages;
				$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
				var moreparams = "";
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				var table = "";
				if (list == DevExpress.localization.formatMessage("action"))
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
					table = "nlactionres";
				}
				else if (list == DevExpress.localization.formatMessage("import"))
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
					table = "nlimportres";
				}
				else
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
					table = "nlexportres";
				}
				var query = buildPageQueryByOffset(table, initDayDate, finDayDate, page_actual, num_regs, moreparams, sortby_order);
				var dataValue = executeCGI(computerid, query, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
				var dataGrid = $('#gridContainer').dxDataGrid('instance');
				dataGrid.option("dataSource", dataValue);
			}
		});
	}

	function createPageAntButton()
	{
		$("#PageAnt").dxButton(
		{
			type: "success",
			height: 40,
			text: DevExpress.localization.formatMessage("<< Before"),
			onClick: function(data2)
			{
				if (page_actual > 1)
				{
					page_actual--;
				}
				$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
				var moreparams = "";
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				var table = "";
				if (list == DevExpress.localization.formatMessage("action"))
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
					table = "nlactionres";
				}
				else if (list == DevExpress.localization.formatMessage("import"))
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
					table = "nlimportres";
				}
				else
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
					table = "nlexportres";
				}			
				
				var query = buildPageQueryByOffset(table, initDayDate, finDayDate, page_actual, num_regs, moreparams, sortby_order);
				var dataValue = executeCGI(computerid, query, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
				var dataGrid = $('#gridContainer').dxDataGrid('instance');
				dataGrid.option("dataSource", dataValue);
			}
		});
	}

	function createPageSigButton()
	{
		$("#PageSig").dxButton(
		{
			type: "success",
			height: 40,
			text: DevExpress.localization.formatMessage("Next >>"),
			onClick: function(data2)
			{
				if (page_actual < num_pages)
				{
					page_actual++;
				}
				$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
				var moreparams = "";
				var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
				var table = "";
				if (list == DevExpress.localization.formatMessage("action"))
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
					table = "nlactionres";
				}
				else if (list == DevExpress.localization.formatMessage("import"))
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
					table = "nlimportres";
				}
				else
				{
					$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
					$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
					table = "nlexportres";
				}			
				var query = buildPageQueryByOffset(table, initDayDate, finDayDate, page_actual, num_regs, moreparams, sortby_order);
				var dataValue = executeCGI(computerid, query, getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
				var dataGrid = $('#gridContainer').dxDataGrid('instance');
				dataGrid.option("dataSource", dataValue);
			}
		});
	}

	function loadResults()
	{
		var configs = executeCGI(computerid, "getconfig", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
		$.each(configs[0], function(i, item)
		{
			dictlist[item.id] = item.description;
		});
		$.each(configs[2], function(i, item)
		{
			dictactions[item.actiontype] = item.text;
		});
		$.each(configs[3], function(i, item)
		{
			dictexports[item.exporttype] = item.text;
		});
		$.each(configs[4], function(i, item)
		{
			dictimports[item.importtype] = item.text;
		});
	}

	function createDateTime(name, dateValue)
	{
		var data = $(name).dxDateBox(
			{
				type: "datetime",
				displayFormat: "dd/MM/yyyy HH:mm:ss",
				value: dateValue
			}).dxDateBox('instance');
		return data;
	}

	function createPaginitas()
	{
		var paginitas = $("#paginitas").dxTextBox(
		{
			readOnly: true,
			width: 120,
			value: ""
		});
	}
	
	function createTypeSelector()
	{
		$("#radio-group-simple").dxSelectBox(
		{
			dataSource: priorities,
			value: DevExpress.localization.formatMessage("export"),
		});
	}

	function createShowNomRegister()
	{
		$("#numreg").dxSelectBox(
		{
			items: [10, 20, 50, 100],
			value: 10
		});
	}

	function createMediumIndicator()
	{
		$("#medium-indicator").dxLoadIndicator(
		{
			height: 40,
			width: 40
		});
		$("#medium-indicator").hide();
	}

	function hideAllButton()
	{
		$("#PageAnt").hide();
		$("#PageSig").hide();
		$("#paginitas").hide();
		$("#FirstPage").hide();
		$("#LastPage").hide();
	}

	function showAllButton()
	{
		$("#PageAnt").show();
		$("#PageSig").show();
		$("#paginitas").show();
		$("#FirstPage").show();
		$("#LastPage").show();
	}

	function createIconDoneInfo()
	{
		$("#icon-done_info").dxButton(
		{
			type: "success",
			height: 40,
			text: DevExpress.localization.formatMessage("Search"),
			onClick: function(data2)
			{
				if (initDayDate.option('value') > finDayDate.option('value'))
				{
					DevExpress.ui.dialog.alert(DevExpress.localization.formatMessage("The 'from date' can not be greater than  'to date'"));
				}
				else if(initDayDate.option('value') == undefined || initDayDate.option('value') == "" || finDayDate.option('value') == undefined || finDayDate.option('value') == "")
				{
					var msg1 = "";
					msg1 = DevExpress.localization.formatMessage("Invalid dates");
					
					DevExpress.ui.dialog.alert(msg1);
				}
				else
				{
					var i = 1;
					var moreparams = "";
					data2.component.option("text", DevExpress.localization.formatMessage("Searching"));
					$("#medium-indicator").show();
					var list = $("#radio-group-simple").dxSelectBox('instance').option('value');
					num_regs = $("#numreg").dxSelectBox('instance').option('value');
					var table = "";
					if (list == DevExpress.localization.formatMessage("action"))
					{
						$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", true);
						$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", false);
						table = "nlactionres";
					}
					else if (list == DevExpress.localization.formatMessage("import"))
					{
						$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
						$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
						table = "nlimportres";
					}
					else
					{
						$("#gridContainer").dxDataGrid("columnOption", "idresult", "visible", false);
						$("#gridContainer").dxDataGrid("columnOption", "registers", "visible", true);
						table = "nlexportres";
					}
					hideAllButton();
	
						num_registros_consulta = executeCGI(computerid, "count|table=" + table + "|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(initDayDate.option('value')) + ";" + getStringNormalDate2(finDayDate.option('value')) + moreparams + "|dd", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), false);
						if (num_registros_consulta > 0)
						{
							var data = executeCGI(computerid, "select|table=" + table + "|camp0=timestamp|comp0=between|value0=" + getStringNormalDate(initDayDate.option('value')) + ";" + getStringNormalDate2(finDayDate.option('value')) + moreparams + "|maxvalues=" + num_regs + "|dd", getStringNormalDate(new Date()), localStorage.getItem("TOKEN"), true);
							data2.component.option("text", DevExpress.localization.formatMessage("Search"));
							$("#medium-indicator").hide();
							var dataGrid = $('#gridContainer').dxDataGrid('instance');
							dataGrid.option("dataSource", data);
							dataGrid.option('paging.pageSize', num_regs);
							page_actual = 1;
							num_pages = Math.ceil(num_registros_consulta / num_regs);
							$('#paginitas').dxTextBox('instance').option('value', DevExpress.localization.formatMessage("Pag.") + " " + page_actual + "/" + num_pages);
							if (num_pages > 1)
							{
								showAllButton();
							}
						}
						else
						{
							data2.component.option("text", DevExpress.localization.formatMessage("Search"));
							$("#medium-indicator").hide();
							var dataGrid = $('#gridContainer').dxDataGrid('instance');
							dataGrid.option("dataSource", []);
						}
					//}
				}
			}
		});
	}

	function createGridContainer()
	{
		$("#gridContainer").dxDataGrid(
		{
			dataSource: results,
			showBorders: true,
			showRowLines: true,
			keyExpr: "id",
			width: 1150,
			hoverStateEnabled: true,
			searchPanel:
			{
				visible: true,
				width: 240,
				placeholder: DevExpress.localization.formatMessage("Search...")
			},
			pager:
			{
				visible: false
			},
			columns: [
			{
				dataField: "id",
				caption: "ID",
				width: 80,
			},
			{
				dataField: "timestamp",
				dataType: "date",
				caption: DevExpress.localization.formatMessage("Time"),
				width: 180,
				format: "HH:mm:ss.SSS dd/MM/yyyy"
			},
			{
				width: 90,
				dataField: "status",
				caption: DevExpress.localization.formatMessage("Status"),
				cellTemplate: function(element, info)
				{
					element.append(DevExpress.localization.formatMessage(info.text));
				}
			},
			{
				width: 100,
				dataField: "subtype",
				caption: DevExpress.localization.formatMessage("Type"),
				cellTemplate: function(element, info)
				{
					if (typeof dictactions[info.text] !== 'undefined')
					{
						element.append(dictactions[info.text]);
					}
					else if (typeof dictexports[info.text] !== 'undefined')
					{
						element.append(dictexports[info.text]);
					}
					else
					{
						element.append(dictimports[info.text]);
					}
				}
			},
			{
				width: 80,
				dataField: "idresult",
				caption: DevExpress.localization.formatMessage("Res.")
			},
			{
				width: 140,
				dataField: "listid",
				caption: DevExpress.localization.formatMessage("List"),
				cellTemplate: function(element, info)
				{
					var listastring = dictlist[info.text];
					element.append(listastring);
				}
			},
			{
				width: 290,
				dataField: "description",
				caption: DevExpress.localization.formatMessage("Description")
			},
			{
				width: 60,
				dataField: "registers",
				caption: DevExpress.localization.formatMessage("Num.")
			},
			{
				width: 120,
				dataField: "resultfile",
				caption: DevExpress.localization.formatMessage("File"),
				cellTemplate: function(element, info)
				{
					if (info.text != "")
					{
						element.append("<a  href='" + pathcgi + "cgi-bin/vparcgi.cgi?computerid=" + computerid + "&oper=getfile&path=" + info.text + localStorage.getItem("TOKEN") + "' >" + DevExpress.localization.formatMessage("Get file") + "</a> ")
					}
				}
			}],

			onRowPrepared: function(row)
			{
				if (row.rowType == "data")
				{
					if (row.values[2] != "DONE")
					{
						row.rowElement.addClass('Red');
					}
				}
			}
		});
	}

	var priorities;
	var d2 = new Date();
	var dateiniday;
	var dateendday;
	var results = [];
	var dictlist = {};
	var dictactions = {};
	var dictexports = {};
	var dictimports = {};

	var num_registros_consulta = 0;
	var num_pages = 0;
	var page_actual = 0;
	var num_regs = 10;
	var sortby_order="sortasc=id";
	

	Init_translate();

	priorities = [DevExpress.localization.formatMessage("export"), DevExpress.localization.formatMessage("import"), DevExpress.localization.formatMessage("action")];
	d2 = getimeCamera();
	dateiniday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 0, 0, 0);
	dateendday = new Date(d2.getFullYear(), d2.getMonth(), d2.getDate(), 23, 59, 59);
	
	make_header("historic");
	
	setPropertiesTexts();

	set_rcpopup();
	
	configureWebIcon();


	loadResults();

	var initDayDate = createDateTime("#data1", dateiniday);
	var finDayDate = createDateTime("#data2", dateendday);
		
	createPaginitas();
	
	createTypeSelector();
	
	createShowNomRegister();

	createMediumIndicator();
	
	createExportButton();

	createFirstPageButton();

	createLastPageButton();

	createPageAntButton();

	createPageSigButton();
	
	hideAllButton();

	createIconDoneInfo();

	createGridContainer();
	
});