///////////////////////////////////////////////////////////////////
//File:			PlayMpeg4.h
//Date:			2011-01-05
//Description:	Interface for PlayM4.dll
///////////////////////////////////////////////////////////////////
#ifndef PLAY_M4
#define  PLAY_M4

#include <Windows.h>
#include "playm4_common.h"
#ifdef __cplusplus
extern "C"
{
#endif

#ifdef	PLAYM4_API
#else
#define PLAYM4_API extern "C" __declspec(dllimport)
#endif

#define WINAPI __stdcall


//Max channel numbers
#define PLAYM4_MAX_SUPPORTS 500
//Wave coef range;
#define MIN_WAVE_COEF -100
#define MAX_WAVE_COEF 100

//Timer type
#define TIMER_1 1 //Only 16 timers for every process.Default TIMER;
#define TIMER_2 2 //Not limit;But the precision less than TIMER_1; 
//BUFFER TYPE
#define BUF_VIDEO_SRC 1
#define BUF_AUDIO_SRC 2
#define BUF_VIDEO_RENDER 3
#define BUF_AUDIO_RENDER 4

//Error code
#define  PLAYM4_NOERROR					0	//no error
#define	 PLAYM4_PARA_OVER				1	//input parameter is invalid;
#define  PLAYM4_ORDER_ERROR				2	//The order of the function to be called is error.
#define	 PLAYM4_TIMER_ERROR				3	//Create multimedia clock failed;
#define  PLAYM4_DEC_VIDEO_ERROR			4	//Decode video data failed.
#define  PLAYM4_DEC_AUDIO_ERROR			5	//Decode audio data failed.
#define	 PLAYM4_ALLOC_MEMORY_ERROR		6	//Allocate memory failed.
#define  PLAYM4_OPEN_FILE_ERROR			7	//Open the file failed.
#define  PLAYM4_CREATE_OBJ_ERROR		8	//Create thread or event failed
#define  PLAYM4_CREATE_DDRAW_ERROR		9	//Create DirectDraw object failed.
#define  PLAYM4_CREATE_OFFSCREEN_ERROR 10	//failed when creating off-screen surface.
#define  PLAYM4_BUF_OVER			   11	//buffer is overflow
#define  PLAYM4_CREATE_SOUND_ERROR	   12	//failed when creating audio device.	
#define	 PLAYM4_SET_VOLUME_ERROR	   13	//Set volume failed
#define  PLAYM4_SUPPORT_FILE_ONLY	   14	//The function only support play file.
#define  PLAYM4_SUPPORT_STREAM_ONLY	   15	//The function only support play stream.
#define  PLAYM4_SYS_NOT_SUPPORT		   16	//System not support.
#define  PLAYM4_FILEHEADER_UNKNOWN     17	//No file header.
#define  PLAYM4_VERSION_INCORRECT	   18	//The version of decoder and encoder is not adapted.  
#define  PLAYM4_INIT_DECODER_ERROR     19	//Initialize decoder failed.
#define  PLAYM4_CHECK_FILE_ERROR	   20	//The file data is unknown.
#define  PLAYM4_INIT_TIMER_ERROR	   21	//Initialize multimedia clock failed.
#define	 PLAYM4_BLT_ERROR			   22	//Blt failed.
#define  PLAYM4_UPDATE_ERROR		   23	//Update failed.
#define  PLAYM4_OPEN_FILE_ERROR_MULTI  24   //openfile error, streamtype is multi
#define  PLAYM4_OPEN_FILE_ERROR_VIDEO  25   //openfile error, streamtype is video
#define  PLAYM4_JPEG_COMPRESS_ERROR    26   //JPEG compress error
#define  PLAYM4_EXTRACT_NOT_SUPPORT    27	//Don't support the version of this file.
#define  PLAYM4_EXTRACT_DATA_ERROR     28	//extract video data failed.
#define  PLAYM4_SECRET_KEY_ERROR       29	//Secret key is error //
//Max display regions.
#define MAX_DISPLAY_WND 4

//Display buffers
#define MAX_DIS_FRAMES 50
#define MIN_DIS_FRAMES 1

//Locate by
#define BY_FRAMENUM  1
#define BY_FRAMETIME 2

//Source buffer
#define SOURCE_BUF_MAX	1024*100000
#define SOURCE_BUF_MIN	1024*50

//Stream type
#define STREAME_REALTIME 0
#define STREAME_FILE	 1

//frame type
#define T_AUDIO16	101
#define T_AUDIO8	100
#define T_UYVY		1
#define T_YV12		3
#define T_RGB32		7
//capability
#define SUPPORT_DDRAW		1 
#define SUPPORT_BLT         2 
#define SUPPORT_BLTFOURCC   4 
#define SUPPORT_BLTSHRINKX  8 
#define SUPPORT_BLTSHRINKY  16
#define SUPPORT_BLTSTRETCHX 32
#define SUPPORT_BLTSTRETCHY 64
#define SUPPORT_SSE         128
#define SUPPORT_MMX			256 

// º궨HIK_MEDIAINFOṹ
#define FOURCC_HKMI			0x484B4D49	// "HKMI" HIK_MEDIAINFOṹ
// ϵͳװʽ	
#define SYSTEM_NULL			0x0				// ûϵͳ㣬ƵƵ	
#define SYSTEM_HIK          0x1				// ļ
#define SYSTEM_MPEG2_PS     0x2				// PSװ
#define SYSTEM_MPEG2_TS     0x3				// TSװ
#define SYSTEM_RTP          0x4				// rtpװ

// Ƶ
#define VIDEO_NULL          0x0 // ûƵ
#define VIDEO_H264          0x1 // ׼H.264ͺH.264
#define VIDEO_MPEG4         0x3 // ׼MPEG4

// Ƶ
#define AUDIO_NULL          0x0000 // ûƵ
#define AUDIO_ADPCM         0x1000 // ADPCM 
#define AUDIO_MPEG          0x2000 // MPEG ϵƵӦMPEGƵ
// GϵƵ
#define AUDIO_G711_U		0x7110
#define AUDIO_G711_A		0x7111
#define AUDIO_G722_1		0x7221
#define AUDIO_G723_1        0x7231
#define AUDIO_G726          0x7260
#define AUDIO_G729          0x7290

//Frame position
typedef struct{
	long nFilePos;
	long nFrameNum;
	long nFrameTime;
	long nErrorFrameNum;
	SYSTEMTIME *pErrorTime;
	long nErrorLostFrameNum;
	long nErrorFrameSize;
}FRAME_POS,*PFRAME_POS;

//Frame Info
typedef struct{
	long nWidth;
	long nHeight;
	long nStamp;
	long nType;
	long nFrameRate;
	DWORD dwFrameNum;
}FRAME_INFO;

//Frame 
typedef struct{
	char *pDataBuf;
	long  nSize;
	long  nFrameNum;
	BOOL  bIsAudio;
	long  nReserved;
}FRAME_TYPE;

//Watermark Info	//add by gb 080119
typedef struct{
	char *pDataBuf;
	long  nSize;
	long  nFrameNum;
	BOOL  bRsaRight;
	long  nReserved;
}WATERMARK_INFO;

#ifndef _HIK_MEDIAINFO_FLAG_
#define _HIK_MEDIAINFO_FLAG_
typedef struct _HIK_MEDIAINFO_	
{
	unsigned int    media_fourcc;			// "HKMI": 0x484B4D49 Hikvision Media Information
	unsigned short  media_version;			// 汾ţָϢṹ汾ţĿǰΪ0x0101,1.01汾01汾ţ01Ӱ汾š
	unsigned short  device_id;				// 豸IDڸ/			
    
	unsigned short  system_format;          // ϵͳװ
    unsigned short  video_format;           // Ƶ

    unsigned short  audio_format;           // Ƶ
	unsigned char   audio_channels;         // ͨ  
    unsigned char   audio_bits_per_sample;  // λ
    unsigned int    audio_samplesrate;      //  
    unsigned int    audio_bitrate;          // ѹƵ,λbit

    unsigned int    reserved[4];            // 
}HIK_MEDIAINFO;
#endif

PLAYM4_API BOOL WINAPI PlayM4_SDKInit();
PLAYM4_API BOOL WINAPI PlayM4_SDKUnInit();
PLAYM4_API BOOL WINAPI PlayM4_GetPort2(LONG* nPort);
PLAYM4_API BOOL WINAPI PlayM4_FreePort(LONG nPort);
PLAYM4_API BOOL WINAPI PlayM4_SetStreamOpenMode(LONG nPort,DWORD nMode);
PLAYM4_API BOOL WINAPI PlayM4_OpenStream(LONG nPort,PBYTE pFileHeadBuf,DWORD nSize,DWORD nBufPoolSize);
PLAYM4_API BOOL WINAPI PlayM4_CloseStream(LONG nPort);
PLAYM4_API BOOL WINAPI PlayM4_OpenFile(LONG nPort,LPSTR sFileName);
PLAYM4_API BOOL WINAPI PlayM4_CloseFile(LONG nPort);
PLAYM4_API BOOL WINAPI PlayM4_InputData(LONG nPort,PBYTE pBuf,DWORD nSize);
PLAYM4_API BOOL WINAPI PlayM4_SetVolume(LONG nPort,WORD nVolume);
PLAYM4_API BOOL WINAPI PlayM4_StopSound();
PLAYM4_API BOOL WINAPI PlayM4_PlaySound(LONG nPort);
PLAYM4_API BOOL WINAPI PlayM4_Play(LONG nPort, HWND hWnd);
PLAYM4_API BOOL WINAPI PlayM4_Stop(LONG nPort);
PLAYM4_API BOOL WINAPI PlayM4_Pause(LONG nPort,DWORD nPause);
PLAYM4_API BOOL WINAPI PlayM4_Fast(LONG nPort);
PLAYM4_API BOOL WINAPI PlayM4_Slow(LONG nPort);
PLAYM4_API BOOL WINAPI PlayM4_OneByOne(LONG nPort);
PLAYM4_API BOOL WINAPI PlayM4_OneByOneBack(LONG nPort);
PLAYM4_API BOOL WINAPI PlayM4_GetPlayPos(LONG nPort,float & fRelativePos);
PLAYM4_API BOOL WINAPI PlayM4_SetPlayPos(LONG nPort,float fRelativePos);
PLAYM4_API BOOL WINAPI PlayM4_CaptureImage(LONG nPort, unsigned char *pBuf, unsigned long *plWidth, unsigned long *plHeight);
PLAYM4_API BOOL WINAPI PlayM4_ConvertToBmpFile(unsigned char * pBuf, LONG nSize, LONG nWidth, LONG nHeight, LONG nType,char *sFileName);
PLAYM4_API BOOL WINAPI PlayM4_OpenTalk(fVoiceDataCallBack VoiceEncData, long lNetType, void *pUserData);
PLAYM4_API BOOL WINAPI PlayM4_CloseTalk();
PLAYM4_API BOOL WINAPI PlayM4_InputTalkData(unsigned char *pRecvDataBuffer, DWORD dwBufSize, unsigned __int64 Pts );
PLAYM4_API BOOL WINAPI PlayM4_RigisterDrawFun(LONG nPort, fDrawFun DrawOSDFunc,LONG nUser);
PLAYM4_API char* WINAPI	PlayM4_GetSdkVersion();

#ifdef __cplusplus
}
#endif

#endif

