#ifndef _PLAYM4_COMMON_STRUCTS_H_
#define  _PLAYM4_COMMON_STRUCTS_H_

#include <Windows.h>
#ifdef __cplusplus
extern "C" {
#endif


#pragma pack(4)

#define		PLAYM4_ERR_SRC_NETWORK			0x00000001L
#define		PLAYM4_ERR_SRC_IO					0x00000002L
#define		PLAYM4_ERR_SRC_REMOTE				0x00000003L
#define		PLAYM4_ERR_SRC_AVDATA				0x00000004L
#define		PLAYM4_ERR_SRC_MEMORY				0x00000005L
#define		PLAYM4_ERR_SRC_PARAMETER			0x00000006L
#define		PLAYM4_ERR_SRC_THREAD				0x00000007L
#define		PLAYM4_ERR_SRC_OTHER				0x000000F0L
#define		PLAYM4_ERR_SRC_RESERVED			0x000000FEL
#define		PLAYM4_ERR_SRC_UNKNOWN			0x000000FFL

#define     PLAYM4_ERR_SUCCESS                0x00000000L

#define		PLAYM4_ERR_UNKNOWN				0x80FF0000L
#define		PLAYM4_ERR_UNKNOWN_ALL			0x80FF0000L


#define		PLAYM4_ERR_NET_NOTINIT				0x80010001L
#define		PLAYM4_ERR_NET_CRSCK_FAILED			0x80010002L
#define		PLAYM4_ERR_NET_CONNECT_FAILED		0x80010003L
#define		PLAYM4_ERR_NET_SENDDATA_FAILED		0x80010004L
#define		PLAYM4_ERR_NET_IP_INVALID			0x80010005L
#define		PLAYM4_ERR_NET_HOST_INVALID			0x80010006L
#define		PLAYM4_ERR_NET_GETHOST_FAILED		0x80010007L
#define		PLAYM4_ERR_NET_READDATA_FAILED		0x80010008L
#define		PLAYM4_ERR_NET_DEVICENOTONLINE		0x80010009L
#define		PLAYM4_ERR_NET_DISCONNECTED			0x8001000AL
#define		PLAYM4_ERR_NET_TIMEOUT_CONNECT		0x8001000BL
#define		PLAYM4_ERR_NET_INIT_FAILED			0x8001000CL
#define		PLAYM4_ERR_NET_UNINIT_FAILED			0x8001000DL
#define		PLAYM4_ERR_NET_NOTALL_FAILED			0x8001000EL
#define		PLAYM4_ERR_NET_LOGIN_FAILED			0x8001000FL
#define		PLAYM4_ERR_NET_BINDADDR_FAILED		0x80010010L
#define		PLAYM4_ERR_NET_BINDIP_FAILED			0x80010011L
#define		PLAYM4_ERR_NET_GETACCEPT_FAILED		0x80010012L
#define		PLAYM4_ERR_NET_LISTEN_FAILED			0x80010013L
#define		PLAYM4_ERR_NET_REGEVENT_ACCEPT		0x80010014L
#define		PLAYM4_ERR_NET_BINDCPORT_FAILED		0x80010015L
#define		PLAYM4_ERR_NET_NODATA					0x80010016L
#define		PLAYM4_ERR_NET_IOPENDING				0x80010017L
#define		PLAYM4_ERR_NET_SETRECVSOCKET			0x80010018L
#define		PLAYM4_ERR_NET_TASK_NOTSUPPORT		0x80010019L


#define		PLAYM4_ERR_IO_PLAYING					0x80020001L
#define		PLAYM4_ERR_IO_NOTPLAYING				0x80020002L
#define		PLAYM4_ERR_IO_SAVING					0x80020003L
#define		PLAYM4_ERR_IO_NOTSAVEING				0x80020004L
#define		PLAYM4_ERR_IO_OPENFILE_FAILED		0x80020005L
#define		PLAYM4_ERR_IO_FILELEN_ERROR			0x80020006L
#define		PLAYM4_ERR_IO_NOSPACE					0x80020007L
#define		PLAYM4_ERR_IO_ALARMEMPTY				0x80020008L
#define		PLAYM4_ERR_IO_READ_FILE_FAILED		0x80020009L
#define		PLAYM4_ERR_IO_TYPE_NOT_SUPPORT		0x8002000AL
#define		PLAYM4_ERR_IO_OPENDECODER_FAILED 	0x8002000BL
#define		PLAYM4_ERR_IO_FILEEXIST				0x8002000CL
#define		PLAYM4_ERR_IO_READHEADER_FAILED		0x8002000DL
#define		PLAYM4_ERR_IO_OFFSETTOOLONG			0x8002000EL
#define		PLAYM4_ERR_IO_OFFSETTOOLSHORT		0x8002000FL
#define		PLAYM4_ERR_IO_NOTCLIPALL				0x80020010L
#define		PLAYM4_ERR_IO_TIMEFMTINCORRECT		0x80020011L
#define		PLAYM4_ERR_IO_FILEOPENED				0x80020012L
#define		PLAYM4_ERR_IO_FILENAMEINCORRECT		0x80020013L
#define		PLAYM4_ERR_IO_FILENOTOPENED			0x80020014L
#define		PLAYM4_ERR_IO_CREATETIMERFAILED		0x80020015L
#define		PLAYM4_ERR_IO_CLIPPING				0x80020016L
#define		PLAYM4_ERR_IO_GETFULLPATH_FAILED 	0x80020017L
#define		PLAYM4_ERR_IO_DIRTOODEEP				0x80020018L
#define		PLAYM4_ERR_IO_SPEEDNOTSUPPORT		0x80020019L
#define		PLAYM4_ERR_IO_GETFILELIST_FAILED	0x8002001AL
#define		PLAYM4_ERR_IO_NOFILEINLIST			0x8002001BL
#define		PLAYM4_ERR_IO_FILENOTMODIFY			0x8002001CL


#define		PLAYM4_ERR_REMOTE_UNKNOWN				0x8003FFFFL
#define		PLAYM4_ERR_REMOTE_NOSIGNAL				0x80030001L
#define		PLAYM4_ERR_REMOTE_DOWNING				0x80030002L
#define		PLAYM4_ERR_REMOTE_UPDATING				0x80030004L
#define		PLAYM4_ERR_REMOTE_VODING					0x80030006L
#define		PLAYM4_ERR_REMOTE_ALMTRANING				0x80030008L
#define		PLAYM4_ERR_REMOTE_FILERECORDING			0x8003000AL
#define		PLAYM4_ERR_REMOTE_EXCUTE_FAILED			0x8003000BL
#define		PLAYM4_ERR_REMOTE_TRANSDATA				0x8003000CL
#define		PLAYM4_ERR_REMOTE_CNNLIMITED				0x8003000DL
#define		PLAYM4_ERR_REMOTE_CLIPPING				0x8003000EL
#define		PLAYM4_ERR_REMOTE_RPLAYING				0x8003000FL
#define		PLAYM4_ERR_REMOTE_PROTO_ANSFAILED		0x80030010L
#define		PLAYM4_ERR_REMOTE_CNNMEDIASVR_FAILED	0x80030011L
#define		PLAYM4_ERR_REMOTE_MEDIALINK_CFAILED		0x80030012L
#define		PLAYM4_ERR_REMOTE_MEDIATHREAD_CFAILED	0x80030013L
#define		PLAYM4_ERR_REMOTE_NOFILE					0x80030014L
#define		PLAYM4_ERR_REMOTE_PLAYBACK_FAILED		0x80030015L
#define		PLAYM4_ERR_REMOTE_NOT_IMPLEMENT			0x80030016L
#define		PLAYM4_ERR_REMOTE_CNNBROKEN				0x80030017L
#define		PLAYM4_ERR_REMOTE_WAITACK_FAILED		0x80030018L
#define		PLAYM4_ERR_REMOTE_SENDDATA_FAILED		0x80030019L
#define		PLAYM4_ERR_REMOTE_RECVDATA_FAILED		0x8003001AL

#define		PLAYM4_ERR_REMOTE_OPERATION_IMPACT		0x8003001BL
#define		PLAYM4_ERR_REMOTE_GETUSERPW_FAILED		0x8003001CL
#define		PLAYM4_ERR_REMOTE_FILE_ERROR				0x8003001DL
#define		PLAYM4_ERR_REMOTE_PASSWORD_INVFMT		0x8003001EL
#define		PLAYM4_ERR_REMOTE_FILEEXIST				0x8003001FL
#define		PLAYM4_ERR_REMOTE_UPGRADING				0x80030020L
#define		PLAYM4_ERR_REMOTE_PARAMETER_INVALID		0x80030021L
#define		PLAYM4_ERR_REMOTE_MSGTYPE_INVALID		0x80030022L


#define		PLAYM4_ERR_AVDATA_NOTRIGHT				0x80040001L
#define		PLAYM4_ERR_AVDATA_NOFRAME				0x80040002L
#define		PLAYM4_ERR_AVDATA_NOIFRAME				0x80040003L


#define		PLAYM4_ERR_MEM_OUT						0x80050001L
#define		PLAYM4_ERR_MEM_OPENDECODER_FAILED		0x80050002L
#define		PLAYM4_ERR_MEM_OPERATION_FAILED			0x80050003L
#define		PLAYM4_ERR_MEM_CREATEEVENT_FAILED		0x80050004L

#define		PLAYM4_ERR_PAR_PARAMETER					0x80060000L

#define		PLAYM4_ERR_THREAD_CREATE_FAILED			0x80070001L
#define		PLAYM4_ERR_THREAD_CTIMER_FAILED			0x80070002L


#define		PLAYM4_ERR_OTHER_NORIGHT					0x80F00001L
#define		PLAYM4_ERR_OTHER_NOTSUPPORT				0x80F00002L
#define		PLAYM4_ERR_OTHER_TASKGOING				0x80F00003L
#define		PLAYM4_ERR_OTHER_TASKNOTGO				0x80F00004L
#define		PLAYM4_ERR_OTHER_BEGDECODE_FAILED		0x80F00005L
#define		PLAYM4_ERR_OTHER_PROT_NOTSUPPORTED		0x80F00006L
#define		PLAYM4_ERR_OTHER_NOTINIT					0x80F00007L
#define		PLAYM4_ERR_OTHER_UNKNOWN_DEVICE			0x80F00008L
#define		PLAYM4_ERR_OTHER_NOSUBCLASS_FUNCTION	0x80F00009L
#define		PLAYM4_ERR_OTHER_NOTFIND					0x80F0000AL
#define		PLAYM4_ERR_OTHER_ENDALREADY				0x80F0000BL
#define		PLAYM4_ERR_OTHER_NONEED					0x80F0000CL
#define		PLAYM4_ERR_OTHER_INITFAILED				0x80F0000DL
#define		PLAYM4_ERR_OTHER_NOT_IMPLEMENT			0x80F0000EL
#define		PLAYM4_ERR_OTHER_NOT_EXIST				0x80F0000FL


#define	FRAMETYPE_NONE			0L
#define	FRAMETYPE_I			0x00000001L	
#define	FRAMETYPE_P			0x00000002L	
#define	FRAMETYPE_VIDEO		0x00000003L	
#define	FRAMETYPE_A			0x00000004L	
#define	FRAMETYPE_JPEG			0x00000008L	
#define	FRAMETYPE_UPGRADE		0x00000009L	
#define	FRAMETYPE_COVER		0x0000000AL	
#define	FRAMETYPE_END			0x000000FFL	

#define	PLAYM4_IFBMP			1L
#define	PLAYM4_IFJPG			2L
#define	PLAYM4_IFGIF			3L

#define	PLAYM4_HIDE			0L
#define	PLAYM4_SHOW			1L

#define	PLAYM4_TASK_START	    0L
#define	PLAYM4_TASK_END		1L

#define	PLAYM4_PCPLAY		    0L
#define	PLAYM4_PCPAUSE		    1L
#define	PLAYM4_PCNORMAL		2L
#define	PLAYM4_PCBACK		    3L

#define	PLAYM4_POOFFSET		0L	
#define	PLAYM4_POFRAME		    1L	
#define	PLAYM4_POTIME		    2L	

#define	PLAYM4_FPSTART		    0L	
#define	PLAYM4_FPCURRENT	    1L	
#define	PLAYM4_FPEND		    2L	

enum PLAYM4_STREAM_TYPE_E
{
	PLAYM4_STREAM_STREAMING	= 1L,
	PLAYM4_STREAM_DECODPICT	= 2L,
	PLAYM4_STREAM_AVI		    = 3L
};

enum PLAYM4_AUDIOENC_TYPE
{
	PLAYM4_AUDIOFORMAT_AMR   = 1,   
	PLAYM4_AUDIOFORMAT_G726  = 2,   
	PLAYM4_AUDIOFORMAT_ADPCM = 3,  
	PLAYM4_AUDIOFORMAT_PCM   = 4,   
};

typedef struct
{
	unsigned char	cYear;
	unsigned char	cMonth;
	unsigned char	cDay;
	unsigned char	cHour;
	unsigned char	cMinute;
	unsigned char	cSecond;
	unsigned short	usMilliSecond:10;
	unsigned short	usWeek:3;
	unsigned short	usReserved:2;
	unsigned short	usMilliValidate:1;
}  PLAYM4_MEDIA_DATETIME;



struct PLAYM4_VIF_HEADER
{
	unsigned long		lFrameType;	
	unsigned long		lStreamType;	
	unsigned long		lFrameLen;		
	unsigned short	usExtendLen;	
	unsigned short	usExtendMode;	
	ULONGLONG		ullPts;	
};

struct PLAYM4_AIF_HEADER
{
	unsigned long		lFrameType;
	unsigned short	usFrameLen;
	unsigned short	usPacketLen;
};

struct PLAYM4_STREAMFILE_HEADER
{
	unsigned char		videoType;
	unsigned char		frameRate;
	unsigned char		begYear;
	unsigned char		begMonth;
	unsigned char		begDay;
	unsigned char		begHour;
	unsigned char		begMinute;
	unsigned char		begSecond;
	unsigned char		endYear;
	unsigned char		endMonth;
	unsigned char		endDay;
	unsigned char		endHour;
	unsigned char		endMinute;
	unsigned char		endSecond;
};

struct PLAYM4_CBD_INTMSG
{
	unsigned long	lFlag;
	unsigned long	lValue;
};

typedef	void (* PLAYM4_INTCALLBACK)( unsigned long lUserData, const PLAYM4_CBD_INTMSG *pstuIntMsg );


typedef enum
{
	PT_PCMU = 0,
	PT_1016 = 1,
	PT_G721 = 2,
	PT_GSM = 3,
	PT_G723 = 4,
	PT_DVI4_8K = 5,
	PT_DVI4_16K = 6,
	PT_LPC = 7,
	PT_PCMA = 8,
	PT_G722 = 9,
	PT_S16BE_STEREO,
	PT_S16BE_MONO = 11,
	PT_QCELP = 12,
	PT_CN = 13,
	PT_MPEGAUDIO = 14,
	PT_G728 = 15,
	PT_DVI4_3 = 16,
	PT_DVI4_4 = 17,
	PT_G729 = 18,
	PT_G711A = 19,
	PT_G711U = 20,
	PT_G726 = 21,
	PT_G729A = 22,
	PT_LPCM = 23,
	PT_CelB = 25,
	PT_JPEG = 26,
	PT_CUSM = 27,
	PT_NV = 28,
	PT_PICW = 29,
	PT_CPV = 30,
	PT_H261 = 31,
	PT_MPEGVIDEO = 32,
	PT_MPEG2TS = 33,
	PT_H263 = 34,
	PT_SPEG = 35,
	PT_MPEG2VIDEO = 36,
	PT_AAC = 37,
	PT_WMA9STD = 38,
	PT_HEAAC = 39,
	PT_PCM_VOICE = 40,
	PT_PCM_AUDIO = 41,
	PT_AACLC = 42,
	PT_MP3 = 43,
	PT_ADPCMA = 49,
	PT_AEC = 50,
	PT_X_LD = 95,
	PT_H264 = 96,
	PT_D_GSM_HR = 200,
	PT_D_GSM_EFR = 201,
	PT_D_L8 = 202,
	PT_D_RED = 203,
	PT_D_VDVI = 204,
	PT_D_BT656 = 220,
	PT_D_H263_1998 = 221,
	PT_D_MP1S = 222,
	PT_D_MP2P = 223,
	PT_D_BMPEG = 224,
	PT_MP4VIDEO = 230,
	PT_MP4AUDIO = 237,
	PT_VC1 = 238,
	PT_JVC_ASF = 255,
	PT_D_AVI = 256,
	PT_MAX = 257,		
	PT_AMR = 1001,
	PT_MJPEG = 1002,
}PAYLOAD_TYPE_E;

typedef enum PlayM4_AUDIO_SAMPLE_RATE_E 
{ 
    AUDIO_SAMPLE_RATE_8000   = 8000,    /* 8K samplerate*/
	AUDIO_SAMPLE_RATE_11025  = 11025,   /* 11.025K samplerate*/
	AUDIO_SAMPLE_RATE_16000  = 16000,   /* 16K samplerate*/
	AUDIO_SAMPLE_RATE_22050	 = 22050,   /* 22.050K samplerate*/
	AUDIO_SAMPLE_RATE_24000  = 24000,   /* 24K samplerate*/
	AUDIO_SAMPLE_RATE_32000  = 32000,   /* 32K samplerate*/
	AUDIO_SAMPLE_RATE_44100  = 44100,   /* 44.1K samplerate*/
	AUDIO_SAMPLE_RATE_48000  = 48000,   /* 48K samplerate*/
	AUDIO_SAMPLE_RATE_BUTT,
}AUDIO_SAMPLE_RATE_E; 

typedef enum PlayM4_AUDIO_BIT_WIDTH_E
{
    AUDIO_BIT_WIDTH_8   = 0,   /* 8bit width */
	AUDIO_BIT_WIDTH_16  = 1,   /* 16bit width*/
	AUDIO_BIT_WIDTH_32  = 2,   /* 32bit width*/
	AUDIO_BIT_WIDTH_BUTT,
}AUDIO_BIT_WIDTH_E;

typedef enum PlayM4_AIO_SOUND_MODE_E
{
    AUDIO_SOUND_MODE_MOMO   =0,/*mono*/
	AUDIO_SOUND_MODE_STEREO =1,/*stereo*/
	AUDIO_SOUND_MODE_BUTT    
}AUDIO_SOUND_MODE_E;

typedef struct PlayM4_PT_Talk_S
{
    int Chn;
    int bRun;
    PAYLOAD_TYPE_E enType; 
    AUDIO_SAMPLE_RATE_E enSamplerate;   /*sample rate*/
    AUDIO_BIT_WIDTH_E   enBitwidth;     /*bitwidth*/
    AUDIO_SOUND_MODE_E  enSoundmode;    /*momo or steror*/
}PT_Talk_S;

typedef int (* fVoiceDataCallBack) (unsigned char *pRecvDataBuffer, DWORD dwBufSize, unsigned __int64 Pts);
typedef void (CALLBACK* fDrawFun)(long nPort,HDC hDc,LONG nUser, RECT rcMem);

#pragma pack()

#ifdef __cplusplus
}
#endif

#endif
