#ifndef __HCNETSDK_H__
#define __HCNETSDK_H__

#include <Windows.h>
//#ifdef HCNETSDK_EXPORTS
#define NET_DVR_API extern "C" __declspec(dllexport)
//#else
//#define NET_DVR_API __declspec(dllimport)
//#endif

#define SERIALNO_LEN 48

/*******************ļ־ֵ*************************/
#define NET_DVR_FILE_SUCCESS		1000	//ļϢ
#define NET_DVR_FILE_NOFIND			1001	//ûļ
#define NET_DVR_ISFINDING			1002	//ڲļ
#define	NET_DVR_NOMOREFILE			1003	//ļʱûиļ
#define	NET_DVR_FILE_EXCEPTION		1004	//ļʱ쳣

#define NET_DVR_MAX_USERNUM 52

#define MAX_CHANNEL_NUM 16

#define NET_USER_NUM	128

#define NAME_LEN 32
#define MACADDR_LEN 6
#define MAX_NAMELEN 16
#define LOG_INFO_LEN 4096
#define PTZ_PROTOCOL_NUM 200
#define DESC_LEN 16


/*************************************************
طʱſ궨 
NET_DVR_PlayBackControl
NET_DVR_PlayControlLocDisplay
NET_DVR_DecPlayBackCtrlĺ궨
ֲ֧鿴˵ʹ
**************************************************/	
#define NET_DVR_PLAYSTART		1//ʼ
#define NET_DVR_PLAYSTOP		2//ֹͣ
#define NET_DVR_PLAYPAUSE		3//ͣ
#define NET_DVR_PLAYRESTART		4//ָ
#define NET_DVR_PLAYFAST		5//
#define NET_DVR_PLAYSLOW		6//
#define NET_DVR_PLAYNORMAL		7//ٶ
#define NET_DVR_PLAYFRAME		8//֡
#define NET_DVR_PLAYSTARTAUDIO	9//
#define NET_DVR_PLAYSTOPAUDIO	10//ر
#define NET_DVR_PLAYAUDIOVOLUME	11//
#define NET_DVR_PLAYSETPOS		12//ıļطŵĽ
#define NET_DVR_PLAYGETPOS		13//ȡļطŵĽ
#define NET_DVR_PLAYGETTIME		14//ȡǰѾŵʱ(ļطŵʱЧ)
#define NET_DVR_PLAYGETFRAME	15//ȡǰѾŵ֡(ļطŵʱЧ)
#define NET_DVR_GETTOTALFRAMES  16//ȡǰļܵ֡(ļطŵʱЧ)
#define NET_DVR_GETTOTALTIME    17//ȡǰļܵʱ(ļطŵʱЧ)
#define NET_DVR_THROWBFRAME		20//B֡
#define NET_DVR_SETSPEED		24//ٶ
#define NET_DVR_KEEPALIVE		25//豸(ص2뷢һ)
#define LIGHT_PWRON              2//ͨƹԴ 
#define WIPER_PWRON              3//ͨˢ 
#define FAN_PWRON                4//ͨȿ 
#define HEATER_PWRON             5//ͨ 
#define AUX_PWRON1               6//ͨ豸 
#define AUX_PWRON2               7//ͨ豸 
#define SET_PRESET               8//Ԥõ 
#define CLE_PRESET               9//Ԥõ 
#define ZOOM_IN                 11//ٶȱ(ʱ) 
#define ZOOM_OUT                12//ٶȱС(ʱС) 
#define FOCUS_NEAR              13//ٶǰ 
#define FOCUS_FAR               14//ٶȺ 
#define IRIS_OPEN               15//Ȧٶ 
#define IRIS_CLOSE              16//ȦٶС 
#define TILT_UP                 21//̨ٶ 
#define TILT_DOWN               22//̨ٶ¸ 
#define PAN_LEFT                23//̨ٶת 
#define PAN_RIGHT               24//̨ٶת 
#define UP_LEFT                 25//̨ٶת 
#define UP_RIGHT                26//̨ٶת 
#define DOWN_LEFT               27//̨SSٶ¸ת 
#define DOWN_RIGHT              28//̨ٶ¸ת 
#define PAN_AUTO                29//̨ٶԶɨ 
#define FILL_PRE_SEQ            30//ԤõѲ 
#define SET_SEQ_DWELL           31//Ѳͣʱ 
#define SET_SEQ_SPEED           32//Ѳٶ 
#define CLE_PRE_SEQ             33//ԤõѲɾ 
#define STA_MEM_CRUISE          34//ʼ¼켣 
#define STO_MEM_CRUISE          35//ֹͣ¼켣 
#define RUN_CRUISE              36//ʼ켣 
#define RUN_SEQ                 37//ʼѲ 
#define STOP_SEQ                38//ֹͣѲ 
#define FILL_PRE_SEQ_END        39
#define GOTO_PRESET             39//תԤõ 
#define MAX_ALARMOUT             4//

#define MAX_NAMELEN             16 //豸ص¼ 
#define MAX_RIGHT               32 //豸ֵ֧Ȩޣ1-21ʾȨޣ13-32ʾԶȨޣ 
#define NAME_LEN                32 //û 
#define PASSWD_LEN              16 //볤 
#define SERIALNO_LEN            48 //кų 
#define MACADDR_LEN              6 //MACַ 
#define MAX_ETHERNET             2 //豸̫ 
#define PATHNAME_LEN           128 //· 
#define MAX_TIMESEGMENT_V30      8 //V3.0ϰ汾ֵ֧豸ʱ 
#define MAX_TIMESEGMENT          4 //V3.0°汾ֵ֧豸ʱ 
#define MAX_SHELTERNUM           4 //V3.0°汾ֵ֧豸ڵ 
#define MAX_DAYS                 7 //ÿܵ 
#define PHONENUMBER_LEN         32 //PPPoEź󳤶 
#define MAX_DISKNUM_V30         33 //V3.0ϰ汾ֵ֧豸Ӳ33Ӳ(16SATAӲ̡1eSATAӲ̺16NFS) 
#define MAX_DISKNUM             16 //V3.0°汾ֵ֧豸Ӳ 
#define MAX_DISKNUM_V10          8 //1.2汾֮ǰ汾 
#define MAX_WINDOW_V30          32 //V3.0ϰ汾ֵ֧豸ıʾ󲥷Ŵ 
#define MAX_WINDOW              16 //V3.0°汾ֵ֧豸ıʾ󲥷Ŵ 
#define MAX_VGA_V30              4 //V3.0ϰ汾ֵ֧豸ɽVGA 
#define MAX_VGA                  1 //V3.0°汾ֵ֧豸ɽVGA 
#define MAX_USERNUM_V30         12 //V3.0ϰ汾ֵ֧豸û 
#define MAX_USERNUM             16 //V3.0°汾ֵ֧豸û 
#define MAX_EXCEPTIONNUM_V30    32 // V3.0ϰ汾ֵ֧豸쳣 
#define MAX_EXCEPTIONNUM        16 //V3.0°汾ֵ֧豸쳣 
#define MAX_LINK                 6 //V3.0°汾ֵ֧豸ĵͨƵ 
#define MAX_DECPOOLNUM           4 //·ÿͨѭ 
#define MAX_DECNUM               4 //·ͨʵֻһ 
#define MAX_TRANSPARENTNUM       2 //·͸ͨ 
#define MAX_CYCLE_CHAN          16 //·ѭͨ 
#define MAX_CYCLE_CHAN_V30      64 //ѯͨչ 
#define MAX_DIRNAME_LENGTH      80 //Ŀ¼ 
#define MAX_WINDOWS             16 //󴰿 
#define MAX_STRINGNUM_V30        8 //V3.0ϰ汾ֵ֧豸OSDַ 
#define MAX_STRINGNUM            4 //V3.0°汾ֵ֧豸OSDַ 
#define MAX_AUXOUT               4 //V3.0°汾ֵ֧豸 
#define MAX_HD_GROUP            16 //V3.0ϰ汾ֵ֧豸Ӳ 
#define MAX_NFS_DISK             8 //V3.0°汾ֵ֧豸NFSӲ 
#define IW_ESSID_MAX_SIZE       32 //WIFISSIDų 
#define IW_ENCODING_TOKEN_MAX   32 //WIFIԿֽ 
#define MAX_SERIAL_NUM          64 //ֵ֧͸ͨ· 
#define MAX_DDNS_NUMS           10 //V3.0ϰ汾ֵ֧豸DDNS 
#define MAX_DOMAIN_NAME         64 // 
#define MAXPROGRESS            100 //طʱٷ 
#define MAX_SERIALNUM            2 //豸ֵ֧Ĵ1-2322-485 
#define CARDNUM_LEN             20 //ų 
#define MAX_VIDEOOUT_V30         4 //V3.0ϰ汾ֵ֧豸Ƶ 
#define MAX_VIDEOOUT             2 //V3.0°汾ֵ֧豸Ƶ 
#define MAX_EMAIL_ADDR_LEN      48 //EMAILַ 
#define MAX_EMAIL_PWD_LEN       32 //EMAIL볤 
#define MAX_PRESET_V30         256 //V3.0ϰ汾ֵ֧豸ֵ̨֧Ԥõ 
#define MAX_TRACK_V30          256 //V3.0ϰ汾ֵ֧豸ֵ̨֧켣 
#define MAX_CRUISE_V30         256 //V3.0ϰ汾ֵ֧豸ֵ̨֧Ѳ 
#define MAX_PRESET             128 //V3.0°汾ֵ֧豸ֵ̨֧Ԥõ 
#define MAX_TRACK              128 //V3.0°汾ֵ֧豸ֵ̨֧켣 
#define MAX_CRUISE             128 //V3.0°汾ֵ֧豸ֵ̨֧Ѳ 
#define CRUISE_MAX_PRESET_NUMS  32 //һѲѲ 
#define MAX_SERIAL_PORT          8 //V3.0ϰ汾ֵ֧豸֧232 
#define MAX_PREVIEW_MODE         8 //豸֧ԤģʽĿ 1,4,9,16.... 
#define MAX_MATRIXOUT           16 //ģ 
#define LOG_INFO_LEN         4096//11840 //־Ϣ 
#define DESC_LEN                16 //ַ̨ 
#define PTZ_PROTOCOL_NUM       200 //V3.0ϰ汾ֵ֧豸ֵ̨֧Э 
#define MAX_AUDIO                1 //V3.0°汾ֵ֧豸Խͨ 
#define MAX_AUDIO_V30            2 //V3.0ϰ汾ֵ֧豸Խͨ 
#define MAX_CHANNUM             16 //V3.0°汾ֵ֧豸ͨ 
#define MAX_ALARMIN             16 //V3.0°汾ֵ֧豸󱨾 
#define MAX_ALARMOUT             4 //V3.0°汾ֵ֧豸󱨾 
#define MAX_ANALOG_CHANNUM      32 //32ģͨ 
#define MAX_ANALOG_ALARMOUT     32 //32·ģⱨ 
#define MAX_ANALOG_ALARMIN      32 //32·ģⱨ 
#define MAX_IP_DEVICE           32 //IP豸 
#define MAX_IP_CHANNEL          32 //IPͨ 
#define MAX_IP_ALARMIN         128 //౨ 
#define MAX_IP_ALARMOUT         64 //౨ 
#define MAX_CHANNUM_V30         64 //(MAX_ANALOG_CHANNUM + MAX_IP_CHANNEL) 
#define MAX_ALARMOUT_V30        96 //(MAX_ANALOG_ALARMOUT + MAX_IP_ALARMOUT) 
#define MAX_ALARMIN_V30        160 //(MAX_ANALOG_ALARMIN + MAX_IP_ALARMIN) 
#define MAX_RULE_NUM             8 // 
#define MAX_TIMESEGMENT_2        2 //ʱ 
#define VCA_MAX_POLYGON_POINT_NUM 10// ֧10Ķ 
#define MAX_TARGET_NUM          30 //Ŀ 
#define MAX_VCA_CHAN            16 //ͨ 
#define IW_ESSID_MAX_SIZE       32 //SSIDĳ 
#define WIFI_WEP_MAX_KEY_COUNT   4 //Կ 
#define WIFI_WEP_MAX_KEY_LENGTH 33 //Կ 
#define WIFI_WPA_PSK_MAX_KEY_LENGTH 63 //ַ󳤶 
#define WIFI_WPA_PSK_MIN_KEY_LENGTH  8 //ַС 
#define WIFI_MAX_AP_COUNT           20 //AP 
#define NET_DVR_MAX_DISPREGION      16 //ÿʾͨʾĴ 
#define MAX_DECODECHANNUM           32 //·ͨ 
#define MAX_DISPCHANNUM             24 //·ʾͨ 
#define MAX_NET_DISK                16 //Ӳ 
#define MAX_ATM_PROTOCOL_NUM       256 //ATMЭ 
#define ATM_PROTOCOL_SORT            4 //ATMЭ 
#define ATM_DESC_LEN                32 //ATMַ 
#define MAX_ACTION_TYPE             12 //ATMԶЭӽΪΪ 
#define SEARCH_EVENT_INFO_LEN      300 //¼Ϣ 
#define MAX_MASK_REGION_NUM          4 // 
#define MAX_CALIB_PT                 6 //궨 

#define MAJOR_ALARM 0x1 // 
#define MAJOR_EXCEPTION 0x2 //쳣 
#define MAJOR_OPERATION 0x3 // 
#define MAJOR_INFORMATION 0x4 //־Ϣ 
//alarm subtype
#define MINOR_ALARM_IN 0x1 // 
#define MINOR_ALARM_OUT 0x2 // 
#define MINOR_MOTDET_START 0x3 //ƶⱨʼ 
#define MINOR_MOTDET_STOP 0x4 //ƶⱨ 
#define MINOR_HIDE_ALARM_START 0x5 //ڵʼ 
#define MINOR_HIDE_ALARM_STOP 0x6 //ڵ 
#define MINOR_VCA_ALARM_START 0x7 //ܱʼ 
#define MINOR_VCA_ALARM_STOP 0x8 //ܱ 
//exception
#define MINOR_VI_LOST 0x21 //ƵźŶʧ 
#define MINOR_ILLEGAL_ACCESS 0x22 //Ƿ 
#define MINOR_HD_FULL 0x23 //Ӳ 
#define MINOR_HD_ERROR 0x24 //Ӳ̴¼쳣 
#define MINOR_DCD_LOST 0x25 //MODEM () 
#define MINOR_IP_CONFLICT 0x26 //IPַͻ 
#define MINOR_NET_BROKEN 0x27 //Ͽ 
#define MINOR_REC_ERROR 0x28 //¼ 
#define MINOR_IPC_NO_LINK 0x29 //IPC쳣 
#define MINOR_VI_EXCEPTION 0x2a //Ƶ쳣(ֻģͨ) 
#define MINOR_IPC_IP_CONFLICT 0x2b //IPCIPַͻ
//operation 
#define MINOR_START_DVR 0x41 // 
#define MINOR_STOP_DVR 0x42 //ػ 
#define MINOR_STOP_ABNORMAL 0x43 //쳣ػ 
#define MINOR_REBOOT_DVR 0x44 //豸 
#define MINOR_LOCAL_LOGIN 0x50 //ص½ 
#define MINOR_LOCAL_LOGOUT 0x51 //ע½ 
#define MINOR_LOCAL_CFG_PARM 0x52 //ò 
#define MINOR_LOCAL_PLAYBYFILE 0x53 //ذļطŻ 
#define MINOR_LOCAL_PLAYBYTIME 0x54 //ذʱطŻ 
#define MINOR_LOCAL_START_REC 0x55 //ؿʼ¼ 
#define MINOR_LOCAL_STOP_REC 0x56 //ֹͣ¼ 
#define MINOR_LOCAL_PTZCTRL 0x57 //̨ 
#define MINOR_LOCAL_PREVIEW 0x58 //Ԥ(ʹ) 
#define MINOR_LOCAL_MODIFY_TIME 0x59 //޸ʱ(ʹ) 
#define MINOR_LOCAL_UPGRADE 0x5a // 
#define MINOR_LOCAL_RECFILE_OUTPUT 0x5b //ر¼ļ 
#define MINOR_LOCAL_FORMAT_HDD 0x5c //سʼӲ 
#define MINOR_LOCAL_CFGFILE_OUTPUT 0x5d //ļ 
#define MINOR_LOCAL_CFGFILE_INPUT 0x5e //뱾ļ 
#define MINOR_LOCAL_COPYFILE 0x5f //رļ 
#define MINOR_LOCAL_LOCKFILE 0x60 //¼ļ 
#define MINOR_LOCAL_UNLOCKFILE 0x61 //ؽ¼ļ 
#define MINOR_LOCAL_DVR_ALARM 0x62 //ֶʹ 
#define MINOR_IPC_ADD 0x63 //IPC 
#define MINOR_IPC_DEL 0x64 //ɾIPC 
#define MINOR_IPC_SET 0x65 //IPC 
#define MINOR_LOCAL_START_BACKUP 0x66 //ؿʼ 
#define MINOR_LOCAL_STOP_BACKUP 0x67 //ֹͣ 
#define MINOR_LOCAL_COPYFILE_START_TIME 0x68 //رݿʼʱ 
#define MINOR_LOCAL_COPYFILE_END_TIME 0x69 //رݽʱ 
#define MINOR_LOCAL_ADD_NAS 0x6a //Ӳ 
#define MINOR_LOCAL_DEL_NAS 0x6b //ɾNAS 
#define MINOR_LOCAL_SET_NAS 0x6c //NAS 
#define MINOR_REMOTE_LOGIN 0x70 //Զ̵¼ 
#define MINOR_REMOTE_LOGOUT 0x71 //Զע½ 
#define MINOR_REMOTE_START_REC 0x72 //Զ̿ʼ¼ 
#define MINOR_REMOTE_STOP_REC 0x73 //Զֹͣ¼ 
#define MINOR_START_TRANS_CHAN 0x74 //ʼ͸ 
#define MINOR_STOP_TRANS_CHAN 0x75 //ֹͣ͸ 
#define MINOR_REMOTE_GET_PARM 0x76 //Զ̻ȡ 
#define MINOR_REMOTE_CFG_PARM 0x77 //Զò 
#define MINOR_REMOTE_GET_STATUS 0x78 //Զ̻ȡ״̬ 
#define MINOR_REMOTE_ARM 0x79 //Զ̲ 
#define MINOR_REMOTE_DISARM 0x7a //Զ̳ 
#define MINOR_REMOTE_REBOOT 0x7b //Զ 
#define MINOR_START_VT 0x7c //ʼԽ 
#define MINOR_STOP_VT 0x7d //ֹͣԽ 
#define MINOR_REMOTE_UPGRADE 0x7e //Զ 
#define MINOR_REMOTE_PLAYBYFILE 0x7f //Զ̰ļط 
#define MINOR_REMOTE_PLAYBYTIME 0x80 //Զ̰ʱط 
#define MINOR_REMOTE_PTZCTRL 0x81 //Զ̨ 
#define MINOR_REMOTE_FORMAT_HDD 0x82 //Զ̸ʽӲ 
#define MINOR_REMOTE_STOP 0x83 //Զ̹ػ 
#define MINOR_REMOTE_LOCKFILE 0x84 //Զļ 
#define MINOR_REMOTE_UNLOCKFILE 0x85 //Զ̽ļ 
#define MINOR_REMOTE_CFGFILE_OUTPUT 0x86 //Զ̵ļ 
#define MINOR_REMOTE_CFGFILE_INTPUT 0x87 //Զ̵ļ 
#define MINOR_REMOTE_RECFILE_OUTPUT 0x88 //Զ̵¼ļ 
#define MINOR_REMOTE_DVR_ALARM 0x89 //Զֶʹ 
#define MINOR_REMOTE_IPC_ADD 0x8a //ԶIPC 
#define MINOR_REMOTE_IPC_DEL 0x8b //ԶɾIPC 
#define MINOR_REMOTE_IPC_SET 0x8c //ԶIPC 
#define MINOR_REBOOT_VCA_LIB 0x8d //ܿ 
#define MINOR_REMOTE_ADD_NAS 0x8e //ԶNAS 
#define MINOR_REMOTE_DEL_NAS 0x8f //ԶɾNAS 
#define MINOR_REMOTE_SET_NAS 0x90 //ԶNAS 
//  information
#define MINOR_HDD_INFO 0xa1 //ӲϢ 
#define MINOR_SMART_INFO 0xa2 //S.M.A.R.TϢ 
#define MINOR_REC_START 0xa3 //ʼ¼ 
#define MINOR_REC_STOP 0xa4 //ֹͣ¼ 
#define MINOR_REC_OVERDUE 0xa5 //¼ɾ 
#define MINOR_LINK_START 0xa6 //ǰ豸 
#define MINOR_LINK_STOP 0xa7 //Ͽǰ豸 
#define MINOR_NET_DISK_INFO 0xa8 //ӲϢ 

#define NET_DVR_SET_DEVICECFG         101  //豸 NET_DVR_DEVICECFG 
#define NET_DVR_SET_TIMECFG           119  //ʱ NET_DVR_TIME 
#define NET_DVR_SET_NETCFG            103  // NET_DVR_NETCFG 
#define NET_DVR_SET_NETCFG_V30      1001 // NET_DVR_NETCFG_V3
#define NET_DVR_SET_PICCFG            105  //ͼ NET_DVR_PICCFG 
#define NET_DVR_SET_PICCFG_EX         201  //ͼչ NET_DVR_PICCFG_EX 
#define NET_DVR_SET_PICCFG_V30        1003 //ͼ NET_DVR_PICCFG_V30
#define NET_DVR_SET_COMPRESSCFG       107  //ѹ NET_DVR_COMPRESSIONCFG
#define NET_DVR_SET_EVENTCOMPCFG G    133  //¼¼ NET_DVR_COMPRESSIONCF
#define NET_DVR_SET_COMPRESSCFG_EX    205  //ѹչ NET_DVR_COMPRESSIONCFG_EX 
#define NET_DVR_SET_COMPRESSCFG_V30   1041 //ѹ NET_DVR_COMPRESSIONCFG_V30
#define NET_DVR_SET_RECORDCFG         109  //¼ NET_DVR_RECORD
#define NET_DVR_SET_RECORDCFG_V30     1005 //¼ NET_DVR_RECORD_V30
#define NET_DVR_SET_DECODERCFG        111  //ą̃ NET_DVR_DECODERCFG
#define NET_DVR_SET_DECODERCFG_V30    1043 //ą̃ NET_DVR_DECODERCFG_V30
#define NET_DVR_SET_RS232CFG          113  //232ڲ NET_DVR_RS232CFG 
#define NET_DVR_SET_RS232CFG_V30      1037 //232ڲ NET_DVR_RS232CFG_V30
#define NET_DVR_SET_ALARMINCFG        115  //ñ NET_DVR_ALARMINCFG
#define NET_DVR_SET_ALARMINCFG_V30    1025 //ñ NET_DVR_ALARMINCFG_V30
#define NET_DVR_SET_ALARMOUTCFG       117  //ñ NET_DVR_ALARMOUTCFG
#define NET_DVR_SET_ALARMOUTCFG_V30   1027 //ñ NET_DVR_ALARMOUTCFG_V30 
#define NET_DVR_SET_PREVIEWCFG        121  //ñԤ NET_DVR_PREVIEWCFG 
#define NET_DVR_SET_PREVIEWCFG_AUX    143  //-sϵ˫Ԥ NET_DVR_PREVIEWCFG
#define NET_DVR_SET_PREVIEWCFG_V30    1045 //ñԤ NET_DVR_PREVIEWCFG_V30
#define NET_DVR_SET_PREVIEWCFG_AUX_V30 1047 //øԤ NET_DVR_PREVIEWCFG_V30 
#define NET_DVR_SET_VIDEOOUTCFG       123  //Ƶ NET_DVR_VIDEOOUT 
#define NET_DVR_SET_VIDEOOUTCFG_V30   1029 //Ƶ NET_DVR_VIDEOOUT_V30
#define NET_DVR_SET_USERCFG           125  //û NET_DVR_USER
#define NET_DVR_SET_USERCFG_EX        203  //û NET_DVR_USER_EX
#define NET_DVR_SET_USERCFG_V30       1007 //û NET_DVR_USER_V30
#define NET_DVR_SET_EXCEPTIONCFG      127  //쳣 NET_DVR_EXCEPTION
#define NET_DVR_SET_EXCEPTIONCFG_V30  1035 //쳣 NET_DVR_EXCEPTION_V30   
#define NET_DVR_SET_ZONEANDDST        129  //ʱʱƲ NET_DVR_ZONEANDDST
#define NET_DVR_SET_SHOWSTRING        131  //õַ NET_DVR_SHOWSTRING  
#define NET_DVR_SET_SHOWSTRING_V30    1031 //õַ NET_DVR_SHOWSTRING_V30
#define NET_DVR_SET_AUXOUTCFG         141  //ñ NET_DVR_AUXOUTCFG
#define NET_DVR_SET_NETAPPCFG         223  //Ӧò(NTP/DDNS) NET_DVR_NETAPPCFG  
#define NET_DVR_SET_NTPCFG            225  //Ӧò(NTP) NET_DVR_NTPPARA
#define NET_DVR_SET_DDNSCFG           227  //Ӧò(DDNS) NET_DVR_DDNSPARA
#define NET_DVR_SET_DDNSCFG_EX        275  //Ӧò(DDNS) NET_DVR_DDNSPARA_EX 
#define NET_DVR_SET_DDNSCFG_V30       1011 //Ӧò(DDNS) NET_DVR_DDNSPARA_V30
#define NET_DVR_SET_EMAILPARACFG      251  //Ӧò(EMAIL) NET_DVR_EMAILCFG 
#define NET_DVR_SET_EMAILCFG_V30      1013 //Ӧò(EMAIL) NET_DVR_EMAILCFG_V30
#define NET_DVR_SET_NFSCFG            231  //NFSļϵͳ NET_DVR_NFSCFG
#define NET_DVR_SET_IPPARACFG         1049 //IPò NET_DVR_IPPARACFG
#define NET_DVR_SET_IPPARACFG_V31     1061 //IPò NET_DVR_IPPARACFG_V31 
#define NET_DVR_SET_HDCFG             1055 //Ӳ̹ NET_DVR_HDCFG 
#define NET_DVR_SET_HDGROUP_CFG       1057 // NET_DVR_HDGROUP_CFG 
#define NET_DVR_SET_PTZPOS            292  //IPPTZ  NET_DVR_PTZPOS
#define NET_DVR_SET_CRUISE            1021 //Ѳ NET_DVR_CRUISE_PARA 
#define NET_DVR_SET_COMPRESSCFG_AUD   1059 //ԽƵ NET_DVR_COMPRESSION_AUDIO
#define NET_DVR_SET_WIFI_CFG          306  //IP豸߲ NET_DVR_WIFI_CFG
#define NET_DVR_SET_WIFI_WORKMODE     308  //IP豸ڲ NET_DVR_WIFI_WORKMODE
#define NET_DVR_SET_NET_DISKCFG       1039 //Ӳ̽ NET_DVR_NET_DISKCFG  

#define NET_DVR_GET_TIMECFG 118  //ȡʱ NET_DVR_TIME
#define NET_DVR_GET_HDCFG 1054   //ȡӲ̹ NET_DVR_HDCFG  


#define COMM_ALARM_V30 0x4000

/********************Ԥص*********************/
#define NET_DVR_SYSHEAD			1	//ϵͳͷ
#define NET_DVR_STREAMDATA		2	//ƵݣƵֿƵݣ
#define NET_DVR_AUDIOSTREAMDATA	3	//Ƶ
#define NET_DVR_STD_VIDEODATA	4	//׼Ƶ
#define NET_DVR_STD_AUDIODATA	5	//׼Ƶ
#define NET_DVR_GET_DECODERCFG 110  //ȡ̨
#define NET_DVR_GET_NETCFG_V30   1000  //ȡ
#define NET_DVR_GET_DECODERCFG_V30 1042  //ȡ̨
#define NET_DVR_GET_NETAPPCFG 222 //ȡӦò(NTP/DDNS)
#define NET_DVR_GET_NTPCFG 224 //ȡӦò(NTP)
#define NET_DVR_GET_DDNSCFG_V30 1010 //ȡӦò(DDNS)
#define NET_DVR_GET_EMAILCFG_V30 1012 //ȡӦò(EMAIL)
#define NET_DVR_GET_PREVIEWCFG_V30 1044 //ȡԤ
#define NET_DVR_GET_PICCFG_V30      1002 //ȡͼ
#define NET_DVR_GET_RECORDCFG_V30    1004 //ȡ¼
#define NET_DVR_GET_COMPRESSCFG_V30  1040 //ȡѹ 
#define NET_DVR_GET_VIDEOOUTCFG_V30   1028 //ȡƵ
#define NET_DVR_GET_DEVICECFG         100  //ȡ豸
#define NET_DVR_GET_USERCFG_V30       1006 //ȡû
#define NET_DVR_GET_ALARMOUTCFG_V30   1026 //ȡ
#define NET_DVR_GET_ALARMINCFG_V30    1024 //ȡ

#define EXCEPTION_EXCHANGE 0x8000 //ûʱ쳣 
#define EXCEPTION_AUDIOEXCHANGE 0x8001 //Խ쳣 
#define EXCEPTION_ALARM 0x8002 //쳣 
#define EXCEPTION_PREVIEW 0x8003 //Ԥ쳣 
#define EXCEPTION_SERIAL 0x8004 //͸ͨ쳣 
#define EXCEPTION_RECONNECT 0x8005 //Ԥʱ 
#define EXCEPTION_ALARMRECONNECT 0x8006 //ʱ 
#define EXCEPTION_SERIALRECONNECT 0x8007 //͸ͨ 
#define EXCEPTION_SERIALRECONSUCCESS 0x8008 //͸ͨɹ 
#define EXCEPTION_PLAYBACK 0x8010 //ط쳣 
#define EXCEPTION_DISKFMT 0x8011// Ӳ̸ʽ 
#define EXCEPTION_PASSIVEDECODE 0x8012 //쳣 


typedef struct 
{
	/*I֡Ϊx0dcxڵһֽڣ0ΪڶֽڣdΪֽڣcΪĸֽڣp ֡Ϊx1dc*/
	unsigned char channel;
	unsigned char frametype;
	unsigned char resv0;
	unsigned char resv1;
	unsigned int streamtype;   /*ʽʱ̶ΪH264ASCII*/
	unsigned int framelen;     /*Ƶ֡ݳ*/
	unsigned short extenlen;    /*չݳ*/
	unsigned short externmod;   /*չģʽ*/
	__int64 pts;          /*ʱ*/
}video_head_t;

typedef struct 
{
	unsigned char channel;
	unsigned char frametype;
	unsigned char resv0;
	unsigned char resv1;
	unsigned short framelen;     /*һƵ֡*/
	unsigned short datalen;    /*˰Ƶݳ*/
}audio_head_t;

typedef struct tagNET_DVR_TIME{
	unsigned int    dwYear;
	unsigned int    dwMonth;
	unsigned int    dwDay;
	unsigned int    dwHour;
	unsigned int    dwMinute;
	unsigned int    dwSecond;
}NET_DVR_TIME, *LPNET_DVR_TIME;


typedef struct tagNET_DVR_FINDDATA_V30{
	char             sFileName[100];
	NET_DVR_TIME     struStartTime;
	NET_DVR_TIME     struStopTime;
	DWORD            dwFileSize;
	char             sCardNum[32];
	BYTE             byLocked;
	BYTE             byRes[3];
}NET_DVR_FINDDATA_V30,*LPNET_DVR_FINDDATA_V30;


typedef struct tagNET_DVR_FILECOND{
	LONG             lChannel;
	DWORD            dwFileType;
	DWORD            dwIsLocked;
	DWORD            dwUseCardNo;
	BYTE             sCardNumber[32];
	NET_DVR_TIME     struStartTime;
	NET_DVR_TIME     struStopTime;
}NET_DVR_FILECOND,*LPNET_DVR_FILECOND;


typedef struct tagNET_DVR_CLIENTINFO{
	LONG    lChannel;
	LONG    lLinkMode;
	HWND    hPlayWnd;
	char    *sMultiCastIP;
}NET_DVR_CLIENTINFO, *LPNET_DVR_CLIENTINFO;

typedef struct tagNET_DVR_DEVICEINF0{
	BYTE     sSerialNumber[SERIALNO_LEN];
	BYTE     byAlarmInPortNum;
	BYTE     byAlarmOutPortNum;
	BYTE     byDiskNum;
	BYTE     byDVRType;
	BYTE     byChanNum;
	BYTE     byStartChan;
}NET_DVR_DEVICEINFO,*LPNET_DVR_DEVICEINFO;


typedef struct tagNET_DVR_DEVICEINFO_V30{
	char     sSerialNumber[SERIALNO_LEN];
	char     byAlarmInPortNum;
	char     byAlarmOutPortNum;
	char     byDiskNum;
	char     byDVRType;
	char     byChanNum;
	char     byStartChan;
	char     byAudioChanNum;
	char     byIPChanNum;
	char     byRes1[24];
}NET_DVR_DEVICEINFO_V30,*LPNET_DVR_DEVICEINFO_V30;

typedef struct tagNET_DVR_JPEGPARA{
	WORD     wPicSize;
	WORD     wPicQuality;
}NET_DVR_JPEGPARA,*LPNET_DVR_JPEGPARA;

typedef struct tagNET_DVR_ALARMER{
	BYTE     byUserIDValid;
	BYTE     bySerialValid;
	BYTE     byVersionValid;
	BYTE     byDeviceNameValid;
	BYTE     byMacAddrValid;
	BYTE     byLinkPortValid;
	BYTE     byDeviceIPValid;
	BYTE     bySocketIPValid;
	LONG     lUserID;
	BYTE     sSerialNumber[SERIALNO_LEN];
	DWORD    dwDeviceVersion;
	char     sDeviceName[NAME_LEN];
	BYTE     byMacAddr[MACADDR_LEN];
	WORD     wLinkPort;
	char     sDeviceIP[128];
	char     sSocketIP[128];
	BYTE     byIpProtocol;
	BYTE     byRes2[11];
}NET_DVR_ALARMER,*LPNET_DVR_ALARMER;


typedef void(CALLBACK*MSGCallBack)(
	LONG               lCommand,
	NET_DVR_ALARMER    *pAlarmer,
	char               *pAlarmInfo,
	DWORD              dwBufLen,
	void               *pUser
	);

typedef void(CALLBACK *fExceptionCallBack)(
  DWORD    dwType,
  LONG     lUserID,
  LONG     lHandle,
  void     *pUser
);

typedef struct tagNET_DVR_IPADDR{
	char    sIpV4[16];
	char    sIpV6[128];
}NET_DVR_IPADDR, *LPNET_DVR_IPADDR;


typedef struct tagNET_DVR_LOG_V30{
	NET_DVR_TIME     strLogTime;
	DWORD            dwMajorType;
	DWORD            dwMinorType;
	BYTE             sPanelUser[MAX_NAMELEN];
	BYTE             sNetUser[MAX_NAMELEN];
	NET_DVR_IPADDR   struRemoteHostAddr;
	DWORD            dwParaType;
	DWORD            dwChannel;
	DWORD            dwDiskNumber;
	DWORD            dwAlarmInPort;
	DWORD            dwAlarmOutPort;
	DWORD            dwInfoLen;
	char             sInfo[LOG_INFO_LEN];
}NET_DVR_LOG_V30,*LPNET_DVR_LOG_V30;

typedef struct tagNET_DVR_PTZ_PROTOCOL{
	DWORD    dwType;
	BYTE     byDescribe[DESC_LEN];
}NET_DVR_PTZ_PROTOCOL, *LPNET_DVR_PTZ_PROTOCOL;



typedef struct tagNET_DVR_PTZCFG{
	DWORD                   dwSize;
	NET_DVR_PTZ_PROTOCOL    struPtz[PTZ_PROTOCOL_NUM];
	DWORD                   dwPtzNum;
	BYTE                    byRes[8];
}NET_DVR_PTZCFG, *LPNET_DVR_PTZCFG;

#define MAX_ALARMOUT_V30 96

typedef struct tagNET_DVR_ALARMOUTSTATUS_V30{
	BYTE      Output[MAX_ALARMOUT_V30];
}NET_DVR_ALARMOUTSTATUS_V30,*LPNET_DVR_ALARMOUTSTATUS_V30;

typedef struct 
{
	DWORD dwVolume;//Ӳ̵
	DWORD dwFreeSpace;//Ӳ̵ʣռ
	DWORD dwHardDiskStatic; //Ӳ̵״̬,0-,1-,2-
}NET_DVR_DISKSTATE, *LPNET_DVR_DISKSTATE;

typedef struct 
{
	BYTE byRecordStatic; //ͨǷ¼,0-¼,1-¼
	BYTE bySignalStatic; //ӵź״̬,0-,1-źŶʧ
	BYTE byHardwareStatic;//ͨӲ״̬,0-,1-쳣,DSP
	BYTE byRes1;		//
	DWORD dwBitRate;//ʵ
	DWORD dwLinkNum;//ͻӵĸ
	NET_DVR_IPADDR struClientIP[MAX_LINK];//ͻ˵IPַ
	DWORD dwIPLinkNum;//ͨΪIP룬ôʾIP뵱ǰ
	BYTE byRes[12];
}NET_DVR_CHANNELSTATE_V30, *LPNET_DVR_CHANNELSTATE_V30;

typedef struct tagNET_DVR_WORKSTATE_V30{
	DWORD                      dwDeviceStatic;
	NET_DVR_DISKSTATE          struHardDiskStatic[MAX_DISKNUM_V30];
	NET_DVR_CHANNELSTATE_V30   struChanStatic[MAX_CHANNUM_V30];
	BYTE                       byAlarmInStatic[MAX_ALARMIN_V30];
	BYTE                       byAlarmOutStatic[MAX_ALARMOUT_V30];
	DWORD                      dwLocalDisplay;
	BYTE                       byAudioChanStatus[MAX_AUDIO_V30];
	BYTE                       byRes[10];
}NET_DVR_WORKSTATE_V30,*LPNET_DVR_WORKSTATE_V30;

typedef struct tagNET_DVR_DECODERCFG_V30{
	DWORD     dwSize;
	DWORD     dwBaudRate;
	BYTE      byDataBit;
	BYTE      byStopBit;
	BYTE      byParity;
	BYTE      byFlowcontrol;
	WORD      wDecoderType;
	WORD      wDecoderAddress;
	BYTE      bySetPreset[MAX_PRESET_V30];
	BYTE      bySetCruise[MAX_CRUISE_V30];
	BYTE      bySetTrack[MAX_TRACK_V30];
}NET_DVR_DECODERCFG_V30, *LPNET_DVR_DECODERCFG_V30;

typedef struct tagNET_DVR_ETHERNET_V30{
	NET_DVR_IPADDR    struDVRIP;
	NET_DVR_IPADDR    struDVRIPMask;
	DWORD             dwNetInterface;
	WORD              wDVRPort;
	WORD              wMTU;
	BYTE              byMACAddr[MACADDR_LEN];
}NET_DVR_ETHERNET_V30, *LPNET_DVR_ETHERNET_V30;

typedef struct tagNET_DVR_PPPOECFG{
	DWORD             dwPPPOE;
	BYTE              sPPPoEUser[NAME_LEN];
	char              sPPPoEPassword[PASSWD_LEN];
	NET_DVR_IPADDR    struPPPoEIP;
}NET_DVR_PPPOECFG, *LPNET_DVR_PPPOECFG;

typedef struct tagNET_DVR_NETCFG_V30{
	DWORD                    dwSize;
	NET_DVR_ETHERNET_V30     struEtherNet[MAX_ETHERNET];
	NET_DVR_IPADDR           struRes1[2];
	NET_DVR_IPADDR           struAlarmHostIpAddr;
	WORD                     wRes2[2];
	WORD                     wAlarmHostIpPort;
	BYTE                     byUseDhcp;
	BYTE                     byRes3;
	NET_DVR_IPADDR           struDnsServer1IpAddr;
	NET_DVR_IPADDR           struDnsServer2IpAddr;
	BYTE                     byIpResolver[MAX_DOMAIN_NAME];
	WORD                     wIpResolverPort;
	WORD                     wHttpPortNo;
	NET_DVR_IPADDR           struMulticastIpAddr;
	NET_DVR_IPADDR           struGatewayIpAddr;
	NET_DVR_PPPOECFG         struPPPoE;
	BYTE                     byRes[64];
}NET_DVR_NETCFG_V30,*LPNET_DVR_NETCFG_V30;

typedef struct tagNET_DVR_NTPPARA{
	BYTE           sNTPServer[64];
	WORD           wInterval;
	BYTE           byEnableNTP;
	signed char    cTimeDifferenceH;
	signed char    cTimeDifferenceM;
	BYTE           res1;
	WORD           wNtpPort;
	BYTE           res2[8];
}NET_DVR_NTPPARA,*LPNET_DVR_NTPPARA;

typedef struct tagNET_DVR_DDNSPARA_V30{
	BYTE     byEnableDDNS;
	BYTE     byHostIndex;
	BYTE     byRes1[2];
	struct{
		BYTE   sUserName[NAME_LEN];
		BYTE   sPassword[PASSWD_LEN];
		BYTE   sDomainName[MAX_DOMAIN_NAME];
		BYTE   sServerName[MAX_DOMAIN_NAME];
		WORD   wDDNSPort;
		BYTE   byRes[16];
	}struDDNS[MAX_DDNS_NUMS];
	BYTE     byRes2[16];
}NET_DVR_DDNSPARA_V30,*LPNET_DVR_DDNSPARA_V30;


typedef struct tagNET_DVR_DDNSPARA{
	BYTE     sUserName[NAME_LEN];
	BYTE     sPassword[PASSWD_LEN];
	BYTE     sDomainName[64];
	BYTE     byEnableDDNS;
	BYTE     res[15];
}NET_DVR_DDNSPARA,*LPNET_DVR_DDNSPARA;

typedef struct tagNET_DVR_EMAILCFG_V30{
	DWORD     dwSize;
	BYTE      sAccount[NAME_LEN];
	BYTE      sPassword[MAX_EMAIL_PWD_LEN];
	struct{
		BYTE   sName[NAME_LEN];
		BYTE   sAddress[MAX_EMAIL_ADDR_LEN];
	}struSender;
	BYTE      sSmtpServer[MAX_EMAIL_ADDR_LEN];
	BYTE      sPop3Server[MAX_EMAIL_ADDR_LEN];
	struct{
		BYTE   sName[NAME_LEN];
		BYTE   sAddress[MAX_EMAIL_ADDR_LEN];
	}struReceiver[3];
	BYTE      byAttachment;
	BYTE      bySmtpServerVerify;
	BYTE      byMailInterval;
	BYTE      byEnableSSL;
	WORD      wSmtpPort;
	BYTE      byRes[74];
}NET_DVR_EMAILCFG_V30,*LPNET_DVR_EMAILCFG_V30;


typedef struct tagNET_DVR_NETAPPCFG{
	DWORD               dwSize;
	char                sDNSIp[16];
	NET_DVR_NTPPARA     struNtpClientParam;
	NET_DVR_DDNSPARA    struDDNSClientParam;
	BYTE                res[464];
}NET_DVR_NETAPPCFG,*LPNET_DVR_NETAPPCFG;

typedef struct tagNET_DVR_PREVIEWCFG_V30{
	DWORD      dwSize;
	BYTE       byPreviewNumber;
	BYTE       byEnableAudio;
	BYTE       wSwitchTime;
	BYTE       bySwitchSeq[MAX_PREVIEW_MODE][MAX_WINDOW_V30];
	BYTE       byRes[24];
}NET_DVR_PREVIEWCFG_V30,*LPNET_DVR_PREVIEWCFG_V30;

typedef struct tagNET_DVR_HANDLEEXCEPTION_V30{
	DWORD    dwHandleType;
	BYTE     byRelAlarmOut[MAX_ALARMOUT_V30];
}NET_DVR_HANDLEEXCEPTION_V30, *LPNET_DVR_HANDLEEXCEPTION_V30;

typedef struct tagNET_DVR_SCHEDTIME{
	BYTE    byStartHour;
	BYTE    byStartMin;
	BYTE    byStopHour;
	BYTE    byStopMin;
}NET_DVR_SCHEDTIME, *LPNET_DVR_SCHEDTIME;


typedef struct tagNET_DVR_VILOST_V30{
	BYTE                           byEnableHandleVILost;
	NET_DVR_HANDLEEXCEPTION_V30    strVILostHandleType;
	NET_DVR_SCHEDTIME              struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];
}NET_DVR_VILOST_V30, *LPNET_DVR_VILOST_V30;

typedef struct tagNET_DVR_MOTION_V30{
	BYTE                           byMotionScope[64][96];
	BYTE                           byMotionSensitive;
	BYTE                           byEnableHandleMotion;
	BYTE                           byPrecision;
	char                           reservedData;
	NET_DVR_HANDLEEXCEPTION_V30    strMotionHandleType;
	NET_DVR_SCHEDTIME              struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];
	BYTE                           byRelRecordChan[MAX_CHANNUM_V30];
}NET_DVR_MOTION_V30, *LPNET_DVR_MOTION_V30;

typedef struct tagNET_DVR_HIDEALARM_V30{
	DWORD                          dwEnableHideAlarm;
	WORD                           wHideAlarmAreaTopLeftX;
	WORD                           wHideAlarmAreaTopLeftY;
	WORD                           wHideAlarmAreaWidth;
	WORD                           wHideAlarmAreaHeight;
	NET_DVR_HANDLEEXCEPTION_V30    strHideAlarmHandleType;
	NET_DVR_SCHEDTIME              struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];
}NET_DVR_HIDEALARM_V30, *LPNET_DVR_HIDEALARM_V30;

typedef struct tagNET_DVR_SHELTER{
	WORD    wHideAreaTopLeftX;
	WORD    wHideAreaTopLeftY;
	WORD    wHideAreaWidth;
	WORD    wHideAreaHeight;
}NET_DVR_SHELTER, *LPNET_DVR_SHELTER;

typedef struct tagNET_DVR_COLOR{
	BYTE    byBrightness;
	BYTE    byContrast;
	BYTE    bySaturation;
	BYTE    byHue;
}NET_DVR_COLOR, *LPNET_DVR_COLOR;

typedef struct tagNET_DVR_PICCFG_V30{
	DWORD                    dwSize;
	BYTE                     sChanName[NAME_LEN];
	DWORD                    dwVideoFormat;
	NET_DVR_COLOR            struColor;
	char                     reservedData[60];
	DWORD                    dwShowChanName;
	WORD                     wShowNameTopLeftX;
	WORD                     wShowNameTopLeftY;
	NET_DVR_VILOST_V30       struVILost;
	NET_DVR_VILOST_V30       struRes;
	NET_DVR_MOTION_V30       struMotion;
	NET_DVR_HIDEALARM_V30    struHideAlarm;
	DWORD                    dwEnableHide;
	NET_DVR_SHELTER          struShelter[MAX_SHELTERNUM];
	DWORD                    dwShowOsd;
	WORD                     wOSDTopLeftX;
	WORD                     wOSDTopLeftY;
	BYTE                     byOSDType;
	BYTE                     byDispWeek;
	BYTE                     byOSDAttrib;
	BYTE                     byHourOsdType;
	BYTE                     byRes[64];
}NET_DVR_PICCFG_V30,*LPNET_DVR_PICCFG_V30;

typedef struct tagNET_DVR_RECORDDAY{
	WORD    wAllDayRecord;
	BYTE    byRecordType;
	char    reservedData;
}NET_DVR_RECORDDAY, *LPNET_DVR_RECORDDAY;

typedef struct tagNET_DVR_RECORDSCHED{
	NET_DVR_SCHEDTIME    struRecordTime;
	BYTE                 byRecordType;
	char                 reservedData[3];
}NET_DVR_RECORDSCHED, *LPNET_DVR_RECORDSCHED;

typedef struct tagNET_DVR_RECORD_V30{
	DWORD                 dwSize;
	DWORD                 dwRecord;
	NET_DVR_RECORDDAY     struRecAllDay[MAX_DAYS];
	NET_DVR_RECORDSCHED   struRecordSched[MAX_DAYS][MAX_TIMESEGMENT_V30];
	DWORD                 dwRecordTime;
	DWORD                 dwPreRecordTime;
	DWORD                 dwRecorderDuration;
	BYTE                  byRedundancyRec;
	BYTE                  byAudioRec;
	BYTE                  byReserve[10];
}NET_DVR_RECORD_V30, *LPNET_DVR_RECORD_V30;

typedef struct tagNET_DVR_COMPRESSION_INFO_V30{
	BYTE     byStreamType;
	BYTE     byResolution;
	BYTE     byBitrateType;
	BYTE     byPicQuality;
	DWORD    dwVideoBitrate;
	DWORD    dwVideoFrameRate;
	WORD     wIntervalFrameI;
	BYTE     byIntervalBPFrame;
	BYTE     byres1;
	BYTE     byVideoEncType;
	BYTE     byAudioEncType;
	BYTE     byres[10];
}NET_DVR_COMPRESSION_INFO_V30, *LPNET_DVR_COMPRESSION_INFO_V30;

typedef struct tagNET_DVR_COMPRESSIONCFG_V30{
	DWORD                           dwSize;
	NET_DVR_COMPRESSION_INFO_V30    struNormHighRecordPara;
	NET_DVR_COMPRESSION_INFO_V30    struRes;
	NET_DVR_COMPRESSION_INFO_V30    struEventRecordPara;
	NET_DVR_COMPRESSION_INFO_V30    struNetPara;
}NET_DVR_COMPRESSIONCFG_V30, *LPNET_DVR_COMPRESSIONCFG_V30;

typedef struct tagNET_DVR_VOOUT{
	BYTE      byVideoFormat;
	BYTE      byMenuAlphaValue;
	WORD      wScreenSaveTime;
	WORD      wVOffset;
	WORD      wBrightness;
	BYTE      byStartMode;
	BYTE      byEnableScaler;
}NET_DVR_VOOUT,*LPNET_DVR_VOOUT;

typedef struct tagNET_DVR_VGAPARA{
	WORD       wResolution;
	WORD       wFreq;
	DWORD      dwBrightness;
}NET_DVR_VGAPARA,*LPNET_DVR_VGAPARA;

typedef struct tagNET_DVR_MATRIXPARA_V30{
	WORD       wOrder[MAX_ANALOG_CHANNUM];
	WORD       wSwitchTime;
	BYTE       res[14];
}NET_DVR_MATRIXPARA_V30,*LPNET_DVR_MATRIXPARA_V30;

typedef struct tagNET_DVR_VIDEOOUT_V30{
	DWORD                       dwSize;
	NET_DVR_VOOUT               struVOOut[MAX_VIDEOOUT_V30];
	NET_DVR_VGAPARA             struVGAPara[MAX_VGA_V30];
	NET_DVR_MATRIXPARA_V30      struMatrixPara[MAX_MATRIXOUT];
	BYTE                        byRes[16];
}NET_DVR_VIDEOOUT_V30,*LPNET_DVR_VIDEOOUT_V30;

typedef struct tagNET_DVR_DEVICECFG{
	DWORD    dwSize;
	BYTE     sDVRName[NAME_LEN];
	DWORD    dwDVRID;
	DWORD    dwRecycleRecord;
	BYTE     sSerialNumber[SERIALNO_LEN];
	DWORD    dwSoftwareVersion;
	DWORD    dwSoftwareBuildDate;
	DWORD    dwDSPSoftwareVersion;
	DWORD    dwDSPSoftwareBuildDate;
	DWORD    dwPanelVersion;
	DWORD    dwHardwareVersion;
	BYTE     byAlarmInPortNum;
	BYTE     byAlarmOutPortNum;
	BYTE     byRS232Num;
	BYTE     byRS485Num;
	BYTE     byNetworkPortNum;
	BYTE     byDiskCtrlNum;
	BYTE     byDiskNum;
	BYTE     byDVRType;
	BYTE     byChanNum;
	BYTE     byStartChan;
	BYTE     byDecordChans;
	BYTE     byVGANum;
	BYTE     byUSBNum;
	BYTE     byAuxoutNum;
	BYTE     byAudioNum;
	BYTE     byIPChanNum;
}NET_DVR_DEVICECFG,*LPNET_DVR_DEVICECFG;

typedef struct
{
	DWORD 	dwHDNo;
	DWORD 	dwCapacity;
	DWORD 	dwFreeSpace;
	DWORD 	dwHdStatus;
	BYTE		byHDAttr;
	BYTE		byHDType;
	BYTE		byRes1[2];
	DWORD 	dwHdGroup;
	BYTE		byRes2[120];
}NET_DVR_SINGLE_HD, *LPNET_DVR_SINGLE_HD;

typedef struct
{
	DWORD 				dwSize;
	DWORD 				dwHDCount;
	NET_DVR_SINGLE_HD 	struHDInfo[MAX_DISKNUM_V30];
}NET_DVR_HDCFG, *LPNET_DVR_HDCFG;

typedef struct tagNET_DVR_USER_INFO_V30{
	BYTE                sUserName[NAME_LEN];
	BYTE                sPassword[PASSWD_LEN];
	BYTE                byLocalRight[MAX_RIGHT];
	BYTE                byRemoteRight[MAX_RIGHT];
	BYTE                byNetPreviewRight[MAX_CHANNUM_V30];
	BYTE                byLocalPlaybackRight[MAX_CHANNUM_V30];
	BYTE                byNetPlaybackRight[MAX_CHANNUM_V30];
	BYTE                byLocalRecordRight[MAX_CHANNUM_V30];
	BYTE                byNetRecordRight[MAX_CHANNUM_V30];
	BYTE                byLocalPTZRight[MAX_CHANNUM_V30];
	BYTE                byNetPTZRight[MAX_CHANNUM_V30];
	BYTE                byLocalBackupRight[MAX_CHANNUM_V30];
	NET_DVR_IPADDR      struUserIP;
	BYTE                byMACAddr[MACADDR_LEN];
	BYTE                byPriority;
	BYTE                byRes[17];
}NET_DVR_USER_INFO_V30,*LPNET_DVR_USER_INFO_V30;

typedef struct tagNET_DVR_USER_V30{
	DWORD                     dwSize;
	NET_DVR_USER_INFO_V30     struUser[MAX_USERNUM_V30];
}NET_DVR_USER_V30,*LPNET_DVR_USER_V30;

typedef struct tagNET_DVR_ALARMINCFG_V30{
	DWORD                            dwSize;
	BYTE                             sAlarmInName[NAME_LEN];
	BYTE                             byAlarmType;
	BYTE                             byAlarmInHandle;
	BYTE                             byRes1[2];
	NET_DVR_HANDLEEXCEPTION_V30      struAlarmHandleType;
	NET_DVR_SCHEDTIME                struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];
	BYTE                             byRelRecordChan[MAX_CHANNUM_V30];
	BYTE                             byEnablePreset[MAX_CHANNUM_V30];
	BYTE                             byPresetNo[MAX_CHANNUM];
	BYTE                             byRes2[192];
	BYTE                             byEnableCruise[MAX_CHANNUM];
	BYTE                             byCruiseNo[MAX_CHANNUM];
	BYTE                             byEnablePtzTrack[MAX_CHANNUM];
	BYTE                             byPTZTrack[MAX_CHANNUM];
	BYTE                             byRes3[16];
}NET_DVR_ALARMINCFG_V30,*LPNET_DVR_ALARMINCFG_V30;

typedef struct tagNET_DVR_ALARMOUTCFG_V30{
	DWORD                   dwSize;
	BYTE                    sAlarmOutName[NAME_LEN];
	DWORD                   dwAlarmOutDelay;
	NET_DVR_SCHEDTIME       struAlarmOutTime[MAX_DAYS][MAX_TIMESEGMENT_V30];
	BYTE                    byRes[16];
}NET_DVR_ALARMOUTCFG_V30,*LPNET_DVR_ALARMOUTCFG_V30;


//ϴϢ(9000չ)
typedef struct 
{
	DWORD dwAlarmType;/*0-ź,1-Ӳ,2-źŶʧ,3ƶ,4Ӳδʽ,5-дӲ̳,6-ڵ,7-ʽƥ, 8-Ƿ, 9-Ƶź쳣10-¼쳣 */
	DWORD dwAlarmInputNumber;/*˿*/
	BYTE byAlarmOutputNumber[MAX_ALARMOUT_V30];/*˿ڣΪ1ʾӦ*/
	BYTE byAlarmRelateChannel[MAX_CHANNUM_V30];/*¼ͨΪ1ʾӦ¼, dwAlarmRelateChannel[0]Ӧ1ͨ*/
	BYTE byChannel[MAX_CHANNUM_V30];/*dwAlarmTypeΪ23,6910ʱʾĸͨdwChannel[0]Ӧ1ͨ*/
	BYTE byDiskNumber[MAX_DISKNUM_V30];/*dwAlarmTypeΪ1,4,5ʱ,ʾĸӲ, dwDiskNumber[0]Ӧ1Ӳ*/
}NET_DVR_ALARMINFO_V30, *LPNET_DVR_ALARMINFO_V30;

typedef struct
{
  BYTE    PresetNum;
  BYTE    Dwell;
  BYTE    Speed;
  BYTE    Reserve;
}NET_DVR_CRUISE_POINT, *LPNET_DVR_CRUISE_POINT;

typedef struct
{
	NET_DVR_CRUISE_POINT	  struCruisePoint[32];
}NET_DVR_CRUISE_RET,*LPNET_DVR_CRUISE_RET;

NET_DVR_API DWORD NET_DVR_GetLastError();


//---------------------------------API DESCRIPTION---------------------------------------------
//
//SDK control API. incluing 6 API fucntions
//inluding: 1. NET_DVR_Init() - Initiate SDK; 
//               2. NET_DVR_Cleanup() -  Destroy SDK
///             3. NET_DVR_GetSDKVersion() - get SDK version;
//               4. NET_DVR_SetConnectTime() - socket control;
//               5. NET_DVR_SetReconnect() - socket control;
//               6. NET_DVR_GetHostByName() - Domain name to IP 
//		    
//---------------------------------API DESCRIPTION---------------------------------------------
/* Initialise the SDK module*/
NET_DVR_API BOOL   NET_DVR_Init();
NET_DVR_API BOOL   NET_DVR_Cleanup();
NET_DVR_API DWORD  NET_DVR_GetSDKVersion();

NET_DVR_API BOOL NET_DVR_SetConnectTime(DWORD dwWaitTime = 5000, DWORD dwTryTimes = 3);
NET_DVR_API BOOL NET_DVR_SetReconnect(DWORD dwInterval = 30000, BOOL bEnableRecon = TRUE);
//---------------------------------API DESCRIPTION---------------------------------------------
//
//Login/Logout a DVR API. Including 2 API functions.
//inluding:  1. NET_DVR_Login() - Login 
//                2. NET_DVR_Logout() - Logout
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API LONG  NET_DVR_Login( char *sDVRIP,WORD wDVRPort,char *sUserName,char *sPassword,LPNET_DVR_DEVICEINFO_V30 lpDeviceInfo);
NET_DVR_API BOOL  NET_DVR_Logout(LONG lUserID);


//---------------------------------API DESCRIPTION---------------------------------------------
//
//Realtime preview, capture, display and storage API. Including 15 API functions
//inluding: 1. NET_DVR_SetPlayerBufNumber() - Set buffer number for recieve realtime streaming from network.
//               2. NET_DVR_RealPlay_V30() - start preview; 
//               3. NET_DVR_RigisterDrawFun() - register a callback function to draw OSD on the media display window
//               4. NET_DVR_SetRealDataCallBack() - register a callback function to capture the realtime streaming
//               5. NET_DVR_SaveRealData_V30() - save the realtime streaming to local disk
//               6. NET_DVR_StopSaveRealData() - stop save the realtime streaming to local disk
//               7. NET_DVR_MakeKeyFrame() - Make a I frame in the main stream
//               8. NET_DVR_MakeKeyFrameSub() - Make a I frame in the sub stream
//               9. NET_DVR_OpenSound() - Open the preview sound
//             10. NET_DVR_CloseSound() - Close the preview sound
//             11. NET_DVR_SetVolume() - Set the volume of  the preview sound
//             12. NET_DVR_GetRealPlayerIndex() - Get the port of local decoder for this streaming channel
//             13. NET_DVR_CapturePicture() - Capture a BMP picture
//             14. NET_DVR_CaptureJPEGPicture() - Capture a JPEG picture
//             15. NET_DVR_StopRealPlay_V30() - stop preview; 
//          16. NET_DVR_ClientSetVideoEffect() - control image parameter
//          17. NET_DVR_ClientGetVideoEffect() - get image parameter
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API LONG  NET_DVR_RealPlay(LONG lUserID, LPNET_DVR_CLIENTINFO lpClientInfo, void(CALLBACK *fRealDataCallBack_V30) (LONG lRealHandle, DWORD dwDataType, BYTE *pBuffer, DWORD dwBufSize, void* pUser) = NULL, void* pUser = NULL, BOOL bBlocked = FALSE);
NET_DVR_API BOOL NET_DVR_SetPlayerBufNumber(LONG lRealHandle,DWORD dwBufNum);
typedef void(CALLBACK *fDrawFun)(LONG  lRealHandle, HDC  hDc, DWORD dwUser);
NET_DVR_API BOOL NET_DVR_RigisterDrawFun(LONG lRealHandle, fDrawFun cbDraw, DWORD dwUser);
NET_DVR_API BOOL  NET_DVR_SetRealDataCallBack(LONG lRealHandle,void(CALLBACK *fRealDataCallBack) (LONG lRealHandle, DWORD dwDataType, BYTE *pBuffer,DWORD dwBufSize,DWORD dwUser),DWORD dwUser);
NET_DVR_API BOOL  NET_DVR_SaveRealData(LONG lRealHandle, DWORD dwTransType, char *sFileName);
NET_DVR_API BOOL  NET_DVR_StopSaveRealData(LONG lRealHandle);
NET_DVR_API BOOL  NET_DVR_OpenSound(LONG lRealHandle);
NET_DVR_API BOOL  NET_DVR_CloseSound();
NET_DVR_API BOOL  NET_DVR_Volume(LONG lRealHandle,WORD wVolume);
NET_DVR_API int NET_DVR_GetRealPlayerIndex(LONG lRealHandle);
//capture JPEG file
NET_DVR_API BOOL NET_DVR_CaptureJPEGPicture(LONG lUserID, LONG lChannel, LPNET_DVR_JPEGPARA lpJpegPara, char *sPicFileName);
NET_DVR_API BOOL  NET_DVR_StopRealPlay(LONG lRealHandle);


//---------------------------------API DESCRIPTION---------------------------------------------
//
//Recording file searching, playback, storage. Including 20 API functions
//inluding:  1. NET_DVR_FindFile_V30() - search the recording file by the certain conditions 
//                2. NET_DVR_FindNextFile_V30() - search the next file
//                3. NET_DVR_FindFileByEvent() - search the recording file by the event
//                4. NET_DVR_FindNextEvent() - search the next recording file by the event
//                5. NET_DVR_FindClose_V30() - close the process of searching files
//                6. NET_DVR_LockFileByName() -Lock a file
//                7. NET_DVR_UnlockFileByName() - unlock a file
//                8. NET_DVR_PlayBackByName() - play back a file
//                9. NET_DVR_PlayBackByTime() - play back the recording during the certain time
//              10. NET_DVR_PlayBackControl() - play control: play, pause, fast-forward, backword, ......
//              11. NET_DVR_GetPlayBackPos() - get the palyback progress.
//              12. NET_DVR_SetPlayDataCallBack() - register a callback function to capure the data from playback session
//              13. NET_DVR_PlayBackSaveData() - save the data from playback session to local HDD
//              14. NET_DVR_StopPlayBackSave() - stop save the data from playback session
//              15. NET_DVR_PlayBackCaptureFile() -capture a JPEG/BMP file
//              16. NET_DVR_GetFileByName() - download a recording file
//              17. NET_DVR_GetFileByTime() - download the recording files during the certain time
//              18. NET_DVR_GetDownloadPos() - get the progress of downloading
//              19. NET_DVR_StopGetFile() - stop downloading
//              20. NET_DVR_StopPlayBack() - stop playback session
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API LONG  NET_DVR_FindFile(LONG lUserID, LPNET_DVR_FILECOND pFindCond);
NET_DVR_API LONG  NET_DVR_FindNextFile(LONG lFindHandle, LPNET_DVR_FINDDATA_V30 lpFindData);
NET_DVR_API BOOL  NET_DVR_FindClose(LONG lFindHandle);
NET_DVR_API LONG  NET_DVR_PlayBackByName(LONG lUserID,char *sPlayBackFileName, HWND hWnd);
NET_DVR_API BOOL  NET_DVR_PlayBackControl(LONG lPlayHandle,DWORD dwControlCode,DWORD dwInValue,DWORD *LPOutValue);
NET_DVR_API BOOL NET_DVR_SetPlayDataCallBack(LONG lPlayHandle,void(CALLBACK *fPlayDataCallBack) (LONG lPlayHandle, DWORD dwDataType, BYTE *pBuffer,DWORD dwBufSize,DWORD dwUser),DWORD dwUser);
NET_DVR_API BOOL  NET_DVR_PlayBackSaveData(LONG lPlayHandle,char *sFileName);
NET_DVR_API BOOL  NET_DVR_StopPlayBackSave(LONG lPlayHandle);
NET_DVR_API BOOL NET_DVR_PlayBackCaptureFile(LONG lPlayHandle,char *sFileName);
NET_DVR_API LONG  NET_DVR_GetFileByName(LONG lUserID,char *sDVRFileName,char *sSavedFileName);
NET_DVR_API BOOL  NET_DVR_StopGetFile(LONG lFileHandle);
NET_DVR_API int  NET_DVR_GetDownloadPos(LONG lFileHandle);
NET_DVR_API BOOL  NET_DVR_StopPlayBack(LONG lPlayHandle);

//---------------------------------API DESCRIPTION---------------------------------------------
//
//start and stop recording manually. Including 2 API functions
//inluding:  1. NET_DVR_StartDVRRecord() - start recording manually
//                2. NET_DVR_StopDVRRecord() - stop recording manually
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API BOOL  NET_DVR_StartDVRRecord(LONG lUserID,LONG lChannel,LONG lRecordType);
NET_DVR_API BOOL  NET_DVR_StopDVRRecord(LONG lUserID,LONG lChannel);

//---------------------------------API DESCRIPTION---------------------------------------------
//
//capture the alarm information.  Including 3 API functions
//inluding:  1. NET_DVR_SetupAlarmChan_V30() - Setup the alarm channle
//           2. NET_DVR_SetDVRMessageCallBack_V30() - register a callback function to capture alarm information
//           3. NET_DVR_CloseAlarmChan_V30() - cancel the alarm channle
//
//---------------------------------API DESCRIPTION---------------------------------------------

NET_DVR_API LONG NET_DVR_SetupAlarmChan(LONG lUserID);

NET_DVR_API BOOL NET_DVR_SetDVRMessageCallBack(MSGCallBack fMessageCallBack, void* pUser);

NET_DVR_API BOOL NET_DVR_CloseAlarmChan(LONG lAlarmHandle);


//---------------------------------API DESCRIPTION---------------------------------------------
//
//PTZ control.  Including 1 API function
//inluding:  1. NET_DVR_PTZControl() - send PTZ command to DVR
//           2. NET_DVR_PTZPreset() - Preset command
//           3. NET_DVR_PTZCruise() - Cruise command
//           4. NET_DVR_PTZTrack() - Track command
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API BOOL  NET_DVR_PTZControl(LONG lRealHandle,DWORD dwPTZCommand,DWORD dwStop);
NET_DVR_API BOOL  NET_DVR_PTZPreset(LONG lRealHandle, DWORD dwPTZPresetCmd, DWORD dwPresetIndex);
NET_DVR_API BOOL  NET_DVR_PTZCruise(LONG lRealHandle, DWORD dwPTZCruiseCmd, BYTE byCruiseRoute, BYTE byCruisePoint, WORD put);
NET_DVR_API BOOL  NET_DVR_PTZTrack(LONG lRealHandle, DWORD dwPTZTrackCmd);
NET_DVR_API BOOL  NET_DVR_GetPTZCruise(LONG lUserID, LONG lChannel, LONG lCruiseRoute, LPNET_DVR_CRUISE_RET lpCruiseRet);

//---------------------------------API DESCRIPTION---------------------------------------------
//
//two-way and multicast audio. Including 7 API functions
//inluding:  1. NET_DVR_StartVoiceCom_V30() - Start two way audio 
//           2. NET_DVR_SetVoiceComClientVolume(0 - set audio volume of two-way and multicast audio
//           3. NET_DVR_StopVoiceCom() - Stop two way audio
//           4. NET_DVR_ClientAudioStart_V30() - start multicast audio
//           5. NET_DVR_AddDVR_V30() - add a multicast audio client
//           6. NET_DVR_delDVR_V30() - delete a multicast audio client
//           7. NET_DVR_ClientAudioStop() - stopmulticast audio
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API LONG NET_DVR_StartVoiceCom(LONG lUserID, DWORD dwVoiceChan, BOOL bNeedCBNoEncData, void(CALLBACK *fVoiceDataCallBack)(LONG lVoiceComHandle, char *pRecvDataBuffer, DWORD dwBufSize, BYTE byAudioFlag, void* pUser), void* pUser);

NET_DVR_API BOOL NET_DVR_SetVoiceComClientVolume(LONG lVoiceComHandle, WORD wVolume);

NET_DVR_API BOOL NET_DVR_StopVoiceCom(LONG lVoiceComHandle);


//---------------------------------API DESCRIPTION---------------------------------------------
//
//Format HDD. Including 3 API functions
//inluding:		  1. NET_DVR_FormatDisk() - start format 
//                2. NET_DVR_GetFormatProgress() - get the progress of format process
//                3. NET_DVR_CloseFormatHandle() - release the handle
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API LONG  NET_DVR_FormatDisk(LONG lUserID,LONG lDiskNumber);

NET_DVR_API BOOL NET_DVR_GetFormatProgress(LONG lFormatHandle, LONG *pCurrentFormatDisk,LONG *pCurrentDiskPos,LONG *pFormatStatic);
NET_DVR_API BOOL NET_DVR_CloseFormatHandle(LONG lFormatHandle);
//---------------------------------API DESCRIPTION---------------------------------------------
//
//search the log information. Including 3 API functions
//inluding:  1. NET_DVR_FindDVRLog_V30() - Start searching
//           2. NET_DVR_FindNextLog_V30() - find the next log item 
//           3. NET_DVR_FindLogClose_V30() -stop searching
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API LONG  NET_DVR_FindDVRLog(LONG lUserID, LONG lSelectMode, DWORD dwMajorType,DWORD dwMinorType, LPNET_DVR_TIME lpStartTime, LPNET_DVR_TIME lpStopTime, BOOL bOnlySmart = FALSE);


NET_DVR_API LONG  NET_DVR_FindNextLog(LONG lLogHandle, LPNET_DVR_LOG_V30 lpLogData);

NET_DVR_API BOOL  NET_DVR_FindLogClose(LONG lLogHandle);

//---------------------------------API DESCRIPTION---------------------------------------------
//
//Get and set config file from/to the certain DVR. Including 2 API functions
//inluding:  1. NET_DVR_GetConfigFile() - get config file from the certain DVR
//           2. NET_DVR_SetConfigFile() - set config file to the certain DVR
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API BOOL  NET_DVR_GetConfigFile(LONG lUserID, char *sFileName);

NET_DVR_API BOOL  NET_DVR_SetConfigFile(LONG lUserID, char *sFileName);

//---------------------------------API DESCRIPTION---------------------------------------------
//
//Get and set config file from/to the certain DVR. Including 2 API functions
//inluding:  1. NET_DVR_GetConfigFile() - get config file from the certain DVR
//           2. NET_DVR_SetConfigFile() - set config file to the certain DVR
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API BOOL NET_DVR_Upgrade( LONG lUserID, char  *sFileName);

//---------------------------------API DESCRIPTION---------------------------------------------
//
//Reboot and shut down the DVR. Including 2 API functions
//inluding:  1. NET_DVR_RebootDVR() - Reboot the DVR
//		    2. NET_DVR_ShutDownDVR() - shut down the DVR
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API BOOL  NET_DVR_RebootDVR(LONG lUserID);
NET_DVR_API BOOL  NET_DVR_ShutDownDVR(LONG lUserID);

//---------------------------------API DESCRIPTION---------------------------------------------
//
//config the DVR parameter, including 4 API functions
//inluding:  1. NET_DVR_GetDVRConfig() - get the config from the certain DVR
//		    2. NET_DVR_SetDVRConfig() - set the config to the certain DVR
//		    3. NET_DVR_RestoreConfig() - restore the config of the certain DVR
//		    4. NET_DVR_GetPTZProtocol() - get thePTZ  protocol that the DVR supports ???why we need this API??
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API BOOL  NET_DVR_GetDVRConfig(LONG lUserID, DWORD dwCommand,LONG lChannel, LPVOID lpOutBuffer, DWORD dwOutBufferSize, LPDWORD lpBytesReturned);
NET_DVR_API BOOL  NET_DVR_SetDVRConfig(LONG lUserID, DWORD dwCommand,LONG lChannel, LPVOID lpInBuffer, DWORD dwInBufferSize);
NET_DVR_API BOOL  NET_DVR_RestoreConfig(LONG lUserID);

NET_DVR_API BOOL NET_DVR_GetPTZProtocol(LONG lUserID, NET_DVR_PTZCFG *pPtzcfg);
//---------------------------------API DESCRIPTION---------------------------------------------
//
//config the DVR parameter, including 2 API functions
//inluding:  1. NET_DVR_RebootDVR() - reboot device
//		    2. NET_DVR_ShutDownDVR() - shutdown device
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API BOOL  NET_DVR_RebootDVR(LONG lUserID);
NET_DVR_API BOOL  NET_DVR_ShutDownDVR(LONG lUserID);

//---------------------------------API DESCRIPTION---------------------------------------------
//
//config the DVR parameter, including 2 API functions
//inluding:  1. NET_DVR_ClientSetVideoEffect() - get vedio parameter
//		    2. NET_DVR_ClientGetVideoEffect() - set vedio paramter
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API BOOL  NET_DVR_ClientSetVideoEffect(LONG lRealHandle,DWORD dwBrightValue,
	DWORD dwContrastValue, DWORD dwSaturationValue,DWORD dwHueValue);
NET_DVR_API BOOL  NET_DVR_ClientGetVideoEffect(LONG lRealHandle,DWORD *pBrightValue,DWORD *pContrastValue,
	DWORD *pSaturationValue,DWORD *pHueValue);


NET_DVR_API BOOL NET_DVR_CapturePicture(LONG lRealHandle, char  *sPicFileName);

//---------------------------------API DESCRIPTION---------------------------------------------
//
//control the DVR alarm out. Including 2 API functions
//inluding:  1. NET_DVR_GetAlarmOut_V30() - get the DVR alarm out status
//		       2. NET_DVR_SetAlarmOut() - set the DVR alarm out status
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API BOOL NET_DVR_GetAlarmOut(LONG lUserID, LPNET_DVR_ALARMOUTSTATUS_V30 lpAlarmOutState);

NET_DVR_API BOOL NET_DVR_SetAlarmOut(LONG lUserID, LONG lAlarmOutPort,LONG lAlarmOutStatic);


//---------------------------------API DESCRIPTION---------------------------------------------
//
//Get the DVR device ability, including 1 API function
//inluding:  1. NET_DVR_GetDeviceAbility() - get the DVR device ability
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API BOOL NET_DVR_GetDeviceAbility(LONG lUserID, DWORD dwAbilityType, char* pInBuf, DWORD dwInLength, char* pOutBuf, DWORD dwOutLength);


//---------------------------------API DESCRIPTION---------------------------------------------
//
//Get the DVR runing status, including 1 API function
//inluding:  1. NET_DVR_GetDVRWorkState_V30() - get the DVR runing status
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API BOOL NET_DVR_GetDVRWorkState(LONG lUserID, LPNET_DVR_WORKSTATE_V30 lpWorkState);

//---------------------------------API DESCRIPTION---------------------------------------------
//
//exception call back  API. including 1 API function.
//inluding:  1. NET_DVR_SetExceptionCallBack_V30() - Register a callback function to capture the exception information
//
//---------------------------------API DESCRIPTION---------------------------------------------
NET_DVR_API BOOL NET_DVR_SetExceptionCallBack(UINT nMessage, HWND hWnd, void (CALLBACK* fExceptionCallBack)(DWORD dwType, LONG lUserID, LONG lHandle, void *pUser), void *pUser);

#endif
