#ifndef _NETCOMMON_H_
#define _NETCOMMON_H_

#define MAX_NET_NAME_LEN 32

#define NET_SESSION_NUM	32

#define MACADDR_LEN     6
#define MAX_ETHERNET    2
#define NAME_LEN        32
#define PASSWD_LEN      16
#define MAX_EMAIL_PWD_LEN 32
#define MAX_EMAIL_ADDR_LEN 48
#define MAX_ALARMOUT_V30    96
#define MAX_DAYS             7
#define MAX_TIMESEGMENT_V30  24

#define MAX_CHANNUM_V30      64
#define MAX_SHELTERNUM       4
#define MAX_VGA_V30          4
#define SERIALNO_LEN         48

#define NET_HEADER_CHECK_VAL 0x0abcdef0

#define NET_CFG_BUFF_SIZE 30720

#define MAX_NAMELEN 16
#define LOG_INFO_LEN 4096
#define MAX_CHANNEL_NUM 16
#define MAX_DISK_NUM 8

// will disconnect if no heartbeat be received 
#define TIMER_HEART_BEAT 10
#define MAX_NET_FRAME_SIZE    1024*256
#define NET_BUF_SIZE    40000 //8192 //1024*8
#define NET_HEAD_SIZE    20

#define MAX_ALARMOUT_V30 96

#define MAX_SEND_FILES 40

#define NET_GET_USERID(x) ((x>>16)&0xffff)
#define NET_GET_SESSIONID(x) (x&0xffff)

#define NET_ALARM_IO 0x00000001L
#define NET_ALARM_MD 0x00000002L
#define NET_ALARM_VADIO_LOSS 0x00000004L
#define NET_ALARM_BLIND 0x00000008L
#define NET_ALARM_DISCONNET 0x00000010L
#define NET_ALARM_AUDIO 0x00000020L
#define NET_ALARM_HD 0x00000040L

#define NET_SERIAL_LEN 48
#define NET_DEVICE_NAME_LEN 32
#define MAX_USERNUM_V30     12 
#define MAX_RIGHT            32
#define MAX_CHANNUM          16
#define PTZ_ADD_KEY_POINT 30 //ԤõѲ 
#define PTZ_SET_CRUISE_TIME 31 //Ѳͣʱ 
#define PTZ_SET_CRUISE_SPEED 32 //Ѳٶ 
#define PTZ_DEL_KEY_POINT 33 //ԤõѲɾ 
#define PTZ_ADD_KEY_POINT_END 39//FILL_PRE_SEQ_END 39//Ѳ


typedef struct tagNetLoginInfo
{
	char user[MAX_NET_NAME_LEN];
	char password[MAX_NET_NAME_LEN];
	int iNet; // 0:lan, 1:wan
}NetLoginInfo;

typedef struct tagNETIME{
	unsigned int    dwYear;
	unsigned int    dwMonth;
	unsigned int    dwDay;
	unsigned int    dwHour;
	unsigned int    dwMinute;
	unsigned int    dwSecond;
}NETIME;

typedef struct tagNetPtzParam
{	
	long channel;
	unsigned int 	dwBaudRate;
	char		byDataBit;
	char		byStopBit;
	char		byParity;
	char		byFlowcontrol;
	unsigned int		wDecoderType;
	unsigned int		wDecoderAddress;
	char 	preset[256];
	char	cruise[256];
	char	track[256];

}NetPtzParam;

typedef struct{
	char    sIpV4[16];
	char    sIpV6[128];
}NET_IPADDR;

typedef struct tagNetEtherNet
{
	NET_IPADDR	  struDVRIP;
	NET_IPADDR	  struDVRIPMask;
	unsigned int  wDVRPort;
	char	      byMACAddr[24];
}NetEntherNet;

typedef struct tagNetCfg
{
	NetEntherNet   struEtherNet;
	NET_IPADDR	  struGatewayIpAddr;
	unsigned int	  dwPPPOE;
	unsigned int   byUseDhcp;
	char			  sPPPoEUser[NAME_LEN];
	char		      sPPPoEPassword[PASSWD_LEN];
	NET_IPADDR	  struPPPoEIP; 
	NET_IPADDR	  struDnsServer1IpAddr;
	NET_IPADDR     struDnsServer2IpAddr;
	unsigned int   wHttpPortNo;
	unsigned char res[64];
}NetCfg;

typedef struct tagNtpCfg
{
	char       sNTPServer[64];  
	int        wInterval;
	int        wNtpPort;
	int        byEnableNTP;
}NtpCfg;

typedef struct tagDDNSCfg
{
	char byEnableDDNS;
	char byHostIndex;
	char res[2];
	char sUserName[NAME_LEN];
	char sPassword[PASSWD_LEN];
	char sDomainName[32];
}DDNSCfg;

typedef struct tagNetApp
{
	char sDNSIp[16];
	NtpCfg struNtpClientParam;
	DDNSCfg struDDNSClientParam;  
}NetApp;

typedef struct tagEmailCfg
{
	char sAccount[NAME_LEN];
	char sPassword[MAX_EMAIL_PWD_LEN];
	char sSmtpServer[MAX_EMAIL_ADDR_LEN];
	struct
	{ 
		char sAddress[MAX_EMAIL_ADDR_LEN];
	}struReceiver[3];
	unsigned int wSmtpPort;   
	char byAttachment;
	char byEnableSSL;	 
	char byMailInterval; 
	char byReserve; 
}EmailCfg;

typedef struct tagPreviewCfg
{
	char byPreviewNumber;
	char byEnableAudio;
	char wSwitchTime;
	char res;
}PreviewCfg;

typedef struct tagNetColor{
	char    byBrightness;
	char    byContrast;
	char    bySaturation;
	char    byHue;
}NetColor;

typedef struct tagNetShelter{
	INT    wHideAreaTopLeftX;
	INT    wHideAreaTopLeftY;
	INT    wHideAreaWidth;
	INT    wHideAreaHeight;
}NetShelter;

typedef struct tagHandleException{
	unsigned int       dwHandleType;
	char     byRelAlarmOut[MAX_ALARMOUT_V30];
}HandleException;

typedef struct tagSchedTime{
	char    byStartHour;
	char    byStartMin;
	char    byStopHour;
	char    byStopMin;
}SchedTime;

typedef struct tagVilost{
	char byEnableHandleVILost;
	char res[3];
	HandleException strVILostHandleType;
	//SchedTime struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];
	int  invalid;
	int  iTimeTable[MAX_DAYS][MAX_TIMESEGMENT_V30];
}Vilost;

typedef struct tagSENSITIVITY_INFO
{
    BYTE byBeginHour;
    BYTE byBeginMinute;
    BYTE byEndHour;
    BYTE byEndMinute;
    BYTE bySensitivity;
    BYTE byRes[3];
}SENSITIVITY_INFO;

typedef struct  tagMotion{
	int                    width;
	int                    hight;
	char                   byMotionScope[64][96];
    SENSITIVITY_INFO       szSensitivityInfo[4];
	char                   byEnableHandleMotion;
	char                   reservedData[3];
	HandleException        strMotionHandleType;
	//SchedTime              struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];
	int                    invalid;
	int                    iTimeTable[MAX_DAYS][MAX_TIMESEGMENT_V30];
	char                   byRelRecordChan[MAX_CHANNUM_V30];
}Motion;

typedef struct tagHideAlarm{
	unsigned int                  dwEnableHideAlarm;
	HandleException               strHideAlarmHandleType;
	//SchedTime                     struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];
	int                           invalid;
	int                           iTimeTable[MAX_DAYS][MAX_TIMESEGMENT_V30];
}HideAlarm;

typedef struct tagPicCfg{
	long                lchannel;	
	char                sChanName[NAME_LEN];
	unsigned int        dwVideoFormat;
	NetColor            struColor;
	unsigned int        dwShowChanName;
	int                 wShowNameTopLeftX;
	int                 wShowNameTopLeftY;
	Vilost              struVILost;
	Motion              struMotion;
	HideAlarm           struHideAlarm;
	unsigned int        dwEnableHide;
	NetShelter          struShelter[MAX_SHELTERNUM];
	int 				bShowTime;
	int 				iTimex;
	int					iTimey;
	int					iTimeFmt;
	char				charW;
	char				charH;
	char				language;
	char				resolution;
}PicCfg;

typedef struct tagRecordDay
{
	unsigned short 	  wAllDayRecord;
	char 	  byRecordType;
	char      reservedData;
}RecordDay;

typedef struct tagRecordSched
{
	SchedTime	      struRecordTime;
	unsigned int			      byRecordType;
	//char			  reservedData[3];
}RecordSched;

typedef struct tagRecordCfg
{
	long				lchannel;
	int                 bCycle;//ѭд
	unsigned int		dwRecordTime;//¼ӳʱ
	unsigned int		dwPreRecordTime;//Ԥ¼ʱ
	int                 packageTime;//ʱ(Min)
	char				   byAudioRec;
	char				   byReserve[3];
}RecordCfg;

typedef struct 
{
	int 				channel;
	unsigned int		dwRecord;
	//RecordDay			struRecAllDay[MAX_DAYS];
	int                 invalidType;
	RecordSched			struRecordSched[MAX_DAYS][MAX_TIMESEGMENT_V30];
}RecordSchedule, *PRecordSchedule;

typedef struct tagCompressionInfo
{
	char	 byStreamType;
	char	   byResolution;
	char	   byBitrateType;
	char	   byPicQuality;
	unsigned int    dwVideoBitrate;
	unsigned int    dwVideoFrameRate;
}CompressionInfo;

typedef struct tagCompressionCfg
{
	long      lchannel;
	CompressionInfo    struNormHighRecordPara;
	CompressionInfo    struNetPara;
}CompressionCfg;

typedef struct tagVgaPara
{ 
	int       wResolution;
}VgaPara;

typedef struct tagVideoOut
{
	VgaPara 		struVGAPara;    
}VideoOutCfg;

typedef struct tagDeviceCfg{
	long             lchannel;
	char 	         sDVRName[NAME_LEN];
	unsigned int	 dwDVRID;
	char	         byAlarmInPortNum;
	char	         byAlarmOutPortNum;
	char	         byRS232Num;
	char	         byRS485Num;
	char	         byNetworkPortNum;
	char	         byDiskCtrlNum;
	char	         byDiskNum;
	char	         byDVRType;
	char	         byChanNum;
	char	         byStartChan;
	char	         byDecordChans;
	char	         byVGANum;
	char	         byUSBNum;
	char	         byAuxoutNum;
	char	         byAudioNum;
	char	         byIPChanNum;
	int              norm;
	int              fmt;
	int              language;
}DeviceCfg;

typedef struct tagUserInfoAll
{
	char				  sUserName[NAME_LEN];
	char				  sPassword[PASSWD_LEN];
	char				  byLocalRight[MAX_RIGHT];
	char				  byRemoteRight[MAX_RIGHT];
	char				  byNetPreviewRight[MAX_CHANNUM_V30];
	char				  byLocalPlaybackRight[MAX_CHANNUM_V30];
	char				  byNetPlaybackRight[MAX_CHANNUM_V30];
	char				  byLocalRecordRight[MAX_CHANNUM_V30];
	char				  byNetRecordRight[MAX_CHANNUM_V30];
	char				  byLocalPTZRight[MAX_CHANNUM_V30];
	char				  byNetPTZRight[MAX_CHANNUM_V30];
	char				  byLocalBackupRight[MAX_CHANNUM_V30];
	NET_IPADDR	      struUserIP;
	char				  byMACAddr[MACADDR_LEN];
	char				  byPriority;
	char				  byRes[17];   
}UserInfoAll;

typedef struct tagUser
{
	UserInfoAll	 struUser[MAX_USERNUM_V30];
}User;

typedef struct tagAlarmInCfg
{
	long                             lchannel;
	char							    sAlarmInName[NAME_LEN];
	char 							byAlarmType;
	char 							byAlarmInHandle;
	char 							byRes1[2];
	HandleException		            struAlarmHandleType;
	//SchedTime				        struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];
	int								invalid;
	int 							timetable[MAX_DAYS][MAX_TIMESEGMENT_V30];
	char 							byRelRecordChan[MAX_CHANNUM_V30];
	char 							byEnablePreset[MAX_CHANNUM_V30];
	char 							byPresetNo[MAX_CHANNUM];
	char 							byEnableCruise[MAX_CHANNUM];
	char 							byCruiseNo[MAX_CHANNUM];
	char 							byEnablePtzTrack[MAX_CHANNUM];
	char 							byPTZTrack[MAX_CHANNUM];
}AlarmInCfg;

typedef struct tagAlarmOutCfg
{
	long                    lchannel;
	char 				   sAlarmOutName[NAME_LEN];
	unsigned int			   dwAlarmOutDelay;
	//SchedTime	           struAlarmOutTime[MAX_DAYS][MAX_TIMESEGMENT_V30];
	int                   invalid;
	int                   iTimeTable[MAX_DAYS][MAX_TIMESEGMENT_V30];
}AlarmOutCfg;

typedef struct tagNetFileInfo
{
	int channel;	
	int filehandle;
	char filename[MAX_NET_NAME_LEN];
	NETIME starttime;
	NETIME endtime;
	int rectype;
	int reserv;
	int filesize;
	int filesizeH;
	//unsigned __int64 filesize;
}NetFileInfo;

typedef struct tagNetPreviewInfo
{
	int channel;	
	int hwnd;
	int streamtype;
}NetPreviewInfo;


typedef enum tagNetRsp{
	NET_RSP_OK,
	NET_RSP_FAILED,
}NetRsp;

typedef struct tagNetPtzInfo
{
	int channel;
	int speed;
	int cmd;
	int presetid;
	int patrolid;
	int keypos;
	int time;
	int patternid;
}NetPtzInfo;

typedef struct tagNetVedioParam
{
	int channel;
	int bright;
	int contrast;
	int saturation;
	int hue;
}NetVedioParam;

typedef struct tagNetAlarmStatus
{
	char status[MAX_ALARMOUT_V30];
}NetAlarmStatus;

typedef struct tagNetAlarmout
{
	int channel;
	int status;
}NetAlarmout;

typedef struct tagNetManualRec
{
	int channel;
	int type;
}NetManualRec;

typedef struct{
	unsigned int     dwHDNo;
	unsigned int     dwCapacity;
	unsigned int     dwFreeSpace;
	unsigned int     dwHdStatus;//01δʽ23S.M.A.R.T״̬4ƥ䣬5ߣ6-δ״̬ Ӳ̣ 
	unsigned char    byHDAttr;//0:ͨ 1: 2:ֻ
	unsigned char    byHDType;//0:Ӳ 1:ESATAӲ 2:NFS
	unsigned char    byRes1[2];
	unsigned int     dwHdGroup;
}NetHDInfo;

typedef struct tagNetHdCfg
{
	int diskCount;
	NetHDInfo diskInfo[MAX_DISK_NUM];
}NetHDCfg;

typedef struct{
	NETIME     strLogTime;
	int            dwMajorType;
	int            dwMinorType;
	char             sPanelUser[MAX_NAMELEN];
	char             sNetUser[MAX_NAMELEN];
	NET_IPADDR   struRemoteHostAddr;
	int            dwParaType;
	int            dwChannel;
	int            dwDiskNumber;
	int            dwAlarmInPort;
	int            dwAlarmOutPort;
	int            dwInfoLen;
	char             sInfo[LOG_INFO_LEN];
}Net_Log;

typedef struct tagNetLogInfo
{
	NETIME starttime;
	NETIME endtime;
	NETIME logtime;
	int major;
	int minor;
	int maxcount;
	int handle;
	int mode;
	Net_Log loginfo;
}NetLogInfo;

typedef struct tagNetAlarmInfo{
	int alarm;
	int recState;
}NetAlarmInfo;

typedef struct tagNetAlarmCtrl{
	bool enable;
	int handle;
	unsigned int version;
	char serialno[NET_SERIAL_LEN];
	char devicename[NET_DEVICE_NAME_LEN];
	char mac[6];
	unsigned short port;
	char ip[16];
	NetAlarmInfo info[16];
}NetAlarmCtrl;

typedef struct tagNetUniversParam
{
	unsigned int cmd;
	char data[NET_CFG_BUFF_SIZE];
}NetUniversParam;

typedef struct
{
	int battachment;
	int bssl;
	char name[32];
	char pass[32];
	char smtp[32];
	int smtpport;
	char sender[32];
	char recver[32];
}NetEmailCfg;

typedef struct tagNetKeyPoint
{
	int id;//ؼidid=cruiseid<<8|keyptid;
	int cruiseid;//min:1 max:6
	int keyptid;//min:1 max:16
	int speed;//min:0 max:6
	int time;//min:1 max:30
	int presetpt;//min:1 max:64
	int channel;//belong channel
	struct tagNetKeyPoint *next;
}NetKeyPoint, *PNetKeyPoint;


typedef struct 
{
	PNetKeyPoint head;
	PNetKeyPoint tail;
	PNetKeyPoint cur;
	int keyptcnt;
}NetCruiseTrack, *PNetCruiseTrack;

typedef struct 
{
	unsigned char presetid;
	unsigned char time;
	unsigned char speed;
	unsigned char reserve;
}NetCrusiePtInfo, *PNetCrusiePtInfo;

typedef struct
{
	char serialNum[48];
	char alarminNum;
	char alarmoutNum;
	char diskNum;
	char dvrType;
	char maxChan;
	char startChan;
	char audioChan;
	char ipChan;
	char resolution;
	char language;
	char res[2];
	char typeinfo[32];
	unsigned int softver;
	unsigned int hardver;
	unsigned int panelver;
	unsigned int hdChannels[4];//echo bit corresponds to one channel , if the bit is '1' means correspond channel is hd channel
	int norm;
	int fmt;
	int b485;
}NetDeviceInfo;

typedef struct
{
	char filename[256];
	unsigned long filesize;//ļС
	unsigned long cursize;//ѽļС
	int updateparameter;
	int reserv;
}NetCfgFileInfo, *PNetCfgFileInfo;

typedef struct
{
	int port;
}NetServiceCfg, *PNetServiceCfg;

typedef struct
{
	int port;
}NetWebCfg, *PNetWebCfg;

typedef struct
{
	char ip[16];
	char mask[16];
	char gateway[16];
	char mac[24];
}NetIPCfg, *PNetIPCfg;

typedef struct
{
	char dns1[16];
	char dns2[16];
}NetDNSCfg, *PNetDNSCfg;

typedef struct
{
	char server[32];
	int port;
	int bnonymous;
	char username[32];
	char password[32];
	char remotedir[256];
	int filelen;	
}NetFTPCfg, *PNetFTPCfg;

typedef struct
{
	SchedTime time;
	int type;
}NetTimeSection, *PNetTimeSection; 

typedef struct
{
	int channel;
	int bvalid;
	NetTimeSection timetable[7][2];
}NetFTPTask, *PNetFTPTask;

typedef struct
{
	int type;    // 0:ipfilter invalid   1:white valid  2:black valid
	char white[64][16];
	char black[64][16];
}NetIPFilterCfg, *PNetIPFilterCfg;

typedef struct
{
	int bautoapn;
	char apn[128];
	char phone[32];/*dial phone num*/
	char name[128];/*user name */
	char pass[32];/*user password*/
	int bautoip;
	int bautodns;
	NetIPCfg ip;
	NetDNSCfg dns;
}Net3GConfig, *PNet3GConfig;

typedef struct
{
	int bdhcp;//dhcp or static
	int bautodns;//get dns automaticaly or static configure
	NetIPCfg ipconfig;//ip configure
	NetDNSCfg dnsconfig; //dns configure
}NetLocalConfig, *PNetLocalConfig;

typedef struct 
{
	char	cName[32];
	char	cType[32];
	char	cSerialNo[32];
	char	cBuildDay[32];
	char	cHardwareVer[32];
	char	cCfgVer[32];
	char	cFirmwareVer[32];
	char	cDetail[32];
	char	res[16];
}VersionInfo, *PVersionInfo;

typedef struct
{
	char name[128];
	char pass[128];
}PPPoECfg;

typedef enum
{
	NET_LAN,
	NET_PPPOE,
	NET_CDMA
}LinkType;

typedef struct
{
	int enable;
}UpnpCfg, *PUpnpCfg;

typedef enum
{
	LOG_MAJOR_OP = 0,
	LOG_MAJOR_EXP,
	LOG_MAJOR_ALARM,
	LOG_MAJOR_INFO,
	LOG_MAJOR_BUTT,
}LOG_MAJOR_TYPE_E;

typedef enum
{
	LOG_MINOR_STARTUP = 0,
	LOG_MINOR_SHUTDOWN,
	LOG_MINOR_RESTART,
	LOG_MINOR_LOGIN,
	LOG_MINOR_LOGOUT,
	LOG_MINOR_LOCALCONFIG,
	LOG_MINOR_REMOTECONFIG,
	LOG_MINOR_UPDATE,
	LOG_MINOR_MANUAL_STARTREC,
	LOG_MINOR_MANUAL_STOPREC,
	LOG_MINOR_SCHED_STARTREC,
	LOG_MINOR_SCHED_STOPREC,
	LOG_MINOR_CTRLPTZ,
	LOG_MINOR_MANUALALARM,
	LOG_MINOR_FORMATDISK,
	LOG_MINOR_PLAYBACK,
	LOG_MINOR_EXPORT_CFG,
	LOG_MINOR_IMPORT_CFG,
	LOG_MINOR_BAK,
	LOG_MINOR_ADD_DISK,
	LOG_MINOR_DEL_DISK,
	LOG_MINOR_SET_DISK,
	LOG_MINOR_OP_BUTT,
}LOG_MINOR_OP_E;

typedef enum
{
	LOG_MINOR_ILLEGAL = 0,
	LOG_MINOR_DISK_FULL,
	LOG_MINOR_DISK_ERR,
	LOG_MINOR_IP,
	LOG_MINOR_DISCONNECT,
	LOG_MINOR_REC_EXP,
	LOG_MINOR_EXP_BUTT,
}LOG_MINOR_EXP_E;

typedef enum
{
	/*alarm*/
	LOG_MINOR_VL = 0,
	LOG_MINOR_ALARMIN,
	LOG_MINOR_ALARMOUT,
	LOG_MINOR_MD,
	LOG_MINOR_BLIND,
	LOG_MINOR_ALARM_BUTT,
}LOG_MINOR_ALARM_E;

typedef enum
{
	/*info*/
	LOG_MINOR_DISKINFO = 0,
	LOG_MINOR_VERSION,
	LOG_MINOR_INFO_BUTT,
}LOG_MINOR_INFO_E;

typedef enum tagNetDataType{
	NET_HEART_BEAT,
	NET_LOGIN,
	NET_LOGOUT,
	NET_PREVIEW,
	NET_PREVIEW_STOP,	
	NET_REPLAY,
	NET_STREAM_HEADER,
	NET_REPLAY_STOP,
	NET_DOWNLOAD,
	NET_DOWNLOAD_STOP,
	NET_TALK_OPEN,
	NET_TALK_CLOSE,
	NET_TALK_STREAM,
	NET_FILE_INFO,
	NET_FILE_FIND,
	NET_FILE_FIND_NEXT,
	NET_FILE_FIND_CLOSE,
	NET_STREAM,
	NET_PTZ_CONTROL,
	NET_PTZ_PRESET,
	NET_PTZ_CRUISE,
	NET_PTZ_TRACK,
	NET_FORMATDISK,
	NET_REBOOT,
	NET_SHUTDOWN,
	NET_SETVEDIOPARAM,
	NET_GETVEDIOPARAM,
	NET_GETALARMOUT,
	NET_SETALARMOUT,
	NET_STARTMANREC,
	NET_STOPMANREC,
	NET_RESTORECONFIG,
	NET_QUERY_LOG,
	NET_GETNEXT_LOG,
	NET_CLOSE_LOG,
	NET_SET_ALARM,	
	NET_STOP_ALARM,
	NET_ALARM,
	NET_GET_TIME,
	NET_SET_TIME,
	NET_SET_DECODER,
	NET_GET_DECODER,
	NET_SET_NETCFG,
	NET_GET_NETCFG,
	NET_GET_NTPCFG,
	NET_SET_NTPCFG,
	NET_GET_DDNSCFG,
	NET_SET_DDNSCFG,
	NET_GET_NETAPP,
	NET_SET_NETAPP,
	NET_GET_EMAILCFG,
	NET_SET_EMAILCFG,
	NET_GET_PREVIEWCFG,
	NET_SET_PREVIEWCFG,
	NET_GET_PICCFG,
	NET_SET_PICCFG,
	NET_GET_RECORD,
	NET_SET_RECORD,
	NET_GET_COMPRESSIONCFG,
	NET_SET_COMPRESSIONCFG,
	NET_GET_VIDEOOUTCFG,
	NET_SET_VIDEOOUTCFG,
	NET_GET_DEVICECFG,
	NET_SET_DEVICECFG,
	NET_SET_HDCFG,
	NET_GET_HDCFG,
	NET_GET_USERCFG,
	NET_SET_USERCFG,
	NET_GET_ALARMINCFG,
	NET_SET_ALARMINCFG,
	NET_GET_ALARMOUTCFG,
	NET_SET_ALARMOUTCFG,
	NET_GET_PTZCRUISE,
	NET_DISCON,
	NET_EXPORT_CFG,
	NET_IMPORT_CFG,
	NET_UPDATE_DEV,
	NET_GET_FTPCFG,
	NET_SET_FTPCFG,
	NET_GET_FTPTASK,
	NET_SET_FTPTASK,
	NET_GET_IPFILTER,
	NET_SET_IPFILTER,
	NET_GET_SERVCFG,
	NET_SET_SERVCFG,
	NET_GET_HTTPCFG,
	NET_SET_HTTPCFG,
	NET_GET_3GCFG,
	NET_SET_3GCFG,
	NET_GET_LOCAL_LINK,
	NET_SET_LOCAL_LINK,
	NET_VEDIO_PARAM,
	NET_PTZ_PARAM,
	NET_GET_VERSION,
	NET_GET_RECSCHEDULE,
	NET_SET_RECSCHEDULE,
	NET_GET_HDDFULLCFG,
	NET_SET_HDDFULLCFG,
	NET_GET_HDDERRCFG,
	NET_SET_HDDERRCFG,
	NET_GET_NETDISCONCFG,
	NET_SET_NETDISCONCFG,
	NET_GET_IPCONFLICTCFG,
	NET_SET_IPCONFLICTCFG,
	NET_GET_OUTPUTCFG,
	NET_SET_OUTPUTCFG,
	NET_GET_LINKTYPE,
	NET_SET_LINKTYPE,
	NET_GET_PPPOECFG,
	NET_SET_PPPOECFG,
	NET_GET_UPNPSTATE,
	NET_SET_UPNPSTATE,
	NET_SET_RESTORE,
	NET_SET_AUTO_REBOOT_CFG,
	NET_GET_AUTO_REBOOT_CFG,
	NET_GET_HDD_CFG,
	NET_INIT_HDD,
	NET_GET_SYSGENERAL_CFG,
	NET_SET_SYSGENERAL_CFG,
	NET_GET_DST_CFG,
	NET_SET_DST_CFG,
	NET_GET_LOG,
	NET_INVALID,
}NetCmd;

typedef struct tagNetHeader{
	// only for verify header, is a const value
	int check;

	NetCmd type;
	// data length
	int len;

	// session id
	int handle;

	// server proc rsp
	int rspcode;	
}NetHeader;

//////////// file header//////////////////
typedef struct tagNetFileHeader{
	unsigned char ver[4];
	unsigned int len;
	unsigned int w;
	unsigned int h;
	unsigned char type;
	unsigned char frameRate;
	unsigned char begYear;
	unsigned char begMonth;
	unsigned char begDay;
	unsigned char begHour;
	unsigned char begMinute;
	unsigned char begSecond;
	unsigned char endYear;
	unsigned char endMonth;
	unsigned char endDay;
	unsigned char endHour;
	unsigned char endMinute;
	unsigned char endSecond;
	unsigned char resv[2];
}NetFileHeader;


#define MAX_RESO_TYPES 10

#define MAX_QUAULITY_TYPES MAX_RESO_TYPES
#define MAX_QUAULITY_NUM 10

#define MAX_FRAME_TYPES MAX_RESO_TYPES
#define MAX_FRAME_NUM 20

#define MAX_BIT_RATE_TYPES MAX_RESO_TYPES
#define MAX_BIT_RATE_NUM 15

typedef struct
{
	int quaulityTypes;
	int quaulity[MAX_QUAULITY_NUM];
}QuaulityInfo;

typedef struct
{
	int channel[4];//channel bit, use bit OR
	int streamType;//main stream:0  substream:1
	int reso;
	char strReso[32];
}ResoInfo;

typedef struct
{
	int min;//min frame rate
	int max;//max frame rate
	int def;
	int types;//frame types to choose
	int frame[MAX_FRAME_NUM];//frame list 
}FrameInfo;

typedef struct
{
	int min;//min bit rate
	int max;//max bit rate
	int def;
	int types;// bit rate types to choose
	int times;//relationship between bit rat and frame rate
	int bitRate[MAX_BIT_RATE_NUM];//bit rate list
}BitRateInfo;

typedef struct
{	
	int resoTypes;//resolution types to choose
	ResoInfo reso[MAX_RESO_TYPES];//resolution list
	
	QuaulityInfo quaulity[MAX_QUAULITY_TYPES];
	
	FrameInfo frame[MAX_FRAME_TYPES];
	
	BitRateInfo bitRate[MAX_BIT_RATE_TYPES];
}StreamInfo;

typedef struct
{
	int bAudio;
	int resolution;
	int enctype;//0 vbr 1 cbr
	int picQuaulity;
	int frame;
	int bCustom;
	int bitRate;
}EncInfo, *PEncInfo;

typedef struct
{
	int channel;
	int bHD;//is hd channel or not
	int streamTypes;//valid stream types
	EncInfo mainStream;
	EncInfo subStream;
	EncInfo resStream;
}ChannelEncInfo;

typedef struct
{
	int triggerBuzzer;
	int triggerSnap;
	int triggerOut[32];
	int reserve[2];
}NetExceptionCfg, *PNetExceptionCfg;

typedef struct
{
	int reso;
	char name[32];
}ResoType;

typedef struct
{
	int types;
	int cur;
	ResoType list[32];
}ResotList;

typedef struct
{
	int max;
	int min;
	int cur;
}UITrans;

typedef struct
{
	int max;
	int min;
	int cur;
}MouseSense;

typedef struct
{
	int types;
	int cur;
	int list[16];
}DellTable;

typedef struct
{
	ResotList reso;
	UITrans trans;
	MouseSense mouseSense;
	DellTable dwell;
	int bmute;
}OutputCfg,*POutputCfg;

typedef struct
{
	int display;
	int recording;
	int network;
	int alarm;
	int device;
	int system;
}RestoreCfg,*PRestoreCfg;

typedef struct
{
    int enable;
    int week_day;
    int hour;
    int min;
    int second;
}AutoRebootCfg,*PAutoRebootCfg;

typedef struct
{
    int number;
    int capacity;
    int b_format;
    int b_mount;
    int remain_size;
}HddInfo;

typedef struct
{
    int total;
    HddInfo hddInfo[10];
}HddCfg,*PHddCfg;

typedef struct
{
    int total;
    int init_id[10];
}HddInitInfo,*PHddInitInfo;

typedef struct
{
    int video_standard;
    int time_zone;
    int date_format;
    int year;
    int month;
    int day;
    int hour;
    int min;
    int second;
    int device_id;
}SysGeneralCfg,*PSysGeneralCfg;

typedef struct
{
    int enable;
    int offset;
    int mode;
	
    int start_month;
    int start_index;
    int start_weekday;
    int start_hour;
    int start_minute;
    int start_second;
	
    int end_month;
    int end_index;
    int end_weekday;
    int end_hour;
    int end_minute;
    int end_second;
}DstCfg, *PDstCfg;

#endif

